﻿//
//	SW_FileDir02.c
//

#include	<AjrCstXX.h>
#include	<math.h>
#include	<tchar.h>
#include	"resource.h"

//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
static	HINSTANCE		hInst;							//	ＤＬＬインスタンスハンドル
static	HWND			hDlgMain;						//	ダイアログボックスハンドル
static	HWND			hVth;
//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Main);
static	BOOL	fBusy = FALSE;
static	BOOL	fCan  = FALSE;
static	BOOL	fEnd  = FALSE;

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, PSTR szCmdLine, int iCmdShow)
{
	MSG 	msg;

	hInst = hInstance;

	//----- メイン・ダイアログオープン -----------------//
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_DLGMAIN), NULL, AJC_DLGPROC_NAME(Main));
	//----- ダイアログ表示 -----------------------------//
	ShowWindow(hDlgMain, SW_SHOW);

	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}

	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//==============================================================================================================//
static	BOOL CALLBACK cbQuery(UI id, C_UTP pPath, UI att, BOOL *pfDiscard, UX cbp)
{
	BOOL	rc = TRUE;
	HWND	hDlg = (HWND)cbp;
	UT		wild[MAX_PATH];

	AjcDoEvent();

	if (!(fCan || fEnd)) {
		//	ワイルドカードチェック
		AjcGetDlgItemStr(hDlg, IDC_TXT_WILD, wild, MAX_PATH);
		if (wild[0] != 0) {
			if (!AjcPathMatchSpec(pPath, wild)) {
				*pfDiscard = TRUE;
			}
		}
	}
	else {
		rc = FALSE;
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
static	BOOL CALLBACK cbEnum(AJCFMLITEM item[2], UX cbp)
{
	BOOL		rc = TRUE;
	UI			ix;
	SYSTEMTIME	st, lt;

	AjcDoEvent();

	if (!(fCan || fEnd)) {
		AjcVthPrintF(hVth, TEXT("------------------------------\n"));
		for (ix = 0; ix < 2; ix++) {
			if (item[ix].fValid) {
				AjcVthPrintF(hVth, TEXT("%d: %s\n"), ix, item[ix].path);
				AjcTime1970ToSysTime(item[ix].hd.utc, &st);
				AjcSysTimeToLocalTime(&st, &lt);
				AjcVthPrintF(hVth, TEXT("    time : %04d/%02d/%02d %02d:%02d:%02d\n"), lt.wYear, lt.wMonth, lt.wDay,
																					   lt.wHour, lt.wMinute, lt.wSecond);
				AjcVthPrintF(hVth, TEXT("    name : %s\n"), item[ix].name);
			}
			else {
				AjcVthPrintF(hVth, TEXT("%d: -\n"), ix);
			}
		}
	}
	else {
		rc = FALSE;
	}
	return rc;
}
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG 	)
{
	UT	base[MAX_PATH];

	hDlgMain = hDlg;
	hVth	 = GetDlgItem(hDlg, IDC_VTH);
	AjcEnableDlgItemToDrop(hDlg, IDC_TXT_BASE , AJCDROP_DIR);
	AjcEnableDlgItemToDrop(hDlg, IDC_TXT_PATH1, AJCDROP_DIR);
	AjcEnableDlgItemToDrop(hDlg, IDC_TXT_PATH2, AJCDROP_DIR);
	AjcLoadAllControlSettings(hDlg, TEXT("Main"), AJCCTL_SELACT_ALL);

	AjcGetDlgItemStr(hDlg, IDC_TXT_BASE, base, MAX_PATH);
	if (base[0] != 0) {
		SetCurrentDirectory(base);
	}

	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY		)
{
	AjcSaveAllControlSettings(hDlg);
	PostQuitMessage(0);
	return TRUE;
}
//----- 「実行」ボタン -----------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_RUN		)
{
	int		rsu;
	UT		path1[MAX_PATH];
	UT		path2[MAX_PATH];

	AjcEnableDlgItem(hDlg, IDC_CMD_RUN , FALSE);
	AjcEnableDlgItem(hDlg, IDC_CMD_STOP, TRUE);
	fCan = fEnd = FALSE;
	fBusy = TRUE;
	AjcGetDlgItemStr(hDlg, IDC_TXT_PATH1, path1, MAX_PATH);
	AjcGetDlgItemStr(hDlg, IDC_TXT_PATH2, path2, MAX_PATH);
	rsu = AjcEnumFilesMatchingList(path1[0] != 0 ? path1 : NULL,
								   path2[0] != 0 ? path2 : NULL, AJCFML_BOTH, (UX)hDlg, cbQuery, cbEnum);
	AjcVthPrintF(hVth, TEXT("\nResult = %d\n\n"), rsu);
	AjcEnableDlgItem(hDlg, IDC_CMD_RUN , TRUE);
	AjcEnableDlgItem(hDlg, IDC_CMD_STOP, FALSE);
	fBusy = FALSE;
	if (fEnd) DestroyWindow(hDlg);
	return TRUE;
}
//----- 「中止」ボタン -----------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_STOP		)
{
	if (fBusy) fCan = TRUE;
	return TRUE;
}
//----- 「Cancel」 ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL			)
{
	if (fBusy) fEnd = TRUE;
	else DestroyWindow(hDlg);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG	   )
	AJC_DLGMAP_MSG(Main, WM_DESTROY 	   )
	
	AJC_DLGMAP_CMD(Main, IDC_CMD_RUN	   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_STOP	   )
	AJC_DLGMAP_CMD(Main, IDCANCEL		   )
AJC_DLGMAP_END

