﻿//
//	SW_FontDlg.c
//

#include	<AjrCstXX.h>
#include	<math.h>
#include	<tchar.h>
#include	"resource.h"

#define	CTRL_V	0x001B

//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
static	HINSTANCE		hInst;							//	ＤＬＬインスタンスハンドル
static	HWND			hDlgMain;						//	ダイアログボックスハンドル
static	HWND			hVth;

static	AJCCFPERMINFO	PermInfo = {0};
static	UI				lsp = 0;
static	int				VthTop;

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Main);
static	VO	 CALLBACK cbInit (HWND hDlg, UX cbp);
static	BOOL CALLBACK cbApply(HFONT hFont, UI lsp, UX cbp);
//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 	msg;

	hInst = hInstance;

	//----- プロファイルをINIファイルに設定 ------------//
	AjcSetProfileIsRegistory(FALSE);

	//----- メイン・ダイアログオープン -----------------//
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_DLGMAIN), NULL, AJC_DLGPROC_NAME(Main));
	//----- ダイアログ表示 -----------------------------//
	ShowWindow(hDlgMain, SW_SHOW);

	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}

	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//==============================================================================================================//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG 	)
{
	RECT		r;
	UT			txt[AJCCFMAX_TEXT];

	hDlgMain = hDlg;
	hVth	 = GetDlgItem(hDlg, IDC_VTH);

	//	VTH上位置退避
	GetWindowRect(hVth, &r);
	MapWindowPoints(NULL, hDlg, (LPPOINT)&r, 2);
	VthTop = r.top;
	//	VTHサイズ設定
	GetClientRect(hDlg, &r);
	SendMessage(hDlg, WM_SIZE, SIZE_RESTORED, MAKELONG(r.right - r.left, r.bottom - r.top));
	//	VT100右クリック禁止，キャレット非表示
	AjcVthSetNtcRClk(hVth, TRUE, 0, 0);
	AjcVthShowCaret(hVth, FALSE);
	//	サンプルテキスト表示
	AjcVthPrintF(hVth,	TEXT("\n")
						TEXT("ここにテキストファイルをドロップすると、ファイルの内容を表示します。\n")
						TEXT("\n")
						TEXT("また、CTRL+V キーを押すと、クリップボードのテキストを表示します。\n"));
	//	自ダイアログ設定値ロード
	AjcLoadAllControlSettings(hDlg, TEXT("Settings"), AJCCTL_SELACT_ALL);
	//	フォント選択ダイアログ設定値（永続化情報）初期化
	AjcCfInitPermInfo(NULL, NULL, &PermInfo);
	//	フォント選択ダイアログ設定値（永続化情報）ロード
	AjcGetProfileStr(TEXT("FontSec"), TEXT("FontKey"), TEXT(""), txt, AJCCFMAX_TEXT);
	AjcCfTextToInfo(txt, &PermInfo);

	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY		)
{
	UT		txt[AJCCFMAX_TEXT];
	//	ダイアログ設定値セーブ
	AjcSaveAllControlSettings(hDlg);
	//	フォント選択ダイアログ設定値（永続化情報）セーブ
	AjcCfInfoToText(&PermInfo, txt);
	AjcPutProfileStr(TEXT("FontSec"), TEXT("FontKey"), txt);

	//----- プログラム終了 ---------------------------------------//
	PostQuitMessage(0);
	return TRUE;
}
//----- サイズ変更 ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_SIZE			)
{
	int		dw = LOWORD(lParam);
	int		dh = HIWORD(wParam);
	RECT	r;

	GetClientRect(hDlg, &r);
	SetWindowPos(hVth, NULL, 4, VthTop, r.right - 8, r.bottom - VthTop - 4, SWP_NOZORDER);

	return TRUE;
}
//----- フォント設定ボタン -------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_FONT		)
{
	AJCCFFONTINFO	fi;

	if (AjcCfFontDlg(hDlg, 0, &fi, &PermInfo, (UX)hDlg, cbInit, cbApply)) {
		AjcVthSetFontInfo(hVth, &fi.lf, fi.lsp);
	}
	return TRUE;
}
//----- INIファイルを開くボタン --------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_INIOPEN	)
{
	UT		path[MAX_PATH];
	AjcGetIniFilePath(path, MAX_PATH);
	ShellExecute(NULL, TEXT("open"), path, NULL, NULL, SW_SHOWNORMAL);
	return TRUE;
}
//----- VT100ウインドからの通知 --------------------------------------------------------------------------------//
//	ダイアログ下のVT100コントロールの場合、AJCVTHN_KEYINは使用不可の為、AJCVTHN_VKEYIN,AJCVTHN_VKEYOUTで処理する
AJC_DLGPROC(Main, IDC_VTH			)
{
	static BOOL fCtrl = FALSE;
	UT		path[MAX_PATH];

	switch (HIWORD(wParam)) {
		case AJCVTHN_VKEYIN:							//	●キー押下
			//	CTRL+V：貼り付け
			if (lParam == TEXT('V') && fCtrl) {
				UTP	pTxt;
				if (pTxt = AjcCreateClipboardText()) {
					AjcVthClear(hVth);
					AjcVthPutText(hVth, pTxt, -1);
					AjcReleaseClipboardText(pTxt);
				}
			}
			//	CTRLキー押下処理
			if (lParam == VK_CONTROL) fCtrl = TRUE;
			break;

		case AJCVTHN_VKEYOUT:							//	●キー離し
			//	CTRLキー離し処理
			if (lParam == VK_CONTROL) fCtrl = FALSE;
			break;

		case AJCVTHN_DROPFILE:							//	●ファイル ドロップ（ファイルの内容を描画）
			AjcVthClear(hVth);
			while (AjcVthGetDroppedFile(hVth, path)) {
				HAJCFILE	hFile;
				UT			wbuf[256];
				AjcVthPrintF(hVth, TEXT("\r\n\x1B[34m[[[ FILE = %s ]]]\x1B[0m\r\n"), path);
				if (hFile = AjcFOpen(path, AJCTEC_AUTO)) {
					while (AjcFGetS(hFile, wbuf, 256)) {
						AjcVthPutText(hVth, wbuf, -1);
					}
					AjcFClose(hFile);
				}
			}
			break;
	}
	return 0;
}
//----- 「Cancel」ボタン ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL			)
{
	DestroyWindow(hDlg);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG	   )
	AJC_DLGMAP_MSG(Main, WM_DESTROY 	   )
	AJC_DLGMAP_MSG(Main, WM_SIZE	 	   )

	AJC_DLGMAP_CMD(Main, IDC_CMD_FONT	   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_INIOPEN   )
	AJC_DLGMAP_CMD(Main, IDC_VTH		   )
	AJC_DLGMAP_CMD(Main, IDCANCEL		   )
AJC_DLGMAP_END

//--------------------------------------------------------------------------------------------------------------//
//	初期化コールバック																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO CALLBACK cbInit (HWND hDlgChoFont, UX cbp)
{
	HWND	hDlg = (HWND)cbp;
	RECT	r;
	GetWindowRect(hDlg, &r);
	SetWindowPos(hDlgChoFont, NULL, r.right, r.top, 0, 0, SWP_NOSIZE);
}
//--------------------------------------------------------------------------------------------------------------//
//	適用コールバック																							//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL CALLBACK cbApply(HFONT hFont, UI lsp, UX cbp)
{
	HWND	hDlg = (HWND)cbp;
	LOGFONT	lf;
	GetObject(hFont, sizeof lf, &lf);
	AjcVthSetFontInfo(hVth, &lf, lsp);
	return TRUE;
}
