﻿//
//	SW_ListBox.c
//
#include	<AjrCstXX.h>
#include	<math.h>
#include	<tchar.h>
#include	"resource.h"

#define		TIPTEXT_ADD(ID, TEXT)	AjcTipTextAdd(GetDlgItem(hDlg, ID), TEXT)

//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
HINSTANCE		hInst;							//	ＤＬＬインスタンスハンドル
HWND			hDlgMain;						//	ダイアログボックスハンドル
HWND			hLbx;							//	リストボックスコントロールのウインドハンドル

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Main);
static	VO	SubCreateListBox(int sty);

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 	msg;

	hInst = hInstance;

	//----- メイン・ダイアログオープン -----------------//
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_DLGMAIN), NULL, AJC_DLGPROC_NAME(Main));
	//----- ダイアログ表示 -----------------------------//
	ShowWindow(hDlgMain, SW_SHOW);

	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}

	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//==============================================================================================================//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG 	)
{
	int		sty;
	UT		path[MAX_PATH];
	UT		defp[MAX_PATH];

	hDlgMain = hDlg;
	hLbx = GetDlgItem(hDlgMain, IDC_LISTBOX);

	//----- リストボックスコントロール生成 ----------------------//
	//
	//	リストボックス生成時のみ有効なスタイルを設定可能とするため
	//	リストボックスコントロールをCreateWindow()で生成します。
	//
	SubCreateListBox(AJCLBXS_STD_FILEDIR_S | AJCLBXS_SINGLE);
	//----- 初期リスト項目設定 ----------------------------------//
	AjcLbxAddString(hLbx, TEXT("List Item 1"));
	AjcLbxAddString(hLbx, TEXT("List Item 2"));
	AjcLbxAddString(hLbx, TEXT("List Item 3"));
	//----- ベースパスのドロップ許可 ----------------------------//
	AjcEnableDlgItemToDrop(hDlg, IDC_TXT_BASEPATH, AJCDROP_DIR);
	//----- スタイルをチェックボックスに反映 --------------------//
	sty = (int)MAjcGetWindowLong(hLbx, GWL_STYLE);
	AjcSetDlgItemChk(hDlg, IDC_CHK_RIGHT		, (sty & AJCLBXS_RIGHT		  ) != 0);
	AjcSetDlgItemChk(hDlg, IDC_CHK_TRIM			, (sty & AJCLBXS_TRIM		  ) != 0);
	AjcSetDlgItemChk(hDlg, IDC_CHK_FILE			, (sty & AJCLBXS_FILE		  ) != 0);
	AjcSetDlgItemChk(hDlg, IDC_CHK_DIRTAIL		, (sty & AJCLBXS_DIRTAIL	  ) != 0);
	AjcSetDlgItemChk(hDlg, IDC_CHK_ADDITEMINDROP, (sty & AJCLBXS_ADDITEMINDROP) != 0);
	AjcSetDlgItemChk(hDlg, IDC_CHK_ACCEPTDIRS	, (sty & AJCLBXS_ACCEPTDIRS	  ) != 0);
	AjcSetDlgItemChk(hDlg, IDC_CHK_ACCEPTFILES	, (sty & AJCLBXS_ACCEPTFILES  ) != 0);
	AjcSetDlgItemChk(hDlg, IDC_CHK_DIRPATH		, (sty & AJCLBXS_DIRPATH	  ) != 0);
	AjcSetDlgItemChk(hDlg, IDC_CHK_FILEPATH		, (sty & AJCLBXS_FILEPATH	  ) != 0);
	AjcSetDlgItemChk(hDlg, IDC_CHK_SORT_EXACT	, (sty & AJCLBXS_SORT_EXACT	  ) != 0);
	AjcSetDlgItemChk(hDlg, IDC_CHK_COMP_EXACT	, (sty & AJCLBXS_COMP_EXACT	  ) != 0);
	AjcSetDlgItemChk(hDlg, IDC_CHK_SINGLE		, (sty & AJCLBXS_SINGLE		  ) != 0);
	AjcSetDlgItemChk(hDlg, IDC_CHK_SORT			, (sty & AJCLBXS_SORT		  ) != 0);
	//----- ツールチップ設定 ------------------------------------//
	TIPTEXT_ADD(IDC_CHK_RIGHT		, TEXT("右詰め表示（ウインド生成時のみ有効）"));
	TIPTEXT_ADD(IDC_CHK_INSFILE		, TEXT("選択項目無しで右クリック時「ファイル追加」メニュー表示"));
	TIPTEXT_ADD(IDC_CHK_TRIM		, TEXT("項目の前後の空白を除去する"));
	TIPTEXT_ADD(IDC_CHK_FILE		, TEXT("リスト項目としてファイル／フォルダパス名を扱う場合に指定します。\n")
		TEXT("FILEスタイルは、以下の項目を有効にします。\n")
		TEXT("  ・項目追加ダイアログ中の「ディレクトリ選択」「ファイル選択」「相対パスに変換」ボタンを有効化\n")
		TEXT("  ・FILEPATHスタイル指定時に、ポップアップメニュー中の「ファイル追加」を有効化\n")
		TEXT("  ・ベースパスが設定済で、選択項目がある場合、ポップアップメニュー中の「選択項目を相対パスに変換」")
																		TEXT("「選択項目を絶対パスに変換」を有効化\n")
		TEXT("FILEスタイルが指定されていない場合は、上記項目は全て非表示となります。"));
	TIPTEXT_ADD(IDC_CHK_DIRTAIL		, TEXT("ディレクトリ名の末尾に「\\」を付加する"));
	TIPTEXT_ADD(IDC_CHK_ADDITEMINDROP,TEXT("ファイル／ディレクトリドロップでリストボックス項目を追加"));
	TIPTEXT_ADD(IDC_CHK_ACCEPTDIRS	, TEXT("ディレクトリのドラッグ＆ドロップを可能にする"));
	TIPTEXT_ADD(IDC_CHK_ACCEPTFILES	, TEXT("ファイルのドラッグ＆ドロップを可能にする"));
	TIPTEXT_ADD(IDC_CHK_DIRPATH		, TEXT("項目の追加／編集時にディレクトリパスを選択可能とする（AJCLBXS_FILE有効時）"));
	TIPTEXT_ADD(IDC_CHK_FILEPATH	, TEXT("項目の追加／編集時にファイルパスを選択可能とする    （AJCLBXS_FILE有効時）"));
	TIPTEXT_ADD(IDC_CHK_SORT_EXACT	, TEXT("COMP_EXACTとSORT_EXACT指定時は、単に文字列の大小でソートされる")
		TEXT("（ex. AAA < CCC < aaa < bbb）\n")
		TEXT("COMP_EXACTだけ指定した場合は、アルファベット順にソートされる（ex. AAA < aaa < bbb < CCC）"));
	TIPTEXT_ADD(IDC_CHK_COMP_EXACT	, TEXT("英字の大小を区別して比較する"));
	TIPTEXT_ADD(IDC_CHK_SINGLE		, TEXT("単一選択モード（ウインド生成時のみ有効）"));
	TIPTEXT_ADD(IDC_CHK_SORT		, TEXT("アイテム追加時にソートする（ウインド生成時のみ有効）"));
	//----- 設定値ロード ----------------------------------------//
	AjcCtrlSetPermAtt (hLbx, AJCCTL_PSEL_EXCLUDE);
	AjcLoadAllControlSettings(hDlg, TEXT("MySect"), AJCCTL_SELACT_ALL | AJCCTL_SELACT_NTCCHK);
	AjcLbxLoadItems(hLbx, TEXT("MySect"), TEXT("Lbx"));
	//----- プロファイルからベースパス読み出し ------------------//
	AjcGetAppPath(defp, MAX_PATH);
	AjcGetProfileStr(TEXT("MAIN"), TEXT("BasePath"), defp, path, MAX_PATH);
	AjcSetDlgItemStr(hDlg, IDC_TXT_BASEPATH, path);
	//----- 相対パスへ変換時のベースパス設定 --------------------//
	AjcLbxSetBasePath(hLbx, path);
	//----- 初期メッセージ --------------------------------------//
	AjcVthPrintF(GetDlgItem(hDlg, IDC_VTH), TEXT("ここに「Get All Item」「Get Selected Item」ボタン\nで取得した項目を表示します\n"));
	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY		)
{
	//----- 設定値セーブ ----------------------------------------//
	AjcSaveAllControlSettings(hDlg);
	AjcLbxSaveItems(hLbx, TEXT("MySect"), TEXT("Lbx"));
	//----- リストボックス破棄 ----------------------------------//
	DestroyWindow(hLbx);
	//----- プログラム終了 --------------------------------------//
	PostQuitMessage(0);
	return TRUE;
}
//----- ベースパス設定ボタン -----------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_BASEPATH	)
{
	UT	path[MAX_PATH];

	AjcGetDlgItemStr(hDlg, IDC_TXT_BASEPATH, path, MAX_PATH);
	if (AjcGetFolderName(hDlg, TEXT("Set base path"), path, path, FALSE)) {
		AjcSetDlgItemStr(hDlg, IDC_TXT_BASEPATH, path);
		AjcLbxSetBasePath(hLbx, path);
	}
	return TRUE;
}
//----- GetAll Item ボタン -------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_GETALL	)
{
	PAJCLBXITEM pTop, p;
	UI			i, n;

	AjcVthClearAllText(GetDlgItem(hDlg, IDC_VTH));
	if (pTop = AjcLbxGetAllItems(hLbx, &n)) {
		for (i = 0, p = pTop; i < n; i++, p++) {
			AjcVthPrintF(GetDlgItem(hDlg, IDC_VTH), TEXT("%s\n"), p->pStr);
		}
		AjcLbxRelAllItems(pTop);
	}
	return TRUE;
}
//----- Get Selected Item ボタン -------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_GETSEL	)
{
	PAJCLBXITEM pTop, p;
	UI			i, n;

	AjcVthClearAllText(GetDlgItem(hDlg, IDC_VTH));
	if (pTop = AjcLbxGetSelectedItems(hLbx, &n)) {
		for (i = 0, p = pTop; i < n; i++, p++) {
			AjcVthPrintF(GetDlgItem(hDlg, IDC_VTH), TEXT("%s\n"), p->pStr);
		}
		AjcLbxRelSelectedItems(pTop);
	}
	return TRUE;
}
//----- Enable ボタン ------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_ENABLE	)
{
	EnableWindow(hLbx, TRUE);
	return TRUE;
}
//----- Disable ボタン -----------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_DISABLE	)
{
	EnableWindow(hLbx, FALSE);
	return TRUE;
}
//----- リストボックス -----------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_LISTBOX		)
{
	switch (HIWORD(wParam)) {
		case AJCLBXN_DBLCLK:							//	●ダブルクリック通知
		case AJCLBXN_ERRSPACE:							//	●メモリ不足通知
		case AJCLBXN_KILLFOCUS:							//	●フォーカス喪失通知
		case AJCLBXN_SELCANCEL:							//	●選択キャンセル通知
		case AJCLBXN_SELCHANGE:							//	●選択変更通知
		case AJCLBXN_SETFOCUS:							//	●フォーカス取得通知
			break;

		case AJCLBXN_RCLICK:							//	●右クリック通知
		{	PAJCLBXRCLK	p = (PAJCLBXRCLK)lParam;
			UT			txt[64] = {0};
			AjcSnPrintF(txt, 64, TEXT("%s%s右クリック発生(x = %d, y = %d)"), p->fShift ? TEXT("Shift+") : TEXT(""),
																			 p->fCtrl  ? TEXT("Ctrl+" ) : TEXT(""),
																			 p->x, p->y);
			MessageBox(hDlg, txt, TEXT("S_CtrlVT100_01"), MB_OK);
			break;
		}

		case AJCLBXN_DROPDIR:							//	●ディレクトリドロップ
		{	UT		path[MAX_PATH];
			UT		txt[4096];
			MAjcStrCpy(txt, AJCTSIZE(txt), TEXT("-- Dir dropped --\n"));
			while (AjcLbxGetDroppedDir(hLbx, path)) {
				MAjcStrCat(txt, AJCTSIZE(txt), path);
				MAjcStrCat(txt, AJCTSIZE(txt), TEXT("\n"));
			}
			MessageBox(hDlg, txt, TEXT("Dropped Dir"), MB_OK);
			break;
		}

		case AJCLBXN_DROPFILE:							//	●ファイルドロップ
		{	UT		path[MAX_PATH];
			UT		txt[4096];
			MAjcStrCpy(txt, AJCTSIZE(txt), TEXT("-- File dropped --\n"));
			while (AjcLbxGetDroppedFile(hLbx, path)) {
				MAjcStrCat(txt, AJCTSIZE(txt), path);
				MAjcStrCat(txt, AJCTSIZE(txt), TEXT("\n"));
			}
			MessageBox(hDlg, txt, TEXT("Dropped File"), MB_OK);
			break;
		}

		case AJCLBXN_REMOVED:							//	●項目削除
		{	UT		str[AJCLBX_MAXSTL];
			UT		txt[16384];
			MAjcStrCpy(txt, AJCTSIZE(txt), TEXT("-- Removed --\n"));
			while (AjcLbxGetRemovedItem(hLbx, str, sizeof str)) {
				MAjcStrCat(txt, AJCTSIZE(txt), str);
				MAjcStrCat(txt, AJCTSIZE(txt), TEXT("\n"));
			}
			MessageBox(hDlg, txt, TEXT("Removed Items"), MB_OK);
			break;
		}
	}
	return TRUE;
}
//----- スタイル・チェックボックス -----------------------------------------------------------------------------//
//	当該スタイルビットをセット／リセットする
#define	SET_STY(S)	if (HIWORD(wParam) == BN_CLICKED) {																		\
						UT		val[16];																					\
						int		sty = (int)MAjcGetWindowLong(hLbx, GWL_STYLE);												\
						if (AjcGetDlgItemChk(hDlg, IDC_CHK_##S)) MAjcSetWindowLong(hLbx, GWL_STYLE, sty |=	AJCLBXS_##S);	\
						else									 MAjcSetWindowLong(hLbx, GWL_STYLE, sty &= ~AJCLBXS_##S);	\
						AjcSnPrintF(val, AJCTSIZE(val), TEXT("%04X"), sty & 0x0000FFFF);									\
						AjcSetDlgItemStr(hDlg, IDC_TXT_STYLE, val);															\
					}
AJC_DLGPROC(Main, IDC_CHK_TRIM			)	{SET_STY(TRIM			); return TRUE;}
AJC_DLGPROC(Main, IDC_CHK_FILE			)	{SET_STY(FILE			); return TRUE;}
AJC_DLGPROC(Main, IDC_CHK_DIRTAIL		)	{SET_STY(DIRTAIL		); return TRUE;}
AJC_DLGPROC(Main, IDC_CHK_ADDITEMINDROP	)	{SET_STY(ADDITEMINDROP	); return TRUE;}
AJC_DLGPROC(Main, IDC_CHK_ACCEPTDIRS	)	{SET_STY(ACCEPTDIRS		); return TRUE;}
AJC_DLGPROC(Main, IDC_CHK_ACCEPTFILES	)	{SET_STY(ACCEPTFILES	); return TRUE;}
AJC_DLGPROC(Main, IDC_CHK_DIRPATH		)	{SET_STY(DIRPATH		); return TRUE;}
AJC_DLGPROC(Main, IDC_CHK_FILEPATH		)	{SET_STY(FILEPATH		); return TRUE;}
AJC_DLGPROC(Main, IDC_CHK_SORT_EXACT	)	{SET_STY(SORT_EXACT		); return TRUE;}
AJC_DLGPROC(Main, IDC_CHK_COMP_EXACT	)	{SET_STY(COMP_EXACT		); return TRUE;}

//	AJCLBXS_RIGHT/SINGLE/SORTは、ウインド生成時にのみ指定可能なため、ウインドを生成し直してスタイルを設定する
#define	REMK_LBX(S)	if (HIWORD(wParam) == BN_CLICKED) {																		\
						UT		val[16];																					\
						int		sty = (int)MAjcGetWindowLong(hLbx, GWL_STYLE);			/*	スタイル更新値設定			*/	\
						if (AjcGetDlgItemChk(hDlg, IDC_CHK_##S)) sty |=  AJCLBXS_##S;	/*	・							*/	\
						else									 sty &= ~AJCLBXS_##S;	/*	・							*/	\
						AjcLbxSaveItems(hLbx, TEXT("LbxTemp"), TEXT("LBX"));			/*	リストボックス項目をセーブ	*/	\
						DestroyWindow(hLbx);											/*	リストボックス破棄			*/	\
						SubCreateListBox(sty & 0xFFFF);									/*	リストボックス再生成		*/	\
						AjcLbxLoadItems  (hLbx, TEXT("LbxTemp"), TEXT("LBX"));			/*	リストボックス項目ロード	*/	\
						AjcDelProfileSect(TEXT("LbxTemp"));								/*	プロファイルセクション消去	*/	\
						AjcSnPrintF(val, AJCTSIZE(val), TEXT("%04X"), sty & 0x0000FFFF);/*	スタイル値表示				*/	\
						AjcSetDlgItemStr(hDlg, IDC_TXT_STYLE, val);						/*	・							*/	\
					}

AJC_DLGPROC(Main, IDC_CHK_RIGHT			)	{REMK_LBX(RIGHT ); return TRUE;}
AJC_DLGPROC(Main, IDC_CHK_SINGLE		)	{REMK_LBX(SINGLE); return TRUE;}
AJC_DLGPROC(Main, IDC_CHK_SORT			)	{REMK_LBX(SORT	); return TRUE;}

//----- 項目追加 -----------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_ADD		)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		UT	txt[AJCLBX_MAXSTL];
		AjcGetDlgItemStr(hDlg, IDC_TXT_ADD, txt, AJCTSIZE(txt));
		AjcLbxAddString(hLbx, txt);
	}
	return TRUE;
}
//----- 項目挿入 -----------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_INS		)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		UT	txt[AJCLBX_MAXSTL];
		AjcGetDlgItemStr(hDlg, IDC_TXT_INS, txt, AJCTSIZE(txt));
		AjcLbxInsertString(hLbx,AjcGetDlgItemUInt(hDlg, IDC_TXT_INS_IX), txt);
	}
	return TRUE;
}
//----- 項目検索 -----------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_SRH		)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		int	ix;
		UT	txt[AJCLBX_MAXSTL];
		UT	rsu[256];
		AjcGetDlgItemStr(hDlg, IDC_TXT_SRH, txt, AJCTSIZE(txt));
		ix = AjcLbxFindString(hLbx, -1, txt);
		if (ix >= 0) AjcSnPrintF(rsu, AJCTSIZE(rsu), TEXT("Find ix = %d"), ix);
		else		 AjcSnPrintF(rsu, AJCTSIZE(rsu), TEXT("Not found"	));
		AjcSetDlgItemStr(hDlg, IDC_LBL_SRH, rsu);

		ix = AjcLbxGetTextLen(hLbx, 1);
		txt[0] = 0;
	}
	return TRUE;
}
//----- 「Cancel」ボタン ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL			)
{
	DestroyWindow(hDlg);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG			)
	AJC_DLGMAP_MSG(Main, WM_DESTROY 			)

	AJC_DLGMAP_CMD(Main, IDC_CMD_BASEPATH		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_GETALL			)
	AJC_DLGMAP_CMD(Main, IDC_CMD_GETSEL			)
	AJC_DLGMAP_CMD(Main, IDC_CMD_ENABLE			)
	AJC_DLGMAP_CMD(Main, IDC_CMD_DISABLE		)
	AJC_DLGMAP_CMD(Main, IDC_LISTBOX			)

	AJC_DLGMAP_CMD(Main, IDC_CMD_ADD			)
	AJC_DLGMAP_CMD(Main, IDC_CMD_INS			)
	AJC_DLGMAP_CMD(Main, IDC_CMD_SRH			)

	AJC_DLGMAP_CMD(Main, IDC_CHK_TRIM			)
	AJC_DLGMAP_CMD(Main, IDC_CHK_FILE			)
	AJC_DLGMAP_CMD(Main, IDC_CHK_DIRTAIL		)
	AJC_DLGMAP_CMD(Main, IDC_CHK_ADDITEMINDROP	)
	AJC_DLGMAP_CMD(Main, IDC_CHK_ACCEPTDIRS		)
	AJC_DLGMAP_CMD(Main, IDC_CHK_ACCEPTFILES	)
	AJC_DLGMAP_CMD(Main, IDC_CHK_DIRPATH		)
	AJC_DLGMAP_CMD(Main, IDC_CHK_FILEPATH		)
	AJC_DLGMAP_CMD(Main, IDC_CHK_SORT_EXACT		)
	AJC_DLGMAP_CMD(Main, IDC_CHK_COMP_EXACT		)

	AJC_DLGMAP_CMD(Main, IDC_CHK_RIGHT			)
	AJC_DLGMAP_CMD(Main, IDC_CHK_SINGLE			)
	AJC_DLGMAP_CMD(Main, IDC_CHK_SORT			)

	AJC_DLGMAP_CMD(Main, IDCANCEL			   )
AJC_DLGMAP_END
//--------------------------------------------------------------------------------------------------------------//
//	リストボックス生成																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO	SubCreateListBox(int sty)
{
	RECT	r;

	GetWindowRect(GetDlgItem(hDlgMain, IDC_LBL_LBX), &r);
	MapWindowPoints(NULL, hDlgMain, (LPPOINT)&r, 2);

	hLbx = CreateWindow(TEXT("AjcCtrlListBox"), 	// window class name
						TEXT(""),					// window caption
						WS_CHILD | sty,				// window style
						r.left,						// initial x position
						r.top,						// initial y position
						r.right - r.left,			// initial x size
						r.bottom - r.top,			// initial y size
						hDlgMain,					// parent window handle
						(HMENU)IDC_LISTBOX,			// window menu handle
						hInst,						// program instance handle
						NULL);						// creation parameters
	ShowWindow(hLbx, SW_SHOW);
	AjcCtrlSetPermAtt (hLbx, AJCCTL_PSEL_EXCLUDE);
}
