﻿//
//	SW_LogFile.c
//
#include	<AjrCstXX.h>
#include	"resource.h"

//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
static	HINSTANCE		hInst;
static	HWND			hDlgMain;
static	HWND			hWndLgf;
static	HWND			hWndGrp;

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Main);
static	VO	ShowEncode(HWND hDlg, EAJCTEC OutTec, BOOL fBOM);

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 	msg;

	hInst = hInstance;

	//----- メイン・ダイアログオープン -----------------//
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_DLGMAIN), NULL, AJC_DLGPROC_NAME(Main));
	ShowWindow(hDlgMain, SW_SHOW);

	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}
	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//==============================================================================================================//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG )
{
	EAJCTEC	OutTec;
	BOOL	fBOM;

	hWndLgf = GetDlgItem(hDlg, IDC_LGF);
	hWndGrp = GetDlgItem(hDlg, IDC_GRP_TSFORM);

	AjcLgfSetLogFileNamePrefix(hWndLgf, TEXT("S01_"));
	AjcLgfSetTimeStampFormat(hWndLgf, AJCLGFTS_HMSN);
	AjcLgfLoadProp(hWndLgf, TEXT("LogFileSect"));

	AjcSbcRadioBtns(hWndGrp);
	AjcSbcSetRbt   (hWndGrp, AjcLgfGetTimeStampFormat(hWndLgf));
	SetTimer(hDlg, 1, 1000, NULL);

	AjcLgfGetTextEncode(hWndLgf, NULL, &OutTec, &fBOM);
	ShowEncode(hDlg, OutTec, fBOM);

	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY	)
{
	KillTimer(hDlg, 1);
	AjcLgfSaveProp(hWndLgf, TEXT("LogFileSect"));
	PostQuitMessage(0);
	return TRUE;
}
//----- タイマ -------------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_TIMER		)
{
	AjcLgfPrintF(hWndLgf, TEXT("【ＩＤ】"), TRUE, TEXT("%6d, %6d, %6d\n"), rand(), rand(), rand());
	return TRUE;
}
//----- キャンセルボタン ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL		)
{
	DestroyWindow(hDlg);
	return TRUE;
}
//----- Enableボタン -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_ENABLE)
{
	EnableWindow(hWndLgf, TRUE);
	EnableWindow(GetDlgItem(hDlg, IDC_CMD_ENABLE ), FALSE);
	EnableWindow(GetDlgItem(hDlg, IDC_CMD_DISABLE), TRUE );
	return TRUE;
}
//----- Disableボタン ------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_DISABLE)
{
	EnableWindow(hWndLgf, FALSE);
	EnableWindow(GetDlgItem(hDlg, IDC_CMD_ENABLE ), TRUE );
	EnableWindow(GetDlgItem(hDlg, IDC_CMD_DISABLE), FALSE);
	return TRUE;
}
//----- タイムスタンプ形式ラジオボタン -------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_GRP_TSFORM)
{
	AjcLgfSetTimeStampFormat(hWndLgf, (AJCLGFTS)AjcSbcGetRbt(hWndGrp));
	return TRUE;
}
//----- ログファイル出力コントロールからの通知 -----------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_LGF		)
{
	switch (HIWORD(wParam)) {
		case AJCLGFN_START:
			AjcSetDlgItemStr(hDlg, IDC_LBL_MSG, TEXT("ログ出力中"));
			break;

		case AJCLGFN_STOP:
			AjcSetDlgItemStr(hDlg, IDC_LBL_MSG, TEXT("ログ出力停止中"));
			break;

		case AJCLGFN_ENCODE:
			ShowEncode(hDlg, (EAJCTEC)LOWORD(lParam), (BOOL)HIWORD(lParam));
			break;
	}
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG	)
	AJC_DLGMAP_MSG(Main, WM_DESTROY 	)
	AJC_DLGMAP_MSG(Main, WM_TIMER		)

	AJC_DLGMAP_CMD(Main, IDCANCEL		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_ENABLE )
	AJC_DLGMAP_CMD(Main, IDC_CMD_DISABLE)
	AJC_DLGMAP_CMD(Main, IDC_GRP_TSFORM )
	AJC_DLGMAP_CMD(Main, IDC_LGF		)
AJC_DLGMAP_END

//--------------------------------------------------------------------------------------------------------------//
//	テキストエンコード表示																						//
//--------------------------------------------------------------------------------------------------------------//
static	VO	ShowEncode(HWND hDlg, EAJCTEC OutTec, BOOL fBOM)
{
	UT		txt[64] = {0};
	switch (OutTec) {
		case AJCTEC_MBC:		MAjcStrCpy(txt, AJCTSIZE(txt), TEXT("MBC(S-JIS)"));	break;	//	マルチバイト
		case AJCTEC_UTF_8:		MAjcStrCpy(txt, AJCTSIZE(txt), TEXT("UTF-8"));		break;	//	ＵＴＦ－８
		case AJCTEC_EUC_J:		MAjcStrCpy(txt, AJCTSIZE(txt), TEXT("EUC-J"));		break;	//	ＥＵＣ（日本語）
		case AJCTEC_UTF_16LE:	MAjcStrCpy(txt, AJCTSIZE(txt), TEXT("UTF-16 LE"));	break;	//	ＵＴＦ－１６ＬＥ
		case AJCTEC_UTF_16BE:	MAjcStrCpy(txt, AJCTSIZE(txt), TEXT("UTF-16 BE"));	break;	//	ＵＴＦ－１６ＢＥ
	}
	if (fBOM) {
		MAjcStrCat(txt, AJCTSIZE(txt), TEXT(", BOM"));
	}
	AjcSetDlgItemStr(hDlg, IDC_LBL_ENC, txt);
}
