﻿//
//	SW_PrintText.c
//
#include	<AjrCstXX.h>
#include	<Shlwapi.h>
#include	<io.h>
#include	<tchar.h>
#include	<sys/stat.h>
#include	"resource.h"
#pragma comment(lib, "shlwapi.lib")

#define		PICL	300

//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
static	HINSTANCE		hInst;							//	ＤＬＬインスタンスハンドル
static	HWND			hDlgMain;						//	ダイアログボックスハンドル
static	HAJCFILE		hFile = NULL;					//	テキストファイルハンドル
static	HAJCPRN 		hPrn;							//	印刷インスタンス
static	BOOL			fPrintContinue	= TRUE; 		//	印刷継続フラグ
static	HFONT			hFont = NULL;					//	フォントオブジェクト
static	AJCPRN_INFO		PrnInfo;						//	プリンタ情報
static	BOOL			fFileOut = FALSE;				//	ファイルへ出力フラグ


//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Main);

static	BOOL CALLBACK cbQueryPage(PCAJCPRN_INFO pPrnInfo, PAJCPRN_PGINFO pPageInfo, UX cbp);
static	BOOL CALLBACK cbDrawByDibSectDC(HDC hdc, PCAJCPRN_INFO pPrnInfo, PCAJCDIBINFO pDibInfo, UX cbp);
static	BOOL CALLBACK cbDrawByPrinterDC(HDC hdc, PCAJCPRN_INFO pPrnInfo, UX cbp);

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 	msg;

	hInst = hInstance;

	//----- メイン・ダイアログオープン -----------------//
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_MAIN), NULL, AJC_DLGPROC_NAME(Main));
	ShowWindow(hDlgMain, SW_SHOW);

	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}

	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//==============================================================================================================//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG 	)
{
	AJCPRN_MARGIN	mrg;
	LOGFONT 		lf;

	hDlgMain = hDlg;

	//----- 印刷インスタンス生成 --------------------------//
	hPrn = AjcPrnCreate();
	//----- ページ印刷開始コールバック設定 ----------------//
	AjcPrnSetCallbackQueryPage(hPrn, cbQueryPage);
	//----- プリンタ名表示 --------------------------------//
	AjcSetDlgItemStr(hDlg, IDC_LBL_PRNAME, AjcPrnGetInfo(hPrn, &PrnInfo));
	//----- テキストファイル名入力でドロップ可能とする ----//
	AjcEnableDlgItemToDrop (hDlg, IDC_TXT_FILE, AJCDROP_FILE);
	//----- ラジオボタン初期化 ----------------------------//
	AjcSetDlgItemChk(hDlg, IDC_RBT_DIB_DC, TRUE);
	//----- 設定値ロード ----------------------------------//
	AjcLoadAllControlSettings(hDlg, TEXT("Settings"), AJCCTL_SELACT_ALL | AJCCTL_SELACT_NTCALL);
	//----- 余白設定 --------------------------------------//
	mrg.u = AjcGetDlgItemUInt(hDlg, IDC_INP_SPC_U);
	mrg.d = AjcGetDlgItemUInt(hDlg, IDC_INP_SPC_D);
	mrg.l = AjcGetDlgItemUInt(hDlg, IDC_INP_SPC_L);
	mrg.r = AjcGetDlgItemUInt(hDlg, IDC_INP_SPC_R);
	AjcPrnSetMargin(hPrn, &mrg);
	//----- フォント生成 ----------------------------------//
	lf.lfHeight		 = 80;			lf.lfStrikeOut		= 0;
	lf.lfWidth		 = 0;			lf.lfCharSet		= DEFAULT_CHARSET;
	lf.lfEscapement	 = 0;			lf.lfOutPrecision	= OUT_STROKE_PRECIS;
	lf.lfOrientation = 0;			lf.lfClipPrecision	= CLIP_STROKE_PRECIS;
	lf.lfWeight		 = FW_NORMAL;	lf.lfQuality		= DRAFT_QUALITY;
	lf.lfItalic		 = 0;			lf.lfPitchAndFamily	= FF_MODERN | VARIABLE_PITCH;
	lf.lfUnderline	 = 0;			MAjcStrCpy(lf.lfFaceName, AJCTSIZE(lf.lfFaceName), TEXT("Arial Unicode MS"));
	hFont = CreateFontIndirect(&lf);

	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY		)
{
	//----- 設定値セーブ ----------------------------------//
	AjcSaveAllControlSettings(hDlg);
	//----- リソース解放 ----------------------------------//
	AjcPrnDelete(hPrn);
	DeleteObject(hFont);
	//----- プログラム終了 --------------------------------//
	PostQuitMessage(0);

	return TRUE;
}
//----- WM_COMMAND ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_COMMAND		)
{
	int 	cmd = LOWORD(wParam);

	if (cmd == IDC_INP_SPC_U || cmd == IDC_INP_SPC_D || cmd == IDC_INP_SPC_L || cmd == IDC_INP_SPC_R) {
		if (HIWORD(wParam) == AJCIVN_INTVALUE) {
			AJCPRN_MARGIN	mrg;
			mrg.u = AjcGetDlgItemUInt(hDlg, IDC_INP_SPC_U);
			mrg.d = AjcGetDlgItemUInt(hDlg, IDC_INP_SPC_D);
			mrg.l = AjcGetDlgItemUInt(hDlg, IDC_INP_SPC_L);
			mrg.r = AjcGetDlgItemUInt(hDlg, IDC_INP_SPC_R);
			AjcPrnSetMargin(hPrn, &mrg);
		}
	}
	return TRUE;
}
//----- ウインドクローズ ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL			)
{
	DestroyWindow(hDlg);
	return TRUE;
}
//----- プリンタの設定ボタン -----------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_SETPRN	)
{
	if (AjcPrnSelectDlg(hPrn, &PrnInfo, 0, hDlg)) {
		//	プリンタ名表示
		AjcSetDlgItemStr(hDlg, IDC_LBL_PRNAME, AjcPrnGetInfo(hPrn, NULL));
	}
	return TRUE;
}
//----- 印刷開始ボタン ----------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_START		)
{
	AJCPRN_OPT	opt = {0};
	UT			path[MAX_PATH];

	if (HIWORD(wParam) == BN_CLICKED) {
		AjcGetDlgItemStr(hDlg, IDC_TXT_FILE, path, MAX_PATH);
		if (hFile = AjcFOpen(path, AJCTEC_AUTO)) {
			opt.Flags = (
				AJCPRNF_DISABLECOPIES		|	//	「印刷部数」を無効化する
				AJCPRNF_DISABLEPAGEINFO		|	//	「印刷範囲」を無効にする
			//	AJCPRNF_ALLPAGES			|	//	「すべて」を選択状態にする
			//	AJCPRNF_SELECTION			|	//	「選択した部分」を選択状態にする
			//	AJCPRNF_NOSELECTION			|	//	「選択した部分」を無効状態にする
			//	AJCPRNF_PAGENUMS			|	//	「ページ指定」を選択状態にする
			//	AJCPRNF_NOPAGENUMS			|	//	「ページ指定」を無効状態にする
			//	AJCPRNF_NOWARNING			|	//	既定のプリンタがない場合に警告メッセージ非表示
			//	AJCPRNF_PRINTTOFILE			|	//	「ファイルへ出力」をチェックする
			//	AJCPRNF_DISABLEPRINTTOFILE	|	//	「ファイルへ出力」を無効化する
			//	AJCPRNF_HIDEPRINTTOFILE		|	//	ファイルへ出力」を非表示
			//	AJCPRNF_USEDEVMODECOPIES	|	//	アプリで「部単位で印刷」が未サポートであることを指定
				0);
			opt.nCopies 	= 1;				//	コピー部数
			opt.nFromPage	= 1;				//	開始ページ
			opt.nToPage		= 1;				//	終了ページ
			opt.nMinPage	= 1;				//	ページ範囲の最小値
			opt.nMaxPage	= 10;				//	ページ範囲の最小値
			if (AjcPrnPrintDlg(hPrn, NULL, &opt, hDlg)) {
				//--- プリンタ名表示 ------------//
				AjcSetDlgItemStr(hDlg, IDC_LBL_PRNAME, AjcPrnGetInfo(hPrn, NULL));
				//--- 印刷継続フラグ初期化 ------//
				fPrintContinue = TRUE;
				//--- 中止ボタンのみ有効化 ------//
				AjcEnableGroup(GetDlgItem(hDlg, IDC_GRP_ALL ), FALSE, FALSE);
				EnableWindow  (GetDlgItem(hDlg, IDC_CMD_STOP), TRUE);
				//--- 印刷開始 ------------------//
				AjcPrnStart (hPrn, (opt.Flags & AJCPRNF_OUTPUTTOFILE) != 0);
				//--- グレー状態解除 -----------//
				AjcEnableGroup(GetDlgItem(hDlg, IDC_GRP_ALL ), TRUE, TRUE);
				EnableWindow  (GetDlgItem(hDlg, IDC_CMD_STOP), FALSE);
			}
			//--- ファイルクローズ ---------//
			AjcFClose(hFile); hFile = NULL;
		}
		else {
			MessageBox(hDlg, TEXT("ファイルをオープンできません"), TEXT("SW_PrintText"), MB_ICONERROR);
		}
	}
	return TRUE;
}
//----- 印刷中止ボタン ----------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_STOP		)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		//--- グレー状態解除 -----------//
		AjcEnableGroup(GetDlgItem(hDlg, IDC_GRP_ALL ), TRUE, TRUE);
		EnableWindow  (GetDlgItem(hDlg, IDC_CMD_STOP), FALSE);
		//--- 印刷終了の旨、設定 -------//
		fPrintContinue = FALSE;
	}
	return TRUE;
}
//----- 印刷テキストファイル設定ボタン -------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_FILE		)
{
	UT		path[MAX_PATH];

	if (HIWORD(wParam) == BN_CLICKED) {
		AjcGetDlgItemStr(hDlg, IDC_TXT_FILE, path, AJCTSIZE(path));
		if (AjcGetOpenFile(hDlg, TEXT("イメージファイル設定"), TEXT("Text File (*.txt)/*.txt/All Files (*.*)/*.*"),
																					TEXT("txt"), path, MAX_PATH)) {
			AjcSetDlgItemStr(hDlg, IDC_TXT_FILE, path);
		}
	}
	return TRUE;
}
//----- ラジオボタン（プリンタＤＣへ直接描画）------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_RBT_PRT_DC	)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		if (AjcGetDlgItemChk(hDlg, IDC_RBT_PRT_DC)) AjcPrnSetCallbackByPrinter(hPrn, cbDrawByPrinterDC);
		else										AjcPrnSetCallbackByDibSect(hPrn, cbDrawByDibSectDC);
	}
	return TRUE;
}
//----- ラジオボタン（ＤＩＢセクションを介して描画）------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_RBT_DIB_DC	)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		if (AjcGetDlgItemChk(hDlg, IDC_RBT_PRT_DC)) AjcPrnSetCallbackByPrinter(hPrn, cbDrawByPrinterDC);
		else										AjcPrnSetCallbackByDibSect(hPrn, cbDrawByDibSectDC);
	}
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG		)
	AJC_DLGMAP_MSG(Main, WM_DESTROY 		)
	AJC_DLGMAP_MSG(Main, WM_COMMAND 		)
	AJC_DLGMAP_CMD(Main, IDCANCEL			)
	AJC_DLGMAP_CMD(Main, IDC_CMD_SETPRN 	)
	AJC_DLGMAP_CMD(Main, IDC_CMD_START		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_STOP		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_FILE		)
	AJC_DLGMAP_CMD(Main, IDC_RBT_PRT_DC		)
	AJC_DLGMAP_CMD(Main, IDC_RBT_DIB_DC		)
AJC_DLGMAP_END

//--------------------------------------------------------------------------------------------------------------//
//	コールバック（ページ印刷開始）																				//
//																												//
//	引　数	：	hdc 		- ＤＩＢセクションビットマップのＤＣ												//
//				pPrnInfo	- プリンタ情報へのポインタ															//
//				pPgInfo		- ページ情報へのポインタ															//
//				cbp 		- コールバックパラメタ																//
//																												//
//	戻り値	：	TRUE  - 印刷継続																				//
//				FALSE - 印刷終了（このページを印刷後に終了）													//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL CALLBACK cbQueryPage(PCAJCPRN_INFO pPrnInfo, PAJCPRN_PGINFO pPgInfo, UX cbp)
{
	BOOL	rc = FALSE;

	AjcDoEvent();														//	印刷中止ボタンチェック
	rc = fPrintContinue;												//	・

	return !AjcFEof(hFile);
}
//--------------------------------------------------------------------------------------------------------------//
//	コールバック（ＤＩＢへ描画）																				//
//																												//
//	引　数	：	hdc 		- ＤＩＢセクションビットマップのＤＣ												//
//				pPi	- プリンタ情報へのポインタ																	//
//				pDi	- ＤＩＢセクション情報へのポインタ															//
//				cbp 		- コールバックパラメタ																//
//																												//
//	戻り値	：	TRUE  - 印刷継続																				//
//				FALSE - 印刷終了（このページを印刷後に終了）													//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL CALLBACK cbDrawByDibSectDC(HDC hdc, PCAJCPRN_INFO pPi, PCAJCDIBINFO pDi, UX cbp)
{
	BOOL		rc;
	int 		CxChar, CyChar;
	int 		y, i, nLine;
	HFONT		hFontSv;
	TEXTMETRIC	tm;
	UT			buf[512];

	AjcDoEvent();																//	印刷中止ボタンチェック
	rc = fPrintContinue;														//	・

	//	テキストイメージ描画
	hFontSv = (HFONT)SelectObject(hdc, hFont);									//	フォント設定
	GetTextMetrics(hdc, &tm);													//	テキスト情報取得
	CxChar = __max(1, tm.tmAveCharWidth);										//	フォントサイズ設定
	CyChar = __max(1, tm.tmHeight + tm.tmExternalLeading);						//	・
	nLine = pDi->height / CyChar;												//	印刷可能行数設定
	for (i = 0, y = 0; i < nLine && AjcFGetS(hFile, buf, AJCTSIZE(buf)); i++) {	//	印刷可能行数数ループ
		MAjcStrTok(buf, TEXT("\x0A")); 											//			改行文字消去
		TextOut(hdc, 0, y, buf, (int)MAjcStrLen(buf)); 							//			テキスト描画
		y += CyChar;															//			ラスタ位置更新
	}
	SelectObject(hdc, hFontSv);

	//	外枠描画
	{
		HBRUSH hBru = (HBRUSH)SelectObject(hdc, GetStockObject(NULL_BRUSH));
		HPEN   hPen = (HPEN  )SelectObject(hdc, CreatePen(PS_SOLID, 5, RGB(0, 0, 0)));
		Rectangle(hdc, 0, 0, pDi->width, pDi->height);
		SelectObject(hdc, hBru);
		DeleteObject(SelectObject(hdc, hPen));
	}
	return fPrintContinue;		//	FALSE:終了，TRUE：継続
}
//--------------------------------------------------------------------------------------------------------------//
//	コールバック（プリンタＤＣへ描画）																			//
//																												//
//	引　数	：	hdc 		- プリンタのＤＣ																	//
//				pPi			- プリンタ情報へのポインタ															//
//				cbp 		- コールバックパラメタ																//
//																												//
//	戻り値	：	TRUE  - 印刷継続																				//
//				FALSE - 印刷終了（このページを印刷後に終了）													//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL CALLBACK cbDrawByPrinterDC(HDC hdc, PCAJCPRN_INFO pPi, UX cbp)
{
	BOOL		rc = FALSE;
	int 		CxChar, CyChar;
	int 		y, i, nLine;
	HFONT		hFontSv;
	TEXTMETRIC	tm;
	UT			buf[512];

	AjcDoEvent();																		//	印刷中止ボタンチェック
	rc = fPrintContinue;																//	・

	//	テキストイメージ描画
	hFontSv = (HFONT)SelectObject(hdc, hFont);											//	フォント設定
	GetTextMetrics(hdc, &tm);															//	テキスト情報取得
	CxChar = __max(1, tm.tmAveCharWidth);												//	フォントサイズ設定
	CyChar = __max(1, tm.tmHeight + tm.tmExternalLeading);								//	・
	nLine = pPi->cy / CyChar;															//	印刷可能行数設定
	for (i = 0, y = pPi->y; i < nLine && AjcFGetS(hFile, buf, AJCTSIZE(buf)); i++) {	//	印刷可能行数数ループ
		MAjcStrTok(buf, TEXT("\x0A")); 													//			改行文字消去
		TextOut(hdc, pPi->x, y, buf, (int)MAjcStrLen(buf)); 							//			テキスト描画
		y += CyChar;																	//			ラスタ位置更新
	}
	SelectObject(hdc, hFontSv);

	//	外枠描画
	{
		HBRUSH hBru = (HBRUSH)SelectObject(hdc, GetStockObject(NULL_BRUSH));
		HPEN   hPen = (HPEN  )SelectObject(hdc, CreatePen(PS_SOLID, 5, RGB(0, 0, 0)));
		Rectangle(hdc, pPi->x, pPi->y, pPi->x + pPi->cx, pPi->y + pPi->cy);
		SelectObject(hdc, hBru);
		DeleteObject(SelectObject(hdc, hPen));
	}
	return fPrintContinue;		//	FALSE:終了，TRUE：継続
}
