﻿//
//	SW_ProcessMemC.C
//
#include	<AjrCstXX.h>
#include	<stdio.h>
#include	<conio.h>
#include	<tchar.h>

static	BOOL CALLBACK cbEnumWindow(HWND hwnd, LPARAM lParam);
static	BOOL CALLBACK cbEnumChild (HWND hwnd, LPARAM lParam);

typedef struct	{
	TC_ITEM	tci;
	UT		txt[256];
} MYWORK, *PMYWORK;

int  AjcMain(int argc, UTP argv[])
{
	HWND	hWndProp = NULL;
	HWND	hTab;
	UI		Count = 0;
	UI		i;
	MYWORK	wrk;
	HAJCPM	hPm;
	BOOL	w64;

	AjcSetStdoutMode();

	//	実行環境チェック（６４ビットＯＳ下の３２ビットプロセスの場合メッセージ表示）
	if	(IsWow64Process(GetCurrentProcess(), &w64) && w64) {
		AjcPrintF(TEXT("\n64ビットWindowsでは正常に実行されません。SW_ProcessMemC_64Aを実行してください\n"));
	}

	EnumWindows(cbEnumWindow, (LPARAM)&hWndProp);
	if (IsWindow(hWndProp)) {
		//	プロパティウインド内のタブコントロール検索
		hTab = NULL;
		EnumChildWindows(hWndProp, cbEnumChild, (LPARAM)&hTab);
		//	タブコントロールあり・・・
		if (IsWindow(hTab)) {
			//	エクスプローラ・プロセス内にメモリ確保
			hPm = AjcPmCreateByWnd(hWndProp, sizeof wrk);
			//	タブコントロールのタブ数取得
			Count = (UI)SendMessage(hTab, TCM_GETITEMCOUNT, 0, 0);
			//	タブコントロール内のタブテキストをログ表示
			memset(&wrk, 0, sizeof wrk);
			wrk.tci.mask	   = TCIF_TEXT;
			wrk.tci.pszText    = (UTP)AjcPmGetAddr(hPm, sizeof wrk.tci);
			wrk.tci.cchTextMax = sizeof wrk.txt;
			for (i = 0; i < Count; i++) {
				//	タブテキスト取得，表示
				AjcPmWrite (hPm, 0, &wrk, sizeof wrk);
				SendMessage(hTab, TCM_GETITEM, i, AjcPmGetAddr(hPm, 0));
				AjcPmRead  (hPm, 0, &wrk, sizeof wrk);
				AjcPrintF(TEXT("  %s\n"), wrk.txt);
			}
			//	エクスプローラ・プロセス内のメモリ解放
			AjcPmDelete(hPm);
		}
		//	タブコントロールなし・・・
		else {
			AjcPrintF(TEXT("タブコントロールが見つかりません。\n"));
		}
	}
	else {
		AjcPrintF(TEXT("ドライブ・プロパティ・ウインドが見つかりません。\n"));
	}

	AjcPrintF(TEXT("\n Hit Enter Key !"));
	getchar();

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
//	エクスプローラ・ドライブ・プロパティウインド検索（「のプロパティ」を含むウインド検索）						//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL CALLBACK cbEnumWindow(HWND hwnd, LPARAM lParam)
{
	BOOL	rc = TRUE;
	UT		name[256];

	GetWindowText(hwnd, name, 256);

	if (MAjcStrStr(name, TEXT("のプロパティ"))) {
		*((HWND*)lParam) = hwnd;
		rc = FALSE;
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	エクスプローラ・ドライブ・プロパティウインド内のタブコントロール（子孫ウインド）検索						//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL CALLBACK cbEnumChild(HWND hwnd, LPARAM lParam)
{
	BOOL	rc = TRUE;
	UT		name[256];

	GetClassName(hwnd, name, 256);

	if (MAjcStrICmp(name, TEXT("SysTabControl32")) == 0) {
		*((HWND*)lParam) = hwnd;
		rc = FALSE;
	}
	return rc;
}
