﻿//
//	SW_Profile.c
//
#include	<AjrCstXX.h>
#include	<Shlwapi.h>
#include	<stdio.h>
#include	<tchar.h>
#include	"resource.h"

//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
static	HINSTANCE		hInst;							//	ＤＬＬインスタンスハンドル
static	HWND			hWndBack;						//	バックウインドハンドル
static	HWND			hDlgConf;						//	設定用ダイアロ・ハンドル
static	HWND			hDlgMain;						//	メインダイアロ・ハンドル
static	HWND			hVthLog;						//	ログウインドハンドル
static	UT				MyPath[MAX_PATH];				//	自プログラム設定値退避用レジストリパス
static	UT				MySect[] = _T("Settings");		//	自プログラム設定値退避用セクション
static	BOOL			fVolatile  = TRUE;				//	一時記録フラグ

//----- プロファイルＲ／Ｗテスト  デフォルト値／書き込み値 -----------------------------------------------------//
static	UI				defUInt =	10, wdUInt =  11;
static	SI				defSInt =  -10, wdSInt = -11;
static	UI				defHex	= 0x10, wdHex  = 0x11;
static	double			defReal = 10.0, wdReal = 11.0;
static	UT				defStr[256] = TEXT("DefStr"),	wdStr[256] = TEXT("WrtStr");

static	UI				wdArr[3] = {10, 20, 30};
static	double			wdBin[3] = {10.0, 20.0, 30.0};

//----- プロファイルＲ／Ｗテスト  読み出し値 -------------------------------------------------------------------//
static	UI				rdUInt;
static	SI				rdSInt;
static	UI				rdHex;
static	double			rdReal;
static	UT				rdStr[256];

static	UI				rdArr[3];
static	double			rdBin[3];

#define	MAX_ARR	((sizeof rdArr) / (sizeof rdArr[0]))

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC_DEF(Back);
AJC_DLGPROC_DEF(Conf);
AJC_DLGPROC_DEF(Main);

static	VO		SetProfileInfo(HWND hDlg);

static	VO		ReadSect1(VO);
static	VO		ReadSect2(VO);
static	VO		SaveRegInfo(VO);
static	VO		RecvRegInfo(VO);
static	VO		LoadAllDlgItems(HWND hDlg, C_UTP pSect);
static	VO		SaveAllDlgItems(HWND hDlg);

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 		msg;
	WNDCLASS	wndclass;
	UT			buf[MAX_PATH];
	UT			drv[_MAX_DRIVE], dir[_MAX_DIR], fname[_MAX_FNAME], ext[_MAX_EXT];

	hInst = hInstance;

	//----- 自プログラム用のINIファイルパス設定 --------//
	GetModuleFileName(NULL, buf, MAX_PATH);
	MAjcSplitPath(buf	, drv, dir, fname, ext);
	MAjcMakePath (MyPath, drv, dir, fname, TEXT(".ini"));
	PathCombine  (MyPath, MyPath, NULL);

	//----- バックウインド生成 -------------------------//
	wndclass.style			= 0;
	wndclass.lpfnWndProc	= AJC_WNDPROC_NAME(Back);
	wndclass.cbClsExtra 	= 0;
	wndclass.cbWndExtra 	= 0;
	wndclass.hInstance		= hInst;
	wndclass.hIcon			= NULL;
	wndclass.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wndclass.hbrBackground	= (HBRUSH)GetStockObject(WHITE_BRUSH);
	wndclass.lpszMenuName	= NULL;
	wndclass.lpszClassName	= TEXT("SW_Profile");
	RegisterClass(&wndclass);

	hWndBack = CreateWindow(TEXT("SW_Profile"),			// window class name
							TEXT("SW_Profile"),			// window caption
							WS_OVERLAPPEDWINDOW & ~WS_THICKFRAME,		// window style
							0,							// initial x position
							0,							// initial y position
							0,							// initial x size
							0,							// initial y size
							NULL,						// parent window handle
							NULL,						// window menu handle
							hInst,						// program instance handle
							NULL);						// creation parameters

	//----- ウインド表示 -------------------------------//
	ShowWindow(hWndBack, iCmdShow);
	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgConf, &msg)) break;
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}
	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	バックウインド・プロシージャ																				//
//																												//
//==============================================================================================================//
//----- WM_CREATE ----------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_CREATE 		)
{
	RECT	rm, r1, r2;
	int		w1, h1, w2, h2;
	int		sty = (int)MAjcGetWindowLong(hwnd, GWL_STYLE);
	int		exs = (int)MAjcGetWindowLong(hwnd, GWL_EXSTYLE);

	hWndBack = hwnd;
	//----- ダイアログ生成 -------------------------------------------//
	hDlgConf = CreateDialog(hInst, MAKEINTRESOURCE(IDD_DLGCONF), hWndBack, AJC_DLGPROC_NAME(Conf));
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_DLGMAIN), hWndBack, AJC_DLGPROC_NAME(Main));
	//----- ダイアログサイズ設定 -------------------------------------//
	GetWindowRect(hDlgConf, &r1);	GetWindowRect(hDlgMain, &r2);
	w1 = r1.right - r1.left;		w2 = r2.right - r2.left;
	h1 = r1.bottom - r1.top;		h2 = r2.bottom - r2.top;
	//----- ウインドサイズ設定 ---------------------------------------//
	sty = (int)MAjcGetWindowLong(hWndBack, GWL_STYLE);
	exs = (int)MAjcGetWindowLong(hWndBack, GWL_EXSTYLE);
	rm.left = rm.top = 0;
	rm.right  = __max(w1, w2);
	rm.bottom = h1 + h2;
	AdjustWindowRectEx(&rm, sty, FALSE, exs);
	SetWindowPos(hwnd, NULL, 0, 0, rm.right - rm.left, rm.bottom - rm.top, SWP_NOMOVE);
	//----- ダイアログ移動 -------------------------------------------//
	SetWindowPos(hDlgConf, NULL, 0, 0 , 0, 0, SWP_NOSIZE);
	SetWindowPos(hDlgMain, NULL, 0, h1, 0, 0, SWP_NOSIZE);
	//----- ウインド表示 ---------------------------------------------//
	ShowWindow(hDlgMain, SW_SHOW);
	ShowWindow(hDlgConf, SW_SHOW);

	return 0;
}
//----- WM_DESTROY ---------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_DESTROY		)
{
	//----- ダイアログ破棄 -------------------------------------------//
	DestroyWindow(hDlgConf);
	DestroyWindow(hDlgMain);
	//----- プログラム終了 -------------------------------------------//
	PostQuitMessage(0);
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(Back)
	AJC_WNDMAP_MSG(Back, WM_CREATE	   )
	AJC_WNDMAP_MSG(Back, WM_DESTROY    )
AJC_WNDMAP_END
//==============================================================================================================//
//																												//
//	設定情報・ダイアログ・プロシージャ																			//
//																												//
//==============================================================================================================//
static	BOOL			fEndOfInit = FALSE;				//	初期化終了フラグ
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Conf, WM_INITDIALOG 	)
{
	UT		txt[MAX_PATH];
	UT		drv[_MAX_DRIVE], dir[_MAX_DIR], fname[_MAX_FNAME], fext[_MAX_EXT];

	hDlgConf = hDlg;
	//	ダイアログ項目のデフォルト設定
	AjcSetDlgItemChk(hDlg, IDC_RBT_REG, TRUE);			//	アクセス先＝レジストリ
	AjcSetDlgItemChk(hDlg, IDC_CHK_VOLATILE, TRUE);		//	一時記録
	AjcGetIniFilePath(txt, MAX_PATH);					//	INIファイルパス
	MAjcSplitPath(txt, drv, dir,fname, fext);
	MAjcStrCat(fname, _MAX_FNAME, TEXT("_Data"));
	MAjcMakePath (txt, drv, dir, fname, fext);
	AjcSetDlgItemStr(hDlg, IDC_TXT_INIPATH, txt);
	AjcGetRegRootPath(txt, MAX_PATH);					//	レジストリルートパス
	AjcSetDlgItemStr(hDlg, IDC_TXT_ROOTPATH, txt);
	AjcGetRegMidPath(txt, MAX_PATH);					//	レジストリミドルパス
	MAjcStrCat(txt, MAX_PATH, TEXT("_Data"));
	AjcSetRegMidPath(txt);
	AjcSetDlgItemStr(hDlg, IDC_TXT_MIDPATH, txt);
	AjcGetProfilePath(txt, MAX_PATH);					//	レジストリパス
	AjcSetDlgItemStr(hDlg, IDC_TXT_REGPATH, txt);
	AjcGetBinDataDir(txt, MAX_PATH);					//	バイナリデータ格納フォルダパス
	AjcSetDlgItemStr(hDlg, IDC_TXT_BINPATH, txt);
	//	ダイアログ設定値ロード
	LoadAllDlgItems(hDlg, TEXT("Settings"));
	//	初期化終了の旨設定
	fEndOfInit =TRUE;
	//	プロファイルアクセス先設定
	SetProfileInfo(hDlg);
	//	プロファイル読み出し
	ReadSect1();
	ReadSect2();

	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Conf, WM_DESTROY		)
{
	//	ダイアログ設定値セーブ
	SaveAllDlgItems(hDlg);

	return TRUE;
}
//----- WM_COMMAND ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Conf, WM_COMMAND		)
{
	UI		cmd = LOWORD(wParam);
	UI		act = HIWORD(wParam);

	//	初期化終了後
	if (fEndOfInit) {
		//	設定変更ならばプロファイルアクセス先設定し全データ読み出し
		if (((cmd == IDC_RBT_INI || cmd == IDC_RBT_REG || cmd == IDC_CHK_VOLATILE) && act == BN_CLICKED) || act == EN_CHANGE) {
			SetProfileInfo(hDlg);
			ReadSect1();
			ReadSect2();
		}
	}
	return TRUE;
}
//----- INIファイルパスを開くボタン ----------------------------------------------------------------------------//
AJC_DLGPROC(Conf, IDC_CMD_OPENINI	)
{
	UT		path[MAX_PATH];
	AjcGetDlgItemStr(hDlg, IDC_TXT_INIPATH, path, MAX_PATH);
	ShellExecute(NULL, TEXT("open"), path, NULL, NULL, SW_SHOWNORMAL);
	return TRUE;
}
//----- キャンセル ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Conf, IDCANCEL			)
{
	DestroyWindow(hDlg);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Conf)
	AJC_DLGMAP_MSG(Conf, WM_INITDIALOG	   )
	AJC_DLGMAP_MSG(Conf, WM_DESTROY		   )
	AJC_DLGMAP_MSG(Conf, WM_COMMAND		   )

	AJC_DLGMAP_CMD(Conf, IDC_CMD_OPENINI   )
	AJC_DLGMAP_CMD(Conf, IDCANCEL		   )
AJC_DLGMAP_END
//--------------------------------------------------------------------------------------------------------------//
//	プロファイルアクセス先設定																					//
//--------------------------------------------------------------------------------------------------------------//
static	VO		SetProfileInfo(HWND hDlg)
{
	UT		txt[MAX_PATH];

	//	データ用プロファイル記録先設定
	if (AjcGetDlgItemChk(hDlg, IDC_RBT_INI)) {
		AjcSetProfileIsRegistory(FALSE);									//	アクセス先＝INIファイル
		AjcGetDlgItemStr(hDlg, IDC_TXT_INIPATH, txt, MAX_PATH);				//	INIファイルパス設定
		AjcSetIniFilePath(txt);
	}
	else {
		AjcSetProfileIsRegistory(TRUE);										//	アクセス先＝レジストリ
		AjcGetDlgItemStr(hDlg, IDC_TXT_ROOTPATH, txt, MAX_PATH);			//	レジストリルートパス設定
		AjcSetRegRootPath(txt);
		AjcGetDlgItemStr(hDlg, IDC_TXT_MIDPATH, txt, MAX_PATH);				//	レジストリミドルパス設定
		AjcSetRegMidPath(txt);
		AjcSetRegOptionVolatile(AjcGetDlgItemChk(hDlg, IDC_CHK_VOLATILE));	//	恒久記録／一時記録設定
	}
	AjcGetDlgItemStr(hDlg, IDC_TXT_BINPATH, txt, MAX_PATH);					//	バイナリデータ格納パス設定
	AjcSetBinDataDir(txt);

}
//==============================================================================================================//
//																												//
//	データ・ダイアログ・プロシージャ																			//
//																												//
//==============================================================================================================//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG 	)
{
	hDlgMain = hDlg;
	hVthLog	 = GetDlgItem(hDlg, IDC_VTH_LOG);

	//	プロファイルテストのデフォルト値設定
	AjcSetDlgItemUInt(hDlg, IDC_TXT_UINTDEF, defUInt);
	AjcSetDlgItemSInt(hDlg, IDC_TXT_SINTDEF, defSInt);
	AjcSetDlgItemHex (hDlg, IDC_TXT_HEXDEF , defHex );
	AjcSetDlgItemReal(hDlg, IDC_TXT_REALDEF, defReal, 2);
	AjcSetDlgItemStr (hDlg, IDC_TXT_STRDEF , defStr);

	AjcSetDlgItemUInt(hDlg, IDC_TXT_UINTWD , wdUInt);
	AjcSetDlgItemSInt(hDlg, IDC_TXT_SINTWD , wdSInt);
	AjcSetDlgItemHex (hDlg, IDC_TXT_HEXWD  , wdHex );
	AjcSetDlgItemReal(hDlg, IDC_TXT_REALWD , wdReal , 2);
	AjcSetDlgItemStr (hDlg, IDC_TXT_STRWD  , wdStr );

	AjcSetDlgItemSInt(hDlg, IDC_TXT_ARRWD0 , wdArr[0]);
	AjcSetDlgItemSInt(hDlg, IDC_TXT_ARRWD1 , wdArr[1]);
	AjcSetDlgItemSInt(hDlg, IDC_TXT_ARRWD2 , wdArr[2]);

	AjcSetDlgItemReal(hDlg, IDC_TXT_BINWD0 , wdBin[0], 2);
	AjcSetDlgItemReal(hDlg, IDC_TXT_BINWD1 , wdBin[1], 2);
	AjcSetDlgItemReal(hDlg, IDC_TXT_BINWD2 , wdBin[2], 2);
	//	ダイアログ設定値ロード
	LoadAllDlgItems(hDlg, TEXT("Data"));
	//	プロファイル読み出し
	ReadSect1();
	ReadSect2();

	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY		)
{
	//	ダイアログ設定値セーブ
	SaveAllDlgItems(hDlg);

	return TRUE;
}
//----- UInt Ｗボタン ------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_UINTW 	)
{
	wdUInt = AjcGetDlgItemUInt(hDlg, IDC_TXT_UINTWD);
	AjcSetDlgItemUInt(hDlg, IDC_TXT_UINTWD, wdUInt);
	AjcPutProfileUInt(TEXT("SECT1"), TEXT("KeyUInt"), wdUInt);

	return TRUE;
}
//----- UInt Ｒボタン ------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_UINTR 	)
{
	rdUInt = AjcGetProfileUInt(TEXT("SECT1"), TEXT("KeyUInt"), defUInt);
	AjcSetDlgItemUInt(hDlg, IDC_TXT_UINTRD, rdUInt);

	return TRUE;
}
//----- UInt ＤＥＬボタン --------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_UINTDEL	)
{
	AjcDelProfileKey(TEXT("SECT1"), TEXT("KeyUInt"));
	SendMessage(hDlg, WM_COMMAND, MAKELONG(IDC_CMD_UINTR, BN_CLICKED), (LPARAM)GetDlgItem(hDlg, IDC_CMD_UINTR));

	return TRUE;
}
//----- SInt Ｗボタン ------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_SINTW 	)
{
	wdSInt = AjcGetDlgItemSInt(hDlg, IDC_TXT_SINTWD);
	AjcSetDlgItemSInt(hDlg, IDC_TXT_SINTWD, wdSInt);
	AjcPutProfileSInt(TEXT("SECT1"), TEXT("KeySInt"), wdSInt);

	return TRUE;
}
//----- SInt Ｒボタン ------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_SINTR 	)
{
	rdSInt = AjcGetProfileSInt(TEXT("SECT1"), TEXT("KeySInt"), defSInt);
	AjcSetDlgItemSInt(hDlg, IDC_TXT_SINTRD, rdSInt);

	return TRUE;
}
//----- SInt ＤＥＬボタン --------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_SINTDEL	)
{
	AjcDelProfileKey(TEXT("SECT1"), TEXT("KeySInt"));
	SendMessage(hDlg, WM_COMMAND, MAKELONG(IDC_CMD_SINTR, BN_CLICKED), (LPARAM)GetDlgItem(hDlg, IDC_CMD_SINTR));

	return TRUE;
}
//----- Hex Ｗボタン -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_HEXW		)
{
	wdHex = AjcGetDlgItemHex(hDlg, IDC_TXT_HEXWD);
	AjcSetDlgItemHex(hDlg, IDC_TXT_HEXWD, wdHex);
	AjcPutProfileHex(TEXT("SECT1"), TEXT("KeyHex"), wdHex);

	return TRUE;
}
//----- Hex Ｒボタン -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_HEXR		)
{
	rdHex = AjcGetProfileHex(TEXT("SECT1"), TEXT("KeyHex"), defHex);
	AjcSetDlgItemHex(hDlg, IDC_TXT_HEXRD, rdHex);

	return TRUE;
}
//----- Hex ＤＥＬボタン ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_HEXDEL	)
{
	AjcDelProfileKey(TEXT("SECT1"), TEXT("KeyHex"));
	SendMessage(hDlg, WM_COMMAND, MAKELONG(IDC_CMD_HEXR , BN_CLICKED), (LPARAM)GetDlgItem(hDlg, IDC_CMD_HEXR ));

	return TRUE;
}
//----- Real Ｗボタン ------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_REALW 	)
{
	wdReal = AjcGetDlgItemReal(hDlg, IDC_TXT_REALWD);
	AjcSetDlgItemReal(hDlg, IDC_TXT_REALWD, wdReal, 2);
	AjcPutProfileReal(TEXT("SECT1"), TEXT("KeyReal"), wdReal);

	return TRUE;
}
//----- Real Ｒボタン ------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_REALR 	)
{
	rdReal = AjcGetProfileReal(TEXT("SECT1"), TEXT("KeyReal"), defReal);
	AjcSetDlgItemReal(hDlg, IDC_TXT_REALRD, rdReal, 2);

	return TRUE;
}
//----- Real ＤＥＬボタン --------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_REALDEL	)
{
	AjcDelProfileKey(TEXT("SECT1"), TEXT("KeyReal"));
	SendMessage(hDlg, WM_COMMAND, MAKELONG(IDC_CMD_REALR, BN_CLICKED), (LPARAM)GetDlgItem(hDlg, IDC_CMD_REALR));

	return TRUE;
}
//----- Str Ｗボタン -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_STRW		)
{
	AjcGetDlgItemStr(hDlg, IDC_TXT_STRWD, wdStr, AJCTSIZE(wdStr));
	AjcSetDlgItemStr(hDlg, IDC_TXT_STRWD, wdStr);
	AjcPutProfileStr(TEXT("SECT1"), TEXT("KeyStr"), wdStr);

	return TRUE;
}
//----- Str Ｒボタン -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_STRR		)
{
	AjcGetProfileStr(TEXT("SECT1"), TEXT("KeyStr"), defStr, rdStr, AJCTSIZE(rdStr));
	AjcSetDlgItemStr(hDlg, IDC_TXT_STRRD, rdStr);

	return TRUE;
}
//----- Str ＤＥＬボタン ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_STRDEL	)
{
	AjcDelProfileKey(TEXT("SECT1"), TEXT("KeyStr"));
	SendMessage(hDlg, WM_COMMAND, MAKELONG(IDC_CMD_STRR , BN_CLICKED), (LPARAM)GetDlgItem(hDlg, IDC_CMD_STRR ));

	return TRUE;
}
//----- Arr Ｗボタン -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_ARRW		)
{
	wdArr[0] = AjcGetDlgItemUInt(hDlg, IDC_TXT_ARRWD0);
	wdArr[1] = AjcGetDlgItemUInt(hDlg, IDC_TXT_ARRWD1);
	wdArr[2] = AjcGetDlgItemUInt(hDlg, IDC_TXT_ARRWD2);
	AjcSetDlgItemUInt(hDlg, IDC_TXT_ARRWD0, wdArr[0]);
	AjcSetDlgItemUInt(hDlg, IDC_TXT_ARRWD1, wdArr[1]);
	AjcSetDlgItemUInt(hDlg, IDC_TXT_ARRWD2, wdArr[2]);
	AjcPutProfileArr(TEXT("SECT2"), TEXT("KeyArr"), wdArr, sizeof wdArr[0], sizeof wdArr / sizeof wdArr[0]);

	return TRUE;
}
//----- Arr Ｒボタン -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_ARRR		)
{
	if (AjcGetProfileArr(TEXT("SECT2"), TEXT("KeyArr"), rdArr, sizeof rdArr[0], sizeof rdArr / sizeof rdArr[0]) == MAX_ARR) {
		AjcSetDlgItemUInt(hDlg, IDC_TXT_ARRRD0, rdArr[0]);
		AjcSetDlgItemUInt(hDlg, IDC_TXT_ARRRD1, rdArr[1]);
		AjcSetDlgItemUInt(hDlg, IDC_TXT_ARRRD2, rdArr[2]);
	}
	else {
		AjcSetDlgItemStr(hDlg, IDC_TXT_ARRRD0, TEXT("-"));
		AjcSetDlgItemStr(hDlg, IDC_TXT_ARRRD1, TEXT("-"));
		AjcSetDlgItemStr(hDlg, IDC_TXT_ARRRD2, TEXT("-"));
	}

	return TRUE;
}
//----- Arr ＤＥＬボタン ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_ARRDEL	)
{
	AjcDelProfileKey(TEXT("SECT2"), TEXT("KeyArr"));
	SendMessage(hDlg, WM_COMMAND, MAKELONG(IDC_CMD_ARRR, BN_CLICKED), (LPARAM)GetDlgItem(hDlg, IDC_CMD_ARRR));

	return TRUE;
}
//----- Bin Ｗボタン -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_BINW		)
{
	wdBin[0] = AjcGetDlgItemReal(hDlg, IDC_TXT_BINWD0);
	wdBin[1] = AjcGetDlgItemReal(hDlg, IDC_TXT_BINWD1);
	wdBin[2] = AjcGetDlgItemReal(hDlg, IDC_TXT_BINWD2);
	AjcSetDlgItemReal(hDlg, IDC_TXT_BINWD0, wdBin[0], 2);
	AjcSetDlgItemReal(hDlg, IDC_TXT_BINWD1, wdBin[1], 2);
	AjcSetDlgItemReal(hDlg, IDC_TXT_BINWD2, wdBin[2], 2);
	AjcPutProfileBin(TEXT("SECT2"), TEXT("KeyBin"), wdBin, sizeof wdBin);

	return TRUE;
}
//----- Bin Ｒボタン -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_BINR		)
{
	if (AjcGetProfileBin(TEXT("SECT2"), TEXT("KeyBin"), rdBin, sizeof rdBin) == sizeof rdBin) {
		AjcSetDlgItemReal(hDlg, IDC_TXT_BINRD0, rdBin[0], 2);
		AjcSetDlgItemReal(hDlg, IDC_TXT_BINRD1, rdBin[1], 2);
		AjcSetDlgItemReal(hDlg, IDC_TXT_BINRD2, rdBin[2], 2);
	}
	else {
		AjcSetDlgItemStr(hDlg, IDC_TXT_BINRD0, TEXT("-"));
		AjcSetDlgItemStr(hDlg, IDC_TXT_BINRD1, TEXT("-"));
		AjcSetDlgItemStr(hDlg, IDC_TXT_BINRD2, TEXT("-"));
	}
	return TRUE;
}
//----- Bin ＤＥＬボタン ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_BINDEL	)
{
	AjcDelProfileKey(TEXT("SECT2"), TEXT("KeyBin"));
	SendMessage(hDlg, WM_COMMAND, MAKELONG(IDC_CMD_BINR, BN_CLICKED), (LPARAM)GetDlgItem(hDlg, IDC_CMD_BINR));

	return TRUE;
}
//----- SECT1 セクション消去ボタン -----------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_SECT1DEL	)
{
	AjcDelProfileSect(TEXT("SECT1"));
	ReadSect1();

	return TRUE;
}
//----- SECT2 セクション消去ボタン -----------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_SECT2DEL	)
{
	AjcDelProfileSect(TEXT("SECT2"));
	ReadSect2();

	return TRUE;
}
//----- セクション名収集 ---------------------------------------------------------------------------------------//
static BOOL CALLBACK cbEnumName (C_UTP pName, UX cbp)
{
	AjcVthPrintF(hVthLog, TEXT("  ・%s\n"), pName);
	return TRUE;
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
AJC_DLGPROC(Main, IDC_CMD_DATASECT	)
{
	int		n;
	AjcVthPrintF(hVthLog, TEXT("\n--- セクション名収集 ---\n"));
	n = AjcEnumProfileSect(0, cbEnumName);
	AjcVthPrintF(hVthLog, TEXT("  %d sections found.\n"), n);
	return TRUE;
}
//----- キー名収集（SECT1）-------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_DATAKEY1	)
{
	int		n;
	AjcVthPrintF(hVthLog, TEXT("\n--- セクション(SECT1)内のキー名収集 ---\n"));
	n = AjcEnumProfileKey(TEXT("SECT1"), 0, cbEnumName);
	AjcVthPrintF(hVthLog, TEXT("  %d keys found.\n"), n);
	return TRUE;
}
//----- キー名収集（SECT2）-------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_DATAKEY2	)
{
	int		n;
	AjcVthPrintF(hVthLog, TEXT("\n--- セクション(SECT2)内のキー名収集 ---\n"));
	n = AjcEnumProfileKey(TEXT("SECT2"), 0, cbEnumName);
	AjcVthPrintF(hVthLog, TEXT("  %d keys found.\n"), n);
	return TRUE;
}
//----- ウインドクローズ ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL			)
{
	DestroyWindow(hDlg);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG	   )
	AJC_DLGMAP_MSG(Main, WM_DESTROY 	   )

	AJC_DLGMAP_CMD(Main, IDC_CMD_UINTW	   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_UINTR	   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_UINTDEL   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_SINTW	   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_SINTR	   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_SINTDEL   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_HEXW	   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_HEXR	   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_HEXDEL    )
	AJC_DLGMAP_CMD(Main, IDC_CMD_REALW	   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_REALR	   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_REALDEL   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_STRW	   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_STRR	   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_STRDEL    )
	AJC_DLGMAP_CMD(Main, IDC_CMD_ARRW	   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_ARRR	   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_ARRDEL    )
	AJC_DLGMAP_CMD(Main, IDC_CMD_BINW	   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_BINR	   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_BINDEL    )
	AJC_DLGMAP_CMD(Main, IDC_CMD_SECT1DEL  )
	AJC_DLGMAP_CMD(Main, IDC_CMD_SECT2DEL  )
	AJC_DLGMAP_CMD(Main, IDC_CMD_DATASECT  )
	AJC_DLGMAP_CMD(Main, IDC_CMD_DATAKEY1  )
	AJC_DLGMAP_CMD(Main, IDC_CMD_DATAKEY2  )
	AJC_DLGMAP_CMD(Main, IDCANCEL		   )
AJC_DLGMAP_END
//--------------------------------------------------------------------------------------------------------------//
//	SECT1セクションの全データ読み出し																			//
//--------------------------------------------------------------------------------------------------------------//
static	VO		ReadSect1(VO)
{
	SendMessage(hDlgMain, WM_COMMAND, MAKELONG(IDC_CMD_UINTR, BN_CLICKED), (LPARAM)GetDlgItem(hDlgMain, IDC_CMD_UINTR));
	SendMessage(hDlgMain, WM_COMMAND, MAKELONG(IDC_CMD_SINTR, BN_CLICKED), (LPARAM)GetDlgItem(hDlgMain, IDC_CMD_SINTR));
	SendMessage(hDlgMain, WM_COMMAND, MAKELONG(IDC_CMD_HEXR , BN_CLICKED), (LPARAM)GetDlgItem(hDlgMain, IDC_CMD_HEXR ));
	SendMessage(hDlgMain, WM_COMMAND, MAKELONG(IDC_CMD_REALR, BN_CLICKED), (LPARAM)GetDlgItem(hDlgMain, IDC_CMD_REALR));
	SendMessage(hDlgMain, WM_COMMAND, MAKELONG(IDC_CMD_STRR , BN_CLICKED), (LPARAM)GetDlgItem(hDlgMain, IDC_CMD_STRR ));
}
//--------------------------------------------------------------------------------------------------------------//
//	SECT2セクションの全データ読み出し																			//
//--------------------------------------------------------------------------------------------------------------//
static	VO		ReadSect2(VO)
{
	SendMessage(hDlgMain, WM_COMMAND, MAKELONG(IDC_CMD_ARRR, BN_CLICKED), (LPARAM)GetDlgItem(hDlgMain, IDC_CMD_ARRR));
	SendMessage(hDlgMain, WM_COMMAND, MAKELONG(IDC_CMD_BINR, BN_CLICKED), (LPARAM)GetDlgItem(hDlgMain, IDC_CMD_BINR));
}
//--------------------------------------------------------------------------------------------------------------//
//	レジストリ記録先情報を退避し、特定の記録先設定																//
//--------------------------------------------------------------------------------------------------------------//
static	VO	SaveRegInfo(VO)
{
	//	記録先退避
	AjcPushProfileStack();
	//	特定の記録先設定
	AjcSetProfileIsRegistory(TRUE);
	AjcSetRegOptionVolatile(FALSE);
	AjcSetRegRootPath(TEXT("Software\\AjrCstXX"));
	AjcSetRegMidPath (TEXT("SW_Profile\\Conf"));
}
//--------------------------------------------------------------------------------------------------------------//
//	レジストリ記録先情 回復 																					//
//--------------------------------------------------------------------------------------------------------------//
static	VO	RecvRegInfo(VO)
{
	AjcPopProfileStack();
}
//--------------------------------------------------------------------------------------------------------------//
//	特定のレジストリからダイアログの全項目をロード																//
//--------------------------------------------------------------------------------------------------------------//
static	VO	LoadAllDlgItems(HWND hDlg, C_UTP pSect)
{
	SaveRegInfo();												//	レジストリ記録先情報を退避し、特定の記録先設定
	AjcLoadAllControlSettings(hDlg, pSect, AJCCTL_SELACT_ALL);	//	ダイアログの全項目をロード
	RecvRegInfo();												//	レジストリ記録先情 回復	

}
//--------------------------------------------------------------------------------------------------------------//
//	特定のレジストリにダイアログの全項目をセーブ																//
//--------------------------------------------------------------------------------------------------------------//
static	VO	SaveAllDlgItems(HWND hDlg)
{
	SaveRegInfo();												//	レジストリ記録先情報を退避し、特定の記録先設定
	AjcSaveAllControlSettings(hDlg);							//	ダイアログの全項目をセーブ
	RecvRegInfo();												//	レジストリ記録先情 回復	
}
