﻿//
//	SW_RingBufC.c
//
#include	<AjrCstXX.h>
#include	<stdio.h>
#include	<tchar.h>

#define STA_SIZE	64			//	スタティック・リングバッファサイズ
#define EXP_SIZE	32			//	拡張リングバッファサイズ

static	UB	StaticBuf[STA_SIZE];
static	UI	AllocCount = 0;

//------------------------------------------------------------------------------------------//
//	ｍ ａ ｉ ｎ 																			//
//------------------------------------------------------------------------------------------//
int  AjcMain(int argc, UTP argv[])
{
	UI		i, n, len;
	UT		buf[256];
	HAJCRNG hRng;

	AjcSetStdoutMode();

	AjcPrintF(TEXT("入力したテキストをリングバッファに蓄えます。\n"));
	AjcPrintF(TEXT("但し、以下の入力はコマンドとして扱います。\n"));
	AjcPrintF(TEXT("　　１桁の数字：指定個数の文字列をリングバッファから取り出して表示\n"));
	AjcPrintF(TEXT("　　　空行　　：全ての文字列をリングバッファから取り出して表示\n"));
	AjcPrintF(TEXT("　　　 Ｋ　　 ：リングバッファ中の最古の文字列を表示\n"));
	AjcPrintF(TEXT("　　　 Ｐ　　 ：リングバッファ中の全データ破棄\n"));
	AjcPrintF(TEXT("　　　ESCキー ：プログラム終了\n"));
	AjcPrintF(TEXT("\n"));

	//----- インスタンス初期化 ----------------------------------------------------------------------//
	if (argc > 1) {
		if		(MAjcStrICmp(argv[1], TEXT("S")) == 0) hRng = AjcRngCreate(StaticBuf, STA_SIZE, 0 	  );
		else if (MAjcStrICmp(argv[1], TEXT("E")) == 0) hRng = AjcRngCreate(NULL	  , 0		, EXP_SIZE);
		else								 hRng = AjcRngCreate(StaticBuf, STA_SIZE, EXP_SIZE);
	}
	else {
		hRng = AjcRngCreate(StaticBuf, STA_SIZE, EXP_SIZE);
	}

	//----- メインループ ----------------------------------------------------------------------------//
	AjcPrintF(TEXT("Input(%5u) - "), AjcRngGetDataSize(hRng));
	while (AjcConInput(NULL, 128, buf, AJCTSIZE(buf), AJCCIN_SHOWTEXT)) {
		//----- Ｐ：全データ破棄 -----------------//
		if		(MAjcStrICmp(buf, TEXT("P")) == 0) {
			AjcRngPurge(hRng);
		}
		//----- Ｋ：最古の文字列表示 -------------//
		else if (MAjcStrICmp(buf, TEXT("K")) == 0) {
			struct {int len; BC txt[1024];} s;
			if (AjcRngPeekData(hRng, &s.len, sizeof s.len) == sizeof s.len) {
				AjcRngPeekData(hRng, &s, sizeof s.len + s.len);
				s.txt[s.len] = 0;
				AjcPrintF(TEXT("%s (Remain %u)\n"), s.txt, AjcRngGetDataSize(hRng));
			}
		}
		//----- 数字：指定個数を取り出し表示 -----//
		else if (isdigit(buf[0]) && buf[1] == 0) {
			n = _ttoi(buf);
			for (i=0; i<n && AjcRngGetData(hRng, &len, sizeof len) == sizeof len; i++) {
				len = AjcRngGetData(hRng, buf, len);
				AjcPrintF(TEXT("%s (Remain %u)\n"), buf, AjcRngGetDataSize(hRng));
			}
		}
		//----- 空行：全数を取り出し表示 --------//
		else if (buf[0] == 0		   ) {
			while (AjcRngGetData(hRng, &len, sizeof len) == sizeof len) {
				len = AjcRngGetData(hRng, buf, len);
				AjcPrintF(TEXT("%s (Remain %u)\n"), buf, AjcRngGetDataSize(hRng));
			}
		}
		//----- その他：データを格納 ------------//
		else {
			struct {UI stl; UT txt[256];} dat;
			MAjcStrCpy(dat.txt, AJCTSIZE(dat.txt), buf);
			dat.stl = (UI)(MAjcStrLen(dat.txt) + 1) * sizeof(UT);
			AjcRngPutDataEx(hRng, &dat , sizeof(UI) + dat.stl);
		}
		AjcPrintF(TEXT("Input(%5u) - "), AjcRngGetDataSize(hRng));
	}

	AjcRngDelete(hRng);

	return 0;
}
