﻿//
// SW_SSepC.c
//
#include	<AjrCstXX.h>
#include	<stdio.h>
#include	<tchar.h>

//----- インスタンスハンドル --------------------------------------------//
static	HAJCSSEP	hSsep;
//----- 制御コード ------------------------------------------------------//
#define STX 0x02
#define ETX 0x03
#define DLE 0x10
#define ESC 0x1B
//----- バイトストリームデータ ------------------------------------------//
static	UB			Data1[] = {0x1B, '[' , 'A' , 'D' , 'E' , 'F' , 0x0D, 'G' , 'H' , 0x0D, DLE};
static	UB			Data2[] = {STX , 0x09, DLE , DLE , 0x11, DLE , ETX , 'X' , 'Y' , 0x0D};

//--------------------------------------------------------------------------------------------------------------//
//	テキストデータのダンプ表示																					//
//--------------------------------------------------------------------------------------------------------------//
static	VO	DumpText(UTP pDat, UI lDat)
{
	AjcPrintF(TEXT("\""));
	while (lDat--) {
		if (_istcntrl(*pDat)) AjcPrintF(TEXT("\\x%02X"), *pDat);
		else				  AjcPrintF(TEXT("%c"), *pDat);
		pDat++;
	}
	AjcPrintF(TEXT("\""));
}
//--------------------------------------------------------------------------------------------------------------//
//	パケットデータのダンプ表示																					//
//--------------------------------------------------------------------------------------------------------------//
static	VO	DumpPacket(UBP pDat, UI lDat)
{
	while (lDat--) {
		AjcPrintF(TEXT(" %02X"), *pDat++);
	}
}
//--------------------------------------------------------------------------------------------------------------//
//	イベント通知用コールバック関数																				//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL  CALLBACK cbEvent(UI evt, VOP pDat, UI lDat, UX cbp)
{
	switch (evt) {
		case AJCSSEP_EV_TXT:					//	●テキスト通知
			AjcPrintF(TEXT("TXT  : "));
			DumpText((UTP)pDat, lDat);
			AjcPrintF(TEXT("\n"));
			break;

		case AJCSSEP_EV_ESC:					//	●ＥＳＣコード通知
			AjcPrintF(TEXT("ESC  : "));
			DumpText((UTP)pDat, lDat);
			AjcPrintF(TEXT("\n"));
			break;

		case AJCSSEP_EV_CTRL:					//	●制御コード通知
			AjcPrintF(TEXT("CTRL : "));
			DumpText((UTP)pDat, lDat);
			AjcPrintF(TEXT("\n"));
			break;

		case AJCSSEP_EV_PKT:					//	●パケットデータ通知
			AjcPrintF(TEXT("PKT  : "));
			DumpPacket((UBP)pDat, lDat);
			AjcPrintF(TEXT("\n"));
			break;

	}
	return TRUE;	// TRUE:データメモリ開放
}
//--------------------------------------------------------------------------------------------------------------//
//	m a i n 																									//
//--------------------------------------------------------------------------------------------------------------//
int  AjcMain(int argc, UTP argv[])
{
	AjcSetStdoutMode();

	hSsep = AjcSsepCreate(AJCSSEP_EV_ALL, 0, cbEvent);			   //  インスタンス生成
	AjcSsepPutData(hSsep, Data1, sizeof Data1); 				   //  バイトストリーム１投与
	AjcSsepPutData(hSsep, Data2, sizeof Data2); 				   //  バイトストリーム２投与
	AjcSsepDelete(hSsep);										   //  インスタンス消去

	getchar();
	return 0;
}
