﻿//
//	SW_SerialComPort1.c
//

#define AJCSOCKSERV_H_
#define AJCSOCKCLIENT_H_
#include	<AjrCstXX.h>
#include	<tchar.h>
#include	"resource.h"

#define WM_SCPEVENT 	(WM_USER + 100)
#define	MAX_TXTBOX_LEN	128

//--------------------------------------------------------------------------------------------------------------//
//	ツールチップ																								//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	int		id;
	C_UTP	pTxt;
} TIPTBL, *PTIPTBL;
typedef const TIPTBL *PCTIPTBL;

static const TIPTBL TipTbl[] = {
	{IDC_TXT_SNDTEXT	, TEXT("Ｃ言語表記のテキストを設定してください。（ex. ABC\\n）")									},
	{IDC_VTH_TXTCHUNK	, TEXT("リアルタイムに受信したデータをテキストデータとして表示します。\n")
						  TEXT("複数バイト文字の場合は、文字が完結するまで次のリアルタイム受信データを待ちます。")			},
	{IDC_VTH_BINCHUNK	, TEXT("リアルタイムに受信したデータをバイナリデータとして表示します。")							},
	{IDC_VTH_INVCHUNK	, TEXT("リアルタイムに受信したテキストデータに不正な制御コードが含まれる場合は、\n")
						  TEXT("テキストチャンクではなく、不正チャンクテキストとしてバイナリ表示します。\n")
						  TEXT("不正な制御コードとは、TAB(0x09)～CR(0x0D)以外の制御コードを意味します。")					},
	{IDC_VTH_TEXT		, TEXT("受信ストリームから制御コード（TAB以外）で区切られたテキストデータを抜き出して表示します。\n")
						  TEXT("\x1B[34mここにファイルをドロップすると、ファイルの内容をバイナリデータとして送信します。")	},
	{IDC_VTH_CTRL		, TEXT("受信ストリームから制御コード（TAB以外）を抜き出して表示します。")							},
	{IDC_VTH_ESC		, TEXT("受信したストリームから、ＥＳＣシーケンス（0x1B～英字）を抜きだして表示します。")			},
	{IDC_VTH_PKT		, TEXT("受信したパケットデータ（DLE・STX～DLE・ETX でサンドイッチされたデータ）をバイナリ表示します。")},
	{IDC_VTH_NOPKT		, TEXT("リアルタイムに受信したデータ内のパケットデータ（DLE・STX～DLE・ETX）以外の部分をテキストとして表示します。\n")
						  TEXT("複数バイト文字の場合は、文字が完結するまで次のリアルタイム受信データを待ちます。")}
};

#define	MAX_TIPTBL	(sizeof TipTbl / sizeof TipTbl[0])

//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
HINSTANCE		hInst;							//	ＤＬＬインスタンスハンドル
HWND			hDlgMain;						//	ダイアログボックスハンドル

HAJCSCP 		hScp;
HWND			hWndVthTxtChu;
HWND			hWndVthBinChu;
HWND			hWndVthText;
HWND			hWndVthCtrl;
HWND			hWndVthEsc;
HWND			hWndVthPkt;
HWND			hWndVthInvChu;
HWND			hWndVthPkt;
HWND			hWndVthNoPkt;
HWND			hWndVthLog;

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Main);

static	VO		SubSendFile(HWND hDlg, C_UTP pFName);
static	VO		ShowSignalState(UI sig);
static	VO		ShowOnOpened(VO);
static	VO		ShowOnClosed(VO);
static	VO		ShowPortName(C_UTP pPortName);

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 	msg;

	hInst = hInstance;

	//----- メイン・ダイアログオープン -----------------//
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_DLGMAIN), NULL, AJC_DLGPROC_NAME(Main));
	ShowWindow(hDlgMain, SW_SHOW);

	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}

	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//==============================================================================================================//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG 	)
{
	int		i;

	hDlgMain		= hDlg;
	hWndVthTxtChu	= GetDlgItem(hDlg, IDC_VTH_TXTCHUNK	);
	hWndVthBinChu	= GetDlgItem(hDlg, IDC_VTH_BINCHUNK	);
	hWndVthText		= GetDlgItem(hDlg, IDC_VTH_TEXT		);
	hWndVthCtrl		= GetDlgItem(hDlg, IDC_VTH_CTRL		);
	hWndVthEsc		= GetDlgItem(hDlg, IDC_VTH_ESC		);
	hWndVthInvChu	= GetDlgItem(hDlg, IDC_VTH_INVCHUNK	);
	hWndVthPkt		= GetDlgItem(hDlg, IDC_VTH_PKT		);
	hWndVthNoPkt	= GetDlgItem(hDlg, IDC_VTH_NOPKT	);
	hWndVthLog		= GetDlgItem(hDlg, IDC_VTH_EVTLOG	);

	//----- ウインド位置ロード ----------------------//
	AjcLoadWndPos(hDlg, NULL);
	//----- ラジオボタンのグループ化 ----------------//
	AjcSbcRadioBtns(GetDlgItem(hDlg, IDC_GRP_RXTEC));
	AjcSbcRadioBtns(GetDlgItem(hDlg, IDC_GRP_TXTEC));
	//----- ダイアログ項目の初期化 ------------------//
	AjcSetDlgItemStr (hDlg, IDC_TXT_SNDTEXT  , TEXT("東京都港区赤坂1-2-3\\n"));
	AjcSetDlgItemStr (hDlg, IDC_TXT_SNDESC	 , TEXT("[31m" 				 ));
	AjcSetDlgItemStr (hDlg, IDC_TXT_SNDBIN	 , TEXT("00 01 02" 			 ));
	AjcSetDlgItemStr (hDlg, IDC_TXT_SNDPKT	 , TEXT("10 11 12" 			 ));
	AjcSetDlgItemStr (hDlg, IDC_TXT_SNDWORD14, TEXT("100"					 ));
	AjcSetDlgItemChk (hDlg, IDC_CHK_RTS	 	 , TRUE);
	AjcSetDlgItemChk (hDlg, IDC_CHK_DTR	 	 , TRUE);
	AjcSetDlgItemUInt(hDlg, IDC_GRP_RXTEC	 , 0	);
	AjcSetDlgItemUInt(hDlg, IDC_GRP_TXTEC	 , 0	);
	//----- テキストボックス長設定 ------------------//
	AjcSetDlgItemEdtLimit(hDlg, IDC_TXT_SNDTEXT, MAX_TXTBOX_LEN - 1);
	AjcSetDlgItemEdtLimit(hDlg, IDC_TXT_SNDESC , MAX_TXTBOX_LEN - 1);
	AjcSetDlgItemEdtLimit(hDlg, IDC_TXT_SNDBIN , MAX_TXTBOX_LEN - 1);
	AjcSetDlgItemEdtLimit(hDlg, IDC_TXT_SNDPKT , MAX_TXTBOX_LEN - 1);
	//----- ツールチップ設定 ------------------------//
	for (i = 0; i < MAX_TIPTBL; i++) {
		AjcTipTextAdd(GetDlgItem(hDlg, TipTbl[i].id), TipTbl[i].pTxt);
	}
	//----- ＳＣＰセットアップ ----------------------//
	hScp = AjcScpCreateEx(TEXT("ComPort"), TRUE, NULL, NULL, NULL); //	ＳＣＰインスタンス生成
	AjcScpSetMode(hScp, hDlg, WM_SCPEVENT, AJCSCP_CM_BOTH);			//	モード設定
	AjcScpSetRxTextCode(hScp, AJCSCP_TXT_AUTO);						//	受信テキストコード自動判別
	AjcScpSetTxTextCode(hScp, AJCSCP_TXT_AUTO);						//	送信テキストコード＝受信と同じ
	AjcScpSetEvtMask(hScp,	0 | 									//	イベントマスク設定
							AJCSCP_EV_PORTSTATE |					//		ポート状態通知
							AJCSCP_EV_RXCHUNK	|					//		チャンクデータ受信通知
							AJCSCP_EV_RXTEXT	|					//		テキスト受信通知
							AJCSCP_EV_RXESC 	|					//		ＥＳＣコード受信通知
							AJCSCP_EV_RXCTRL	|					//		制御コード受信通知
							AJCSCP_EV_RXPKT 	|					//		パケットデータ受信通知
							AJCSCP_EV_RXNOPKT	|					//		パケット外データ受信通知
							AJCSCP_EV_TXEMPTY	|					//		送信完了
							AJCSCP_EV_RING		|					//		RING変化通知
							AJCSCP_EV_ERR		|					//		エラー通知
							AJCSCP_EV_RLSD		|					//		RLSD変化通知
							AJCSCP_EV_DSR		|					//		DSR変化通知
							AJCSCP_EV_CTS		|					//		CTS変化通知
							AJCSCP_EV_RXWORD14	|					//		バイトペアによるワード（14Bit）データ受信
							AJCSCP_EV_INVCHUNK	|					//		不正チャンクテキスト受信通知
	0);
	//----- ポート名表示 ----------------------------//
	ShowPortName(AjcScpGetPortName(hScp));
	//----- 初期グレー表示 --------------------------//
	AjcEnableDlgGroup(hDlgMain, IDC_GRP_SETSIG, FALSE, FALSE);
	AjcEnableDlgGroup(hDlgMain, IDC_GRP_SIGSTS, FALSE, FALSE);
	AjcEnableDlgGroup(hDlgMain, IDC_GRP_SEND  , FALSE, FALSE);
	AjcEnableDlgGroup(hDlgMain, IDC_GRP_RECV  , FALSE, FALSE);
	AjcScpOpenDefault(hScp);
	//----- ダイアログ項目のロード ------------------//
	AjcLoadAllControlSettings (hDlg, TEXT("DlgSetting"), AJCOPT3(AJCCTL_SELACT_, ALL, NTCCHK, NTCRBT));

	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY		)
{
	//----- ウインド位置セーブ ----------------------------//
	AjcSaveWndPos(hDlg, NULL);
	//----- ダイアログ項目のセーブ ------------------------//
	AjcSaveAllControlSettings(hDlg);

	AjcScpDelete(hScp); 		//	ＳＣＰインスタンス消去
	PostQuitMessage(0);
	return TRUE;
}
//----- ＳＣＭイベント通知 -------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_SCPEVENT		)
{
	UI		time = GetTickCount();
	UI		len, param;
	UT		txt[256];
	union {UBP pBin; UWP pWord; UTP pTxt; VOP vp;} u;

	AjcScpGetEventData(hScp, lParam, &u.vp, &len, &param);				//	イベントデータ取得
	if(wParam & AJCSCP_EV_PORTSTATE) {									//	●ポート状態通知
		AjcVthPrintF(hWndVthLog, TEXT("%9d: PORTSTATE len=%5d, param=%d "), time, len, param);
		ShowPortName(u.pTxt);
		switch (param) {
			case AJCSCP_CLOSED: ShowOnClosed(); 						//		・クローズ状態
				AjcSetDlgItemStr(hDlg, IDC_LBL_PORTSTATE, TEXT("Closed"));
				AjcVthPrintF(hWndVthLog, TEXT("(%s closed)\n" ), u.pTxt);
				break;
			case AJCSCP_OPENED: ShowOnOpened();							//		・オープン状態
				AjcSetDlgItemStr(hDlg, IDC_LBL_PORTSTATE, TEXT("Opened"));
				AjcVthPrintF(hWndVthLog, TEXT("(%s opened)\n" ), u.pTxt);
				AjcScpSetRTS(hScp, AjcGetDlgItemChk(hDlg, IDC_CHK_RTS));
				AjcScpSetDTR(hScp, AjcGetDlgItemChk(hDlg, IDC_CHK_DTR));
				break;
			case AJCSCP_OPENFAIL:										//		・オープン失敗
				AjcSnPrintF(txt, AJCTSIZE(txt), TEXT("(%s open falure)\n"),u.pTxt);
				AjcVthPrintF(hWndVthLog, txt);
				MessageBox(hDlg, txt, TEXT("SW_SerialComPort1"), MB_ICONERROR);
				break;
			default:
				AjcVthPutText(hWndVthLog, TEXT("\n"), -1);
				break;
		}
	}
	if(wParam & AJCSCP_EV_RXCHUNK ) {									//	●チャンクデータ受信通知
		AjcVthPrintF(hWndVthLog, TEXT("%9d: RXCHUNK   len=%5d, param=0x%08X\n"), time, len, param);
		//	バイナリチャンク
		if (param == 0) {
			AjcVthHexDump(hWndVthBinChu, (C_VOP)u.pBin, len);
			AjcVthPrintF (hWndVthBinChu, TEXT("\n"));
		}
		//	テキストチャンク
		else {
			AjcVthPutText(hWndVthTxtChu, u.pTxt, -1);
		}
	}
	if (wParam & AJCSCP_EV_RXTEXT ) {									//	●テキスト受信通知
		AjcVthPrintF(hWndVthLog, TEXT("%9d: RXTEXT    len=%5d, param=0x%08X\n"), time, len, param);
		AjcVthPrintF(hWndVthText, TEXT("%s\n"), u.pTxt);				//		テキストデータ表示
	}
	if (wParam & AJCSCP_EV_RXESC  ) {									//	●ＥＳＣコード受信通知
		AjcVthPrintF(hWndVthLog, TEXT("%9d: RXESC     len=%5d, param=0x%08X\n"), time, len, param);
		AjcVthPrintF(hWndVthEsc, TEXT("\\x1B%s\n"), u.pTxt + 1);			//		ＥＳＣデータ表示
	}
	if (wParam & AJCSCP_EV_RXCTRL ) {									//	●制御コード受信通知
		AjcVthPrintF(hWndVthLog, TEXT("%9d: RXCTRL    len=%5d, param=0x%08X, data=%02X\n"), time, len, param, *u.pBin);
		AjcVthPrintF(hWndVthCtrl, TEXT("%02X\n"), *u.pTxt);				//		制御コード表示
	}
	if (wParam & AJCSCP_EV_RXPKT  ) {									//	●パケットデータ受信通知
		AjcVthPrintF(hWndVthLog, TEXT("%9d: RXPKT     len=%5d, param=0x%08X\n"), time, len, param);
		AjcVthHexDump(hWndVthPkt, (C_VOP)u.pBin, len);
		AjcVthPrintF (hWndVthPkt, TEXT("\n"));
	}
	if (wParam & AJCSCP_EV_TXEMPTY) {									//	●送信完了通知
		AjcVthPrintF(hWndVthLog, TEXT("%9d: TXEMPTY   len=%5d, param=0x%08X\n"), time, len, param);
	}
	if (wParam & AJCSCP_EV_RXNOPKT) { 									//	●パケット外テキスト受信通知
		AjcVthPrintF(hWndVthLog, TEXT("%9d: RXNOPKT   len=%5d, param=0x%08X\n"), time, len, param);
		AjcVthPutText(hWndVthNoPkt, u.pTxt, -1);						//		パケット外テキスト表示
	}
	if (wParam & AJCSCP_EV_INVCHUNK) { 									//	●不正テキストチャンク通知
		AjcVthPrintF(hWndVthLog, TEXT("%9d: INVCHUNK  len=%5d, param=0x%08X\n"), time, len, param);
		AjcVthHexDump(hWndVthInvChu, (C_VOP)u.pBin, len);
		AjcVthPrintF (hWndVthInvChu, TEXT("\n"));
	}
	if (wParam & AJCSCP_EV_ERR	  ) {									//	●エラー通知
		AjcVthPrintF(hWndVthLog, TEXT("%9d: ERR       len=%5d, param=0x%08X\n"), time, len, param);
	}
	if (wParam & AJCSCP_EV_RING   ) {									//	●RING変化通知
		AjcVthPrintF(hWndVthLog, TEXT("%9d: RING      len=%5d, param=0x%08X\n"), time, len, param);
		ShowSignalState(LOWORD(param));
	}
	if (wParam & AJCSCP_EV_RLSD   ) {									//	●RLSD変化通知
		AjcVthPrintF(hWndVthLog, TEXT("%9d: RLSD      len=%5d, param=0x%08X\n"), time, len, param);
		ShowSignalState(LOWORD(param));
	}
	if (wParam & AJCSCP_EV_DSR	  ) {									//	●DSR変化通知
		AjcVthPrintF(hWndVthLog, TEXT("%9d: DSR       len=%5d, param=0x%08X\n"), time, len, param);
		ShowSignalState(LOWORD(param));
	}
	if (wParam & AJCSCP_EV_CTS	  ) {									//	●CTS変化通知
		AjcVthPrintF(hWndVthLog, TEXT("%9d: CTS       len=%5d, param=0x%08X\n"), time, len, param);
		ShowSignalState(LOWORD(param));
	}
	if (wParam & AJCSCP_EV_RXWORD14) {									//	●バイトペアによるワード（14Bit）データ受信
		RECT	r;
		UT		txt[64];
		AjcVthPrintF(hWndVthLog, TEXT("%9d: WORD14    len=%5d, param=0x%08X(%d)\n"), time, len, *u.pWord, *u.pWord);
		GetWindowRect(GetDlgItem(hDlg, IDC_LBL_SNDWORD14), &r);
		AjcSnPrintF(txt, AJCTSIZE(txt), TEXT("１４ビットデータ（ %d (0x%04X) ）を受信しました"), *u.pWord, *u.pWord);
		AjcTipTextShow(r.left, r.top, txt, -1, NULL);
	}
	AjcScpRelEventData(hScp, lParam);									//	イベントデータ開放

	return TRUE;
}
//----- ウインドクローズ ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL			)
{
	DestroyWindow(hDlg);
	return TRUE;
}
//----- テキスト送信ボタン -------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_SNDTEXT	)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		UT	txt[MAX_TXTBOX_LEN];
		UT	snd[MAX_TXTBOX_LEN];
		AjcGetDlgItemStr(hDlg, IDC_TXT_SNDTEXT, txt, AJCTSIZE(txt));
		AjcCLangStrToBin(txt, snd, AJCTSIZE(snd));
		AjcScpSendText(hScp, snd, -1);
	}
	return TRUE;
}
//----- ＥＳＣ送信ボタン ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_SNDESC	)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		UT	txt[MAX_TXTBOX_LEN];
		AjcGetDlgItemStr(hDlg, IDC_TXT_SNDESC, txt, AJCTSIZE(txt));
		AjcScpSendChar(hScp, 0x1B);
		AjcScpSendText(hScp, txt, -1);
	}
	return TRUE;
}
//----- バイナリ送信ボタン -------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_SNDBIN	)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		UI	ix;
		UTP	p;
		UT	txt[MAX_TXTBOX_LEN];
		UB	bin[MAX_TXTBOX_LEN];
		ix = 0;
		AjcGetDlgItemStr(hDlg, IDC_TXT_SNDBIN, txt, AJCTSIZE(txt));
		if (p = MAjcStrTok(txt, TEXT(" "))) {
			do {
				if (AjcHexStrToUB(p, 2, &bin[ix])) {
					ix++;
				}
			} while (p = MAjcStrTok(NULL, TEXT(" ")));
		}
		if (ix != 0) {
			AjcScpSendBinData(hScp, bin, ix);
		}
	}
	return TRUE;
}
//----- パケット送信ボタン -------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_SNDPKT	)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		UI	ix;
		UTP	p;
		UT	txt[MAX_TXTBOX_LEN];
		UB	bin[MAX_TXTBOX_LEN];
		ix = 0;
		AjcGetDlgItemStr(hDlg, IDC_TXT_SNDPKT, txt, AJCTSIZE(txt));
		if (p = MAjcStrTok(txt, TEXT(" "))) {
			do {
				if (AjcHexStrToUB(p, 2, &bin[ix])) {
					ix++;
				}
			} while (p = MAjcStrTok(NULL, TEXT(" ")));
		}
		if (ix != 0) {
			AjcScpSendPacket(hScp, bin, ix);
		}
	}
	return TRUE;
}
//----- １４ビット値送信ボタン ---------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_SNDWORD14	)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		UI	val = AjcGetDlgItemUInt(hDlg, IDC_TXT_SNDWORD14);
		AjcScpSendWord14LF(hScp, val);
	}
	return TRUE;
}
//----- ＤＴＲチェックボックス ---------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CHK_DTR		)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		AjcScpSetDTR(hScp, AjcGetDlgItemChk(hDlg, IDC_CHK_DTR));
	}
	return TRUE;
}
//----- ＲＴＳチェックボックス ---------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CHK_RTS		)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		AjcScpSetRTS(hScp, AjcGetDlgItemChk(hDlg, IDC_CHK_RTS));
	}
	return TRUE;
}
//----- オープン／クローズ ボタン ------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_OPEN		)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		if (AjcScpIsOpened(hScp)) {
			AjcScpClose(hScp);
		}
		else {
			AjcScpOpenDefault(hScp);
		}
	}
	return TRUE;
}
//----- 簡易設定ボタン -----------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_EASY		)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		AjcScpDlgParamEasy(hScp, hDlg);
	}
	return TRUE;
}
//----- 詳細設定ボタン -----------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_DETAIL	)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		AjcScpDlgParamDetail(hScp, hDlg);
	}
	return TRUE;
}
//----- 受信テキストエンコード ---------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_GRP_RXTEC		)
{
	if (HIWORD(wParam) == AJCRBTN_SELECT) {
		//	受信テキストエンコード設定
		switch (lParam) {
			case 0: AjcScpSetRxTextCode(hScp, AJCSCP_TXT_SJIS);	break;
			case 1: AjcScpSetRxTextCode(hScp, AJCSCP_TXT_UTF8);	break;
			case 2: AjcScpSetRxTextCode(hScp, AJCSCP_TXT_EUC );	break;
			case 3: AjcScpSetRxTextCode(hScp, AJCSCP_TXT_AUTO);	break;
		}
		//	送信テキストエンコード設定（送信エンコードが AUTO の場合、受信エンコードと同一とするため）
		SendMessage(hDlg, WM_COMMAND, MAKELONG(IDC_GRP_TXTEC, AJCRBTN_SELECT), AjcGetDlgItemUInt(hDlg, IDC_GRP_TXTEC));
	}
	return TRUE;
}
//----- 送信テキストエンコード ---------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_GRP_TXTEC		)
{
	if (HIWORD(wParam) == AJCRBTN_SELECT) {
		//	送信テキストエンコード設定
		switch (lParam) {
			case 0: AjcScpSetTxTextCode(hScp, AJCSCP_TXT_SJIS);	break;
			case 1: AjcScpSetTxTextCode(hScp, AJCSCP_TXT_UTF8);	break;
			case 2: AjcScpSetTxTextCode(hScp, AJCSCP_TXT_EUC );	break;
			case 3: AjcScpSetTxTextCode(hScp, AJCSCP_TXT_AUTO);	break;
		}
	}
	return TRUE;
}
//----- 全てクリアーボタン -------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_CLRALL	)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		AjcVthClear(hWndVthTxtChu	);
		AjcVthClear(hWndVthBinChu	);
		AjcVthClear(hWndVthText		);
		AjcVthClear(hWndVthCtrl		);
		AjcVthClear(hWndVthEsc		);
		AjcVthClear(hWndVthInvChu	);
		AjcVthClear(hWndVthPkt		);
		AjcVthClear(hWndVthNoPkt	);
	}
	return TRUE;
}
//----- ＶＴＨ（テキスト）からの通知 ---------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_VTH_TEXT	)
{
	if (HIWORD(wParam) == AJCVTHN_DROPFILE) {		//	ファイルドロップ
		UI		i, nFile = (UI)lParam;
		HANDLE	hFile;
		UL		bytes;
		UT		path[MAX_PATH];
		UB		buf[2014];
		for (i = 0; i < nFile; i++) {
			AjcVthGetDroppedFile(hWndVthText, path);
			if ((hFile = CreateFile(path, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, 0, NULL)) != INVALID_HANDLE_VALUE) {
				while (ReadFile(hFile, buf, sizeof buf, &bytes, NULL) && bytes != 0) {
					AjcScpSendBinData(hScp, buf, bytes);
				}
				CloseHandle(hFile);
			}
		}
	}
	return TRUE;
}

//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG		)
	AJC_DLGMAP_MSG(Main, WM_DESTROY 		)
	AJC_DLGMAP_MSG(Main, WM_SCPEVENT		)
	AJC_DLGMAP_CMD(Main, IDCANCEL			)
	AJC_DLGMAP_CMD(Main, IDC_CMD_SNDTEXT	)
	AJC_DLGMAP_CMD(Main, IDC_CMD_SNDESC		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_SNDBIN		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_SNDPKT		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_SNDWORD14	)
	AJC_DLGMAP_CMD(Main, IDC_CHK_DTR		)
	AJC_DLGMAP_CMD(Main, IDC_CHK_RTS		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_OPEN		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_EASY		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_DETAIL 	)
	AJC_DLGMAP_CMD(Main, IDC_GRP_RXTEC	 	)
	AJC_DLGMAP_CMD(Main, IDC_GRP_TXTEC	 	)
	AJC_DLGMAP_CMD(Main, IDC_CMD_CLRALL 	)
	AJC_DLGMAP_CMD(Main, IDC_VTH_TEXT	 	)
AJC_DLGMAP_END

//--------------------------------------------------------------------------------------------------------------//
//	ファイル送信																								//
//--------------------------------------------------------------------------------------------------------------//
VO		SubSendFile(HWND hDlg, C_UTP pFName)
{
	HANDLE	fh;
	UL		bytes;
	UT		path[MAX_PATH];
	UT		buf[1024];

	AjcGetAppPath(path, MAX_PATH);
	MAjcStrCat(path, MAX_PATH, pFName);
	fh = CreateFile(path, GENERIC_READ, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	if (fh != INVALID_HANDLE_VALUE) {
		while (ReadFile(fh, buf, AJCTSIZE(buf), &bytes, NULL) && bytes != 0) {
			AjcScpSendBinData(hScp, buf, bytes);
		}
		CloseHandle(fh);
	}
	else {
		UT		txt[512];
		AjcSnPrintF(txt, AJCTSIZE(txt), TEXT("'%s' open falure!"), path);
		MessageBox(hDlgMain, txt, TEXT("Error"), MB_ICONERROR);
	}
}

//--------------------------------------------------------------------------------------------------------------//
//	信号状態表示																								//
//--------------------------------------------------------------------------------------------------------------//
static	VO	ShowSignalState(UI sig)
{
	AjcSetDlgItemChk(hDlgMain, IDC_CHK_DSR , (sig & AJCSCP_DSR ) != 0);
	AjcSetDlgItemChk(hDlgMain, IDC_CHK_CTS , (sig & AJCSCP_CTS ) != 0);
	AjcSetDlgItemChk(hDlgMain, IDC_CHK_RING, (sig & AJCSCP_RING) != 0);
	AjcSetDlgItemChk(hDlgMain, IDC_CHK_RLSD, (sig & AJCSCP_RLSD) != 0);
}

//--------------------------------------------------------------------------------------------------------------//
//	ポートオープン時の表示																						//
//--------------------------------------------------------------------------------------------------------------//
static	VO		ShowOnOpened(VO)
{
	UT	txt[64];

	AjcSnPrintF(txt, AJCTSIZE(txt), TEXT("SW_SerialComPort1 ( %s )"), AjcScpGetPortPathName(hScp));
	SetWindowText(hDlgMain, txt);										//	ウインドタイトル
	AjcSetDlgItemStr(hDlgMain, IDC_CMD_OPEN, TEXT("PORT CLOSE"));		//	ボタンフェース
	AjcEnableDlgGroup(hDlgMain, IDC_GRP_SETSIG, TRUE, TRUE);			//	信号設定チェックボックス有効化
	AjcEnableDlgGroup(hDlgMain, IDC_GRP_SIGSTS, TRUE, TRUE);			//	信号状態表示有効化
	AjcEnableDlgGroup(hDlgMain, IDC_GRP_SEND, TRUE, TRUE);				//	送信表示有効化
	AjcEnableDlgGroup(hDlgMain, IDC_GRP_RECV, TRUE, TRUE);				//	受信表示有効化
	AjcSetDlgItemChk(hDlgMain, IDC_CHK_DTR , TRUE); 					//	ＤＴＲ設定ＯＮ
	AjcSetDlgItemChk(hDlgMain, IDC_CHK_RTS , TRUE); 					//	ＲＴＳ設定ＯＮ
	ShowSignalState(AjcScpGetSigState(hScp));							//	信号状態表示
}
//--------------------------------------------------------------------------------------------------------------//
//	ポートクローズ時の表示																						//
//--------------------------------------------------------------------------------------------------------------//
static	VO		ShowOnClosed(VO)
{
	SetWindowText(hDlgMain, TEXT("SW_SerialComPort1 ( Disconnect )"));	//	ウインドタイトル
	AjcSetDlgItemStr(hDlgMain, IDC_CMD_OPEN, TEXT("PORT OPEN"));		//	ボタンフェース
	AjcEnableDlgGroup(hDlgMain, IDC_GRP_SETSIG, FALSE, FALSE);			//	信号設定チェックボックス無効化
	AjcEnableDlgGroup(hDlgMain, IDC_GRP_SIGSTS, FALSE, FALSE);			//	信号状態表示無効化
	AjcEnableDlgGroup(hDlgMain, IDC_GRP_SEND, FALSE, FALSE);			//	送信表示無効化
	AjcEnableDlgGroup(hDlgMain, IDC_GRP_RECV, FALSE, FALSE);			//	受信表示無効化
}
//--------------------------------------------------------------------------------------------------------------//
//	ポート名表示																								//
//--------------------------------------------------------------------------------------------------------------//
static VO ShowPortName(C_UTP pPortName)
{
	UT		DevName [128];

	AjcSetDlgItemStr(hDlgMain, IDC_LBL_PORTNAME, pPortName);
	if (AjcScpGetPortDevName(pPortName, DevName, AJCTSIZE(DevName))) {
		UT		txt[128];
		AjcSnPrintF(txt, AJCTSIZE(txt), TEXT("(%s)"), DevName);
		AjcSetDlgItemStr(hDlgMain, IDC_LBL_DEVNAME, txt);
	}
	else {
		AjcSetDlgItemStr(hDlgMain, IDC_LBL_DEVNAME, TEXT(""));
	}
}
