﻿//
//	SW_SerialComPort2.c
//
#define AJCSOCKSERV_H_
#define AJCSOCKCLIENT_H_
#include	<AjrCstXX.h>
#include	<tchar.h>
#include	"resource.h"

#define WM_SCPEVENT 	(WM_USER + 100)

//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
static	HINSTANCE		hInst;							//	ＤＬＬインスタンスハンドル
static	HWND			hDlgMain;						//	ダイアログボックスハンドル

static	HAJCSCP 		hScp;
static	UI				TotalBytes;

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Main);

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 	msg;

	hInst = hInstance;

	//----- メイン・ダイアログオープン -----------------//
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_DLGMAIN), NULL, AJC_DLGPROC_NAME(Main));
	ShowWindow(hDlgMain, SW_SHOW);

	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}

	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//==============================================================================================================//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG )
{
	hDlgMain   = hDlg;

	AjcLoadWndPos(hDlg, NULL);												//	ウインド位置ロード

	hScp = AjcScpCreateEx(TEXT("ComPortSect"), TRUE, NULL, NULL, NULL);		// インスタンス生成
	AjcScpSetMode(hScp, hDlg, WM_SCPEVENT, AJCSCP_CM_BIN);					//	モード設定
	AjcScpSetEvtMask(hScp, AJCSCP_EV_PORTSTATE |							//	イベントマスク設定
						   AJCSCP_EV_RXCHUNK);

	AjcSetDlgItemStr (hDlg, IDC_LBL_PORTNAME, TEXT("-"));
	AjcSetDlgItemUInt(hDlg, IDC_TXT_BYTES	, 0);
	AjcSetDlgItemStr (hDlg, IDC_LBL_DEVNAME , TEXT(""));

	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY	)
{
	AjcSaveWndPos(hDlg, NULL);						//	ウインド位置セーブ
	AjcScpDelete(hScp); 							//	インスタンス消去
	PostQuitMessage(0);
	return TRUE;
}
//----- ＳＣＭイベント通知 -------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_SCPEVENT	)
{
	static	UI		TotalBytes = 0;
	VOP 	pDat;
	UI		len, param;
	UT		txt[512];

	AjcScpGetEventData(hScp, lParam, &pDat, &len, &param);				//	イベントデータ取得
	if(wParam & AJCSCP_EV_RXCHUNK ) {									//	●チャンクデータ受信通知？
		//	バイト数表示
		TotalBytes += len;
		AjcSepDlgItemUInt(hDlg, IDC_TXT_BYTES, TotalBytes);
		//	データ返送
		AjcScpSendBinData(hScp, pDat, len);
	}
	if(wParam & AJCSCP_EV_PORTSTATE) {									//	●ポート状態通知？
		switch (param) {
			case AJCSCP_CLOSED: 	// クローズ状態
				AjcSetDlgItemStr(hDlgMain, IDC_CMD_OPEN, TEXT("OPEN"));
				SetWindowText(hDlgMain, TEXT("SW_SerialComPort2 ( Disconnect )"));
				AjcSetDlgItemStr(hDlg, IDC_LBL_PORTNAME , TEXT("-"));
				AjcSetDlgItemStr(hDlg, IDC_LBL_PORTSTATE, TEXT("Closed"));
				break;

			case AJCSCP_OPENED: 	// オープン状態
				AjcSetDlgItemStr(hDlgMain, IDC_CMD_OPEN, TEXT("CLOSE"));
				AjcSnPrintF(txt, AJCTSIZE(txt), TEXT("SW_SerialComPort2 (%s )"), AjcScpGetPortPathName(hScp));
				SetWindowText(hDlgMain, txt);
				AjcSetDlgItemStr(hDlg, IDC_LBL_PORTNAME , AjcScpGetPortPathName(hScp));
				AjcSetDlgItemStr(hDlg, IDC_LBL_PORTSTATE, TEXT("Opened"));
				//	バイト数リセット
				AjcSetDlgItemUInt(hDlg, IDC_TXT_BYTES, TotalBytes = 0);
				break;

			case AJCSCP_OPENFAIL:	// オープン失敗
				AjcSnPrintF(txt, AJCTSIZE(txt), TEXT("\x1B[31m%s open failure!"), AjcScpGetPortPathName(hScp));
				AjcTipTextShowCenter(hDlg, txt, 3000, NULL);
				AjcSetDlgItemStr(hDlg, IDC_LBL_PORTNAME , AjcScpGetPortPathName(hScp));
				AjcSetDlgItemStr(hDlg, IDC_LBL_PORTSTATE, TEXT("Open Failure"));
				break;
		}
	}
	AjcScpRelEventData(hScp, lParam);									//	イベントデータ開放

	return TRUE;
}
//----- ウインドクローズ ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL		)
{
	DestroyWindow(hDlg);
	return TRUE;
}
//----- PORT OPEN/CLOSEボタン ----------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_OPEN	 )
{
	if (AjcScpIsOpened(hScp)) {
		AjcScpClose(hScp);
	}
	else {
		TotalBytes = 0;
		AjcScpOpenDefault(hScp);
		AjcSetDlgItemStr(hDlg, IDC_LBL_PORTSTATE, TEXT("Open in progress"));
	}
	return TRUE;
}
//----- ポート設定ボタン ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_SETPORT)
{
	AjcScpDlgParamEasy(hScp, hDlg);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG	)
	AJC_DLGMAP_MSG(Main, WM_DESTROY 	)
	AJC_DLGMAP_MSG(Main, WM_SCPEVENT	)
	AJC_DLGMAP_CMD(Main, IDCANCEL		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_OPEN	)
	AJC_DLGMAP_CMD(Main, IDC_CMD_SETPORT)
AJC_DLGMAP_END
