﻿//
//	SW_SerialComPort4.c
//
#define AJCSOCKSERV_H_
#define AJCSOCKCLIENT_H_
#include	<AjrCstXX.h>
#include	<tchar.h>
#include	"resource.h"

#define WM_SCPEVENT 	(WM_USER + 100)

//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
static	HINSTANCE	hInst		= NULL;
static	HWND		hDlgMain	= NULL;
static	HWND		hWndVth		= NULL;
static	HAJCSCP 	hScp		= NULL;
static	HANDLE		hMutex		= NULL;
static	UI			msgBC		= 0;

static	UT			SecName[16]	= {0};
static	UT			MySlot [16]	= {0};
static	UT			RmtSlot[16]	= {0};


//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Main);

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 		msg;

	hInst = hInstance;

	//----- メイン・ダイアログオープン -----------------//
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_DLGMAIN), NULL, AJC_DLGPROC_NAME(Main));
	ShowWindow(hDlgMain, SW_SHOW);

	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}

	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//==============================================================================================================//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG )
{
	RECT	r;

	hDlgMain = hDlg;
	hWndVth  = GetDlgItem(hDlg, IDC_VTH);

	//----- ツールチップ設定 ---------------------------//
	AjcTipTextAdd (GetDlgItem(hDlg, IDC_INP_MYSLOT ), TEXT("自身のスロット名を入力します。\n空白を入力した場合は受信不可"));
	AjcTipTextAdd (GetDlgItem(hDlg, IDC_CMD_MYSLOT ), TEXT("自身のスロット名を設定します。"));
	AjcTipTextAdd (GetDlgItem(hDlg, IDC_TXT_MYSLOT ), TEXT("自身のスロット名です。"));
	AjcTipTextAdd (GetDlgItem(hDlg, IDC_INP_RMTSLOT), TEXT("送信先のスロット名を入力します。\n空白を入力した場合は送信不可"));
	AjcTipTextAdd (GetDlgItem(hDlg, IDC_CMD_RMTSLOT), TEXT("送信先のスロット名を設定します。"));
	AjcTipTextAdd (GetDlgItem(hDlg, IDC_TXT_RMTSLOT), TEXT("送信先のスロット名です。"));

	//----- テキスト入力リミット設定 -------------------//
	AjcSetDlgItemEdtLimit(hDlg, IDC_INP_MYSLOT , 15);
	AjcSetDlgItemEdtLimit(hDlg, IDC_INP_RMTSLOT, 15);

	//----- ブロードキャストメッセージ登録 -------------//
	msgBC = RegisterWindowMessage(TEXT("SW_SerialComPort4_BC"));

	//----- ミューテックス生成--------------------------//
	hMutex = CreateMutex(NULL, TRUE, TEXT("SW_SerialComPort4"));

	//----- 最初のプロセス起動時・・・ -----------------//
	if (GetLastError() != ERROR_ALREADY_EXISTS) {
		UT		path[MAX_PATH];
		//	ウインド位置設定
		SetWindowPos(hDlg, NULL, 0, 0, 0, 0, SWP_NOSIZE);
		//	スロット名読み出し
		MAjcStrCpy(SecName, AJCTSIZE(SecName), TEXT("SlotName1"));
		AjcGetProfileStr(SecName, TEXT("MySlot" ), TEXT("SlotA"), MySlot , AJCTSIZE(MySlot ));
		AjcGetProfileStr(SecName, TEXT("RmtSlot"), TEXT("SlotB"), RmtSlot, AJCTSIZE(RmtSlot));
		AjcSetDlgItemStr(hDlg, IDC_TXT_MYSLOT , MySlot ); AjcSetDlgItemStr(hDlg, IDC_INP_MYSLOT , MySlot );
		AjcSetDlgItemStr(hDlg, IDC_TXT_RMTSLOT, RmtSlot); AjcSetDlgItemStr(hDlg, IDC_INP_RMTSLOT, RmtSlot);
		//	ＳＣＰインスタンス生成
		hScp = AjcScpCreateEx(NULL, TRUE, MySlot, NULL, RmtSlot);
		//	２つ目のプロセス起動
		AjcGetAppPath(path, MAX_PATH);
		ShellExecute(NULL, NULL, TEXT("SW_SerialComPort4_32W.exe"), TEXT(""), path, SW_SHOWNORMAL);
	}
	//----- ２つ目のプロセス起動時・・・ ---------------//
	else {
		//	ウインド位置設定
		GetWindowRect(hDlg, &r);
		SetWindowPos(hDlg, NULL, 0, r.bottom - r.top + 10, 0, 0, SWP_NOSIZE);
		//	スロット名読み出し
		MAjcStrCpy(SecName, AJCTSIZE(SecName), TEXT("SlotName2"));
		AjcGetProfileStr(SecName, TEXT("MySlot" ), TEXT("SlotB"), MySlot , AJCTSIZE(MySlot ));
		AjcGetProfileStr(SecName, TEXT("RmtSlot"), TEXT("SlotA"), RmtSlot, AJCTSIZE(RmtSlot));
		AjcSetDlgItemStr(hDlg, IDC_TXT_MYSLOT , MySlot ); AjcSetDlgItemStr(hDlg, IDC_INP_MYSLOT , MySlot );
		AjcSetDlgItemStr(hDlg, IDC_TXT_RMTSLOT, RmtSlot); AjcSetDlgItemStr(hDlg, IDC_INP_RMTSLOT, RmtSlot);
		//	ＳＣＰインスタンス生成
		hScp = AjcScpCreateEx(NULL, TRUE, MySlot, NULL, RmtSlot);
	}
	//	ＳＣＰ初期化
	AjcScpSetMode(hScp, hDlg, WM_SCPEVENT, AJCSCP_CM_TEXT);
	AjcScpSetEvtMask(hScp,	AJCSCP_EV_PORTSTATE | AJCSCP_EV_RXTEXT);
	AjcScpEnablePortSelectionEx(hScp, FALSE, TRUE, FALSE);

	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY	)
{
	//	スロット名書き込み
	AjcPutProfileStr(SecName, TEXT("MySlot" ), MySlot );
	AjcPutProfileStr(SecName, TEXT("RmtSlot"), RmtSlot);

	AjcScpDelete(hScp);
	CloseHandle(hMutex);
	PostMessage(HWND_BROADCAST, msgBC, 0, 0);
	PostQuitMessage(0);
	return TRUE;
}
//----- ＳＣＰイベント通知 -------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_SCPEVENT	)
{
	UI		time = GetTickCount();
	UI		len, param;
	union {UBP pBin; UTP pTxt; VOP vp;} u;
	UT		txt[128];

	AjcScpGetEventData(hScp, lParam, &u.vp, &len, &param);				//	イベントデータ取得
	if(wParam & AJCSCP_EV_PORTSTATE) {									//	●ポート状態通知
		switch (param) {
			case AJCSCP_CLOSED:
				AjcSetDlgItemStr(hDlg, IDC_CMD_OPEN, TEXT("オープン"));
				EnableWindow(GetDlgItem(hDlg, IDC_CMD_SEND), FALSE);
				break;
			case AJCSCP_OPENED:
				AjcSetDlgItemStr(hDlg, IDC_CMD_OPEN, TEXT("クローズ"));
				EnableWindow(GetDlgItem(hDlg, IDC_CMD_SEND), TRUE);
				break;
			case AJCSCP_OPENFAIL:
				AjcSnPrintF(txt, AJCTSIZE(txt), TEXT("%s open failure!"), AjcScpGetPortPathName(hScp));
				MessageBox(hDlgMain, txt, TEXT("Error"), MB_ICONERROR);
				break;
		}
	}
	if (wParam & AJCSCP_EV_RXTEXT ) {									//	●テキスト受信通知
		AjcVthPrintF(hWndVth, TEXT("%s\n"), u.pTxt);					//		テキストデータ表示
	}
	AjcScpRelEventData(hScp, lParam);									//	イベントデータ開放

	return TRUE;
}
//----- ウインドクローズ ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL		)
{
	DestroyWindow(hDlg);
	return TRUE;
}
//----- オープン／クローズ ボタン ------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_OPEN	)
{
	if (AjcScpIsOpened(hScp)) {
		AjcScpClose(hScp);
		AjcEnableDlgItem(hDlg, IDC_INP_RMTSLOT, TRUE);
		AjcEnableDlgItem(hDlg, IDC_CMD_RMTSLOT, TRUE);
	}
	else {
		if (AjcScpOpenDefault(hScp)) {
			AjcEnableDlgItem(hDlg, IDC_INP_RMTSLOT, FALSE);
			AjcEnableDlgItem(hDlg, IDC_CMD_RMTSLOT, FALSE);
		}
		else {
		//	MessageBox(hDlgMain, TEXT("メールスロットのオープンを失敗しました。"), TEXT("Error"), MB_ICONERROR);
		}
	}
	return TRUE;
}
//----- 送信ボタン ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_SEND	)
{
	SYSTEMTIME	lt;
	UT			txt[128];

	GetLocalTime(&lt);
	AjcSnPrintF(txt, AJCTSIZE(txt), TEXT("%d/%02d/%02d  %02d:%02d:%02d.%03d\n"), lt.wYear, lt.wMonth, lt.wDay,
														 lt.wHour, lt.wMinute, lt.wSecond, lt.wMilliseconds);
	AjcScpSendText(hScp, txt, (UI)MAjcStrLen(txt));
	return TRUE;
}
//----- 自スロット名設定ボタン ---------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_MYSLOT)
{
	AjcGetDlgItemStr(hDlg, IDC_INP_MYSLOT, MySlot, AJCTSIZE(MySlot));
	AjcSetDlgItemStr(hDlg, IDC_TXT_MYSLOT, MySlot);
	AjcScpSetMailSlotNames(hScp, MySlot, NULL, NULL);
	if (!AjcScpCreateMySlot(hScp)) {
		MessageBox(hDlgMain, TEXT("自メールスロットの生成を失敗しました。"), TEXT("Error"), MB_ICONERROR);
	}
	return TRUE;
}
//----- 送信先スロット名設定ボタン -----------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_RMTSLOT)
{
	AjcGetDlgItemStr(hDlg, IDC_INP_RMTSLOT, RmtSlot, AJCTSIZE(RmtSlot));
	AjcSetDlgItemStr(hDlg, IDC_TXT_RMTSLOT, RmtSlot);
	AjcScpSetMailSlotNames(hScp, NULL, NULL, RmtSlot);
	return TRUE;
}
//----- ブロードキャストメッセージ（プログラム終了）------------------------------------------------------------//
AJC_DLGPROC(Main, WN_END_MYPROG	)
{
	DestroyWindow(hDlg);
	return TRUE;
}

//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG	)
	AJC_DLGMAP_MSG(Main, WM_DESTROY 	)
	AJC_DLGMAP_MSG(Main, WM_SCPEVENT	)
	AJC_DLGMAP_CMD(Main, IDCANCEL		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_OPEN	)
	AJC_DLGMAP_CMD(Main, IDC_CMD_SEND	)
	AJC_DLGMAP_CMD(Main, IDC_CMD_MYSLOT	)
	AJC_DLGMAP_CMD(Main, IDC_CMD_RMTSLOT)
	AJC_DLGMAP_RWM(Main, WN_END_MYPROG	, TEXT("SW_SerialComPort4_BC"))
AJC_DLGMAP_END

