﻿//
//	SW_SerialComPort5B.c
//

#include	<AjrCstXX.h>
#include	<math.h>
#include	<tchar.h>
#include	"resource.h"

#define	WM_SCPEVENT			WM_APP

//--------------------------------------------------------------------------------------------------------------//
//	通信パケットコマンド																						//
//--------------------------------------------------------------------------------------------------------------//
//	グラフデータ形式
#define	CMD_REQ_START	0x01	//	グラフデータ送信開始要求
#define	CMD_RSP_START	0x11	//			〃			応答
#define	CMD_REQ_STOP	0x02	//	グラフデータ送信停止要求
#define	CMD_RSP_STOP	0x12	//			〃			応答
#define	CMD_DATA		0x40	//	グラフデータ

typedef struct {
	UB			cmd;			//	コマンドコード
	UB			fil[3];			//	－
	AJC3DVEC	vec;			//	グラフデータ
} CMDDATA, *PCMDDATA;

//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
static	HINSTANCE		hInst	 = NULL;				//	ＤＬＬインスタンスハンドル
static	HWND			hDlgMain = NULL;				//	ダイアログボックスハンドル
static	HAJCSCP			hScp	 = NULL;				//	ＳＣＰハンドル
static	HAJCSPD			hSpd	 = NULL;				//	テストデータ生成インスタンス
static	HANDLE			hMut5B	 = NULL;				//	自プログラム起動を示すミューテックス
static	HANDLE			hMut5A	 = NULL;				//	相手プログラム起動チェック用ミューテックス
//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Main);

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 	msg;

	hInst = hInstance;

	//----- メイン・ダイアログオープン -----------------//
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_DLGMAIN), NULL, AJC_DLGPROC_NAME(Main));
	SetWindowPos(hDlgMain, NULL, 560, 0, 0, 0, SWP_NOSIZE);
	//----- ダイアログ表示 -----------------------------//
	ShowWindow(hDlgMain, SW_SHOW);

	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}

	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//==============================================================================================================//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG 	)
{
	hDlgMain = hDlg;

	//	自ミューテックス生成
	hMut5A = CreateMutex(NULL, TRUE, TEXT("SW_SerialComPort5B"));

	//	相手プログラム起動
	hMut5B = CreateMutex(NULL, TRUE, TEXT("SW_SerialComPort5A"));
	if (GetLastError() != ERROR_ALREADY_EXISTS) {
		UT	path[MAX_PATH];
		CloseHandle(hMut5A);
		AjcGetAppPath(path, MAX_PATH);
		ShellExecute(NULL, NULL, TEXT("SW_SerialComPort5A_32W.exe"), TEXT(""), path, SW_SHOWNORMAL);
	}
	//	プロットデータ演算初期化
	hSpd = AjcSpdCreate(0);
	//	ＳＣＰセットアップ
	hScp = AjcScpCreate();											//	ＳＣＰインスタンス生成
	AjcScpSetMode(hScp, hDlg, WM_SCPEVENT, AJCSCP_CM_TEXT);			//	モード設定
	AjcScpSetRxTextCode(hScp, AJCSCP_TXT_SJIS);						//	受信テキストコード＝SJIS
	AjcScpSetTxTextCode(hScp, AJCSCP_TXT_SJIS);						//	送信テキストコード＝SJIS
	AjcScpSetEvtMask(hScp,	AJCSCP_EV_RXPKT 	|					//		パケットデータ受信通知
							AJCSCP_EV_RXNOPKT	|					//		パケット外データ受信通知
							AJCSCP_EV_RXTEXT);						//		テキスト受信通知
	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY		)
{
	if (hMut5B	 != NULL) CloseHandle(hMut5B);
	if (hSpd != NULL) AjcSpdDelete(hSpd);
	if (hScp != NULL) AjcScpDelete(hScp);
	//	プログラム終了
	PostQuitMessage(0);
	return TRUE;
}
//----- タイマ -------------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_TIMER			)
{
	CMDDATA		txd = {CMD_DATA};

	AjcSpdCalcV(hSpd, &txd.vec);
	AjcScpSendPacket(hScp, (C_VOP)&txd, sizeof txd);
	return TRUE;
}
//----- ＳＣＭイベント通知 -------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_SCPEVENT		)
{
	UI		time = GetTickCount();
	UI		len, param;
	union {UBP pCmd; UTP pTxt; VOP vp;} u;
	UB		cmd;

	AjcScpGetEventData(hScp, lParam, &u.vp, &len, &param);			//	イベントデータ取得
	if (wParam & AJCSCP_EV_RXPKT  ) {								//	●パケットデータ受信通知
		switch (*u.pCmd) {
			case CMD_REQ_START:			//	グラフデータ送信開始要求
				cmd = CMD_RSP_START;
				AjcScpSendPacket(hScp, (C_VOP)&cmd, 1);
				SetTimer(hDlg, 1, 100, NULL);
				break;
			case CMD_REQ_STOP:			//	グラフデータ送信停止要求
				cmd = CMD_RSP_STOP;
				AjcScpSendPacket(hScp, (C_VOP)&cmd, 1);
				KillTimer(hDlg, 1);
				break;
		}
	}
	if (wParam & AJCSCP_EV_RXNOPKT) { 								//	●パケット外テキスト受信通知（リアルタイム）
		//	受信テキストをエコーバック
		AjcScpSendText(hScp, u.pTxt, len);
	}
	if (wParam & AJCSCP_EV_RXTEXT) {								//	●テキスト受信通知
		SYSTEMTIME	lt;
		UT			txt[64];
		GetLocalTime(&lt);
		AjcScpSendText(hScp, TEXT("\n\x1B[35m"), -1);
		if		(_tcsicmp(u.pTxt, TEXT("DATE")) == 0) {
			AjcSnPrintF(txt, AJCTSIZE(txt), TEXT("%d/%02d/%02d\n"), lt.wYear, lt.wMonth, lt.wDay);
			AjcScpSendText(hScp, txt, -1);
		}
		else if (_tcsicmp(u.pTxt, TEXT("TIME")) == 0) {
			AjcSnPrintF(txt, AJCTSIZE(txt), TEXT("%02d:%02d:%02d\n"), lt.wHour, lt.wMinute, lt.wSecond);
			AjcScpSendText(hScp, txt, -1);
		}
		else {
			AjcScpSendTextF(hScp, TEXT("*** \"%s\" は、不正なコマンドです ***\n"), u.pTxt);
		}
		AjcScpSendText(hScp, TEXT("\x1B[0m"), -1);
	}
	AjcScpRelEventData(hScp, lParam);									//	イベントデータ開放

	return TRUE;
}
//----- ポート設定ボタン ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_SETPORT	)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		AjcScpDlgParamEasy(hScp, hDlg);
	}
	return TRUE;
}
//----- ＯＰＥＮボタン -----------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_OPEN		)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		if (AjcScpIsOpened(hScp)) {
			AjcScpClose(hScp);
			AjcSetDlgItemStr(hDlg, IDC_CMD_OPEN, TEXT("OPEN"));
		}
		else {
			if (AjcScpOpenDefault(hScp)) AjcSetDlgItemStr(hDlg, IDC_CMD_OPEN, TEXT("CLOSE"));
			else						 MessageBox(hDlg, TEXT("オープン失敗"), TEXT("SW_SerialComPort5A"), MB_ICONERROR);
		}
	}
	return TRUE;
}
//----- 「Cancel」ボタン ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL			)
{
	DestroyWindow(hDlg);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG	   )
	AJC_DLGMAP_MSG(Main, WM_DESTROY 	   )
	AJC_DLGMAP_MSG(Main, WM_TIMER		   )
	AJC_DLGMAP_MSG(Main, WM_SCPEVENT	   )

	AJC_DLGMAP_CMD(Main, IDC_CMD_SETPORT   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_OPEN	   )
	AJC_DLGMAP_CMD(Main, IDCANCEL		   )
AJC_DLGMAP_END

