﻿//
//	SW_SockServer2.c
//
#define AJCSERIALCOMPORT_H_
#include	<AjrCstXX.h>
#include	"resource.h"

#define	MAX_CLIENT	10
#define	WM_SSVEVENT	(WM_APP + 100)

//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
static	HINSTANCE		hInst;							//	ＤＬＬインスタンスハンドル
static	HWND			hDlgMain;						//	ダイアログボックスハンドル
static	HAJCSSV 		hSsv;
static	ULL				total[MAX_CLIENT];

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Main);
static UI GetFreeNumber(HWND hDlg);

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 	msg;

	//----- メイン・ダイアログオープン -----------------//
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_MAIN), NULL, AJC_DLGPROC_NAME(Main));
	AjcMoveWndIntoMonitor(hDlgMain);
	//----- ダイアログ表示 -----------------------------//
	ShowWindow(hDlgMain, SW_SHOW);
	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}
	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	メイン ダイアログ・プロシージャ																				//
//																												//
//==============================================================================================================//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG 	)
{
	UL		lHost;
	UT		szHost[128];

	hDlgMain	= hDlg;

	//	ホスト名表示
	lHost = AJCTSIZE(szHost);
	GetComputerName(szHost, &lHost);
	AjcSetDlgItemStr(hDlg, IDC_LBL_MYNAME, szHost);
	//	ソケットサーバ インスタンス生成
	hSsv = AjcSsvCreate();
	//	ウインド位置ロード
	AjcLoadWndPos(hDlg, TEXT("WndPos"));
	//	サーバ開始
	AjcSsvStart(hSsv, TEXT("14238"), AF_INET, MAX_CLIENT, hDlg, WM_SSVEVENT);

	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY		)
{
	//	ソケットサーバ インスタンス消去
	AjcSsvDelete(hSsv);
	//	ウインド位置セーブ
	AjcSaveWndPos(hDlg, TEXT("WndPos"));
	//	サーバ停止
	AjcSsvStop(hSsv, 10000);

	PostQuitMessage(0);
	return TRUE;
}
//----- ソケット(TCP/IP)イベント -------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_SSVEVENT		)
{
	union {UTP pTxt; BCP pBcp; UBP pBin; VOP pVop;} u;
	UI				len;
	UI				param;
	HAJCSSVCLI		hCli = NULL;
	UX				ux;
	UI				i;
	UT				szIpAddr[256];

	//	イベントデータ取得
	AjcSsvGetEventData(hSsv, lParam, &u.pVop, &len, &param);
	//	クライアント情報を取得し、クライアントのＩＰアドレスを設定
	if (AjcSsvGetClient(hSsv, lParam, &hCli)) {
		AjcSsvGetIpAddrStr(hCli, szIpAddr, AJCTSIZE(szIpAddr));
	}

	switch (wParam) {
		case AJCSSV_EV_CONNECT:									//●接続通知
			if ((i = GetFreeNumber(hDlg)) < MAX_CLIENT) {
				//	バイト数カウンタクリアー
				total[i] = 0;
				//	クライアントに空き番号を関連付ける
				AjcSsvSetClientData(hCli, i);
				//	クライアントIPアドレス表示
				AjcSsvGetIpAddrStr(hCli, szIpAddr, AJCTSIZE(szIpAddr));
				AjcSetDlgItemStr (hDlg, IDC_LBL_ADDR0 + i, szIpAddr);
				AjcSetDlgItemUInt(hDlg, IDC_LBL_CNT0  + i, 0);
			}
			break;

		case AJCSSV_EV_DISCONNECT:								//●切断通知
			//	クライアントに関連付けられた番号取得
			AjcSsvGetClientData(hCli, &ux); i = (UI)ux;
			//	クライアント表示クリアー
			AjcEnableDlgItem(hDlg, IDC_LBL_ADDR0 + i, FALSE);
			AjcEnableDlgItem(hDlg, IDC_LBL_CNT0	 + i, FALSE);
			break;

		case AJCSSV_EV_RXCHUNK:									//●チャンクデータ受信通知
			//	受信データを返送
			AjcSsvSendBinData(hCli, u.pBin, len);
			//	クライアントに関連付けられた番号取得
			AjcSsvGetClientData(hCli, &ux); i = (UI)ux;
			//	バイトカウンタ更新
			total[i] += len;
			AjcSepDlgItemUI64(hDlg, IDC_LBL_CNT0 + i, total[i]);
			break;
	}

	//	イベントデータ開放
	AjcSsvRelEventData(hSsv, lParam);
			
	return TRUE;
}
//----- キャンセル ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL			)
{
	DestroyWindow(hDlg);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG	   )
	AJC_DLGMAP_MSG(Main, WM_DESTROY 	   )
	AJC_DLGMAP_MSG(Main, WM_SSVEVENT 	   )
	AJC_DLGMAP_CMD(Main, IDCANCEL	 	   )
AJC_DLGMAP_END
//--------------------------------------------------------------------------------------------------------------//
//	空番号取得																									//
//--------------------------------------------------------------------------------------------------------------//
static UI GetFreeNumber(HWND hDlg)
{
	static UI ix = 0;
	UI		rc = 0;
	UI		i;

	for (i = 0; i < MAX_CLIENT; i++, ix = ((ix + 1) % MAX_CLIENT)) {
		if (MAjcGetWindowLong(GetDlgItem(hDlg, IDC_LBL_ADDR0 + ix), GWL_STYLE) & WS_DISABLED) {
			AjcEnableDlgItem(hDlg, IDC_LBL_ADDR0 + ix, TRUE);
			AjcEnableDlgItem(hDlg, IDC_LBL_CNT0  + ix, TRUE);
			rc = ix;
			ix = ((ix + 1) % MAX_CLIENT);
			break;
		}
	}
	return rc;
}
