﻿//
//	SW_SubClass4.c
//
#include	<AjrCstXX.h>
#include	<tchar.h>
#include	"resource.h"

//----- 作業領域 -----------------------------------------------------------------------------------------------//
static	HINSTANCE		hInst;
static	HWND			hDlgMain;
static	HWND			hButton;

//----- 内部サブ関数 -------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Main);
AJC_WNDPROC_DEF(SUB);

//--------------------------------------------------------------------------------------------------------------//
int WINAPI AjcWinMain(HINSTANCE hInstance, HINSTANCE hinstPrev, UTP szCmdLine, int iCmdShow)
{
	MSG 	msg;

	hInst = hInstance;
	AjcDgcSetup();
	//----- メイン・ダイアログオープン -----------------//
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_MAIN), NULL, AJC_DLGPROC_NAME(Main));
	ShowWindow(hDlgMain, SW_SHOW);

	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}

	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//==============================================================================================================//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG 	)
{
	hDlgMain = hDlg;
	hButton  = GetDlgItem(hDlg, IDC_BUTTON);

	//	ボタンのWM_LBUTTONDOWNを有効とするため、カラー設定のサブクラス化を先に実行する
	AjcDgcSubclass(hDlg);
	//	ボタンをサブクラス化
	MAjcMmpSetSubclass(SUB, hButton);

	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY		)
{
	PostQuitMessage(0);
	return TRUE;
}
//----- IDC_BUTTON ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_BUTTON		)
{
	MessageBox(hDlg, TEXT("ボタンがクリックされました。\n\n")
					 TEXT("このメッセージはオリジナルのボタンクリックイベントから表示しています。"), TEXT("SW_SubClass4"), MB_OK);
	AjcSetDlgItemStr(hDlgMain, IDC_LBL_MSG, TEXT(""));
	return TRUE;
}
//----- キャンセル ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL			)
{
	DestroyWindow(hDlg);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG	)
	AJC_DLGMAP_MSG(Main, WM_DESTROY 	)
	AJC_DLGMAP_CMD(Main, IDC_BUTTON		)
	AJC_DLGMAP_CMD(Main, IDCANCEL		)
AJC_DLGMAP_END
//--------------------------------------------------------------------------------------------------------------//
//	ボタンをサブクラス化したウインドプロシージャ																//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(SUB, WM_LBUTTONDOWN		)
{
	AjcSetDlgItemStr(hDlgMain, IDC_LBL_MSG, TEXT("ボタンがクリックされました。\n"
											TEXT("このメッセージはサブクラス化されたプロシージャから表示しています。")));
	return MAjcMmpCallOrgWndProc(SUB);
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(SUB, WM_RBUTTONDOWN		)
{
	MessageBox(hwnd, TEXT("ボタンが右クリックされました。\n\n")
					 TEXT("このメッセージはサブクラス化されたプロシージャから表示しています。"), TEXT("SW_SubClass4"), MB_OK);
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(SUB)
	AJC_WNDMAP_MSG(SUB, WM_LBUTTONDOWN	)
	AJC_WNDMAP_MSG(SUB, WM_RBUTTONDOWN	)
AJC_WNDMAP_END

