﻿//
//	SW_Vmg01C.C
//
#include	<AjrCstXX.h>
#include	<stdio.h>
#include	<conio.h>
#include	<time.h>
#include	<tchar.h>

//----- コールバック（変数情報の通知）--------------------------------------------------------------------------//
static BOOL CALLBACK cbNtcVar(PCAJCVMGNODE pVarInfo, UX cbp)
{
	switch (pVarInfo->type) {
		case AJCVMGT_INT:	AjcPrintF(TEXT("- <%s> = %d\n"	)  , pVarInfo->pName, pVarInfo->arr.pSI [0]); break;
		case AJCVMGT_LONG:	AjcPrintF(TEXT("- <%s> = %lld\n")  , pVarInfo->pName, pVarInfo->arr.pSLL[0]); break;
		case AJCVMGT_REAL:	AjcPrintF(TEXT("- <%s> = %f\n"	)  , pVarInfo->pName, pVarInfo->arr.pDBL[0]); break;
		case AJCVMGT_STR:	AjcPrintF(TEXT("- <%s> = \"%s\"\n"), pVarInfo->pName, pVarInfo->arr.pStr[0]); break;
	}
	return TRUE;
}

//==============================================================================================================//
int  AjcMain(int argc, UTP argv[])
{
	HAJCVMG 	hVmg;
	UT			InpBuf[256];

	AjcSetStdoutMode();

	//----- インスタンス生成 -----------------------------------------------------------------------------------//
	hVmg = AjcVmgCreate();

	//----- コマンドガイド表示 ---------------------------------------------------------------------------------//
	AjcPrintF(TEXT("\n"));
	AjcPrintF(TEXT(" -- Enter any command, show in below --\n"));
	AjcPrintF(TEXT(" V32 Name : Create new variable(32-bits integer).\n"));
	AjcPrintF(TEXT(" V64 Name : Create new variable(64-bits integer).\n"));
	AjcPrintF(TEXT(" VR  Name : Create new variable(Real number).\n"));
	AjcPrintF(TEXT(" VS  Name : Create new variable(String).\n"));
	AjcPrintF(TEXT(" SI  Name  nnn      : Set integer to variable.\n"));
	AjcPrintF(TEXT(" SR  Name  nnn.mm   : Set real number to variable.\n"));
	AjcPrintF(TEXT(" SS  Name  string   : Set string to variable.\n"));
	AjcPrintF(TEXT(" G   Name           : Get and show variable content.\n"));
	AjcPrintF(TEXT(" D   Name           : Remove variable.\n"));
	AjcPrintF(TEXT(" P        : Show all variables.\n"));
	AjcPrintF(TEXT(" <ESC>    : Quit\n"));
	AjcPrintF(TEXT("\n"));

	//----- コマンド処理 ---------------------------------------------------------------------------------------//
	AjcPrintF(TEXT("Input - "));
	while (AjcConInput(NULL, 128, InpBuf, AJCTSIZE(InpBuf), AJCCIN_SHOWTEXT)) {
		UTP p1 = MAjcStrTok(InpBuf, TEXT(" "));
		UTP p2 = MAjcStrTok(NULL  , TEXT(" "));
		UTP p3 = MAjcStrTok(NULL  , TEXT(" "));
		//------------------------------------------------------------------------------------------------------//
		if		(p1 && p2 && MAjcStrICmp(p1, TEXT("V32")) == 0) {				//● V32 Name : Create new variable(32-bits integer)
			if (AjcVmgGenVar(hVmg, p2, AJCVMGT_INT, 1)) {
				AjcPrintF(TEXT("- 32-bits integer variable <%s> is created.\n"), p2);
			}
			else AjcPrintF(TEXT("* Variable (<%s>) creation failure.\n"), p2);
		}
		//------------------------------------------------------------------------------------------------------//
		else if (p1 && p2 && MAjcStrICmp(p1, TEXT("V64")) == 0) {				//● V64 Name : Create new variable(64-bits integer)
			if (AjcVmgGenVar(hVmg, p2, AJCVMGT_LONG, 1)) {
				AjcPrintF(TEXT("- 64-bits integer variable <%s> is created.\n"), p2);
			}
			else AjcPrintF(TEXT("* Variable (<%s>) creation failure.\n"), p2);
		}
		//------------------------------------------------------------------------------------------------------//
		else if (p1 && p2 && MAjcStrICmp(p1, TEXT("VR"))  == 0) {				//● VR  Name : Create new variable(Real number)
			if (AjcVmgGenVar(hVmg, p2, AJCVMGT_REAL, 1)) {
				AjcPrintF(TEXT("- Real number variable <%s> is created.\n"), p2);
			}
			else AjcPrintF(TEXT("* Variable (<%s>) creation failure.\n"), p2);
		}
		//------------------------------------------------------------------------------------------------------//
		else if (p1 && p2 && MAjcStrICmp(p1, TEXT("VS"))  == 0) {				//● VS  Name : Create new variable(String)
			if (AjcVmgGenVar(hVmg, p2, AJCVMGT_STR, 1)) {
				AjcPrintF(TEXT("- String variable <%s> is created.\n"), p2);
			}
			else AjcPrintF(TEXT("* Variable <%s> creation failure.\n"), p2);
		}
		//------------------------------------------------------------------------------------------------------//
		else if (p1 && p2 && p3 && MAjcStrICmp(p1, TEXT("SI"))	== 0) {			//● SI  Name nnn	 : Set integer to variable.
			SLL n = AjcAscToLInt(p3);
			if (AjcVmgSetInteger(hVmg, p2, 0, n)) {
				AjcPrintF(TEXT("- Integer value(%lld) set to <%s>.\n"), n, p2);
			}
			else AjcPrintF(TEXT("* Integer value setting failure.\n"));
		}
		//------------------------------------------------------------------------------------------------------//
		else if (p1 && p2 && p3 && MAjcStrICmp(p1, TEXT("SR"))	== 0) {			//● SR  Name nnn.mm : Set real-number to variable.
			double	n = AjcAscToReal(p3);
			if (AjcVmgSetReal(hVmg, p2, 0, n)) {
				AjcPrintF(TEXT("- Real number(%f) set to <%s>.\n"), n, p2);
			}
			else AjcPrintF(TEXT("* Real number setting failure.\n"));
		}
		//------------------------------------------------------------------------------------------------------//
		else if (p1 && p2 && p3 && MAjcStrICmp(p1, TEXT("SS"))	== 0) {			//● SS  Name string : Set string to variable.
			if (AjcVmgSetString(hVmg, p2, 0, p3)) {
				AjcPrintF(TEXT("- String(%s) set to <%s>.\n"), p3, p2);
			}
			else AjcPrintF(TEXT("* String setting failure.\n"));
		}
		//------------------------------------------------------------------------------------------------------//
		else if (p1 && p2 && MAjcStrICmp(p1, TEXT("G"))  == 0) {				//● G	 Name		 : Get and show variable content
			PCAJCVMGNODE  pNode = AjcVmgGetNode(hVmg, p2);
			if (pNode->type != AJCVMGT_UNDEF) {
				SI		si;
				SLL 	sll;
				double	dbl;
				switch (pNode->type) {
					case AJCVMGT_INT:	AjcVmgGetInt32(hVmg, p2, 0, &si ); AjcPrintF(TEXT("- <%s> = %d\n"  ), p2, si ); break;
					case AJCVMGT_LONG:	AjcVmgGetInt64(hVmg, p2, 0, &sll); AjcPrintF(TEXT("- <%s> = %lld\n"), p2, sll); break;
					case AJCVMGT_REAL:	AjcVmgGetReal (hVmg, p2, 0, &dbl); AjcPrintF(TEXT("- <%s> = %f\n"  ), p2, dbl); break;
					case AJCVMGT_STR:	AjcPrintF(TEXT("- <%s> = \"%s\"\n"), p2, AjcVmgGetString(hVmg, p2, 0)); 		break;
				}
			}
			else AjcPrintF(TEXT("* Variable <%s> not found.\n"), p2);
		}
		//------------------------------------------------------------------------------------------------------//
		else if (p1 && p2 && MAjcStrICmp(p1, TEXT("D"))  == 0) {				//● D	 Name		 : Remove variable
			if (AjcVmgDelVar(hVmg, p2)) {
				AjcPrintF(TEXT("- Variable <%s> is removed.\n"), p2);
			}
			else AjcPrintF(TEXT("* Variable <%s> not found.\n"), p2);
		}
		//------------------------------------------------------------------------------------------------------//
		else if (p1 && MAjcStrICmp(p1, TEXT("P"))	== 0) { 					//● P				 : Show all variable
			UI	n;
			n = AjcVmgEnumVar(hVmg, 0, cbNtcVar);
			AjcPrintF(TEXT("- %d variables\n"), n);
		}
		else {
			AjcPrintF(TEXT("* Missing parameter.\n"));
		}
		AjcPrintF(TEXT("Input - "));
	}
	AjcVmgDelete(hVmg);

	return 0;
}

