﻿//
//	SZOld_Cip2.c
//

#pragma warning(disable:4996)
#include	<AjrCstXX.h>
#include	"resource.h"

//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
static	HINSTANCE		hInst;							//	ＤＬＬインスタンスハンドル
static	HWND			hDlgMain;						//	ダイアログボックスハンドル
static	HWND			hWndCip;						//	ＣＩＰウインドハンドル
static	BOOL			fRun  = FALSE;					//	マクロ実行中を示すフラグ
static	BOOL			fExit = FALSE;					//	プログラム終了を示すフラグ

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Main);

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 	msg;

	hInst = hInstance;

	//----- プロファイル先をレジストリとする -----------//
	AjcSetProfileIsRegistory(TRUE);
	AjcSetRegOptionVolatile (FALSE);
	//----- メイン・ダイアログオープン -----------------//
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_MAIN), NULL, AJC_DLGPROC_NAME(Main));
	//----- ダイアログ表示 -----------------------------//
	ShowWindow(hDlgMain, SW_SHOW);
	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}
	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//==============================================================================================================//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG 	)
{
	hDlgMain = hDlg;
	hWndCip  = GetDlgItem(hDlg, IDC_CIP);

	//	タイマを設定し、１秒後にマクロ実行
	SetTimer(hDlg, 1, 1000, NULL);

	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY		)
{
	//	プログラム終了
	PostQuitMessage(0);

	return TRUE;
}
//----- WM_TIMER -----------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_TIMER			)
{
	const double *	pResult;
	UI				n;
	BC	InpFile[MAX_PATH];

	//	タイマ停止
	KillTimer(hDlg, 1);

	//	マクロテキストパス設定
	AjcGetAppPath(InpFile, MAX_PATH);
	AjcPathCat(InpFile, "..\\MacTxt\\M990.txt", MAX_PATH);

	//	マクロの読み出しと実行
	if (AjcCipLoad(hWndCip, InpFile)) {
		PAJCCIPCALL	pCall;
		if (pCall = AjcCipCallInfoInit(hWndCip, "func")) {
			fRun = TRUE;
			//	引数設定
			AjcCipCallInfoInsString(hWndCip, pCall, "円の中心計算");	//	第１引数(タイトル)
			AjcCipCallInfoInsReal  (hWndCip, pCall, 0.0);				//	第２引数(x1)
			AjcCipCallInfoInsReal  (hWndCip, pCall, 0.5);				//	第３引数(y1)
			AjcCipCallInfoInsReal  (hWndCip, pCall, 1.0);				//	第４引数(x2)
			AjcCipCallInfoInsReal  (hWndCip, pCall, 1.5);				//	第５引数(y2)
			AjcCipCallInfoInsReal  (hWndCip, pCall, 2.0);				//	第６引数(x3)
			AjcCipCallInfoInsReal  (hWndCip, pCall, 0.5);				//	第７引数(y3)
			//	マクロ実行
			if (AjcCipExec(hWndCip, pCall)) {
			AjcCipPrintF(hWndCip, "\n");
				AjcCipPrintF(hWndCip, "マクロの実行を終了しました。\n");
				pResult = AjcCipGetRetReal(hWndCip, &n);
				AjcCipPrintF(hWndCip, "戻り値： 中心 x = %5.2f, y = %5.2f\n", pResult[0], pResult[1]);
			}
			else {
				AjcCipPrintF(hWndCip, "マクロの実行中にエラーが発生しました。\n");
			}
			AjcCipCallInfoDelete(hWndCip, pCall);
			fRun = FALSE;
			//	プログラム終了判断
			if (fExit) {
				DestroyWindow(hDlg);
			}
		}
		else {
			AjcCipPrintF(hWndCip, "マクロテキストに func() 関数がありません。\n");
		}
	}
	else {
		AjcCipPrintF(hWndCip, "マクロの読み出しを失敗しました。\n");
	}

	return TRUE;
}
//----- キャンセル ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL			)
{
	if (fRun) {
		AjcCipStop(hWndCip);
		fExit = TRUE;
	}
	else {
		DestroyWindow(hDlg);
	}
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG	   )
	AJC_DLGMAP_MSG(Main, WM_DESTROY 	   )
	AJC_DLGMAP_MSG(Main, WM_TIMER	 	   )
	AJC_DLGMAP_CMD(Main, IDCANCEL		   )
AJC_DLGMAP_END

