﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using CAjrCustCtrl;

namespace Sil_3DGraphic3
{
	public partial class Form1 : Form
	{
		AJC3DVEC	m_cent	 = new AJC3DVEC(1.0, 2.0, 3.0);			//	中心位置
		int 		m_Count  = 0;
		int 		m_Ix	 = 0;
		AJC3DVEC[]	m_Points = new AJC3DVEC[3];
		AJC3DVEC	m_vh;

		string m_msg = "SHIFT+クリックで、任意の３点を選択してください。\n" 	  +
					   "３点が選択されたら、各点をとおる平面円が表示されます。\n" +
					   "\n" 													  +
					   "視点設定ボタンを押すと、視点を平面の真上に設定します。\n";

		public Form1()
		{
			InitializeComponent();
		}
		//	起動時初期設定
		private void Form1_Load(object sender, EventArgs e)
		{
			Random	rnd = new Random(1000);
			double	max;
			AJC3DVEC	v;

			g3d.SetCenter(m_cent);
			//	球面付近にランダムな点を１００個表示
			for (int i = 0; i < 100; i ++) {
				v.x = rnd.NextDouble();
				max = Math.Sqrt(1.0 - Math.Pow(v.x, 2.0));
				v.y = rnd.NextDouble() * max;
				v.z = Math.Sqrt(1.0 - Math.Pow(v.x, 2.0) - Math.Pow(v.y, 2.0));
				if ((rnd.Next(2) & 1) != 0) v.x += (rnd.NextDouble() * 0.1); else v.x -= (rnd.NextDouble() * 0.1);
				if ((rnd.Next(2) & 1) != 0) v.y += (rnd.NextDouble() * 0.1); else v.y -= (rnd.NextDouble() * 0.1);
				if ((rnd.Next(2) & 1) != 0) v.z += (rnd.NextDouble() * 0.1); else v.z -= (rnd.NextDouble() * 0.1);
				if ((rnd.Next(2) & 1) != 0) v.x *= -1;
				if ((rnd.Next(2) & 1) != 0) v.y *= -1;
				if ((rnd.Next(2) & 1) != 0) v.z *= -1;
				v = SAjrMath.V3dAdd(v, m_cent);
				g3d.Pixel(0, v, 3);
			}
			SAjrTip.ShowCenter(g3d, m_msg);
		}
		//	３Ｄグラフイック・プロット点通知
		private void cAjr3DGraphic1_OnPltLst(object sender, CAjrCustCtrl.G3dArgPltLst e)
		{
			int					id = 1;
			AJC3DVEC			vc, v;
			double				r;
			AJC3DCIRINFO		cif;
			//	プロット点をバッファへ格納
			m_Points[m_Ix] = e.p[0].v;
			m_Ix = (m_Ix + 1) % 3;
			if (m_Count < 3) m_Count++;
			//	プロット点表示
			g3d.PurgeData(id);
			for (int i = 0; i < m_Count; i++) {
				g3d.Pixel(id, m_Points[i], 3);
			}
			//	３点が揃ったら平面円と法線表示
			if (m_Count >= 3) {
				btnViewPoint.Enabled = true;
				r = SAjrMath.V3dCalcCircle(m_Points[m_Ix], m_Points[(m_Ix + 1) % 3], m_Points[(m_Ix + 2) % 3], out vc, out m_vh, out cif);
				g3d.DefPlane(id, cif.lvc);
				g3d.Ellipse  (id, 0, 0, cif.cr, cif.cr);
				g3d.Pixel    (id, 0, 0, 3);
				v = SAjrMath.V3dNormal(m_vh);
				v = SAjrMath.V3dMult(v, 0.5);
				v = SAjrMath.V3dAdd (v, vc);
				g3d.Line     (id, vc, v, true);
			}
		}
		//	視点設定ボタン
		private void btnViewPoint_Click(object sender, EventArgs e)
		{
			g3d.SetAngle(m_vh);
		}
		//	？ボタン
		private void btnHelp_Click(object sender, EventArgs e)
		{
			 SAjrTip.ShowCenter(g3d, m_msg);
		}

	}
}
