﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using CAjrCustCtrl;

namespace Sil_CToken
{
	public partial class Form1 : Form
	{
		public Form1()
		{
			InitializeComponent();
		}
		//	初期設定
		private void Form1_Load(object sender, EventArgs e)
		{
			//----- ヘッダテキスト出力 ---------------------------//
			vthTtl.PutText("      S U R  V S P D  S  P P  M M M M  W               \n");
			vthTtl.PutText("      Y S S  A T A E  P  R P  A A A A  I               \n");
			vthTtl.PutText("      M R V  L R T L  A  E T  C C C C  D               \n");
			vthTtl.PutText("      B S S  U I H I  C  P O  N W A B  E               \n");
			vthTtl.PutText("      O Y Y  E N N M  E  R P  A I R O  C               \n");
			vthTtl.PutText("      L M M  | G A I  |  O |  M T G D  H               \n");
			vthTtl.PutText("      | | |  | | M T  |  | |  E H | Y  A               \n");
			vthTtl.PutText("      | | |  | | E |  |  | |  | A | |  R               \n");
			vthTtl.PutText("Token | | |  | | | |  |  | |  | R | |  |               \n");
			vthTtl.PutText("Code  | | |  | | | |  |  | |  | G | |  |  TokenString  ");

			vthLog.PutText("\n");
			vthLog.PutText(" Ｃ言語ソースプログラムの字句を解析します。\n");
			vthLog.PutText(" ここにソースファイルをドロップしてください。\n");
		}
		//	イベント（１行入力）
		private bool cAjrCToken1_OnGetS(object sender, CAjrCustCtrl.CtkArgGetS e)
		{
			bool rc = false;
			rc = txfInp.GetS(e.pBuf, e.lBuf);
			return rc;
		}

		private void vthLog_OnFileDrop(object sender, VthArgFileDrop e)
		{
			string syl;
			ECtkCode tkn;
			ECtkFlg  flg;

			do {
				//	画面クリアー
				vthLog.Purge();
				//	入力ファイルエンコード設定
				txfInp.TextEncodeAtRead  = ETextEncode.TEC_AUTO;
		   		//	ファイルオープン
				txfInp.Open(vthLog.GetDroppedFile());
				//	トークン入力ループ
				while (ctk.GetToken(out syl)) {
					tkn = ctk.CurToken;
					vthLog.PutText(((uint)tkn).ToString("X4"));
					vthLog.PutText("  ");
					vthLog.PutText(ctk.IsSymbol 	   (tkn)  		? "1" : ".");	vthLog.PutText(" ");
					vthLog.PutText(ctk.IsUserSymbol    (tkn)  		? "1" : ".");	vthLog.PutText(" ");
					vthLog.PutText(ctk.IsReservedSymbol(tkn)  		? "1" : ".");	vthLog.PutText("  ");
					vthLog.PutText(ctk.IsIsNumericValue(tkn)  		? "1" : ".");	vthLog.PutText(" ");
					vthLog.PutText(ctk.IsString 	   (tkn)  		? "1" : ".");	vthLog.PutText(" ");
					vthLog.PutText(ctk.IsPathName	   (tkn)  		? "1" : ".");	vthLog.PutText(" ");
					vthLog.PutText(ctk.IsDelimiter	   (tkn)  		? "1" : ".");	vthLog.PutText("  ");
					vthLog.PutText(ctk.IsSpace		   (tkn)  		? "1" : ".");	vthLog.PutText("  ");
					
					flg = ctk.CurFlag;
					vthLog.PutText((flg & ECtkFlg.PREPRO	) != 0	? "1" : ".");	vthLog.PutText(" ");
					vthLog.PutText((flg & ECtkFlg.PPTOP 	) != 0	? "1" : ".");	vthLog.PutText("  ");
					vthLog.PutText((flg & ECtkFlg.MACNAME	) != 0	? "1" : ".");	vthLog.PutText(" ");
					vthLog.PutText((flg & ECtkFlg.MACWITHARG) != 0	? "1" : ".");	vthLog.PutText(" ");
					vthLog.PutText((flg & ECtkFlg.MACARG	) != 0	? "1" : ".");	vthLog.PutText(" ");
					vthLog.PutText((flg & ECtkFlg.MACBODY	) != 0	? "1" : ".");	vthLog.PutText("  ");
					vthLog.PutText((flg & ECtkFlg.WIDECHAR	) != 0	? "1" : ".");	vthLog.PutText("   ");
					vthLog.PutText("'" + syl + "'\n");

                    Application.DoEvents();
				}
				//	ファイルクローズ
				txfInp.Close();
			} while(false);

		}
	}
}
