﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using CAjrCustCtrl;

namespace Sil_ConInpC
{
	class Program
	{
		static CAjrStatic	sta    = new CAjrStatic();
		static void Main(string[] args)
		{
			//----- コマンド引数がある場合は、コマンド引数を表示 -------------------------------------------//
			if (args.Length >= 1) {
				Console.Write("\nコマンド引数\n\n");
				cbNtcArgs(args.Length, args);
			}
			//----- コマンド引数が無い場合は、コンソールから入力して表示 -----------------------------------//
			else {
				//	ユーザヘルプテキスト
				string hlp = "\n" +
							 " F2キーでユーザ指定のヘルプを表示します。\n" +
							 " F1キーでオリジナルの操作ヘルプを表示します。\n";
				//	コールバック設定
				ConCbkNtcArgs cb	= new ConCbkNtcArgs(cbNtcArgs);

				//	コンソール入力
				Console.Write("\n\n文字列を入力してください\n\n ");
				string txt = SAjrCon.GetLine("東京都 港区 赤坂 1-23-456",	//	初期表示文字列（不要時はnull）
											 20,							// 	入力フィールド長
											 32,							//	入力文字数
											 ECInGetLineOpt.ALL,			//	オプションフラグ
											 Color.Empty, 					//	入力域のテキスト色
											 Color.Empty,					//	入力域の背景色
											 hlp,							//	F2キー押下時に表示するヘルプテキスト
											 cb);							//	入力テキストの通知用コールバック
				if (txt != null) {
					Console.Write("\n入力テキスト=\"" + txt + "\"\n");
				}
				else {
					Console.Write("\nキャンセルされました / エラー\n");
				}
			}
			Console.Write("\n\nHit Enter key -");
			Console.ReadLine();
		}
		//----- コンソール入力のコールバック ---------------------------------------------------------------//
		static void cbNtcArgs (int argc,  string[] args)
		{
			Console.WriteLine("");
			for (int i = 0; i < argc; i++) {
				Console.WriteLine(args[i]);
			}
		}
	}
}
