﻿//	
//	Sil_FileSearch
//
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using CAjrCustCtrl;

namespace Sil_FileSearch
{
	public partial class Form1 : Form
	{
		int		Count;
		bool	fCont;

		public Form1()
		{
			InitializeComponent();
		}
		//----- 起動時初期設定 ---------------------------------------------------------//
		private void Form1_Load(object sender, EventArgs e)
		{
			this.FormBorderStyle = FormBorderStyle.FixedSingle;
			this.Text = this.Text + (IntPtr.Size == 4 ? " (WIN32)" : " (WIN64)");
			lblSrhDir.Text	   = "";
			//	設定値ロード
			SAjrReg.LoadAllCtrls(this);
			//----- 検索中のフォルダ通知設定 ------//
			fsr.SetNtcSearchingDir(true);
		}
		//----- 終了時の処理 -----------------------------------------------------------//
		private void Form1_FormClosing(object sender, FormClosingEventArgs e)
		{
			fCont = false;
			//	設定値セーブ
			SAjrReg.SaveAllCtrls(this);
		}
		//----- フォルダ検索　ラジオボタン ---------------------------------------------//
		private void rbtFolder_CheckedChanged(object sender, EventArgs e)
		{
			if (rbtFolder.Checked) {
				chkSubDir.Enabled = true;
				chkNwDrive.Enabled = false;
				lblDir.Enabled = true;
				txtDir.Enabled = true;
				cmdDir.Enabled = true;
			}
		}
		//----- マイコンピュータ検索　ラジオボタン -------------------------------------//
		private void rbtMyComp_CheckedChanged(object sender, EventArgs e)
		{
			if (rbtMyComp.Checked) {
				chkSubDir.Enabled = false;
				chkNwDrive.Enabled = true;
				lblDir.Enabled = false;
				txtDir.Enabled = false;
				cmdDir.Enabled = false;
			}
		}
		//----- フォルダ設定ボタン -----------------------------------------------------//
		private void cmdDir_Click(object sender, EventArgs e)
		{
			string dir = SAjrGsr.GetFolder("検索フォルダ設定", "");
			if (dir != "") {
				txtDir.Text = dir;
			}
		}
		//----- 検索開始ボタン ---------------------------------------------------------//
		private void cmdStart_Click(object sender, EventArgs e)
		{
			string wild = "";
			int n;

			vth.Purge();
			if (txtWild0.Text != "") wild = wild						   + txtWild0.Text;
			if (txtWild1.Text != "") wild = wild + (wild != "" ? ";" : "") + txtWild1.Text;
			if (txtWild2.Text != "") wild = wild + (wild != "" ? ";" : "") + txtWild2.Text;
			if (txtWild3.Text != "") wild = wild + (wild != "" ? ";" : "") + txtWild3.Text;
			if (txtWild4.Text != "") wild = wild + (wild != "" ? ";" : "") + txtWild4.Text;
			cmdStart.Enabled = false;
			cmdStop.Enabled  = true;
			Count = 0;
			fCont = true;
			if (rbtFolder.Checked) n = fsr.SearchFiles	   (txtDir.Text, wild, chkSubDir.Checked);
			else				   n = fsr.SearchMyComputer(null	   , wild, chkNwDrive.Checked);
			vth.PutText("\nFind " + n.ToString() + " Files");
			cmdStart.Enabled = true;
			cmdStop.Enabled  = false;
		}
		//----- 検索中止ボタン ---------------------------------------------------------//
		private void cmdStop_Click(object sender, EventArgs e)
		{
			fCont = false;
		}
		//----- ファイル検索通知 -------------------------------------------------------//
		private bool fsr_OnFindFile(object sender, FsrArgFindFile e)
		{
			if (e.nest != -1) {
				Count++;
				vth.PutText(Count.ToString("D4") + " : \x1B[31m" + e.FileName + "\n" + "\x1B[0m" + "       " + e.PathName + "\n");
			}
			else {
				lblSrhDir.Text = e.PathName;
			}

			System.Windows.Forms.Application.DoEvents();

			return fCont;	// true:検索継続，false:検索中止
		}
	}
}
