﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using CAjrCustCtrl;

namespace Sil_FileSearchC
{
	class Program
	{
		static CAjrFileSearch fs = new CAjrFileSearch(); //	ファイル検索オブジェクト生成
		static ConsoleKeyInfo c  = new ConsoleKeyInfo(); // コンソールキー情報オブジェクト生成
		static string dir		 = null;
		static uint   Count 	 = 0;

		static void Main(string[] args)
		{
            string path = @"d:\";
            string wild = "*.bmp;*.png";
			Count = 0;
            Console.WriteLine("パス(" + path + ")からファイル(" + wild + ")を検索します。");
            Console.WriteLine("ENTERキーを押すと開始します。　ESCキーを押すと検索を終了します。\n");
            Console.ReadLine();
			//	ファイル検索実行
			FsrCbkFindFile cb = new FsrCbkFindFile(cbFind);
			fs.SetNtcSearchingDir(true);
			fs.SearchFiles(path, wild, true, (IntPtr)0, cb);
			//	キー入力待ち
			Console.Write("\n\nHit Enter key -");
			Console.ReadLine();
		}
		//	ファイル検索通知コールバック
		static private bool cbFind(int nest, string path, string file, EFileAtt att, uint ftime, IntPtr cbp)
		{
			//	検索中のフォルダパス通知
			if (nest == -1) {
				dir = path;
			}
			//	見つかったファイルパス通知
			else {
				if (dir != null) {
					Console.WriteLine("----- " + dir);
					dir = null;
				}
				Count++;
				Console.WriteLine(Count.ToString() + " " + file);
			}
			//	ＥＳＣキー押下ならば検索中止
			if (Console.KeyAvailable) c = Console.ReadKey(true);
			return (c.Key != ConsoleKey.Escape) ? true : false;
		}
	}
}
