﻿//
//	Sil_InpVal1
//
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using CAjrCustCtrl;

namespace Sil_InpVal1
{
	public partial class Form1 : Form
	{
		Color m_color = Color.Black;
		
		public Form1()
		{
			InitializeComponent();
		}
		//===== 起動時初期設定 ==========================================================//
		private void Form1_Load(object sender, EventArgs e)
		{
			this.FormBorderStyle = FormBorderStyle.FixedSingle;
			this.Text = this.Text + (IntPtr.Size == 4 ? " (WIN32)" : " (WIN64)");
			pic.Invalidate();
        }
		//===== ピクチャ描画イベント ====================================================//
		private void pic_Paint(object sender, PaintEventArgs e)
		{
			SolidBrush b = new SolidBrush(m_color);
			e.Graphics.FillRectangle(b, 0, 0, pic.Size.Width, pic.Size.Height);
			b.Dispose();
        }
		//===== Ｒ値通知 ================================================================//
		private void inpR_OnNtcIntValue(object sender, IvArgNtcIntValue e)
		{
			m_color = Color.FromArgb(inpR.IntValue, inpG.IntValue, inpB.IntValue);
			pic.Invalidate();
		}
		//===== Ｇ値通知 ================================================================//
		private void inpG_OnNtcIntValue(object sender, IvArgNtcIntValue e)
		{
			m_color = Color.FromArgb(inpR.IntValue, inpG.IntValue, inpB.IntValue);
			pic.Invalidate();
		}
		//===== Ｂ値通知 ================================================================//
		private void inpB_OnNtcIntValue(object sender, IvArgNtcIntValue e)
		{
			m_color = Color.FromArgb(inpR.IntValue, inpG.IntValue, inpB.IntValue);
			pic.Invalidate();
		}
		//===== Ａ値(フォームの透明度)通知 ==============================================//
		private void inpA_OnNtcRealValue(object sender, IvArgNtcRealValue e)
		{
			this.Opacity = e.value;
		}
	}
}