﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Collections;
using CAjrCustCtrl;

namespace Sil_SerialComPort3
{
	public partial class Form1 : Form
	{
		string		m_InpDir;					//	入力フォルダパス
		string		m_OutDir;					//	出力フォルダパス
		string		m_InpPath;					//	入力ファイルパス
		string		m_OutPath;					//	出力ファイルパス
		FileStream	m_InpFs;					//	入力ファイルストリーム
		FileStream	m_OutFs;					//	出力ファイルストリーム
		long		m_FileSize;					//	入力ファイルサイズ
		int			m_Unmatch;					//	比較不一致ファイル数
		int			m_ListCount;				//	全ファイル数
		int			m_ListIx;					//	ファイルインデクス
		ArrayList 	m_list = new ArrayList();	//	全入出力ファイル リスト
		int			m_BufSize = 1024;			//	送信データバッファサイズ
		int 		m_Bytes   = 0;				//	送信バイトカウント
		bool		m_fSendBusy = false;		//	送信中フラグ 

		public Form1()
		{
			InitializeComponent();
		}

		private void Form1_Load(object sender, EventArgs e)
		{
			//	ビットマップ表示
			System.Reflection.Assembly myAssembly = System.Reflection.Assembly.GetExecutingAssembly();
			Bitmap bmp = new Bitmap(myAssembly.GetManifestResourceStream("Sil_SerialComPort3.ProgImage.bmp"));
			bmp.MakeTransparent();
			pic.Image = bmp;
			//	ウインド位置ロード
			SAjrReg.LoadWndPos(this);
			//	設定値ロード
			SAjrReg.LoadAllCtrls(this);
			//	ＳＣＰ初期化
			scp.Init();
			//	パケット受信タイムアウト（低速通信用に長めに設定する）
			scp.PktTimeout = 60000;
			//	ポート名表示
			lblPortName.Text = scp.GetPortName();
			//	ソケットのみ設定可とする
		//	scp.EnablePortSelectionInDialog(false, false, true);
		}
		//	フォーム終了
		private void Form1_FormClosed(object sender, FormClosedEventArgs e)
		{
			//	ウインド位置セーブ
			SAjrReg.SaveWndPos(this);
			//	設定値セーブ
			SAjrReg.SaveAllCtrls(this);
		}
		//	入力パス設定ボタン
		private void btnInpPath_Click(object sender, EventArgs e)
		{
			string path;
			if ((path = SAjrGsr.GetFolder("入力フォルダ", "")) != "") {
				txtInpPath.Text = path;
			}
		}
		//	出力パス設定ボタン
		private void btnOutPath_Click(object sender, EventArgs e)
		{
			string path;
			if ((path = SAjrGsr.GetFolder("出力フォルダ", "")) != "") {
				txtOutPath.Text = path;
			}
		}
		//	通信パラメタ設定ボタン
		private void btnParam_Click(object sender, EventArgs e)
		{
			scp.SetParamByDialog();
		}
		//	オープンボタン
		private void btnOpen_Click(object sender, EventArgs e)
		{
			scp.Open();
			lblState.Text = "Openning";
			EnableButtons(false, false, false, true);
		}
		//	開始ボタン
		private void btnStart_Click(object sender, EventArgs e)
		{
			//	入出力パス設定
			m_InpDir = txtInpPath.Text;
			m_OutDir = txtOutPath.Text;
			if (m_InpDir != "" && m_OutDir != "") {
				if (m_InpDir != m_OutDir) {
					//	入出力パスリストクリアー
					m_list.Clear();
					//	ファイル検索（入出力パスリスト作成）
					m_ListCount = 0;
					m_ListIx	= 0;
					m_Unmatch	= 0;
					fsr.SearchFiles(m_InpDir, "*.*", true);
					//	フォルダ構造コピー
					if (m_ListCount != 0) {
						//	出力フォルダ下の全ファイル削除
						if (MessageBox.Show(m_OutDir + "下の全ファイルを削除します。よろしいですか？", "Sil_SerialComPort3",
								MessageBoxButtons.YesNo, MessageBoxIcon.Exclamation) == DialogResult.Yes) {
							//	バイトカウンタクリアー
							m_Bytes = 0;
							lblBytes.Text = "0";
							//	ログクリアー
							vthLog.Purge();
							//	ボタングレー化
							EnableButtons(false, false, false, true);
							//	フォルダ下クリアー
							SAjrFop.CleanFolder(m_OutDir);
							//	フォルダ構造コピー
							SAjrFop.CopyFolderStruct(m_InpDir, m_OutDir);
							//	ファイルをオープンし送信開始
							SendNextFile();
						}
					} else SAjrTip.ShowCenter(this, "\x1B[31m" + "入力フォルダ下にファイルがありません。");

				} else SAjrTip.ShowCenter(this, "\x1B[31m" + "入出力フォルダが同じです。");

			} else SAjrTip.ShowCenter(this, "\x1B[31m" + "入出力フォルダが設定されていません。");
		}
		//	中止ボタン
		private void btnStop_Click(object sender, EventArgs e)
		{
			//	送信中フラグクリアー
			m_fSendBusy = false;
			//	ポートクローズ
			scp.Close();
			//	ファイルストリーム解放
			if (m_InpFs != null) {m_InpFs.Dispose(); m_InpFs = null;}
			if (m_OutFs != null) {m_OutFs.Dispose(); m_OutFs = null;}
			vthLog.PutText("\n\n--- ループバックテストを中止しました ---\n");
		}
		//	ポート状態通知
		private void scp_OnPortState(object sender, ScpArgPortState e)
		{
			lblPortName.Text = e.name;
			if		(e.state == EScpPortState.Opened) {
				lblState.Text = "Opened";
				btnStart.Enabled = true;
			}
			else if (e.state == EScpPortState.Closed) {
				//	データ送信中ならば、中止ボタン押下
				if (m_fSendBusy) {
					btnStop.PerformClick();
				}
				lblState.Text = "Closed";
				EnableButtons(true, true, false, false);
			}
			else if (e.state == EScpPortState.OpenFailure) {
				lblState.Text = "Open Failure";
				EnableButtons(true, true, false, false);
			}
			else if (e.state == EScpPortState.PortChanged) {
				lblState.Text = "Port changed";
			}
		}
		//	パケット受信通知
		private void scp_OnRxPacket(object sender, ScpArgRxPacket e)
		{
			//	空パケット（ファイル終端）以外ならば、受信データをファイルへ出力
			if (e.bin != null) {
				if (m_OutFs != null) {
					m_OutFs.Write(e.bin, 0, e.bin.Length);
				}
			}
			//	空パケット（ファイル終端）ならば、次のファイル送信へ・・
			else {
				//	出力ファイルクローズ
				if (m_OutFs != null) {m_OutFs.Dispose(); m_OutFs = null;}
				//	ファイルコンペア
				if (SAjrFop.FileCompare(m_InpPath, m_OutPath)) {
					vthLog.PutText("OK (Match)\n");
				}
				else {
					m_Unmatch++;
					vthLog.PutText("\x1B[31mNG (Unmatch)\x1B[0m\n");
				}
				//	次のファイル送信開始
				SendNextFile();
			}
		}
		//	送信完了通知
		private void scp_OnTxEmpty(object sender, EventArgs e)
		{
			//	次のファイルデータ送信
			if (m_InpFs != null) {
				FileSend();
			}
		}
		//	ファイル検索通知
		private bool fsr_OnFindFile(object sender, FsrArgFindFile e)
		{
			if (e.FileAtt != EFileAtt._A_SUBDIR) {
				//	入出力ファイルパス設定（セミコロン(;)で区切る）
				string dtail, outpath;
				dtail	= Path.GetDirectoryName(e.PathName);
				dtail	= SAjrGsr.PathCat(dtail, "");
				dtail	= dtail.Substring(m_InpDir.Length);
				outpath = SAjrGsr.PathCat(m_OutDir + dtail, e.FileName);
				m_list.Add(e.PathName + ";" + outpath);
				m_ListCount++;
			}
			return true;
		}
		//	次のファイル送信
		private bool SendNextFile()
		{
			bool	rc = false;
			if (FileOpen()) {
				m_fSendBusy = true;
				FileSend();
				rc = true;
			}
			else {
				m_fSendBusy = false;
				scp.Close();
				vthLog.PutText("\n--- ループバックテストを終了しました ---\n");
				vthLog.PutText("    ループバック不一致数 : " + m_Unmatch.ToString() + " / " +
															   m_ListCount.ToString() + " [files]\n");
			}
			return rc;
		}
		//	ファイルオープン（true:ゼロサイズ以外のファイルオープン，false:ファイルなし）
		private bool FileOpen()
		{
			bool	rc = false;
			while (m_ListIx < m_ListCount) {
				//	入出力パス名設定
				Object obj = m_list[m_ListIx++];
				string pathes = (string)obj;
				string[] s = pathes.Split(';');
				m_InpPath  = s[0];
				m_OutPath  = s[1];
				vthLog.PutText("\n" + m_ListIx.ToString("D3") + " : " + m_InpPath + "\n");
				vthLog.PutText("   -> " + m_OutPath + " - ");
				//	入出力ファイルオープン
				m_InpFs    = new FileStream(m_InpPath, FileMode.Open);
				m_OutFs    = new FileStream(m_OutPath, FileMode.Create);
				//	ファイルサイズ設定
				m_FileSize = m_InpFs.Length;
				//	ゼロサイズならば、ファイルクローズ
				if (m_FileSize == 0) {
					vthLog.PutText("OK (Zero size)\n");
					if (m_InpFs != null) {m_InpFs.Dispose(); m_InpFs = null;}
					if (m_OutFs != null) {m_OutFs.Dispose(); m_OutFs = null;}
				}
				//	ゼロサイズ以外ならば、ファールオープンした旨を返す
				else {
					rc = true;
					break;
				}
			}
			return rc;
		}
		//	ファイル送信
		private void FileSend()
		{
			//	バッファサイズを超える残データ有りならば、データ送信し、バイト数減算
			if (m_FileSize > m_BufSize) {
				byte[] buf = new byte[m_BufSize];
				m_InpFs.Read(buf, 0, m_BufSize);
				m_Bytes += scp.SendPacket(buf);
				m_FileSize -= m_BufSize;
			}
			//	バッファサイズ以下の残データ有りならば、ファイル末尾データ送信
			else if (m_FileSize != 0) {
				byte[] buf = new byte[m_FileSize];
				m_InpFs.Read(buf, 0, (int)m_FileSize);
				m_Bytes += scp.SendPacket(buf);
				m_FileSize = 0;
			}
			//	残データ無しならば、ファイル終端を示す空パケットを送信
			else {
				//	空パケット送信
				m_Bytes += scp.SendPacket(null);
				//	入力ファイルクローズ
				if (m_InpFs != null) {m_InpFs.Dispose(); m_InpFs = null;}
			}
			//	送信バイトカウント表示
			lblBytes.Text = SAjrGsr.SepDecimal(m_Bytes.ToString());
		}
		//	ボタン群許可
		private void EnableButtons(bool fSetServ, bool fConnect, bool fStart, bool fStop)
		{
			btnParam.Enabled = fSetServ;
			btnOpen.Enabled  = fConnect;
			btnStart.Enabled = fStart;
			btnStop.Enabled  = fStop;
		}
	}
}
