﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;
using CAjrCustCtrl;

namespace Sil_SerialComPort5B
{
	public partial class Form1 : Form
	{
		//	通信パケットコマンド
		byte CMD_REQ_START = 0x01;	//	グラフデータ送信開始要求
		byte CMD_RSP_START = 0x11;	//			〃			応答
		byte CMD_REQ_STOP  = 0x02;	//	グラフデータ送信停止要求
		byte CMD_RSP_STOP  = 0x12;	//			〃			応答
		byte CMD_DATA 	   = 0x40;	//	グラフデータ
		//	グラフデータ形式
		[StructLayout(LayoutKind.Sequential, Pack=1)]
		struct CMDDATA {
			public byte		cmd;			//	コマンドコード
			public byte		f1, f2, f3;		//	－
			public AJC3DVEC	vec;			//	グラフデータ
		}

        System.Threading.Mutex m_Mut5A;
		System.Threading.Mutex m_Mut5B = new System.Threading.Mutex(true, "Sil_SerialComPort5B");

		public Form1()
		{
			InitializeComponent();
		}
		//----- 起動時初期設定 ----------------------------------------------------------------------------------//
		private void Form1_Load(object sender, EventArgs e)
		{
			this.Text = this.Text + (IntPtr.Size == 4 ? " (WIN32)" : " (WIN64)");
			//	サイズ変更禁止
			this.FormBorderStyle = FormBorderStyle.FixedSingle;
			//	ＳＣＰ初期化
			scp.Init();
			//	相手プログラム起動
			bool fCreateNew;
			m_Mut5A = new System.Threading.Mutex(false, "Sil_SerialComPort5A", out fCreateNew);
			m_Mut5A.Close();
			if (fCreateNew) {
				System.Diagnostics.Process.Start("Sil_SerialComPort5A.exe");
			}

		}
		//----- ポート設定ボタン -------------------------------------------------------------------------------//
        private void btnSetPort_Click(object sender, EventArgs e)
        {
			scp.SetParamByDialog(this.Handle);
        }
		//----- ＯＰＥＮ／ＣＬＯＳＥボタン ---------------------------------------------------------------------//
        private void btnOpenClose_Click(object sender, EventArgs e)
        {
			if (scp.IsOpened) scp.Close();
			else              scp.Open();
        }
		//----- SCP : シリアルポート状態通知 -------------------------------------------------------------------//
        private void scp_OnPortState(object sender, CAjrCustCtrl.ScpArgPortState e)
        {
			if		(e.state == EScpPortState.Opened	 ) btnOpenClose.Text = "CLOSE";
			else if (e.state == EScpPortState.Closed	 ) btnOpenClose.Text = "OPEN";
			else if (e.state == EScpPortState.OpenFailure) {
				SAjrTip.ShowCenter(this, "\x1B[31m'" + scp.GetPortPathName() + "' Open failure.");
			}
			else if (e.state == EScpPortState.MySlotFail) {
				SAjrTip.ShowCenter(this, "\x1B[31m'" + scp.GetMySlotPathName() + "' Creation failure.");
			}
        }
        //----- SCP : パケットデータ受信通知 -------------------------------------------------------------------//
        private unsafe void scp_OnRxPacket(object sender, ScpArgRxPacket e)
        {
            if      (e.bin[0] == CMD_REQ_START) {
		    	fixed (byte* p = &CMD_RSP_START) {
		    		scp.SendPacket(p, 1);
                    tim.Enabled = true;
		    	}
            }
            else if (e.bin[0] == CMD_REQ_STOP) {
		    	fixed (byte* p = &CMD_RSP_STOP) {
		    		scp.SendPacket(p, 1);
                    tim.Enabled = false;
		    	}
            }
        }
        //----- SCP : パケット外データ受信通知 -----------------------------------------------------------------//
        private void scp_OnRxNoPkt(object sender, CAjrCustCtrl.ScpArgRxNoPkt e)
        {
            scp.SendText(e.text);
        }
        //----- テキスト受信通知 -------------------------------------------------------------------------------//
        private void scp_OnRxText(object sender, CAjrCustCtrl.ScpArgRxText e)
        {
			DateTime dtNow = DateTime.Now;
			string strDate = dtNow.ToString("yyyy/MM/dd") + "\n";
			string strTime = dtNow.ToString("hh:mm:ss") + "\n";
    		scp.SendText("\n\x1B[35m");
    		if		(e.text.Equals("DATE", StringComparison.OrdinalIgnoreCase)) {
    			scp.SendText(strDate);
    		}
    		else if (e.text.Equals("TIME", StringComparison.OrdinalIgnoreCase)) {
    			scp.SendText(strTime);
    		}
    		else {
    			scp.SendText("*** \"" + e.text + "\" は、不正なコマンドです ***\n");
    		}
    		scp.SendText("\x1B[0m");
        }
        //----- タイマ -----------------------------------------------------------------------------------------//
        private unsafe void tim_Tick(object sender, EventArgs e)
        {
            CMDDATA dat = new CMDDATA();
            dat.cmd = CMD_DATA;
            dat.vec = spd.Calc();
            scp.SendPacket(&dat, sizeof(CMDDATA));
        }

	}
}
