﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using CAjrCustCtrl;

namespace Sil_SockClient2
{
	public partial class Form1 : Form
	{
		bool	m_fConnect = false;
		uint	m_bytes    = 0;
		string[] LoadExc = {"txtMsg"};

		public Form1()
		{
			InitializeComponent();
		}
		//	起動時初期設定
		private void Form1_Load(object sender, EventArgs e)
		{
			this.Text = this.Text + (IntPtr.Size == 4 ? " (WIN32)" : " (WIN64)");
			//	サイズ変更禁止
			this.FormBorderStyle = FormBorderStyle.FixedSingle;
			//	ウインド位置ロード
			SAjrReg.LoadWndPos(this);
			//	設定値ロード
			SAjrReg.LoadAllCtrlsExc(this, LoadExc);
			//	ＳＣＴ初期化
			sct.Init();
		}
		//	フォーム終了
		private void Form1_FormClosed(object sender, FormClosedEventArgs e)
		{
			//	ウインド位置セーブ
			SAjrReg.SaveWndPos(this);
			//	設定値セーブ
			SAjrReg.SaveAllCtrlsExc(this, LoadExc);
		}
		//	接続／切断ボタン
		private void btnConnect_Click(object sender, EventArgs e)
		{
			if (m_fConnect) {
				sct.Disconnect();
			}
			else {
				m_bytes = 0;
				sct.Connect(txtServ.Text, uint.Parse(txtPort.Text));
			}
		}

		//----------------------------------------------------------------------//
		//	ＳＣＴイベント通知													//
		//----------------------------------------------------------------------//
		//	接続通知
		private void sct_OnConnect(object sender, EventArgs e)
		{
			m_fConnect = true;
			btnConnect.Text = "切 断";
			txtMsg.Text = "\nサーバと接続状態です。";
		}
		//	切断通知
		private void sct_OnDisconnect(object sender, EventArgs e)
		{
			m_fConnect = false;
			btnConnect.Text = "接 続";
			txtMsg.Text = "\n接続ボタンを押して、サーバと接続してください。";
		}
		//	接続失敗通知
		private void sct_OnCnFail(object sender, SctArgCnFail e)
		{
			txtMsg.Text = "接続を失敗しました。\r\n" +
						  "接続ボタンを押して、サーバと接続してください。";
		}
		//	バイナリチャンク受信通知
		private void sct_OnRxChunkBin(object sender, SctArgRxChunkBin e)
		{
			m_bytes += (uint)e.bin.Length;
			txtBytes.Text = m_bytes.ToString();
			sct.SendBinary(e.bin);
		}
	}
}
