﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using CAjrCustCtrl;

namespace Sil_SockServer2
{
	public partial class Form1 : Form
	{
		uint	MaxCli = 10;			//	最大クライアント数
		long[]	total = new long[10];	//	受信バイト数
		Label[] ipa;					//	ＩＰアドレス・コントロール
		Label[] cnt;					//	受信バイト数・コントロール

		public Form1()
		{
			InitializeComponent();
		}
		//	フォーム開始
		private void Form1_Load(object sender, EventArgs e)
		{
			//	ホスト名表示
			lblMyName.Text = Environment.MachineName;
			//	ウインド位置ロード
			SAjrReg.LoadWndPos(this);
			//	テーブル初期化
			ipa = new Label[]{lblIpA0, lblIpA1, lblIpA2, lblIpA3, lblIpA4, lblIpA5, lblIpA6, lblIpA7, lblIpA8, lblIpA9};
			cnt = new Label[]{lblCnt0, lblCnt1, lblCnt2, lblCnt3, lblCnt4, lblCnt5, lblCnt6, lblCnt7, lblCnt8, lblCnt9};
			//	テーブルクリアー
			for (int i = 0; i < MaxCli; i++) {
				ipa[i].Text = "-";
				cnt[i].Text = "-";
			}
			//	サーバ開始
			ssv.Start(14238, 10);
		}

		//	フォーム終了
		private void Form1_FormClosed(object sender, FormClosedEventArgs e)
		{
			//	ウインド位置セーブ
			SAjrReg.SaveWndPos(this);
			//	サーバ停止
			ssv.Stop();
		}
		//	クライアント接続
		private void cAjrSockServer1_OnConnect(object sender, CAjrCustCtrl.SsvArgConnect e)
		{
			int	i = ssv.GetIndex(e.hClient);
			//	バイト数カウンタクリアー
			total[i] = 0;
			//	クライアントIPアドレス表示
			ipa[i].Text = ssv.GetIpAddrStr(e.hClient);
			cnt[i].Text = "0";
		}
		//	クライアント切断
		private void cAjrSockServer1_OnDisconnect(object sender, CAjrCustCtrl.SsvArgDisconnect e)
		{
			//	クライアント表示クリアー
			int	i = ssv.GetIndex(e.hClient);
			ipa[i].Text = "-";
			cnt[i].Text = "-";
		}
		//	バイナリチャンク受信
		private void cAjrSockServer1_OnRxChunkBin(object sender, CAjrCustCtrl.SsvArgRxChunkBin e)
		{
			int	i = ssv.GetIndex(e.hClient);
			//	受信データを返送
			ssv.SendBinary(e.hClient, e.bin);
			//	バイトカウンタ更新
			total[i] += e.bin.Length;
			cnt[i].Text = total[i].ToString("N0");
		}
	}
}
