﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.InteropServices;
using CAjrCustCtrl;

namespace Sil_SockServer2C
{
	//	クライアント情報
	public struct ClientsInfo
	{
		public	string	ipaddr;
		public	bool	busy;
		public	int		bytes;
	}

	class Program
	{
		//	ソケットサーバ インスタンス
		static CAjrSockServer ssv = new CAjrSockServer();

		static void Main(string[] args)
		{
			IntPtr	hClient;		//	クライアントハンドル
			ESsvEvt evt;			//	イベントマスク
			object	obj;			//	イベントデータ
			string	IpAddr = "";	//	クライアントのＩＰアドレス

			//	コンソールキーオブジェクト生成
			ConsoleKeyInfo c   = new ConsoleKeyInfo();

			//	クライアント情報テーブル生成
			ClientsInfo[] CliTbl = new ClientsInfo[10];

			//	コンソールアプリ終了ハンドラ登録
			m_CbkConApExit = new CbkConApExit(SsvConApExit);
			SetConsoleCtrlHandler(m_CbkConApExit, true);

			//	初期表示
			Console.Clear();
			Console.WriteLine("");
			Console.WriteLine(" エコーサーバ (" + (IntPtr.Size == 4 ? "WIN32" : "WIN64") + ")");
			Console.WriteLine("");
			Console.WriteLine("   ホスト名　：" + Environment.MachineName);
			Console.WriteLine("   ポート番号：14238");
			Console.WriteLine("");
			Console.WriteLine(" ＥＳＣキーを押すと、プログラムを終了します。");
			Console.WriteLine("");
			Console.WriteLine("      No. IP-Address      Bytes");
			Console.WriteLine("");
			Console.WriteLine("       1. -               -");
			Console.WriteLine("       2. -               -");
			Console.WriteLine("       3. -               -");
			Console.WriteLine("       4. -               -");
			Console.WriteLine("       5. -               -");
			Console.WriteLine("       6. -               -");
			Console.WriteLine("       7. -               -");
			Console.WriteLine("       8. -               -");
			Console.WriteLine("       9. -               -");
			Console.WriteLine("      10. -               -");

			//	実行モード設定（イベントを「WaitEvent」で待つ）
			ssv._SsvMode = ESsvMode.WaitingForEvent;
			//	対象とするイベントを設定
			ssv.SetEvtMask(ESsvEvt.EV_CONNECT | ESsvEvt.EV_DISCONNECT | ESsvEvt.EV_RXCHUNK | ESsvEvt.EV_STOP);
			//	サーバ開始（ポート番号：14238, 最大クライアント数：10）
			ssv.Start(14238, 10);
			//	ループ
			while (true) {
				//	ＥＳＣキー入力でサーバ終了
				if (c.Key == ConsoleKey.Escape) {
					ssv.Stop();
				}
				//	イベント待ち
				obj = null;
				if ((evt = ssv.WaitEvent(out obj, 1000, out hClient)) != ESsvEvt.EV_NOEVENT) {
					//	クライアントのIPアドレス取得
					if (hClient != (IntPtr)0) {
						IpAddr = ssv.GetIpAddrStr(hClient);
					}
					//	各イベント処理
					//	●接続通知
					if ((evt & ESsvEvt.EV_CONNECT) != 0) {
						//	クライアントテーブルの空きエントリ検索
						int		ix;
						for (ix = 0; ix < 10 && CliTbl[ix].busy; ix++);
						if (ix < 10) {
							//	テーブルインデクスをクライアントに関連付け
							ssv.SetClientData(hClient, ix);
							//	テーブルエントリ設定
							CliTbl[ix].ipaddr = ssv.GetIpAddrStr(hClient);
							CliTbl[ix].busy   = true;
							CliTbl[ix].bytes   = 0;
							//	クライアント情報初期表示
							SAjrCon.SetCursorPos(10, 10 + ix);		Console.Write(CliTbl[ix].ipaddr);
							SAjrCon.SetCursorPos(26, 10 + ix);		Console.Write(CliTbl[ix].bytes.ToString());
						}
					}
					//	●切断通知
					if ((evt & ESsvEvt.EV_DISCONNECT) != 0) {
						//	クライアントインデクス取得
						int	ix = (int)obj;
						//	クライアントテーブルエントリに「空き」をマーク
						CliTbl[ix].busy = false;
						//	クライアント情報を消す
						SAjrCon.SetCursorPos(10, 10 + ix);		Console.Write("-               ");
						SAjrCon.SetCursorPos(26, 10 + ix);		Console.Write("-               ");
					}
					//	●バイナリチャンク受信通知
					if ((evt & ESsvEvt.EV_RXCHUNK) != 0) {
						Byte[] rxd = (Byte[])obj;
						//	クライアントインデクス取得
						object oix;
						ssv.GetClientData(hClient, out oix);
						int	ix = (int)oix;
						//	受信バイト数を表示
						CliTbl[ix].bytes += rxd.Length;
						SAjrCon.SetCursorPos(26, 10 + ix);		Console.Write(CliTbl[ix].bytes.ToString());
						//	受信データを返信
						ssv.SendBinary(hClient, (byte[])obj);
					}
					//	●サーバ終了通知
					if ((evt & ESsvEvt.EV_STOP) != 0) {
						break;
					}
					//	イベント処理終了
					ssv.EndEvent();
				}
				//	キー入力
				if (Console.KeyAvailable) c = Console.ReadKey(true);
			}
			//	ソケットサーバ消去
			ssv.Delete();

			SAjrCon.SetCursorPos(0, 20);
		}

		//	コンソールアプリ終了ハンドラ用デリゲート
		[DllImport("Kernel32")]
		static extern bool SetConsoleCtrlHandler(CbkConApExit Handler, bool Add);
		delegate bool	CbkConApExit(EAJCEXITTYPE ExitType);
		static CbkConApExit  m_CbkConApExit;
		//	コンソールアプリ終了ハンドラ
		static bool SsvConApExit(EAJCEXITTYPE ExitType)
		{
			//	ソケットサーバ消去
			ssv.Delete();
			//	false : 次のイベントハンドラへリンクする
			return false;
		}
	}
}
