﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;
using CAjrCustCtrl;

namespace Sil_TipText1
{
	public partial class Form1 : Form
	{
		private TipCbkNeedText m_cbNeedText;
		private Font		   m_SFont = new Font("MS UI Gothic",  9);
		private Font		   m_LFont = new Font("MS UI Gothic", 12);
        private Bitmap         m_skr   = Properties.Resources.sakura;
        private Bitmap         m_bmp   = Properties.Resources.cat;
        private Icon           m_ico   = Properties.Resources.logo;

		public Form1()
		{
			InitializeComponent();
		}
		//----- 閉じるボタン押下 -------------------------------------------------------------------------------//
		private void btnClose_Click(object sender, EventArgs e)
		{
			Close();
		}
		//----- 起動時初期設定 ---------------------------------------------------------------------------------//
		private void Form1_Load(object sender, EventArgs e)
		{
            //----- チップテキスト用イメージ登録 -------------------------------------------------------------------//
            SAjrTip.RegistBitmap(m_skr, 0, 0, 0, 0, 0);
            SAjrTip.RegistBitmap(m_bmp, 1, 0, 0, 0, 0);
            SAjrTip.RegistIcon  (m_ico, 2, 0, 0, 0, 0);

            //--- 常時／アクティブ時選択ラジオボタンのツールチップ -------------//
			SAjrTip.Add(rbtShowAlways , "常時ツールチップ表示します。\n" +
										"但し、以下のコントロールは、アクティブ時のみツールチップを表示します。\n" +
										"　・「２．フォントや文字色背景色を指定したツールチップ」\n" +
										"　・「３Ｄグラフィック」");
			SAjrTip.Add(rbtShowOnActive,"全てのコントロールで、アクティブ状態時のみツールチップを表示します。\n" +
										"非アクティブ時はツールチップを表示しません。");
			//--- 小さいフォント ラジオボタンのツールチップ --------------------//
			SAjrTip.Add(rbtSFont , "小さい文字でツールチップを表示します。\n" +
								   "但し、「２．フォントや文字色・・」 は独自のフォントで表示します。");
			//--- 大きいフォント ラジオボタンのツールチップ --------------------//
			SAjrTip.Add(rbtLFont , "大きい文字でツールチップを表示します。\n" +
								   "但し、「２．フォントや文字色・・」 は独自のフォントで表示します。");
			//--- テキストボックス１のツールチップ(ボールド，イタリックの例) ---//
			SAjrTip.Add(textBox1, "これはデフォルトのツールチップです。\n"						 +
								  "  \x1B[Tボールドフォントのサンプル\x1B[t\n"					 +
								  "  \x1B[Iイタリックフォントのサンプル\x1B[i\n"				 +
								  "  \x1B[T\x1B[Iボールド＋イタリックフォントのサンプル\x1B[N\n" +
								  "  ノーマルフォントのサンプル" +
                                  "\x1B[1;-26;2;24;24z" +     // （右端-26, 2)）の位置に 24×24サイズでビットマップ表示
                                  "\x1B[2;-18;-18z");         //  (右端-18, 下端-18)の位置に原画サイズでアイコン表示
			//--- テキストボックス２のツールチップ -----------------------------//
			SAjrTip.Add(textBox2, 
				"フォント，ウインド背景色，\x1B[34m文字色，\x1B[43m文字背景色\x1B[0mや外枠色を\n指定したツールチップを表示できます。\n" +
				"\x1B[31mこのツールチップは、ウインドがアクティブな場合のみ表示します。",
				3000, 10000, new Font("HGP楷書体", 18, FontStyle.Bold | FontStyle.Italic), Color.Chocolate, Color.AliceBlue, Color.Fuchsia);
			SAjrTip.SetShowAlways(textBox2, false);	// アクティブ時のみ表示
			//--- テキストボックス３のツールチップ（コールバック設定）----------//
			m_cbNeedText = new TipCbkNeedText(cbNeedText);
			SAjrTip.Add		   (textBox3, "Dummy", 0, 3000);
			SAjrTip.SetCallBack(textBox3, (IntPtr)0, m_cbNeedText);
			//--- 閉じるボタンのツールチップ設定 -------------------------------//
			SAjrTip.Add(btnClose, "ウインドを閉じてプログラムを終了します。");
			//--- 静的／動的選択ラジオボタンのツールチップ ---------------------//
			SAjrTip.Add(rbtStatic	, "あらかじめ設定されているツールチップを表示します。");
			SAjrTip.Add(rbtDynamic	, "コールバックにより現在時刻をツールチップ表示します。");
			//----- 全ての設定値ロード（ラジオボタンはChecked()イベントを発生する）
            SAjrReg.LoadAllCtrls(this, ELoadAllOpt.RbtClickEvent);
		}
        //----- フォームクローズ -------------------------------------------------------------------------------//
        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            //----- 全ての設定値セーブ -----------------------------------------//
            SAjrReg.SaveAllCtrls(this, ESaveAllOpt.ExcReadOnlyText);
        }
        //----- 常時ツールチップ表示・ラジオボタン -------------------------------------------------------------//
		private void rbtShowAlways_Click(object sender, EventArgs e)
		{
			sta.ShowForOnlyActive = false;
		}
		//----- 全て、アクティブ状態時のみツールチップを表示・ラジオボタン -------------------------------------//
		private void rbtShowOnActive_Click(object sender, EventArgs e)
		{
			sta.ShowForOnlyActive = true;
		}
		//	コールバック（ツールチップテキスト要求）
		private string cbNeedText(IntPtr Handle, IntPtr cbp)
		{
			DateTime	dt = DateTime.Now;
			string text = "現在時刻　= " + dt.ToString("HH:mm:ss");
			return text;
		}
		//----- 静的ツールチップ・ラジオボタン -----------------------------------------------------------------//
		private void rbtStatic_Click(object sender, EventArgs e)
		{
			//--- ３Ｄグラフィックのツールチップ -------------------------------//
			SAjrTip.Add(g3d, "\x1B[64;64;255F" + "\x1B[255;200;255B" +
							 "\x1B[37;45m ３Ｄ／２Ｄグラフィックコントロール \n\x1B[0m" +
							 "　・データを投与すると当該座表にプロット表示します。\n" +
							 "　・３Ｄ空間上に図形を描画できます。\n" +
							 "　・ウインドをドラッグで視点を変更できます。\n" +
							 "\x1B[31m このツールチップは、ウインドがアクティブな場合のみ表示します。");
			SAjrTip.SetShowAlways(g3d, false);	// アクティブ時のみ表示
			//--- 棒グラフのツールチップ ---------------------------------------//
			SAjrTip.Add(bar, "\x1B[0;0;255F" + "\x1B[200;200;255B" +
							 "\x1B[34;46m 棒グラフ／折れ線グラフコントロール \n\x1B[0m" +
							 "\x1B[31m" +
							 "　・データを投与するとグラフを更新します。\n" +
							 "　・棒グラフと折れ線グラフを切り替えて表示できます。");
			//--- タイムチャートのツールチップ ---------------------------------//
			SAjrTip.Add(tch, "\x1B[0;0;255F" + "\x1B[64;128;255B" +
							 "\x1B[34;46m タイムチャート（波形表示）コントロール \n\x1B[0m" +
							 "\x1B[33m" +
							 "　・データを投与するとチャートを更新します。\n" +
							 "　・最大８つの波形を同時に表示できます。");
			//--- ＶＴ１００ウインドのツールチップ -----------------------------//
			SAjrTip.Add(vth, "\x1B[255;0;0F" + "\x1B[220;220;220B" +
							 "\x1B[34;47m ＶＴ１００エミュレーションコントロール \n\x1B[0m" +
							 "\x1B[35m" +
							 "　・ログ表示等のテキスト表示に最適です。\n" +
							 "　・文字列の選択／コピーができます。");
			//--- 数値入力コントロールのツールチップ ---------------------------//
			SAjrTip.Add(inp, " 数値入力コントロール \n" +
							 "　・整数モードと実数モードがあります。\n" +
							 "　・直接入力／スライダ／スピンボタン操作ができます。");
			//	コールバック解除
			SAjrTip.SetCallBack(g3d, (IntPtr)0, null, null);
			SAjrTip.SetCallBack(bar, (IntPtr)0, null, null);
			SAjrTip.SetCallBack(tch, (IntPtr)0, null, null);
			SAjrTip.SetCallBack(vth, (IntPtr)0, null, null);
			SAjrTip.SetCallBack(inp, (IntPtr)0, null, null);
		}
		//----- 動的ツールチップ・ラジオボタン -----------------------------------------------------------------//
		private void rbtDynamic_Click(object sender, EventArgs e)
		{
			//	コールバック設定
			SAjrTip.Add(g3d, null);  SAjrTip.SetCallBack(g3d, (IntPtr)0, m_cbNeedText);
			SAjrTip.Add(bar, null);  SAjrTip.SetCallBack(bar, (IntPtr)0, m_cbNeedText);
			SAjrTip.Add(tch, null);  SAjrTip.SetCallBack(tch, (IntPtr)0, m_cbNeedText);
			SAjrTip.Add(vth, null);  SAjrTip.SetCallBack(vth, (IntPtr)0, m_cbNeedText);
			SAjrTip.Add(inp, null);  SAjrTip.SetCallBack(inp, (IntPtr)0, m_cbNeedText);
		}
		//----- 動的ツールチップ取得用コールバック -------------------------------------------------------------//
		private string cbGetText(IntPtr Handle, IntPtr cbp)
		{
			return "\x1B[46m現在時刻：\x1B[0m " + DateTime.Now;
		}
		//----- 小さいフォントラジオボタン ---------------------------------------------------------------------//
		private void rbtSFont_Click(object sender, EventArgs e)
		{
			SAjrTip.SetDefFont(m_SFont);
		}
		//----- 大きいフォントラジオボタン ---------------------------------------------------------------------//
		private void rbtLFont_Click(object sender, EventArgs e)
		{
			SAjrTip.SetDefFont(m_LFont);
		}
        //----- 全てのツールチップの表示を禁止する　------------------------------------------------------------//
        private void chkEnableAll_Click(object sender, EventArgs e)
        {
            SAjrTip.SetEnableAll(!chkEnableAll.Checked);
        }
        //------ チップテキスト表示ボタン ----------------------------------------------------------------------//
        private void btnShowBmp_Click(object sender, EventArgs e)
        {
            string txt = "ビットマップ表示ツールチップのサンプル" +
                         "\x1B[0;7;20;0;0z";
            Point pt = btnShowBmp.PointToScreen(Point.Empty);
            Size  sz = btnShowBmp.Size;
            Size  ts = SAjrTip.GetSize(txt, null, true);

            SAjrTip.Show(pt.X + sz.Width - ts.Width, pt.Y + 35, 0, 0,
                         txt, 10000, null, Color.Empty, Color.Empty, true);
        }
	}
}
