﻿//
//	SP_BAR.cpp
//
#include	<AjxCpp.h>
#include	<tchar.h>
using namespace AjxControl;

#define IDC_BAR 	5001

static	HINSTANCE		hInst	 = NULL;
static	HWND			hWndMain = NULL;
static	HWND			hWndBar  = NULL;
static	BOOL			fTimer	 = FALSE;

AJC_WNDPROC_DEF(Main);

static const UT	TipMsg[] =	TEXT("２秒毎にランダムな値をグラフ表示します。\n")
							TEXT("ダブルクリックで、グラフ表示を開始／停止します。\n")
							TEXT("CTRL+右クリックで、棒グラフ／折れ線グラフを切り替えます。\n")
							TEXT("このツールチップ上にカーソルを置くと表示を継続します。\n")
							TEXT("このツールチップ上をクリックするとツールチップは消えます。");

//----- CAjxBarの派生クラス ------------------------------------------------------------------------------------//
class CAjxBarEx :
	public CAjxBar
{
public:
	VO		OnNtcDblClk() override	{						//	ダブルクリック通知
		if (fTimer) {SetTitleText(TEXT("STOP")); KillTimer(hWndMain, 1);}
		else		{SetTitleText(TEXT("RUN" )); SetTimer(hWndMain, 1, 2000, NULL);}
		fTimer = ~fTimer;
	}
	VO		OnNtcRClick(PCAJCBARRCLK pRClk) override	{	//	右クリック通知
		if (pRClk->fCtrl) {
			UI	sty = (UI)MAjcGetWindowLong(this->m_hCtrl, GWL_STYLE);
			MAjcSetWindowLong(this->m_hCtrl, GWL_STYLE, sty ^ AJCBARS_LINEGRAPH);
		}
	}
};
static	CAjxBarEx	bar;

//----- AjcWinMain ------------------------------------------------------------------------------------------------//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 		msg = {0};
	WNDCLASS	wc	= {0};
	ATOM		atm = 0;

	hInst = hInstance;
	//	ウインド生成
	wc.style		 = 0;							wc.hCursor		 = LoadCursor(NULL, IDC_ARROW); 
	wc.lpfnWndProc	 = AJC_WNDPROC_NAME(Main);		wc.hbrBackground = (HBRUSH)GetStockObject(LTGRAY_BRUSH);
	wc.hInstance	 = hInstance;					wc.lpszClassName = TEXT("SP_BAR");
	atm = RegisterClass(&wc);
	hWndMain = CreateWindow(	TEXT("SP_BAR"), TEXT("SP_BAR"), // window class name, caption
			   WS_OVERLAPPEDWINDOW, 							// window style
			   CW_USEDEFAULT, CW_USEDEFAULT, 500, 300,			// position, size
			   NULL, NULL, hInstance, NULL);					// parent, menu, instance, param
	ShowWindow(hWndMain, iCmdShow);
	//	メッセージループ
	while (GetMessage(&msg, NULL, 0, 0)) {
		TranslateMessage(&msg);
		DispatchMessage (&msg);
	}
	UnregisterClass((UTP)atm, hInstance);
	return (int)msg.wParam ;
}
//----- WM_CREATE ----------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_CREATE 	)
{
	RECT	r;
	srand(GetTickCount());
	//	棒グラウインド生成
	GetClientRect(hwnd, &r);
	hWndBar = CreateWindow(TEXT("AjcCtrlBarGraph"), 					// window class
						   TEXT("P: L=0, H=35000, I=2, MW=60, TL=1"),	// window caption
						   WS_CHILD,									// window style
						   0, 0, r.right, r.bottom, 					// position, size
						   hwnd, (HMENU)IDC_BAR, hInst, NULL);			// parent, menu, instance, param

	SAjxTip::Add	   (hWndBar, TipMsg);	//	ツールチップ設定
	SAjxTip::ShowCenter(hWndBar, TipMsg);	//	・
	bar.Attach(hWndBar);					//	棒グラフウインドハンドル割り当て
	bar.SetTitleText(TEXT("STOP"));			//	棒グラフウインドタイトル設定
	ShowWindow(hWndBar, SW_SHOW);			//	棒グラフウインド表示
	return 0;
}
//----- WM_DESTROY ---------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_DESTROY	)
{
	DestroyWindow(hWndBar);
	PostQuitMessage(0);
	return 0;
}
//----- WM_SIZE ------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_SIZE		)
{
	MoveWindow(hWndBar, 0, 0, LOWORD(lParam), HIWORD(lParam), FALSE);
	return 0;
}
//----- WM_TIMER -----------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_TIMER		)
{
	SYSTEMTIME	st;
	UT			szTime[32];
	GetLocalTime(&st);
	AjcSnPrintF(szTime, AJCTSIZE(szTime), TEXT("%02d:%02d:%02d"), st.wHour, st.wMinute, st.wSecond);
	int x = rand();
	int y = rand();
	bar.PutData(x, y, szTime);
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(Main)
	AJC_WNDMAP_MSG(Main, WM_CREATE	)
	AJC_WNDMAP_MSG(Main, WM_DESTROY )
	AJC_WNDMAP_MSG(Main, WM_SIZE	)
	AJC_WNDMAP_MSG(Main, WM_TIMER	)
AJC_WNDMAP_END
