﻿//
//	SP_BMP.cpp
//
#include	<AjxCpp.h>
#include	<tchar.h>
using namespace AjxControl;

static	HWND			hWndMain = NULL;
static	HBITMAP			hBmp	 = NULL;
static	UI				width, height;
AJC_WNDPROC_DEF(Main);

//----- AjcWinMain ------------------------------------------------------------------------------------------------//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 		msg = {0};
	WNDCLASS	wc	= {0};

	//	ウインド生成
	wc.style		 = 0;							wc.hCursor		 = LoadCursor(NULL, IDC_ARROW);	
	wc.lpfnWndProc	 = AJC_WNDPROC_NAME(Main);		wc.hbrBackground = (HBRUSH)GetStockObject(LTGRAY_BRUSH);
	wc.hInstance	 = hInstance;					wc.lpszClassName = TEXT("SP_BMP");
	RegisterClass(&wc);
	hWndMain = CreateWindow(TEXT("SP_BMP"),	TEXT("SP_BMP"),	// window class name, caption
				WS_OVERLAPPEDWINDOW & ~WS_THICKFRAME,		// window style
				CW_USEDEFAULT, CW_USEDEFAULT, 500, 300,		// position, size
				NULL, NULL, hInstance, NULL);				// parent, menu, instance, param
	ShowWindow(hWndMain, iCmdShow);
	//	メッセージループ
	while (GetMessage(&msg, NULL, 0, 0)) {
		TranslateMessage(&msg);
		DispatchMessage (&msg);
	}
	return (int)msg.wParam ;
}
//----- WM_CREATE ----------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_CREATE 	)
{
	UT		drv[_MAX_DRIVE], dir[_MAX_DIR];
	UT		path[MAX_PATH];

	AjcGetAppPath(path, MAX_PATH);
	MAjcSplitPath(path, drv, dir, NULL, NULL);
	MAjcMakePath (path, drv, dir, TEXT("SW_DIBSect"), TEXT(".bmp"));
	//	ビットマップファイル読み出し
	hBmp = SAjxBmp::CreateDibFromFile(path, &width, &height);
	return 0;
}
//----- WM_DESTROY ---------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_DESTROY	)
{
	if (hBmp != NULL) DeleteObject(hBmp);	//	ビットマップ破棄
	PostQuitMessage(0);						//	プログラム終了
	return 0;
}
//----- WM_PAINT -----------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_PAINT		)
{
	PAINTSTRUCT ps;
	HDC 		hdc, hmd;
	RECT		r;

	hdc   = BeginPaint(hwnd, &ps);
	if (hBmp != NULL) {
		GetClientRect(hwnd, &r);
		hmd = CreateCompatibleDC(hdc);
		SelectObject(hmd, hBmp);
		BitBlt(hdc, (r.right - width) / 2, (r.bottom - height) / 2, width, height, hmd, 0, 0, SRCCOPY);
		DeleteDC(hmd);
	}
	EndPaint(hwnd, &ps);
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(Main)
	AJC_WNDMAP_MSG(Main, WM_CREATE	)
	AJC_WNDMAP_MSG(Main, WM_DESTROY )
	AJC_WNDMAP_MSG(Main, WM_PAINT	)
AJC_WNDMAP_END
