﻿//
//	SP_CTK.cpp
//
#include	<AjxCpp.h>
#include	<tchar.h>
using namespace AjxControl;
#define	RED		RGB(255, 0, 0)
#define	WHITE	RGB(255, 255, 255)

class CAjxCtkEx : public CAjxCtk, public CAjxFile
{
	UT			m_Path[MAX_PATH];
public:
	CAjxCtkEx(UTP pPath) {		//	コンストラクタ
		_tcscpy_s(m_Path, MAX_PATH, pPath);
		if (!AjcPathIsFile(pPath)) throw std::runtime_error("File not found.");
	}
	~CAjxCtkEx()	{			//	デストラクタ
		if (FIsActive()) {
			FClose();
		}
	}
private:
	//	１行読み出し要求
	BOOL  OnGetLine	(UTP pBuf, UI lBuf) override
	{
		BOOL	rc = FALSE;
		//	初回ならばファイルオープン
		if (!FIsActive()) {
			FOpen(m_Path);
		}
		//	1行読み出し，EOFならばファイルクローズ
		if (FIsActive()) {
			if (FGetS(pBuf, lBuf) != NULL) rc = TRUE;
			else						   FClose();
		}
		else throw std::runtime_error("File Open failure.");
		return rc;
	}
};
int AjcMain(int argc, UTP argv[])
{
	SAjxCon::SetStdMode();
	try {
		UI			cnt = 0;
		UT			syl[256];
		CAjxCtkEx	ctk(argv[1]);
		while (ctk.GetToken(syl, AJCTSIZE(syl))) {
			_tprintf(TEXT("%c%4d : Line %3d, Pos %3d, '%s'\n"), (ctk.Flag() & AJCTKF_PREPRO) ? '#' : ' ',
																++cnt, ctk.Line(), ctk.Pos(4), syl);
		}
	}
	catch (std::exception e) {
		printf("Exception: %s\n", e.what());
	}

	_tprintf(TEXT("- Hit Enter key!!"));
	getchar();
	return 0;
}
