﻿//
//	SP_DLG.cpp
//
#include	<AjxCpp.h>
#include	<tchar.h>
#include	"resource.h"
using namespace AjxControl;

static	HINSTANCE	hInst = NULL;
static	HWND		hDlgMain = NULL;
static	CAjxDlg		dlg;
AJC_DLGPROC_DEF(Main);

//----- CAjxTipの派生クラス ------------------------------------------------------------------------------------//
class CAjxTipEx :
	public CAjxTip
{
public:
	VO	OnNeedText(HWND hCtrl, UTP pBuf, UI lBuf) override	{		//	チップテキスト取得通知
		AjcSnPrintF(pBuf, lBuf, TEXT("設定値 = %u"), dlg.GetDlgItemUInt(IDC_INP));
	}
};
static	CAjxTipEx	tip;

//----- AjcWinMain ------------------------------------------------------------------------------------------------//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 		msg = {0};

	hInst = hInstance;

	//	ダイアログ生成
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_MAIN), NULL, AJC_DLGPROC_NAME(Main));
	ShowWindow(hDlgMain, iCmdShow);
	//	メッセージループ
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while(0);
	}
	return (int)msg.wParam ;
}
//----- WM_CREATE ----------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG 	)
{
	//	ダイアログハンドル設定
	dlg.Attach(hDlg);
	//	数値入力のハンドル設定
	tip.Attach(GetDlgItem(hDlg, IDC_INP));
	//	ツールチップ設定
	SAjxTip::Add(GetDlgItem(hDlg, IDC_CHK  ), TEXT("全てのチップテキストを表示しないようにします。"));
	SAjxTip::Add(GetDlgItem(hDlg, IDC_RBT_A), TEXT("ラジオボタンＡ"));
	SAjxTip::Add(GetDlgItem(hDlg, IDC_RBT_B), TEXT("ラジオボタンＢ"));
	SAjxTip::Add(GetDlgItem(hDlg, IDC_TXT  ), TEXT("ここにテキストを入力してください"));
	//	デフォルト値設定
	dlg.SetDlgItemChk (IDC_RBT_A, TRUE);
	dlg.SetDlgItemStr (IDC_TXT	, TEXT("ここにテキストを入力"));
	dlg.SetDlgItemUInt(IDC_INP	, 12);
	//	プロファイルから設定値読み出し
	dlg.LoadAllControlSettings(TEXT("Settings"));

	return TRUE;
}
//----- WM_DESTROY ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY	)
{
	//	プロファイルへ設定値書き込み
	dlg.SaveAllControlSettings();

	PostQuitMessage(0);
	return TRUE;
}
//----- RBT_A --------------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_RBT_A		)
{
	SAjxTip::ShowCenter(hDlg, TEXT("ラジオボタン(RBT_A)が選択されました。"));
	return TRUE;
}
//----- RBT_B --------------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_RBT_B		)
{
	SAjxTip::ShowCenter(hDlg, TEXT("ラジオボタン(RBT_B)が選択されました。"));
	return TRUE;
}
//----- CHK ----------------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CHK		)
{
	SAjxTip::EnableAll(!dlg.GetDlgItemChk(IDC_CHK));
	return TRUE;
}
//----- CANCEL -------------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL		)
{
	DestroyWindow(hDlg);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG	)
	AJC_DLGMAP_MSG(Main, WM_DESTROY		)
	AJC_DLGMAP_CMD(Main, IDC_RBT_A		)
	AJC_DLGMAP_CMD(Main, IDC_RBT_B		)
	AJC_DLGMAP_CMD(Main, IDC_CHK		)
	AJC_DLGMAP_CMD(Main, IDCANCEL		)
AJC_DLGMAP_END
