﻿//
//	SP_G3D.cpp
//
#include	<AjxCpp.h>
#include	<tchar.h>
using namespace AjxControl;

#define	IDC_G3D		5001

static	HINSTANCE		hInst	 = NULL;
static	HWND			hWndMain = NULL;
static	HWND			hWndG3d  = NULL;
static	BOOL			fTimer	 = FALSE;

AJC_WNDPROC_DEF(Main);

static const UT TipMsg[] =	TEXT("ダブルクリックで、球面上に点を描画します。\n")
							TEXT("ウインドをドラッグすることにより視点を変更できます。\n")
							TEXT("右クリックでポップアップメニューを表示します\n")
							TEXT("このツールチップ上にカーソルを置くと表示を継続します。\n")
							TEXT("このツールチップ上をクリックするとツールチップは消えます。");

//----- CAjxG3dの派生クラス ------------------------------------------------------------------------------------//
class CAjxG3dEx :
	public CAjxG3d
{
public:
	VO		OnNtcDblClk() override	{	//	ダブルクリック通知
		if (fTimer) {SetTitleText(TEXT("STOP")); KillTimer(hWndMain, 1);}
		else		{SetTitleText(TEXT("RUN" )); SetTimer(hWndMain, 1, 100, NULL);}
		fTimer = ~fTimer;
	}
};
static	CAjxG3dEx	g3d;

//----- AjcWinMain ------------------------------------------------------------------------------------------------//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 		msg = {0};
	WNDCLASS	wc	= {0};
	ATOM		atm = 0;

	hInst = hInstance;
	//	ウインド生成
	wc.style		 = 0;							wc.hCursor		 = LoadCursor(NULL, IDC_ARROW);	
	wc.lpfnWndProc	 = AJC_WNDPROC_NAME(Main);		wc.hbrBackground = (HBRUSH)GetStockObject(LTGRAY_BRUSH);
	wc.hInstance	 = hInstance;					wc.lpszClassName = TEXT("SP_BMP");
	atm = RegisterClass(&wc);

	hWndMain = CreateWindow(TEXT("SP_BMP"),	TEXT("SP_BMP"),	// window class name, caption
			   WS_OVERLAPPEDWINDOW,							// window style
			   CW_USEDEFAULT, CW_USEDEFAULT, 500, 523,		// position, size
			   NULL, NULL, hInstance, NULL);				// parent, menu, instance, param
	ShowWindow(hWndMain, iCmdShow);
	//	メッセージループ
	while (GetMessage(&msg, NULL, 0, 0)) {
		TranslateMessage(&msg);
		DispatchMessage (&msg);
	}
	UnregisterClass((UTP)atm, hInstance);
	return (int)msg.wParam ;
}
//----- WM_CREATE ----------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_CREATE 	)
{
	RECT	r;
	//	３Ｄグラフィックウインド生成
	GetClientRect(hwnd, &r);
	hWndG3d = CreateWindow(TEXT("AjcCtrl3dGraph"),
						   TEXT("P: XR=1, YR=1, ZR=1"),			// window class name, caption
						   WS_CHILD | AJC3DGS_3DMODE,			// window style
						   0, 0, r.right, r.bottom,				// position, size
						   hwnd, (HMENU)IDC_G3D, hInst, NULL);	// parent, menu, instance, param
	//	ツールチップ設定
	SAjxTip::ShowCenter(hWndG3d, TipMsg);	//	ツールチップ設定
	SAjxTip::Add	   (hWndG3d, TipMsg);	//	・
	g3d.Attach(hWndG3d);					//	棒グラウインドハンドル割り当て
	g3d.SetAngle3D();						//	棒グラウインド視点設定
	g3d.SetTitleText(TEXT("STOP"));			//	棒グラウインドタイトル設定
	ShowWindow(hWndG3d, SW_SHOW);			//	棒グラウインド表示
	return 0;
}
//----- WM_DESTROY ---------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_DESTROY	)
{
	DestroyWindow(hWndG3d);
	PostQuitMessage(0);						//	プログラム終了
	return 0;
}
//----- WM_SIZE ------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_SIZE		)
{
	MoveWindow(hWndG3d, 0, 0, LOWORD(lParam), HIWORD(lParam), FALSE);
	return 0;
}
//----- WM_TIMER -----------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_TIMER		)
{
	AJC3DVEC	v;
	v.x = rand() - (RAND_MAX / 2);
	v.y = rand() - (RAND_MAX / 2);
	v.z = rand() - (RAND_MAX / 2); 
	AjcV3dNormal(&v, &v);
	g3d.Pixel(rand() & 15, &v, 3);
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(Main)
	AJC_WNDMAP_MSG(Main, WM_CREATE	)
	AJC_WNDMAP_MSG(Main, WM_DESTROY )
	AJC_WNDMAP_MSG(Main, WM_SIZE	)
	AJC_WNDMAP_MSG(Main, WM_TIMER	)
AJC_WNDMAP_END
