﻿//
//	SP_HSO.c
//
#include	<AjxCpp.h>
#include	<tchar.h>
using namespace AjxControl;

//----- テーブル（配列） ---------------------------------------------------------------------------------------//
typedef struct {
	UTP		pName;		//	名前
	UI		birth;		//	誕生年
} TBL, *PTBL;
typedef const TBL *PCTBL;

static	TBL		tbl[] = {
	{TEXT("金太郎"	), 700},
	{TEXT("桃太郎"	), 600},
	{TEXT("浦島太郎"), 800},
	{TEXT("かぐや姫"), 500},
	{TEXT("卑弥呼"	), 150},
};

#define	MAX_TBL	((sizeof tbl) / (sizeof tbl[0]))

//----- CAjxHso の継承クラス -----------------------------------------------------------------------------------//
class CAjxHsoEx : public CAjxHso
{
public:
	int OnComp(C_VOP pElm1, C_VOP pElm2, BOOL *pStop) override {
		PCTBL	p1 = (PCTBL)pElm1;
		PCTBL	p2 = (PCTBL)pElm2;
		return (p1->birth - p2->birth);
	}
};

CAjxHsoEx	hso;

//==============================================================================================================//
int  AjcMain(int argc, UTP argv[])
{
	SAjxCon::SetStdMode();

	//	テーブルソート
	hso.Sort(tbl, MAX_TBL, sizeof tbl[0]);
	//	ソート済テーブル表示
	for (int i = 0; i < MAX_TBL; i++) {
		SAjxCon::PrintF(TEXT(" Birth = %4d, Name = %s\n"), tbl[i].birth, tbl[i].pName);
	}

	SAjxCon::PrintF(TEXT("\nHit Enter Key!!"));
	getchar();

	return 0;
}

