﻿//
//	SP_INP.cpp
//
#include	<AjxCpp.h>
#include	<tchar.h>
using namespace AjxControl;

#define	IDC_INP	5001

static	HINSTANCE	hInst = NULL;
static	HWND		hWndMain = NULL;
static	HWND		hWndInp  = NULL;
AJC_WNDPROC_DEF(Main);

//----- CAjxInpの派生クラス ------------------------------------------------------------------------------------//
class CAjxInpEx :
	public CAjxInp
{
public:
	VO	OnNtcIntValue (int val) override	{	//	数値入力通知
		SetLayeredWindowAttributes(hWndMain, 0, val, LWA_ALPHA);
	}
};
static	CAjxInpEx	inp;

//----- AjcWinMain ------------------------------------------------------------------------------------------------//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 		msg = {0};
	WNDCLASS	wc	= {0};
	ATOM		atm = 0;

	hInst = hInstance;

	//	ウインド生成
	wc.style		 = 0;							wc.hCursor		 = LoadCursor(NULL, IDC_ARROW);	
	wc.lpfnWndProc	 = AJC_WNDPROC_NAME(Main);		wc.hbrBackground = (HBRUSH)GetStockObject(LTGRAY_BRUSH);
	wc.hInstance	 = hInstance;					wc.lpszClassName = TEXT("SP_INP");
	atm = RegisterClass(&wc);
	hWndMain = CreateWindowEx(WS_EX_LAYERED,
				TEXT("SP_INP"),	TEXT("SP_INP"),	// window class name, caption
				WS_OVERLAPPEDWINDOW & ~WS_THICKFRAME,		// window style
				CW_USEDEFAULT, CW_USEDEFAULT, 300, 150,		// position, size
				NULL, NULL, hInstance, NULL);				// parent, menu, instance, param
	ShowWindow(hWndMain, iCmdShow);
	//	メッセージループ
	while (GetMessage(&msg, NULL, 0, 0)) {
		TranslateMessage(&msg);
		DispatchMessage (&msg);
	}
	UnregisterClass((UTP)atm, hInstance);
	return (int)msg.wParam ;
}
//----- WM_CREATE ----------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_CREATE 	)
{
	SetLayeredWindowAttributes(hwnd, 0, 255, LWA_ALPHA);

	//	数値入力ウインド生成
	RECT	r;
	GetClientRect(hwnd, &r);
	GetClientRect(hwnd, &r);
	hWndInp = CreateWindow(TEXT("AjcCtrlInpVal"), 					// window class
						   TEXT("I: L=255, R=128"),					// window caption
						   WS_CHILD,								// window style
						   5, 70, r.right - 10, 30, 				// position, size
						   hwnd, (HMENU)IDC_INP, hInst, NULL);		// parent, menu, instance, param

	SAjxTip::ShowCenter(hwnd, TEXT("自ウインドの透明度を設定します。\n")
							  TEXT("設定値は、255(不透明)～128(半透明)"));
	inp.Attach(hWndInp);			//	数値入力ウインドハンドル割り当て
	inp.SetValue(255);				//	数値初期化(255 : 不透明)
	ShowWindow(hWndInp, SW_SHOW);	//	数値入力ウインド表示
	return 0;
}
//----- WM_DESTROY ---------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_DESTROY	)
{
	DestroyWindow(hWndInp);
	PostQuitMessage(0);
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(Main)
	AJC_WNDMAP_MSG(Main, WM_CREATE	)
	AJC_WNDMAP_MSG(Main, WM_DESTROY )
AJC_WNDMAP_END
