﻿//
//	SP_LBX.cpp
#include	<AjxCpp.h>
#include	<tchar.h>
using namespace AjxControl;

#define IDC_LBX 	5001

static	HINSTANCE		hInst	 = NULL;
static	HWND			hWndMain = NULL;
static	HWND			hWndLbx  = NULL;

AJC_WNDPROC_DEF(Main);

static const UT	TipMsg[] =	TEXT("ドロップしたディレクトリをリストボックスに追加し、\n")
							TEXT("当該ディレクトリを選択状態にします。");

//----- CAjxLbxの派生クラス ------------------------------------------------------------------------------------//
class CAjxLbxEx :
	public CAjxLbx
{
public:
	VO		OnNtcDropDir (UI n) override	{				//	ディレクトリドロップ通知
		//	選択状態解除
		SetSel(-1, FALSE);
		//	ドロップしたディレクトリを選択状態にする
		UT	path[MAX_PATH];
		while (GetDroppedDir(path)) {
			SelectString(-1, path);
		}
	}
};
static	CAjxLbxEx	bar;

//----- AjcWinMain ------------------------------------------------------------------------------------------------//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 		msg = {0};
	WNDCLASS	wc	= {0};
	ATOM		atm = 0;

	hInst = hInstance;
	//	ウインド生成
	wc.style		 = 0;							wc.hCursor		 = LoadCursor(NULL, IDC_ARROW); 
	wc.lpfnWndProc	 = AJC_WNDPROC_NAME(Main);		wc.hbrBackground = (HBRUSH)GetStockObject(LTGRAY_BRUSH);
	wc.hInstance	 = hInstance;					wc.lpszClassName = TEXT("SP_LBX");
	atm = RegisterClass(&wc);
	hWndMain = CreateWindow(	TEXT("SP_LBX"), TEXT("SP_LBX"), // window class name, caption
			   WS_OVERLAPPEDWINDOW, 							// window style
			   CW_USEDEFAULT, CW_USEDEFAULT, 500, 293,			// position, size
			   NULL, NULL, hInstance, NULL);					// parent, menu, instance, param
	ShowWindow(hWndMain, iCmdShow);
	//	メッセージループ
	while (GetMessage(&msg, NULL, 0, 0)) {
		TranslateMessage(&msg);
		DispatchMessage (&msg);
	}
	UnregisterClass((UTP)atm, hInstance);
	return (int)msg.wParam ;
}
//----- WM_CREATE ----------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_CREATE 	)
{
	RECT	r;
	//	リストボックス生成
	GetClientRect(hwnd, &r);
	hWndLbx = CreateWindowEx(WS_EX_ACCEPTFILES,
							 TEXT("AjcCtrlListBox"), 					// window class
							 TEXT(""),									// window caption
							 WS_CHILD |									// window style
							 AJCLBXS_FILE			|					//	リスト項目としてファイル／フォルダのパス名を扱う
							 AJCLBXS_ADDITEMINDROP	|					//	ドロップ操作で、当該ディレクトリ／ファイルをリストボックス項目として追加する
							 AJCLBXS_DIRTAIL		|					//	ディレクトリ名の末尾に「\」を付加する
							 AJCLBXS_ACCEPTDIRS		|					//	ディレクトリのドラッグ＆ドロップを可能とする
							 AJCLBXS_SORT,								//	アイテム追加時にソートする
							 0, 0, r.right, r.bottom, 					// position, size
							 hwnd, (HMENU)IDC_LBX, hInst, NULL);		// parent, menu, instance, param

	SAjxTip::Add	   (hWndLbx, TipMsg);	//	ツールチップ設定
	SAjxTip::ShowCenter(hWndLbx, TipMsg);	//	・
	bar.Attach(hWndLbx);					//	リストボックスハンドル割り当て
	ShowWindow(hWndLbx, SW_SHOW);			//	リストボックス表示
	return 0;
}
//----- WM_DESTROY ---------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_DESTROY	)
{
	DestroyWindow(hWndLbx);
	PostQuitMessage(0);
	return 0;
}
//----- WM_SIZE ------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_SIZE		)
{
	MoveWindow(hWndLbx, 0, 0, LOWORD(lParam), HIWORD(lParam), FALSE);
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(Main)
	AJC_WNDMAP_MSG(Main, WM_CREATE	)
	AJC_WNDMAP_MSG(Main, WM_DESTROY )
	AJC_WNDMAP_MSG(Main, WM_SIZE	)
AJC_WNDMAP_END
