﻿//
//	SP_TCH.cpp
//
#include	<AjxCpp.h>
#include	<tchar.h>
using namespace AjxControl;

#define	IDC_TCH	5001
static	HINSTANCE	hInst	 = NULL;
static	HWND		hWndMain = NULL;
static	HWND		hWndTch  = NULL;
static	BOOL		fTimer	 = FALSE;

AJC_WNDPROC_DEF(Main);

static const UT	TipMsg[] =	TEXT("三角関数の値をグラフ表示します。( Tan は±1でカット)\n")
							TEXT("ダブルクリックで、グラフ表示を開始／停止します。\n")
							TEXT("このツールチップ上にカーソルを置くと表示を継続します。\n")
							TEXT("このツールチップ上をクリックするとツールチップは消えます。");

//----- CAjxTchの派生クラス ------------------------------------------------------------------------------------//
class CAjxTchEx :
	public CAjxTch,
	public CAjxTip
{
public:
	VO	SetHWnd(HWND hwnd)
	{
		CAjxTch::Attach(hwnd);
		CAjxTip::Attach(hwnd);
	}
	VO	OnNtcDblClk () override	{								//	ダブルクリック通知
		if (fTimer) {SetTitleText(TEXT("STOP")); KillTimer(hWndMain, 1);}
		else		{SetTitleText(TEXT("RUN" )); SetTimer (hWndMain, 1, 10, NULL);}
		fTimer = ~fTimer;
	}
	VO	OnNeedText (HWND hCtrl, UTP pBuf, UI lBuf) override {	//	チップテキスト取得要求
		if (fTimer) _tcscpy_s(pBuf, lBuf, TEXT("グラフ表示中です。ダブルクリックで表示を停止します。"));
		else		_tcscpy_s(pBuf, lBuf, TEXT("グラフ停止中です。ダブルクリックで表示を開始します。"));
	}
};
static	CAjxTchEx	tch;

//----- AjcWinMain ------------------------------------------------------------------------------------------------//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 		msg = {0};
	WNDCLASS	wc	= {0};
	ATOM		atm = 0;

	hInst = hInstance;
	//	ウインド生成
	wc.style		 = 0;							wc.hCursor		 = LoadCursor(NULL, IDC_ARROW);	
	wc.lpfnWndProc	 = AJC_WNDPROC_NAME(Main);		wc.hbrBackground = (HBRUSH)GetStockObject(LTGRAY_BRUSH);
	wc.hInstance	 = hInstance;					wc.lpszClassName = TEXT("SP_TCH");
	atm = RegisterClass(&wc);
	hWndMain = CreateWindow(TEXT("SP_TCH"),	TEXT("SP_TCH"),				// window class name, caption
							WS_OVERLAPPEDWINDOW,						// window style
							CW_USEDEFAULT, CW_USEDEFAULT, 500, 200,		// position, size
							NULL, NULL, hInstance, NULL);				// parent, menu, instance, param
	ShowWindow(hWndMain, iCmdShow);
	//	メッセージループ
	while (GetMessage(&msg, NULL, 0, 0)) {
		TranslateMessage(&msg);
		DispatchMessage (&msg);
	}
	UnregisterClass((UTP)atm, hInstance);
	return (int)msg.wParam ;
}
//----- WM_CREATE ----------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_CREATE 	)
{
	//	タイムチャートウインド生成
	RECT	r;
	GetClientRect(hwnd, &r);
	GetClientRect(hwnd, &r);
	hWndTch = CreateWindow(TEXT("AjcCtrlTmChart"), 					// window class
						   TEXT("P: L=-1.2, H=1.2, B=10000"),		// window caption
						   WS_CHILD,								// window style
						   0, 0, r.right, r.bottom, 				// position, size
						   hwnd, (HMENU)IDC_TCH, hInst, NULL);		// parent, menu, instance, param

	SAjxTip::ShowCenter(hWndTch, TipMsg);							//	チップテキスト初期表示
	tch.SetHWnd(hWndTch);											//	タイムチャートウインドハンドル割り当て
	tch.SetTitleText(TEXT("STOP"));									//	タイムチャートウインドタイトル設定
	ShowWindow(hWndTch, SW_SHOW);									//	タイムチャートウインド表示
	return 0;
}
//----- WM_DESTROY ---------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_DESTROY	)
{
	DestroyWindow(hWndTch);
	PostQuitMessage(0);
	return 0;
}
//----- WM_SIZE ------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_SIZE		)
{
	MoveWindow(hWndTch, 0, 0, LOWORD(lParam), HIWORD(lParam), FALSE);
	return 0;
}
//----- WM_TIMER -----------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_TIMER		)
{
	static double x = 0.0;
	double	s = sin(x);		double	c = cos(x);		double	t = tan(x);
	t = __min(t, 1.0); t = __max(t, -1.0);
	tch.PutData(s, c, t);
	x += (3.14159 / 180.0); x = fmod(x, 3.14159 * 2);
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(Main)
	AJC_WNDMAP_MSG(Main, WM_CREATE	)
	AJC_WNDMAP_MSG(Main, WM_DESTROY )
	AJC_WNDMAP_MSG(Main, WM_SIZE	)
	AJC_WNDMAP_MSG(Main, WM_TIMER	)
AJC_WNDMAP_END
