﻿#ifndef	AJC3DVEC_H_
#define	AJC3DVEC_H_
/****************************************************************************************************************/

#define	AJC_PAI	3.14159265358979323846
#define	AJC_RAD2DEG(RAD)	((RAD) * 180.0 / AJC_PAI)
#define	AJC_DEG2RAD(DEG)	((DEG) * AJC_PAI / 180.0)

//----- ２Ｄベクトル -------------------------------------------------------------------------------------------//
typedef struct {
	double	x, y;
} AJC2DVEC, *PAJC2DVEC;
typedef	const AJC2DVEC *PCAJC2DVEC;

typedef union {
	AJC2DVEC	s;
	double	arr[2];
} AJC2DVECU, *PAJC2DVECU;
typedef const AJC2DVECU *PCAJC2DVECU;

//----- ２Ｄラインベクトル（始点と方向ベクトル）----------------------------------------------------------------//
typedef struct {
	AJC2DVEC	p, v;
} AJC2DLVEC, *PAJC2DLVEC;
typedef const AJC2DLVEC *PCAJC2DLVEC;

typedef union {
	struct {AJC2DVECU p, v;} s;
	AJC2DLVEC	lv;
} AJC2DLVECU, *PAJC2DLVECU;
typedef const AJC2DLVECU *PCAJC2DLVECU;

//----- ３Ｄベクトル -------------------------------------------------------------------------------------------//
typedef struct {
	double	x, y, z;
} AJC3DVEC, *PAJC3DVEC;
typedef const AJC3DVEC *PCAJC3DVEC;

typedef union {
	AJC3DVEC	s;
	double	arr[3];
} AJC3DVECU, *PAJC3DVECU;
typedef const AJC3DVECU *PCAJC3DVECU;

//----- ３軸情報 -----------------------------------------------------------------------------------------------//
typedef struct {
	AJC3DVEC	x, y, z;
} AJC3DAXIS, *PAJC3DAXIS;
typedef const AJC3DAXIS *PCAJC3DAXIS;

//----- ３Ｄライン情報（始点と終点）----------------------------------------------------------------------------//
typedef struct {
	AJC3DVEC	p1, p2;
} AJC3DLINE, *PAJC3DLINE;
typedef const AJC3DLINE *PCAJC3DLINE;

//----- ３Ｄラインベクトル（始点と方向ベクトル）----------------------------------------------------------------//
typedef struct {
	AJC3DVEC	p, v;
} AJC3DLVEC, *PAJC3DLVEC;
typedef const AJC3DLVEC *PCAJC3DLVEC;

typedef union {
	struct {AJC3DVECU p, v;} s;
	AJC3DLVEC	lv;
} AJC3DLVECU, *PAJC3DLVECU;
typedef const AJC3DLVECU *PCAJC3DLVECU;

//----- ３Ｄ三角形情報 -----------------------------------------------------------------------------------------//
typedef struct {
	AJC3DVEC	p1, p2, p3;
} AJC3DTRI, *PAJC3DTRI;
typedef const AJC3DTRI *PCAJC3DTRI;

//----- ３Ｄ行列 -----------------------------------------------------------------------------------------------//
typedef struct {
	double	m[3][3];
} AJC3DMAT, *PAJC3DMAT;
typedef const AJC3DMAT *PCAJC3DMAT;

//----- ３Ｄ円の情報 -------------------------------------------------------------------------------------------//
typedef struct {
	AJC3DLINE	lt1, lt2;			//	円に内接する２つの直線
	AJC3DLINE	lc1, lc2;			//	内接線の中点からの垂線
	AJC3DLVEC	lvc;				//	円の中心と法線
	double		cr;					//	円の半径
} AJC3DCIRINFO, *PAJC3DCIRINFO;
typedef const AJC3DCIRINFO *PCAJC3DCIRINFO;

//----- ３Ｄ球の情報 -------------------------------------------------------------------------------------------//
typedef struct {
	AJC3DCIRINFO	cif1, cif2;		//	球に内接する２つの円
	AJC3DLINE		ls1 , ls2;		//	内接円中心から球中心への直線
	AJC3DVEC		sc;				//	球の中心
	double			sr;				//	球の半径
} AJC3DSPHINFO, *PAJC3DSPHINFO;
typedef const AJC3DSPHINFO *PCAJC3DSPHINFO;

//--------------------------------------------------------------------------------------------------------------//
//	プロトタイプ																								//
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT	double		WINAPI AjcSin				(double degree);
AJCEXPORT	double		WINAPI AjcSinh				(double degree);
AJCEXPORT	double		WINAPI AjcASin				(double x);

AJCEXPORT	double		WINAPI AjcCos				(double degree);
AJCEXPORT	double		WINAPI AjcCosh				(double degree);
AJCEXPORT	double		WINAPI AjcACos				(double x);

AJCEXPORT	double		WINAPI AjcTan				(double degree);
AJCEXPORT	double		WINAPI AjcTanh				(double degree);
AJCEXPORT	double		WINAPI AjcATan				(double x);
AJCEXPORT	double		WINAPI AjcATan2 			(double y, double x);

AJCEXPORT	PAJC3DVEC	WINAPI AjcV3dAdd			(PCAJC3DVEC pV1, PCAJC3DVEC pV2, PAJC3DVEC pR);
AJCEXPORT	PAJC3DVEC	WINAPI AjcV3dSub			(PCAJC3DVEC pV1, PCAJC3DVEC pV2, PAJC3DVEC pR);
AJCEXPORT	PAJC3DVEC	WINAPI AjcV3dMult			(PCAJC3DVEC pV, double n, PAJC3DVEC pR);
AJCEXPORT	PAJC3DVEC	WINAPI AjcV3dDiv			(PCAJC3DVEC pV, double n, PAJC3DVEC pR);
AJCEXPORT	PAJC3DLVEC	WINAPI AjcV3dSetLineVec		(PCAJC3DVEC p1, PCAJC3DVEC p2, PAJC3DLVEC pR);
AJCEXPORT	PAJC3DLINE	WINAPI AjcV3dSetLinePoint	(PCAJC3DVEC p1, PCAJC3DVEC p2, PAJC3DLINE pR);
AJCEXPORT	PAJC3DTRI	WINAPI AjcV3dSetTriPoint	(PCAJC3DVEC p1, PCAJC3DVEC p2, PCAJC3DVEC p3, PAJC3DTRI pR);
AJCEXPORT	double		WINAPI AjcV3dLength 		(PCAJC3DVEC pV);
AJCEXPORT	PAJC3DVEC	WINAPI AjcV3dLVecCenter		(PCAJC3DLVEC pL, PAJC3DVEC pR);
AJCEXPORT	PAJC3DVEC	WINAPI AjcV3dLineCenter 	(PCAJC3DLINE pL, PAJC3DVEC pR);
AJCEXPORT	PAJC3DVEC 	WINAPI AjcV3dOuter			(PCAJC3DVEC pV1, PCAJC3DVEC pV2, PAJC3DVEC pR);
AJCEXPORT	PAJC3DVEC	WINAPI AjcV3dOuter3P		(PCAJC3DVEC p1, PCAJC3DVEC p2, PCAJC3DVEC p3, PAJC3DVEC pR);
AJCEXPORT	double		WINAPI AjcV3dInner			(PCAJC3DVEC pV1, PCAJC3DVEC pV2);
AJCEXPORT	double		WINAPI AjcV3dInner3P		(PCAJC3DVEC p1, PCAJC3DVEC p2, PCAJC3DVEC p3, PAJC3DVEC pR);
AJCEXPORT	PAJC3DVEC	WINAPI AjcV3dPlaneVec		(PCAJC3DTRI pT, PAJC3DVEC pR);
AJCEXPORT	PAJC3DVEC	WINAPI AjcV3dNormal 		(PCAJC3DVEC pV , PAJC3DVEC pR);
AJCEXPORT	double		WINAPI AjcV3dTheta			(PCAJC3DVEC pV1, PCAJC3DVEC pV2);
AJCEXPORT	PAJC3DVEC	WINAPI AjcV3dVertVecP2L 	(PCAJC3DLVEC pL , PCAJC3DVEC pP , PAJC3DVEC pR);
AJCEXPORT	double		WINAPI AjcV3dDistP2L		(PCAJC3DLVEC pL , PCAJC3DVEC pP , PAJC3DVEC pR);
AJCEXPORT	double		WINAPI AjcV3dDistP2P		(PCAJC3DVEC pV1, PCAJC3DVEC pV2);
AJCEXPORT	PAJC3DVEC	WINAPI AjcV3dCrossL2L		(PCAJC3DLVEC pL1, PCAJC3DLVEC pL2, PAJC3DVEC pR);
AJCEXPORT	PAJC3DVEC	WINAPI AjcV3dCrossL2LEx 	(PCAJC3DLVEC pL1, PCAJC3DLVEC pL2, PAJC3DVEC pR);
AJCEXPORT	PAJC3DVEC	WINAPI AjcV3dCrossP2F		(PCAJC3DLVEC pL, PCAJC3DVEC pP, PAJC3DVEC pR);
AJCEXPORT	PAJC3DVEC	WINAPI AjcV3dOrthoVecOnPlane(PCAJC3DLINE pL, PCAJC3DVEC pV, PAJC3DVEC pR);
AJCEXPORT	PAJC3DVEC	WINAPI AjcV3dMultMat		(PCAJC3DVEC  pV, PCAJC3DMAT pM, PAJC3DVEC pR);
AJCEXPORT	PAJC3DVEC	WINAPI AjcV3dRotateX		(PCAJC3DVEC  pV, double t, PAJC3DVEC pR);
AJCEXPORT	PAJC3DVEC	WINAPI AjcV3dRotateY		(PCAJC3DVEC  pV, double t, PAJC3DVEC pR);
AJCEXPORT	PAJC3DVEC	WINAPI AjcV3dRotateZ		(PCAJC3DVEC  pV, double t, PAJC3DVEC pR);
AJCEXPORT	PAJC3DVEC	WINAPI AjcV3dRotateAny		(PCAJC3DVEC  pV, double t, PCAJC3DVEC pAny, PAJC3DVEC pR);
AJCEXPORT	PAJC3DVEC	WINAPI AjcV3dAnyOrthoVec	(PCAJC3DVEC  pV, PAJC3DVEC pR);
AJCEXPORT	PAJC3DVEC	WINAPI AjcV3dRotateOnPlane	(PCAJC3DVEC pP, PCAJC3DLVEC pC, double theta, PAJC3DVEC pR);

AJCEXPORT	double		WINAPI AjcV3dCalcCircle(double x1, double y1, double z1,
											double x2, double y2, double z2,
											double x3, double y3, double z3, PAJC3DVEC pR, PAJC3DVEC pV);

AJCEXPORT	double		WINAPI AjcV3dCalcCircleEx(double x1, double y1, double z1,
											double x2, double y2, double z2,
											double x3, double y3, double z3, PAJC3DVEC pR, PAJC3DVEC pV, PAJC3DCIRINFO pCir);

AJCEXPORT	double		WINAPI AjcV3dCalcCircleV  (PCAJC3DVEC p1, PCAJC3DVEC p2, PCAJC3DVEC p3, PAJC3DVEC pR, PAJC3DVEC pV);
AJCEXPORT	double		WINAPI AjcV3dCalcCircleVEx(PCAJC3DVEC p1, PCAJC3DVEC p2, PCAJC3DVEC p3, PAJC3DVEC pR, PAJC3DVEC pV, PAJC3DCIRINFO pCir);

AJCEXPORT	double	WINAPI AjcV3dCalcSphere(double x1, double y1, double z1,
											double x2, double y2, double z2,
											double x3, double y3, double z3,
											double x4, double y4, double z4, PAJC3DVEC pR);

AJCEXPORT	double	WINAPI AjcV3dCalcSphereEx(double x1, double y1, double z1,
											  double x2, double y2, double z2,
											  double x3, double y3, double z3,
											  double x4, double y4, double z4, PAJC3DVEC pR, PAJC3DSPHINFO pSph);

AJCEXPORT	double	WINAPI AjcV3dCalcSphereV  (PCAJC3DVEC p1, PCAJC3DVEC p2, PCAJC3DVEC p3, PCAJC3DVEC p4, PAJC3DVEC pR);
AJCEXPORT	double	WINAPI AjcV3dCalcSphereVEx(PCAJC3DVEC p1, PCAJC3DVEC p2, PCAJC3DVEC p3, PCAJC3DVEC p4, PAJC3DVEC pR, PAJC3DSPHINFO pSph);



AJCEXPORT	PAJC2DVEC	WINAPI AjcV2dAdd		(PCAJC2DVEC  pV1, PCAJC2DVEC pV2, PAJC2DVEC pR);
AJCEXPORT	PAJC2DVEC	WINAPI AjcV2dSub		(PCAJC2DVEC  pV1, PCAJC2DVEC pV2, PAJC2DVEC pR);
AJCEXPORT	PAJC2DVEC	WINAPI AjcV2dMult		(PCAJC2DVEC  pV , double n		, PAJC2DVEC pR);
AJCEXPORT	PAJC2DVEC	WINAPI AjcV2dDiv		(PCAJC2DVEC  pV , double n		, PAJC2DVEC pR);
AJCEXPORT	double		WINAPI AjcV2dLength		(PCAJC2DVEC  pV);
AJCEXPORT	double	 	WINAPI AjcV2dOuter		(PCAJC3DVEC  pV1, PCAJC2DVEC pV2);
AJCEXPORT	double		WINAPI AjcV2dInner		(PCAJC2DVEC  pV1, PCAJC2DVEC pV2);
AJCEXPORT	PAJC2DVEC	WINAPI AjcV2dNormal		(PCAJC2DVEC  pV , PAJC2DVEC  pR);
AJCEXPORT	double		WINAPI AjcV2dTheta		(PCAJC2DVEC  pV1, PCAJC2DVEC pV2);
AJCEXPORT	PAJC2DVEC	WINAPI AjcV2dVertVecP2L	(PCAJC2DLVEC pL , PCAJC2DVEC pP , PAJC2DVEC pR);
AJCEXPORT	double		WINAPI AjcV2dDistP2L	(PCAJC2DLVEC pL , PCAJC2DVEC pP , PAJC2DVEC pR);
AJCEXPORT	double		WINAPI AjcV2dDistP2P	(PCAJC2DVEC  pV1, PCAJC2DVEC pV2);
AJCEXPORT	PAJC2DVEC	WINAPI AjcV2dCrossL2L	(PCAJC2DLVEC pL1, PCAJC2DLVEC pL2, PAJC2DVEC pR);
AJCEXPORT	PAJC2DVEC	WINAPI AjcV2dRotate		(PCAJC2DVEC	 pV , double t		 , PAJC2DVEC pR);
AJCEXPORT	PAJC2DVEC	WINAPI AjcV2dAnyOrthoVec(PCAJC2DVEC  pV 				 , PAJC2DVEC pR);


AJCEXPORT	PAJC2DVEC	WINAPI AjcVPtAdd	(LPPOINT pV1, LPPOINT pV2, PAJC2DVEC pR);
AJCEXPORT	PAJC2DVEC	WINAPI AjcVPtSub	(LPPOINT pV1, LPPOINT pV2, PAJC2DVEC pR);
AJCEXPORT	PAJC2DVEC	WINAPI AjcVptMult	(LPPOINT pV , double n, PAJC2DVEC pR);
AJCEXPORT	PAJC2DVEC	WINAPI AjcVPtDiv	(LPPOINT pV , double n, PAJC2DVEC pR);
AJCEXPORT	double		WINAPI AjcVPtLength	(LPPOINT pV);
AJCEXPORT	double		WINAPI AjcVPtOuter	(LPPOINT pV1, LPPOINT pV2);
AJCEXPORT	double		WINAPI AjcVPtInner	(LPPOINT pV1, LPPOINT pV2);
AJCEXPORT	PAJC2DVEC	WINAPI AjcVPtNormal	(LPPOINT pV , PAJC2DVEC pR);
AJCEXPORT	double		WINAPI AjcVPtTheta	(LPPOINT pV1, LPPOINT pV2);
AJCEXPORT	double		WINAPI AjcVPtDistP2P(LPPOINT pV1, LPPOINT pV2);
AJCEXPORT	PAJC2DVEC	WINAPI AjcVPtRotate	(LPPOINT pV , double t, PAJC2DVEC pR);
AJCEXPORT	PAJC2DVEC	WINAPI AjcVPtAnyOrthoVec(LPPOINT pV, PAJC2DVEC pR);
AJCEXPORT	LPPOINT		WINAPI AjcVPtSetIntVec(PAJC2DVEC pV, LPPOINT pR);

/****************************************************************************************************************/
#endif
