﻿#ifndef	AJCAVLTREE_H_
#define	AJCAVLTREE_H_
/****************************************************************************************************************/
/*--------------------------------------------------------------------------------------------------------------*/
/*	ＵＮＩＣＯＤＥ／ＡＳＣＩＩ																					*/
/*--------------------------------------------------------------------------------------------------------------*/
#ifdef	UNICODE
		#define	AjcAvlInsStrNode		AjcAvlInsStrNodeW
		#define	AjcAvlGetStrNode		AjcAvlGetStrNodeW
		#define	AjcAvlRepStrNode		AjcAvlRepStrNodeW
		#define	AjcAvlInsOrGetStrNode	AjcAvlInsOrGetStrNodeW
		#define	AjcAvlInsOrRepStrNode	AjcAvlInsOrRepStrNodeW
		#define	AjcAvlDelStrNode		AjcAvlDelStrNodeW
		#define	AjcAvlSetStrNodeData	AjcAvlSetStrNodeDataW
		#define	AjcAvlGetStrNodeData	AjcAvlGetStrNodeDataW
#else
		#define	AjcAvlInsStrNode		AjcAvlInsStrNodeA
		#define	AjcAvlGetStrNode		AjcAvlGetStrNodeA
		#define	AjcAvlRepStrNode		AjcAvlRepStrNodeA
		#define	AjcAvlInsOrGetStrNode	AjcAvlInsOrGetStrNodeA
		#define	AjcAvlInsOrRepStrNode	AjcAvlInsOrRepStrNodeA
		#define	AjcAvlDelStrNode		AjcAvlDelStrNodeA
		#define	AjcAvlSetStrNodeData	AjcAvlSetStrNodeDataA
		#define	AjcAvlGetStrNodeData	AjcAvlGetStrNodeDataA
#endif
/*--------------------------------------------------------------------------------------------------------------*/
/*	ノードヘッダ形式																							*/
/*--------------------------------------------------------------------------------------------------------------*/
typedef struct _AJCAVLNODE {
	struct _AJCAVLNODE	*l, *r;				//	左右ノードへのポインタ
	UX					key;				//	キー
	SW					bal;				//	バランス係数（ -2 ～ +2 )
	UW					len;				//	ノードデータのバイト数
} AJCAVLNODE, *PAJCAVLNODE;

//--------------------------------------------------------------------------------------------------------------//
//	ポインタ配列エントリの構造体定義マクロ																		//
//--------------------------------------------------------------------------------------------------------------//
#define		MAJCAVLPTR(ST, PT)										\
typedef struct {													\
	UX		key;					/*	キー				*/		\
	PT		pNode;					/*	ノードへのポインタ	*/		\
	UI		len;					/*	ノードのバイト数	*/		\
} ST, *P##ST;														\
typedef const ST *PC##ST;

MAJCAVLPTR(AJCAVLPTR, VOP)

/*--------------------------------------------------------------------------------------------------------------*/
/*	インスタンスワーク																							*/
/*--------------------------------------------------------------------------------------------------------------*/
typedef struct _AJCAVL {
	UI					InstID;				//	インスタンス識別ＩＤ
	PAJCAVLNODE			pRoot;				//	ルートノードへのポインタ
	UI					NodeCount;			//	登録ノード数カウンタ

	BOOL				fMultiThread;		//	排他制御フラグ
	CRITICAL_SECTION	cs;					//	クリティカルセクション・オブジェクト

	PAJCAVLNODE			w_pNode;			//	ワーク（ノードポインタ）
	UX					w_key;				//	  〃  （キー値）
	C_VOP				w_pData;			//	  〃  （ノードデータポインタ）
	UI					w_len;				//	  〃  （ノードデータサイズ）
	BOOL				w_rsu;				//	  〃  （結果コード）
	UI					w_nest;				//	  〃  （ネスト数（＝木の高さ））
	BOOL				w_cont;				//	  〃  （データ通知コールバック続行フラグ）
	UX					w_cbp;				//	  〃  （全ノード通知用コールバックパラメタ）
	PAJCAVLNODE			q, s, w;			//	ノードポインタワーク
	int					b;					//	バランス値退避ワーク
	BOOL  (CALLBACK *w_cb)(UX key, VOP pNodeData, UI len, UI nest, UX cbp);

	UX					cbp;				//	コールバックパラメタ
	int   (CALLBACK *cbComp   )(UX key1, UX key2, UX cbp);
	VO	  (CALLBACK *cbNtcDel )(UX key, VOP pNodeData, UI len, UI nest, UX cbp);
} AJCAVL, *HAJCAVL;

//----- ノードデータ通知用コールバックタイプ -------------------------------------------------------------------//
typedef	BOOL (CALLBACK *AJCAVL_CBNTC)(UX key, VOP pNodeData, UI len, UI nest, UX cbp);

/*--------------------------------------------------------------------------------------------------------------*/
/*	プロトタイプ																								*/
/*--------------------------------------------------------------------------------------------------------------*/
AJCEXPORT	HAJCAVL	WINAPI	AjcAvlCreate(	UX		cbp,
											int   (CALLBACK *cbComp  )(UX key1, UX key2, UX cbp),
											VO	  (CALLBACK *cbRemove)(UX key, VOP pNodeData, UI len, UI nest, UX cbp));

AJCEXPORT	BOOL	WINAPI	AjcAvlDelete			(HAJCAVL hAvl);
AJCEXPORT	BOOL	WINAPI	AjcAvlEnableMultiThread	(HAJCAVL hAvl, BOOL fEnable);
AJCEXPORT	BOOL	WINAPI	AjcAvlSetCbp			(HAJCAVL hAvl, UX cbp);

//	ノードアクセス
AJCEXPORT	BOOL	WINAPI	AjcAvlInsNode			(HAJCAVL hAvl, UX key, C_VOP pNodeData, UI len);
AJCEXPORT	UX		WINAPI	AjcAvlInsDataNode		(HAJCAVL hAvl,		   C_VOP pNodeData, UI len);
AJCEXPORT	int		WINAPI	AjcAvlGetNode			(HAJCAVL hAvl, UX key, VOP	 pBuf,		UI lBuf);
#define	AjcAvlGetNodeByKey	AjcAvlGetNode
AJCEXPORT	VOP		WINAPI	AjcAvlGetNodePtr		(HAJCAVL hAvl, UX	key, UIP pLen);
AJCEXPORT	UX		WINAPI	AjcAvlGetNodeKey		(HAJCAVL hAvl, C_VOP pNode);
AJCEXPORT	int		WINAPI	AjcAvlGetTopNode		(HAJCAVL hAvl, UXP pKey, VOP pBuf, UI lBuf);
AJCEXPORT	int		WINAPI	AjcAvlGetLastNode		(HAJCAVL hAvl, UXP pKey, VOP pBuf, UI lBuf);
AJCEXPORT	BOOL	WINAPI	AjcAvlRepNode			(HAJCAVL hAvl, UX key, C_VOP pNodeData, UI len);
AJCEXPORT	BOOL	WINAPI	AjcAvlInsOrRepNode		(HAJCAVL hAvl, UX key, C_VOP pNodeData, UI len);
AJCEXPORT	BOOL	WINAPI	AjcAvlDelNode			(HAJCAVL hAvl, UX key);
AJCEXPORT	BOOL	WINAPI	AjcAvlDelAllNodes		(HAJCAVL hAvl);

//	文字列ノードアクセス
AJCEXPORT	UX		WINAPI AjcAvlInsStrNodeA		(HAJCAVL hAvl, C_BCP pStr);
AJCEXPORT	UX		WINAPI AjcAvlInsStrNodeW		(HAJCAVL hAvl, C_WCP pStr);

AJCEXPORT	UX		WINAPI AjcAvlGetStrNodeA		(HAJCAVL hAvl, C_BCP pStr);
AJCEXPORT	UX		WINAPI AjcAvlGetStrNodeW		(HAJCAVL hAvl, C_WCP pStr);

AJCEXPORT	UX		WINAPI AjcAvlInsOrGetStrNodeA	(HAJCAVL hAvl, C_BCP pStr);
AJCEXPORT	UX		WINAPI AjcAvlInsOrGetStrNodeW	(HAJCAVL hAvl, C_WCP pStr);

AJCEXPORT	UX		WINAPI AjcAvlDelStrNodeA		(HAJCAVL hAvl, C_BCP pStr);
AJCEXPORT	UX		WINAPI AjcAvlDelStrNodeW		(HAJCAVL hAvl, C_WCP pStr);

AJCEXPORT	UX		WINAPI AjcAvlSetStrNodeDataA	(HAJCAVL hAvl, C_BCP pStr, UX data);
AJCEXPORT	UX		WINAPI AjcAvlSetStrNodeDataW	(HAJCAVL hAvl, C_WCP pStr, UX data);

AJCEXPORT	BOOL	WINAPI AjcAvlGetStrNodeDataA	(HAJCAVL hAvl, C_BCP pStr, UXP pData);
AJCEXPORT	BOOL	WINAPI AjcAvlGetStrNodeDataW	(HAJCAVL hAvl, C_WCP pStr, UXP pData);


//	その他
AJCEXPORT	UI		WINAPI	AjcAvlGetCount	  (HAJCAVL hAvl);
AJCEXPORT	UI		WINAPI	AjcAvlNumber	  (HAJCAVL hAvl);

AJCEXPORT	UI		WINAPI	AjcAvlEnumNodes   (HAJCAVL hAvl,		 AJCAVL_CBNTC cbNtcNodeData, BOOL fDownSeq);
AJCEXPORT	UI		WINAPI	AjcAvlEnumNodesEx (HAJCAVL hAvl, UX cbp, AJCAVL_CBNTC cbNtcNodeData, BOOL fDownSeq);

AJCEXPORT	PCAJCAVLPTR	WINAPI	AjcAvlCreatePtrArr (HAJCAVL hAvl, UIP pNum, BOOL fDownSeq);
AJCEXPORT	BOOL		WINAPI	AjcAvlReleasePtrArr(HAJCAVL hAvl, PCAJCAVLPTR pArr);


/****************************************************************************************************************/
#endif
