﻿#ifndef	AJCAVSTREE_H_
#define	AJCAVSTREE_H_
/****************************************************************************************************************/
/*--------------------------------------------------------------------------------------------------------------*/
/*	ＵＮＩＣＯＤＥ／ＡＳＣＩＩ																					*/
/*--------------------------------------------------------------------------------------------------------------*/
#ifdef	UNICODE
	#define	MAJCAVSPTR				MAJCAVSPTRW
	#define	AJCAVS_CBNTC			AJCAVS_CBNTCW
	#define	AjcAvsCreate			AjcAvsCreateW
	#define	AjcAvsInsNode			AjcAvsInsNodeW
	#define	AjcAvsGetNode			AjcAvsGetNodeW
	#define	AjcAvsGetNodePtr		AjcAvsGetNodePtrW
	#define	AjcAvsGetTopNode		AjcAvsGetTopNodeW
	#define	AjcAvsGetLastNode		AjcAvsGetLastNodeW
	#define	AjcAvsRepNode			AjcAvsRepNodeW
	#define	AjcAvsInsOrRepNode		AjcAvsInsOrRepNodeW
	#define	AjcAvsDelNode			AjcAvsDelNodeW
	#define	AjcAvsEnumNodes  		AjcAvsEnumNodesW
	#define	AjcAvsEnumNodesEx 		AjcAvsEnumNodesExW
	#define	AjcAvsCreatePtrArr		AjcAvsCreatePtrArrW
	#define	AjcAvsReleasePtrArr		AjcAvsReleasePtrArrW

	#define	AJCAVSPTR				AJCAVSPTRW
	#define	PAJCAVSPTR				PAJCAVSPTRW
	#define	PCAJCAVSPTR				PCAJCAVSPTRW
#else
	#define	MAJCAVSPTR				MAJCAVSPTRA
	#define	AJCAVS_CBNTC			AJCAVS_CBNTCA
	#define	AjcAvsCreate			AjcAvsCreateA
	#define	AjcAvsInsNode			AjcAvsInsNodeA
	#define	AjcAvsGetNode			AjcAvsGetNodeA
	#define	AjcAvsGetNodePtr		AjcAvsGetNodePtrA
	#define	AjcAvsGetTopNode		AjcAvsGetTopNodeA
	#define	AjcAvsGetLastNode		AjcAvsGetLastNodeA
	#define	AjcAvsRepNode			AjcAvsRepNodeA
	#define	AjcAvsInsOrRepNode		AjcAvsInsOrRepNodeA
	#define	AjcAvsDelNode			AjcAvsDelNodeA
	#define	AjcAvsEnumNodes  		AjcAvsEnumNodesA
	#define	AjcAvsEnumNodesEx 		AjcAvsEnumNodesExA
	#define	AjcAvsCreatePtrArr		AjcAvsCreatePtrArrA
	#define	AjcAvsReleasePtrArr		AjcAvsReleasePtrArrA

	#define	AJCAVSPTR				AJCAVSPTRA
	#define	PAJCAVSPTR				PAJCAVSPTRA
	#define	PCAJCAVSPTR				PCAJCAVSPTRA
#endif

//--------------------------------------------------------------------------------------------------------------//
//	ポインタ配列エントリの構造体定義マクロ																		//
//--------------------------------------------------------------------------------------------------------------//
#define		MAJCAVSPTRA(ST, PT)										\
typedef struct {													\
	C_BCP	pKey;					/*	キー				*/		\
	PT		pNode;					/*	ノードへのポインタ	*/		\
	UI		len;					/*	ノードのバイト数	*/		\
} ST, *P##ST;														\
typedef const ST *PC##ST;

MAJCAVSPTRA(AJCAVSPTRA, VOP)

#define		MAJCAVSPTRW(ST, PT)										\
typedef struct {													\
	C_WCP	pKey;					/*	キー				*/		\
	PT		pNode;					/*	ノードへのポインタ	*/		\
	UI		len;					/*	ノードのバイト数	*/		\
} ST, *P##ST;														\
typedef const ST *PC##ST;

MAJCAVSPTRW(AJCAVSPTRW, VOP)

/*--------------------------------------------------------------------------------------------------------------*/
/*	インスタンスワーク																							*/
/*--------------------------------------------------------------------------------------------------------------*/
typedef struct _AJCAVS {
	UI					InstID;				//	インスタンス識別ＩＤ
	BOOL				fMultiThread;		//	排他制御フラグ
	CRITICAL_SECTION	cs;					//	クリティカルセクション・オブジェクト
	BOOL				fUnicode;			//	UNICODEモードフラグ
	EAJCCMPMODE			CmpMode;			//	文字列比較モード
	HAJCAVL				hAvl;				//	ＡＶＬインスタンス
	HAJCSPL				hSpl;				//	ＳＰＬインスタンス（キー文字列の保持用）

	UX					cbp;				//	コールバックパラメタ
	union {
		VO	  (CALLBACK *cbNtcDelA)(C_BCP pKey, VOP pNodeData, UI len, UI nest, UX cbp);
		VO	  (CALLBACK *cbNtcDelW)(C_WCP pKey, VOP pNodeData, UI len, UI nest, UX cbp);
	} u;
} AJCAVS, *HAJCAVS;

//----- ノードデータ通知用コールバックタイプ -------------------------------------------------------------------//
typedef	BOOL (CALLBACK *AJCAVS_CBNTCA)(C_BCP pKey, VOP pNodeData, UI len, UI nest, UX cbp);
typedef	BOOL (CALLBACK *AJCAVS_CBNTCW)(C_WCP pKey, VOP pNodeData, UI len, UI nest, UX cbp);

/*--------------------------------------------------------------------------------------------------------------*/
/*	プロトタイプ																								*/
/*--------------------------------------------------------------------------------------------------------------*/
AJCEXPORT	HAJCAVS	WINAPI	AjcAvsCreateA(EAJCCMPMODE CmpMode, UX cbp, VO (CALLBACK *cbRemove)(C_BCP pKey, VOP pNodeData, UI len, UI nest, UX cbp));
AJCEXPORT	HAJCAVS	WINAPI	AjcAvsCreateW(EAJCCMPMODE CmpMode, UX cbp, VO (CALLBACK *cbRemove)(C_WCP pKey, VOP pNodeData, UI len, UI nest, UX cbp));

AJCEXPORT	BOOL	WINAPI	AjcAvsDelete			(HAJCAVS hAvs);
AJCEXPORT	BOOL	WINAPI	AjcAvsEnableMultiThread	(HAJCAVS hAvs, BOOL fEnable);
AJCEXPORT	BOOL	WINAPI	AjcAvsSetCbp			(HAJCAVS hAvs, UX cbp);
AJCEXPORT	BOOL	WINAPI	AjcAvsSetCompMode		(HAJCAVS hAvs, EAJCCMPMODE CmpMode);

//	ノードアクセス
AJCEXPORT	BOOL	WINAPI	AjcAvsInsNodeA			(HAJCAVS hAvs, C_BCP pKey, C_VOP pNodeData, UI len);
AJCEXPORT	BOOL	WINAPI	AjcAvsInsNodeW			(HAJCAVS hAvs, C_WCP pKey, C_VOP pNodeData, UI len);

AJCEXPORT	int		WINAPI	AjcAvsGetNodeA			(HAJCAVS hAvs, C_BCP pKey, VOP	 pBuf,		UI lBuf);
AJCEXPORT	int		WINAPI	AjcAvsGetNodeW			(HAJCAVS hAvs, C_WCP pKey, VOP	 pBuf,		UI lBuf);

AJCEXPORT	VOP		WINAPI	AjcAvsGetNodePtrA		(HAJCAVS hAvs, C_BCP pKey, UIP pLen);
AJCEXPORT	VOP		WINAPI	AjcAvsGetNodePtrW		(HAJCAVS hAvs, C_WCP pKey, UIP pLen);

AJCEXPORT	C_VOP	WINAPI	AjcAvsGetNodeKey		(HAJCAVS pW, VOP pNode);

AJCEXPORT	int		WINAPI	AjcAvsGetTopNodeA		(HAJCAVS hAvs, C_BCP *pKey, VOP pBuf, UI lBuf);
AJCEXPORT	int		WINAPI	AjcAvsGetTopNodeW		(HAJCAVS hAvs, C_WCP *pKey, VOP pBuf, UI lBuf);

AJCEXPORT	int		WINAPI	AjcAvsGetLastNodeA		(HAJCAVS hAvs, C_BCP *pKey, VOP pBuf, UI lBuf);
AJCEXPORT	int		WINAPI	AjcAvsGetLastNodeW		(HAJCAVS hAvs, C_WCP *pKey, VOP pBuf, UI lBuf);

AJCEXPORT	BOOL	WINAPI	AjcAvsRepNodeA			(HAJCAVS hAvs, C_BCP pKey, C_VOP pNodeData, UI len);
AJCEXPORT	BOOL	WINAPI	AjcAvsRepNodeW			(HAJCAVS hAvs, C_WCP pKey, C_VOP pNodeData, UI len);

AJCEXPORT	BOOL	WINAPI	AjcAvsInsOrRepNodeA		(HAJCAVS hAvs, C_BCP pKey, C_VOP pNodeData, UI len);
AJCEXPORT	BOOL	WINAPI	AjcAvsInsOrRepNodeW		(HAJCAVS hAvs, C_WCP pKey, C_VOP pNodeData, UI len);

AJCEXPORT	BOOL	WINAPI	AjcAvsDelNodeA			(HAJCAVS hAvs, C_BCP pKey);
AJCEXPORT	BOOL	WINAPI	AjcAvsDelNodeW			(HAJCAVS hAvs, C_WCP pKey);

AJCEXPORT	BOOL	WINAPI	AjcAvsDelAllNodes		(HAJCAVS hAvs);

//	その他
AJCEXPORT	UI		WINAPI	AjcAvsGetCount			(HAJCAVS hAvs);

AJCEXPORT	UI		WINAPI	AjcAvsEnumNodesA (HAJCAVS hAvs, AJCAVS_CBNTCA cbNtcNodeData, BOOL fDownSeq);
AJCEXPORT	UI		WINAPI	AjcAvsEnumNodesW (HAJCAVS hAvs, AJCAVS_CBNTCW cbNtcNodeData, BOOL fDownSeq);

AJCEXPORT	UI		WINAPI	AjcAvsEnumNodesExA (HAJCAVS hAvs, UX cbp, AJCAVS_CBNTCA cbNtcNodeData, BOOL fDownSeq);
AJCEXPORT	UI		WINAPI	AjcAvsEnumNodesExW (HAJCAVS hAvs, UX cbp, AJCAVS_CBNTCW cbNtcNodeData, BOOL fDownSeq);

AJCEXPORT	PCAJCAVSPTRA	WINAPI	AjcAvsCreatePtrArrA(HAJCAVS hAvs, UIP pNum, BOOL fDownSeq);
AJCEXPORT	PCAJCAVSPTRW	WINAPI	AjcAvsCreatePtrArrW(HAJCAVS hAvs, UIP pNum, BOOL fDownSeq);

AJCEXPORT	BOOL	WINAPI	AjcAvsReleasePtrArrA(HAJCAVS hAvs, PCAJCAVSPTRA pArr);
AJCEXPORT	BOOL	WINAPI	AjcAvsReleasePtrArrW(HAJCAVS hAvs, PCAJCAVSPTRW pArr);

AJCEXPORT	BOOL	WINAPI	AjcAvsIsUnicode			(HAJCAVS hAvs);

/****************************************************************************************************************/
#endif
