﻿#ifndef	AJCBITMAP_H_
#define	AJCBITMAP_H_
/****************************************************************************************************************/
/*--------------------------------------------------------------------------------------------------------------*/
/*	ＵＮＩＣＯＤＥ／ＡＳＣＩＩ																					*/
/*--------------------------------------------------------------------------------------------------------------*/
#ifdef	UNICODE
	#define	AjcWriteBitmapToFile			AjcWriteBitmapToFileW
	#define	AjcCreateDibFromFile			AjcCreateDibFromFileW
#else
	#define	AjcWriteBitmapToFile			AjcWriteBitmapToFileA
	#define	AjcCreateDibFromFile			AjcCreateDibFromFileA
#endif
/*--------------------------------------------------------------------------------------------------------------*/
/*	ビットマップ情報																							*/
/*--------------------------------------------------------------------------------------------------------------*/
typedef union {
	DWORD				size;		//	構造体のサイズ
	BITMAPCOREHEADER	bc;			//	OS2スタイルのビットマップ情報	, size = sizeof(BITMAPCOREHEADER) = 12
	BITMAPINFOHEADER	bi;			//	Windowsの拡張ビットマップ情報	, size = sizeof(BITMAPINFOHEADER) = 40
	BITMAPV4HEADER		v4;			//	バージョン４ヘッダ(Win95/NT～)	, size = sizeof(BITMAPV4HEADER)	  = 108
#if (WINVER >= 0x0500)
	BITMAPV5HEADER		v5;			//	バージョン５ヘッダ(Win98/2K～)	, size = sizeof(BITMAPV5HEADER)	  = 124
#endif
	UB					dmy[256];
} AJCBITMAPINFO, *PAJCBITMAPINFO;


/*--------------------------------------------------------------------------------------------------------------*/
/*	プロトタイプ																								*/
/*--------------------------------------------------------------------------------------------------------------*/
AJCEXPORT	BOOL	WINAPI	AjcChangeBitmapColor(HBITMAP hBmp, COLORREF before, COLORREF after);

AJCEXPORT	BOOL  	WINAPI	AjcSetBitmapToClipboard	(HBITMAP hBitmap);
AJCEXPORT	HBITMAP	WINAPI	AjcGetBitmapFromClipboard(VO);

AJCEXPORT	BOOL	WINAPI	AjcWriteBitmapToFileA	(HBITMAP hBitmap, C_BCP pFilePath);
AJCEXPORT	BOOL	WINAPI	AjcWriteBitmapToFileW	(HBITMAP hBitmap, C_WCP pFilePath);

AJCEXPORT	HBITMAP WINAPI	AjcCreateDibFromFileA(C_BCP pFilePath, UIP pWidth, UIP pHeight, PAJCBITMAPINFO pBmpInfo, VOP *ppImage);
AJCEXPORT	HBITMAP WINAPI	AjcCreateDibFromFileW(C_WCP pFilePath, UIP pWidth, UIP pHeight, PAJCBITMAPINFO pBmpInfo, VOP *ppImage);

AJCEXPORT	UI		WINAPI	AjcGetBitmapSize(HBITMAP hBitmap, LPSIZE pSize);
AJCEXPORT	BOOL	WINAPI	AjcGetIconSize  (HICON   hIcon  , LPSIZE pSize);


/****************************************************************************************************************/
#endif
