﻿#ifndef	AJCCIP_H_
#define	AJCCIP_H_
/****************************************************************************************************************/

//--------------------------------------------------------------------------------------------------------------//
//	値のタイプ																									//
//--------------------------------------------------------------------------------------------------------------//
typedef enum {
	AJCIPT_UNDEF	= AJCVMGT_UNDEF	,		//	未定義／エラー(=0)
	AJCIPT_INTEGER	= AJCVMGT_LONG	,		//	整数
	AJCIPT_REAL		= AJCVMGT_REAL	,		//	実数
	AJCIPT_STRING	= AJCVMGT_STR	,		//	文字列
} EAJCCIPTYP, *PEAJCCIPTYP;
typedef const EAJCCIPTYP * PCEAJCCIPTYP;

//--------------------------------------------------------------------------------------------------------------//
//	トークン情報																								//
//--------------------------------------------------------------------------------------------------------------//
typedef struct _AJCCIPTKN {
	EAJCTKCODE		tkn;					//	トークンコード
	UB				flgCtrl;				//	'do', 'while', 'function' 関連のフラグ情報
	UB				flgValue;				//	数値定数／文字定数の形式(AJCIP_VAL_XXXXX)
	UW				lno;					//	行番号
	union {
		struct _AJCCIPTKN *pJmp;			//	※１
		BCP 			   pStr;			//	※２
		SLL 			   val;				//	数値定数（整数）
		double			   dbl;				//	〃		（実数）
	} u;
} AJCCIPTKN, *PAJCCIPTKN;
typedef const AJCCIPTKN *PCAJCCIPTKN;

/*
	※１：	if			: else / endif(}/;)の直後へのポインタ
			else		: endif(}/;)の直後へのポインタ
			while(前置)	: end-while(}/;)の直後へのポインタ
			end-while(}): 繰り返し位置（while）へのポインタ
			do			: NULL
			while(後置）: 繰り返し位置（'do {' の直後）へのポインタ
			for			: 制御構造が未決中は、更新文の先頭アドレス
						: 制御構造が解決時は、Exitポイント
			FOR-COND	; for文の直後（ 'for (COND, UPD) の直後 ）へのポインタ
			FOR-UPD		: for-CONDへのポインタ
			break		: 構造体の直後へのポインタ
			その他		: NULL

	※２：	シンボル	: シンボル名文字列へのポインタ
			文字定数	: 文字列へのポインタ
*/

//--------------------------------------------------------------------------------------------------------------//
//	「値」情報																									//
//--------------------------------------------------------------------------------------------------------------//
typedef union {
	SLL		sll;								//	整数（符号付き／符号無し 兼用）
	double	dbl;								//	実数
	C_BCP	pStr;								//	文字列(へのポインタ)
	struct {HAJCVMGA hVmg; BCP pName;} arr;		//	配列（VMGインスタンス，変数名）
} AJCCIP_UVAL, *PAJCCIP_UVAL;
typedef const AJCCIP_UVAL *PCAJCCIP_UVAL;

//--------------------------------------------------------------------------------------------------------------//
//	引数値情報																									//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	UI			seq;						//	引数の順序番号（０～）
	EAJCCIPTYP	typ;						//	タイプ
	AJCCIP_UVAL	val;						//	引数値
	BOOL		fArr;						//	配列フラグ
} AJCCIPAGV, *PAJCCIPAGV;
typedef const AJCCIPAGV *PCAJCCIPAGV;

//--------------------------------------------------------------------------------------------------------------//
//	ファンクション呼び出し情報																					//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	BCP			pFunName;					//	ファンクション名へのポインタ
	UI			lno;						//	行番号
	PAJCCIPTKN	pReturn;					//	戻りアドレス
	HAJCVMGA	rchVmg;						//	戻り値を格納するＶＭＧハンドル
	BCP			rcpSym;						//	戻り値を格納する変数へのポインタ
	ULL			rcIx;						//	戻り値を格納する配列インデクス
	UI			nArg;						//	引数の個数
	HAJCFQUE	hQueAgv;					//	引数値群（「AJCCIPAGV」の固定長キュー）
} AJCCIPCALL, *PAJCCIPCALL;
typedef const AJCCIPCALL *PCAJCCIPCALL;

//--------------------------------------------------------------------------------------------------------------//
//	イベント通知コード																							//
//--------------------------------------------------------------------------------------------------------------//
//			HIWORD(wParam)													lParam
#define		AJCCIPN_FUN			1		//	外部関数呼び出し通知			PAJCCIPEVPFUN
#define		AJCCIPN_EXE			2		//	ステップ実行通知				PAJCCIPEVPEXE
#define		AJCCIPN_ERR			3		//	エラー発生通知					PAJCCIPEVPERR

#define		AJCCIPN_DBLCLK		5		//	ダブルクリック通知				C_BCP(ダブルクリック行のテキスト)

#define		AJCCIPN_DROPFILE	8		//	ファイルドロップ通知			ファイル数
#define		AJCCIPN_DROPDIR		9		//	ディレクトリドロップ通知		ディレクトリ数

#define		AJCCIPN_SLOTOPEN	20		//	メールスロット・オープン通知	スロット名情報へのポインタ(PAJCCIPSLOTNAMES)
#define		AJCCIPN_SLOTCLOSE	21		//	メールスロット・クローズ通知	－

//--------------------------------------------------------------------------------------------------------------//
//	エラーコード																								//
//--------------------------------------------------------------------------------------------------------------//
typedef enum {
	AJCIP_ERR_OK			= 0		,	//	正常

	AJCIP_ERR_NOLOAD		= 100	,	//	マクロファイルが読みだされていません
	AJCIP_ERR_NOTREADY				,	//	マクロ実行準備ができていない（マクロが解析されていません）

	AJCIP_ERR_MEM			= 200	,	//	メモリエラー
	AJCIP_ERR_VMG					,	//	変数アクセスエラー
	AJCIP_ERR_SYNTAX				,	//	シンタックスエラー
	AJCIP_ERR_PARAM					,	//	パラメタエラー
	AJCIP_ERR_CALC					,	//	演算エラー
	AJCIP_ERR_EXEC					,	//	実行時エラー
	AJCIP_ERR_USER					,	//	ユーザからのエラー通知

	AJCIP_ERR_INTERNAL		= 300	,	//	内部エラー
} AJCCIP_ERR, *PAJCCIP_ERR;

//--------------------------------------------------------------------------------------------------------------//
//	イベント通知パラメタ																						//
//--------------------------------------------------------------------------------------------------------------//
//	AJCCIPN_FUN - 外部関数呼び出し通知
typedef struct {
	UI 			 argc;			//	引数の個数
	PCAJCCIPAGV  *argv;	 		//	引数情報
	PCAJCCIPCALL pCall;			//	呼び出し情報
} AJCCIPEVPFUN, *PAJCCIPEVPFUN;

//	ステップ実行通知
typedef struct {
	PCAJCCIPTKN	pTkn;			//	トークン情報
	BOOL		fStop;			//	実行中止フラグ
} AJCCIPEVPEXE, *PAJCCIPEVPEXE;

//	AJCCIPN_ERR - エラー発生通知
typedef struct {
	AJCCIP_ERR	err;			//	エラーコード
	UI			lno;			//	行番号
	C_BCP		pMsg;			//	メッセージテキスト
} AJCCIPEVPERR, *PAJCCIPEVPERR;

//	AJCCIPN_SLOTOPEN - スロットオープン通知
typedef struct {
	C_BCP		pMySlot;		//	自スロット名
	C_BCP		pRmtHost;		//	リモートホスト名
	C_BCP		pRmtSlot;		//	リモートスロット名
} AJCCIPSLOTNAMES, *PAJCCIPSLOTNAMES;

//--------------------------------------------------------------------------------------------------------------//
//	ステータス情報																								//
//--------------------------------------------------------------------------------------------------------------//
//	数値タイプ
typedef enum {
	AJCCIPSTS_UNKOWN		= 0	,		//	未設定
	AJCCIPSTS_SINT				,		//	符号付き整数(64 bit)
	AJCCIPSTS_UINT				,		//	符号なし整数(64 bit)
	AJCCIPSTS_REAL				,		//	実数(double)
} AJCCIPSTSTYPE, *PAJCCIPSTSTYPE;

//	実行状態
typedef enum {
	AJCCIPSTS_NOTREADY		= 0	,		//	実行不能状態
	AJCCIPSTS_READY				,		//	実行可能状態
	AJCCIPSTS_EXEC				,		//	実行中
} AJCCIPSTSEXEC, *PAJCCIPSTSEXEC;

//	ステータス情報
typedef struct {
	AJCCIPSTSTYPE	eType;				//	数値タイプ
	AJCCIPSTSEXEC	eExec;				//	マクロテキスト実行状態
} AJCCIPSTATE, *PAJCCIPSTATE;

//--------------------------------------------------------------------------------------------------------------//
//	プロトタイプ																								//
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT AJCCIP_ERR	WINAPI AjcCipLoad			(HWND hwnd, C_BCP pMacFile);
AJCEXPORT BOOL			WINAPI AjcCipExec			(HWND hwnd, PAJCCIPCALL pCall);
AJCEXPORT BOOL			WINAPI AjcCipEvent			(HWND hwnd, PAJCCIPCALL pCall);
AJCEXPORT BOOL			WINAPI AjcCipStop			(HWND hwnd);
AJCEXPORT BOOL			WINAPI AjcCipSetOption		(HWND hwnd, BOOL fEnableOption, EAJCCIPTYP NumType, BOOL fSigned);
AJCEXPORT BOOL			WINAPI AjcCipSetDblClkAct	(HWND hwnd, BOOL fNtcDblClk);

AJCEXPORT BOOL			WINAPI AjcCipPutS			(HWND hwnd, C_BCP pTxt);
AJCEXPORT BOOL			WINAPI AjcCipPrintF			(HWND hwnd, C_BCP pFmt, ...);
AJCEXPORT BOOL			WINAPI AjcCipNtcErrByUser	(HWND hwnd, PCAJCCIPCALL pCall, C_BCP pFmt, ...);
AJCEXPORT C_BCP			WINAPI AjcCipGetExitText	(HWND hwnd);

AJCEXPORT BOOL			WINAPI AjcCipGetDroppedFile (HWND hwnd, BC buf[MAX_PATH]);
AJCEXPORT BOOL 			WINAPI AjcCipGetDroppedDir	(HWND hwnd, BC buf[MAX_PATH]);
AJCEXPORT BOOL 			WINAPI AjcCipGetDroppedDirEx(HWND hwnd, BC buf[MAX_PATH], BOOL fTailIsDelimiter);

AJCEXPORT PAJCCIPCALL	WINAPI AjcCipCallInfoInit		(HWND hwnd, C_BCP pFuncName);
AJCEXPORT BOOL			WINAPI AjcCipCallInfoDelete		(HWND hwnd, PAJCCIPCALL pCallInfo);
AJCEXPORT BOOL			WINAPI AjcCipCallInfoInsInteger	(HWND hwnd, PAJCCIPCALL pCallInfo, SLL value);
AJCEXPORT BOOL			WINAPI AjcCipCallInfoInsReal	(HWND hwnd, PAJCCIPCALL pCallInfo, double value);
AJCEXPORT BOOL			WINAPI AjcCipCallInfoInsString	(HWND hwnd, PAJCCIPCALL pCallInfo, C_BCP pStr);

AJCEXPORT C_ULLP		 WINAPI AjcCipGetRetInt			(HWND hwnd, UIP pNum);
AJCEXPORT const double * WINAPI AjcCipGetRetReal		(HWND hwnd, UIP pNum);
AJCEXPORT const C_BCP *  WINAPI AjcCipGetRetStr			(HWND hwnd, UIP pNum);

AJCEXPORT BOOL			WINAPI AjcCipCreateTraceWindow	(HWND hwnd);
AJCEXPORT BOOL			WINAPI AjcCipDestroyTraceWindow	(HWND hwnd);
AJCEXPORT BOOL			WINAPI AjcCipCreateStepWindow	(HWND hwnd);
AJCEXPORT BOOL			WINAPI AjcCipDestroyStepWindow	(HWND hwnd);
AJCEXPORT BOOL			WINAPI AjcCipEnableStepTrace	(HWND hwnd, BOOL fEnable);
AJCEXPORT HWND			WINAPI AjcCipGetVT100Handle		(HWND hwnd);
AJCEXPORT BOOL			WINAPI AjcCipGetStatus			(HWND hwnd, PAJCCIPSTATE pState);


AJCEXPORT BOOL			WINAPI AjcCipDump				(HWND hwnd);


//----- 通知情報取得 -------------------------------------------------------------------------------------------//
AJCEXPORT UI			WINAPI AjcCipGetNtcDirs			(HWND hwnd);
AJCEXPORT UI			WINAPI AjcCipGetNtcFiles		(HWND hwnd);
AJCEXPORT PAJCCIPEVPFUN	WINAPI AjcCipGetNtcEvpFun		(HWND hwnd);
AJCEXPORT BCP			WINAPI AjcCipGetNtcText			(HWND hwnd);

/****************************************************************************************************************/
#endif
