﻿#ifndef	AJCCTRLBARGRAPH_H_
#define	AJCCTRLBARGRAPH_H_
/****************************************************************************************************************/
/*--------------------------------------------------------------------------------------------------------------*/
/*	ＵＮＩＣＯＤＥ／ＡＳＣＩＩ																					*/
/*--------------------------------------------------------------------------------------------------------------*/
#ifdef	UNICODE
	#define	AjcBarPutRealData		AjcBarPutRealDataW
	#define	AjcBarPutIntData		AjcBarPutIntDataW
	#define	AjcBarSetBarTtl			AjcBarSetBarTtlW
	#define	AjcBarSetVUnit			AjcBarSetVUnitW
	#define	AjcBarLoadProp			AjcBarLoadPropW
	#define	AjcBarSaveProp			AjcBarSavePropW
	#define	AjcBarLoadPropEx		AjcBarLoadPropExW
	#define	AjcBarSavePropEx		AjcBarSavePropExW
	#define	AjcBarSetTipText		AjcBarSetTipTextW
	#define	AjcBarGetTipText		AjcBarGetTipTextW
	#define	AjcBarSetChkBoxTipText	AjcBarSetChkBoxTipTextW
	#define	AjcBarGetChkBoxTipText	AjcBarGetChkBoxTipTextW
	#define	AjcBarGetDroppedFile	AjcBarGetDroppedFileW
	#define	AjcBarGetDroppedDir		AjcBarGetDroppedDirW
	#define	AjcBarGetDroppedDirEx	AjcBarGetDroppedDirExW
	#define	AjcBarSetTitleText		AjcBarSetTitleTextW
	#define	AjcBarTextOut			AjcBarTextOutW
	#define	AjcBarPrintF			AjcBarPrintFW
	#define	AjcBarGetText			AjcBarGetTextW
#else
	#define	AjcBarPutRealData		AjcBarPutRealDataA
	#define	AjcBarPutIntData		AjcBarPutIntDataA
	#define	AjcBarSetBarTtl			AjcBarSetBarTtlA
	#define	AjcBarSetVUnit			AjcBarSetVUnitA
	#define	AjcBarLoadProp			AjcBarLoadPropA
	#define	AjcBarSaveProp			AjcBarSavePropA
	#define	AjcBarLoadPropEx		AjcBarLoadPropExA
	#define	AjcBarSavePropEx		AjcBarSavePropExA
	#define	AjcBarSetTipText		AjcBarSetTipTextA
	#define	AjcBarGetTipText		AjcBarGetTipTextA
	#define	AjcBarSetChkBoxTipText	AjcBarSetChkBoxTipTextA
	#define	AjcBarGetChkBoxTipText	AjcBarGetChkBoxTipTextA
	#define	AjcBarGetDroppedFile	AjcBarGetDroppedFileA
	#define	AjcBarGetDroppedDir		AjcBarGetDroppedDirA
	#define	AjcBarGetDroppedDirEx	AjcBarGetDroppedDirExA
	#define	AjcBarSetTitleText		AjcBarSetTitleTextA
	#define	AjcBarTextOut			AjcBarTextOutA
	#define	AjcBarPrintF			AjcBarPrintFA
	#define	AjcBarGetText			AjcBarGetTextA
#endif
//--------------------------------------------------------------------------------------------------------------//
//	コントロールのスタイル																						//
//--------------------------------------------------------------------------------------------------------------//
#define	AJCBARS_NOBORDER		0x0080			//	Bit7   : 外枠非表示
#define	AJCBARS_LINEGRAPH		0x0040			//	Bit6   : 折れ線グラフモード
#define	AJCBARS_NOFILTER		0x0010			//	Bit4   : フィルタ非表示
#define	AJCBARS_NOSCROLLBAR		0x0008			//	Bit3   : スクロールバー非表示

//--------------------------------------------------------------------------------------------------------------//
//	コントロールのプロパティ																					//
//--------------------------------------------------------------------------------------------------------------//
#define	AJCBAR_MAXBUF	10000			//	最大データ数
#define	AJCBAR_MAXITEM	8				//	最大データ項目数
#define	AJCBAR_MAXSTR	64				//	最大棒タイトル文字数

typedef struct {
	double		RngL, RngH;				//	グラフ上下の座標値
	double		Base;					//	棒グラフのベース値
	UI			MaxBuf;					//	最大データ数
	UI			MaxItem;				//	最大アイテム数
	UI			ScaleWidth;				//	スケール値表示域の幅
	UI			BarWidth;				//	棒の幅
	UI			MinWidth;				//	棒域の最小幅
	UI			BarTtlLines;			//	棒タイトルの最大行数
	COLORREF	rgb[AJCBAR_MAXITEM];	//	棒の表示色
} AJCBARPROP, *PAJCBARPROP;
typedef const AJCBARPROP *PCAJCBARPROP;

//--------------------------------------------------------------------------------------------------------------//
//	レンジ通知情報																								//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	double	RngL;		//	グラフレンジ低位値
	double	RngH;		//	グラフレンジ高位値
} AJCBAR_NTC_RANGE, *PAJCBAR_NTC_RANGE;
typedef const AJCBAR_NTC_RANGE *PCAJCBAR_NTC_RANGE;

//--------------------------------------------------------------------------------------------------------------//
//	右クリック通知情報																							//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	int			x;									//	カーソルｘ座標
	int			y;									//	カーソルｙ座標
	BOOL		fShift;								//	SHIFTキー押下フラグ
	BOOL		fCtrl;								//	CTRL キー押下フラグ
} AJCBARRCLK, *PAJCBARRCLK;
typedef const AJCBARRCLK *PCAJCBARRCLK;

//--------------------------------------------------------------------------------------------------------------//
//	横線属性																									//
//--------------------------------------------------------------------------------------------------------------//
#define	AJCBAR_SOLID		PS_SOLID			/*	実線							*/
#define	AJCBAR_DASH			PS_DASH				/*	点線（長）			-------		*/
#define	AJCBAR_DOT			PS_DOT				/*	点線（短）			.......		*/
#define	AJCBAR_DASHDOT		PS_DASHDOT			/*	１点鎖線			_._._._		*/
#define	AJCBAR_DASHDOTDOT	PS_DASHDOTDOT		/*	２点鎖線			_.._.._		*/
#define	AJCBAR_NULL			PS_NULL				/*	空線							*/
#define	AJCBAR_INSIDEFRAME	PS_INSIDEFRAME		/*	インサイドフレーム				*/

//--------------------------------------------------------------------------------------------------------------//
//	コントロールのメッセージ																					//
//--------------------------------------------------------------------------------------------------------------//
//																				wParam				lParam
//----- 通知メッセージ -----------------------------------------------------------------------------------------//
#define	AJCBARN_RANGE				(WM_APP + 20)	//	グラフレンジ通知		－				PAJCBAR_NTC_RANGE
#define	AJCBARN_SCRPOS				(WM_APP + 21)	//	スクロール位置通知		－				クスロール位置
#define	AJCBARN_DBLCLK				(WM_APP + 23)	//	ダブルクリック通知		－				－
#define	AJCBARN_DROPFILE			(WM_APP + 24)	//	ファイルドロップ通知	－				ファイル数
#define	AJCBARN_DROPDIR				(WM_APP + 25)	//	フォルダドロップ通知	－				ディレクトリ数
#define	AJCBARN_RCLICK				(WM_APP + 26)	//	右クリック通知			－				PAJCBARRCLK

//----- 内部使用メッセージ -------------------------------------------------------------------------------------//
#define	AJCBARM_NEEDNTC_RANGE		(WM_APP + 90)	//	レンジ通知要

//--------------------------------------------------------------------------------------------------------------//
//	プロトタイプ																								//
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcBarPutRealDataA	(HWND hwnd, double dat[], C_BCP pBarTtl);
AJCEXPORT	BOOL		WINAPI	AjcBarPutRealDataW	(HWND hwnd, double dat[], C_WCP pBarTtl);

AJCEXPORT	BOOL		WINAPI	AjcBarPutIntDataA	(HWND hwnd, int	   dat[], C_BCP pBarTtl);
AJCEXPORT	BOOL		WINAPI	AjcBarPutIntDataW	(HWND hwnd, int	   dat[], C_WCP pBarTtl);

AJCEXPORT	BOOL		WINAPI	AjcBarSetBarTtlA	(HWND hwnd, C_BCP pTtl);
AJCEXPORT	BOOL		WINAPI	AjcBarSetBarTtlW	(HWND hwnd, C_WCP pTtl);

AJCEXPORT	BOOL		WINAPI	AjcBarSetVUnitA		(HWND hwnd, C_BCP pUnit);
AJCEXPORT	BOOL		WINAPI	AjcBarSetVUnitW		(HWND hwnd, C_WCP pUnit);

AJCEXPORT	BOOL		WINAPI	AjcBarPurge			(HWND hwnd);

AJCEXPORT	BOOL		WINAPI	AjcBarShowBorder	(HWND hwnd, BOOL fShow, COLORREF rgb);
AJCEXPORT	BOOL		WINAPI	AjcBarShowFilter	(HWND hwnd, BOOL fShow);

AJCEXPORT	BOOL		WINAPI	AjcBarGetProp		(HWND hwnd, PAJCBARPROP	 pBuf);
AJCEXPORT	BOOL		WINAPI	AjcBarSetProp		(HWND hwnd, PCAJCBARPROP pProp);

AJCEXPORT	BOOL		WINAPI	AjcBarGetRealRange	(HWND hwnd, double *pLow, double *pHigh);
AJCEXPORT	BOOL		WINAPI	AjcBarSetRealRange	(HWND hwnd, double	 low, double   high);
AJCEXPORT	BOOL		WINAPI	AjcBarGetIntRange	(HWND hwnd, int	   *pLow, int	*pHigh);
AJCEXPORT	BOOL		WINAPI	AjcBarSetIntRange	(HWND hwnd, int		 low, int	  high);
AJCEXPORT	BOOL		WINAPI	AjcBarGetRealBase	(HWND hwnd, double *base);
AJCEXPORT	BOOL		WINAPI	AjcBarSetRealBase	(HWND hwnd, double	base);
AJCEXPORT	BOOL		WINAPI	AjcBarGetIntBase	(HWND hwnd, int	   *base);
AJCEXPORT	BOOL		WINAPI	AjcBarSetIntBase	(HWND hwnd, int		base);
AJCEXPORT	BOOL		WINAPI	AjcBarSetBufSize	(HWND hwnd, int n);
AJCEXPORT	BOOL		WINAPI	AjcBarSetItemNumber (HWND hwnd, int n);
AJCEXPORT	BOOL		WINAPI	AjcBarSetScaleWidth (HWND hwnd, int width);
AJCEXPORT	BOOL		WINAPI	AjcBarSetBarWidth	(HWND hwnd, int width);
AJCEXPORT	BOOL		WINAPI	AjcBarSetItemWidth	(HWND hwnd, int width);
AJCEXPORT	BOOL		WINAPI	AjcBarSetTtlLines	(HWND hwnd, int lines);

AJCEXPORT	HBITMAP		WINAPI	AjcBarGetBitmap		(HWND hwnd);

AJCEXPORT	BOOL		WINAPI	AjcBarLoadPropA		(HWND hwnd, C_BCP pProfileSect, PCAJCBARPROP pDefProp);
AJCEXPORT	BOOL		WINAPI	AjcBarLoadPropW		(HWND hwnd, C_WCP pProfileSect, PCAJCBARPROP pDefProp);

AJCEXPORT	BOOL		WINAPI	AjcBarSavePropA		(HWND hwnd, C_BCP pProfileSect);
AJCEXPORT	BOOL		WINAPI	AjcBarSavePropW		(HWND hwnd, C_WCP pProfileSect);

AJCEXPORT	BOOL		WINAPI	AjcBarLoadPropExA	(HWND hwnd, C_BCP pProfileSect, PCAJCBARPROP pDefProp);
AJCEXPORT	BOOL		WINAPI	AjcBarLoadPropExW	(HWND hwnd, C_WCP pProfileSect, PCAJCBARPROP pDefProp);

AJCEXPORT	BOOL		WINAPI	AjcBarSavePropExA	(HWND hwnd, C_BCP pProfileSect);
AJCEXPORT	BOOL		WINAPI	AjcBarSavePropExW	(HWND hwnd, C_WCP pProfileSect);

AJCEXPORT	BOOL		WINAPI	AjcBarEnablePopupMenu(HWND hwnd, BOOL fEnable);		//	非公開
AJCEXPORT	BOOL		WINAPI	AjcBarSetNtcRClk	 (HWND hwnd, BOOL fNtcRClk, UI MsgRBDown, UI MsgRBUp);

AJCEXPORT	BOOL		WINAPI	AjcBarSetTipTextA (HWND hwnd, C_BCP pTxt);
AJCEXPORT	BOOL		WINAPI	AjcBarSetTipTextW (HWND hwnd, C_WCP pTxt);

AJCEXPORT	UI			WINAPI	AjcBarGetTipTextA (HWND hwnd, BCP pBuf, UI lBuf);
AJCEXPORT	UI			WINAPI	AjcBarGetTipTextW (HWND hwnd, WCP pBuf, UI lBuf);

AJCEXPORT	BOOL		WINAPI	AjcBarSetTipShowAlways(HWND hwnd, BOOL fShowAlways);
AJCEXPORT	BOOL		WINAPI	AjcBarGetTipShowAlways(HWND hwnd);

AJCEXPORT	BOOL		WINAPI	AjcBarSetChkBoxTipShowAlways(HWND hwnd, UI n, BOOL fShowAlways);
AJCEXPORT	BOOL		WINAPI	AjcBarGetChkBoxTipShowAlways(HWND hwnd, UI n);

AJCEXPORT	BOOL		WINAPI	AjcBarSetTipShowAlwaysAll(HWND hwnd, BOOL fShowAlways);

AJCEXPORT	BOOL		WINAPI	AjcBarSetChkBoxTipTextA(HWND hwnd, UI n, C_BCP pTxt);
AJCEXPORT	BOOL		WINAPI	AjcBarSetChkBoxTipTextW(HWND hwnd, UI n, C_WCP pTxt);

AJCEXPORT	UI			WINAPI	AjcBarGetChkBoxTipTextA(HWND hwnd, UI n, BCP pBuf, UI lBuf);
AJCEXPORT	UI			WINAPI	AjcBarGetChkBoxTipTextW(HWND hwnd, UI n, WCP pBuf, UI lBuf);

AJCEXPORT	int			WINAPI	AjcBarGetScrollPos	(HWND hwnd);
AJCEXPORT	BOOL		WINAPI	AjcBarSetScrollPos	(HWND hwnd, int pos);

AJCEXPORT	BOOL		WINAPI	AjcBarSetFilter		(HWND hwnd, UI n, BOOL state);
AJCEXPORT	BOOL		WINAPI	AjcBarGetFilter		(HWND hwnd, UI n);

AJCEXPORT	BOOL		WINAPI	AjcBarSetHLineAtt (HWND hwnd, UI id, COLORREF color, int width, int style);
AJCEXPORT	BOOL		WINAPI	AjcBarSetHLinePos (HWND hwnd, UI id, double pos);
AJCEXPORT	BOOL		WINAPI	AjcBarEnableHLine (HWND hwnd, UI id, BOOL fEnable);

AJCEXPORT	BOOL		WINAPI	AjcBarGetCharSize (HWND hwnd, LPSIZE pSize);

AJCEXPORT	BOOL		WINAPI	AjcBarGetDroppedFileA(HWND hwnd, BC buf[MAX_PATH]);
AJCEXPORT	BOOL		WINAPI	AjcBarGetDroppedFileW(HWND hwnd, WC buf[MAX_PATH]);

AJCEXPORT	BOOL		WINAPI	AjcBarGetDroppedDirA  (HWND hwnd, BC buf[MAX_PATH]);
AJCEXPORT	BOOL		WINAPI	AjcBarGetDroppedDirW  (HWND hwnd, WC buf[MAX_PATH]);

AJCEXPORT	BOOL		WINAPI	AjcBarGetDroppedDirExA(HWND hwnd, BC buf[MAX_PATH], BOOL fTailIsDelimiter);
AJCEXPORT	BOOL		WINAPI	AjcBarGetDroppedDirExW(HWND hwnd, WC buf[MAX_PATH], BOOL fTailIsDelimiter);

AJCEXPORT	BOOL		WINAPI	AjcBarSetTitleTextA(HWND hwnd, C_BCP pTitleText, COLORREF TextColor, COLORREF BackColor, HFONT hFont);
AJCEXPORT	BOOL		WINAPI	AjcBarSetTitleTextW(HWND hwnd, C_WCP pTitleText, COLORREF TextColor, COLORREF BackColor, HFONT hFont);

AJCEXPORT	HFONT		WINAPI	AjcBarSetTextFont	(HWND hwnd, HFONT hFont);

AJCEXPORT	UI			WINAPI	AjcBarTextOutA		(HWND hwnd, int x, int y, C_BCP pTxt);
AJCEXPORT	UI			WINAPI	AjcBarTextOutW		(HWND hwnd, int x, int y, C_WCP pTxt);

AJCEXPORT	UI			WINAPI	AjcBarPrintFA		(HWND hwnd, int x, int y, C_BCP pFmt, ...);
AJCEXPORT	UI			WINAPI	AjcBarPrintFW		(HWND hwnd, int x, int y, C_WCP pFmt, ...);

AJCEXPORT	UI			WINAPI	AjcBarGetTextA		(HWND hwnd, UI key, BCP pBuf, UI lBuf);
AJCEXPORT	UI			WINAPI	AjcBarGetTextW		(HWND hwnd, UI key, WCP pBuf, UI lBuf);

AJCEXPORT	BOOL		WINAPI	AjcBarClearText		(HWND hwnd, UI key);
AJCEXPORT	BOOL		WINAPI	AjcBarClearAllText	(HWND hwnd);

AJCEXPORT	BOOL		WINAPI	AjcBarClear			(HWND hwnd);

AJCEXPORT	HWND		WINAPI	AjcBarGetMainWindow (HWND hwnd, COLORREF *pBkGnd);

//----- 通知情報取得 -------------------------------------------------------------------------------------------//
AJCEXPORT	PAJCBARRCLK			WINAPI	AjcBarGetNtcRClk	(HWND hwnd);
AJCEXPORT	UI					WINAPI	AjcBarGetNtcDirs	(HWND hwnd);
AJCEXPORT	UI					WINAPI	AjcBarGetNtcFiles	(HWND hwnd);
AJCEXPORT	PAJCBAR_NTC_RANGE	WINAPI	AjcBarGetNtcRng		(HWND hwnd);
AJCEXPORT	UI					WINAPI	AjcBarGetNtcScrPos	(HWND hwnd);

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	ＭＳＩＬ用ウインド生成																						//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
AJCEXPORT HWND WINAPI AjcBarCreateForMSIL(HWND hOwner, BOOL fShowScrollBar, VO (CALLBACK *cbRengeChanged)(double low, double high),
																			VO (CALLBACK *cbNtcScrollPos)(UI pos),
																			VO (CALLBACK *cbFileDrop	)(UI n	 ),
																			VO (CALLBACK *cbDirDrop 	)(UI n	 ),
																			VO (CALLBACK *cbRClick)(int x, int y, BOOL shift, BOOL ctrl));
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	ＭＳＩＬ用スタイルの設定／取得関数																			//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//----- コントロールの外枠・非表示／表示	(AJCTCS_NOBORDER) --------------------------------------------------//
AJCEXPORT BOOL WINAPI AjcBarGetSty_NOBORDER    (HWND hwnd		 );
AJCEXPORT VO   WINAPI AjcBarSetSty_NOBORDER    (HWND hwnd, BOOL f);

//----- 折れ線グラフモード					(AJCBARS_LINEGRAPH) ------------------------------------------------//
AJCEXPORT BOOL WINAPI AjcBarGetSty_LINEGRAPH   (HWND hwnd		 );
AJCEXPORT VO   WINAPI AjcBarSetSty_LINEGRAPH   (HWND hwnd, BOOL f);

//----- フィルタ非表示／表示				(AJCTCS_NOFILTER) --------------------------------------------------//
AJCEXPORT BOOL WINAPI AjcBarGetSty_NOFILTER		(HWND hwnd		  );
AJCEXPORT VO   WINAPI AjcBarSetSty_NOFILTER		(HWND hwnd, BOOL f);


//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	ＭＳＩＬ用プロパティの設定／取得関数																		//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//----- 低位レンジ値 		(RngL) -----------------------------------------------------------------------------//
AJCEXPORT double WINAPI AjcBarGetProp_RngL(HWND hwnd);
AJCEXPORT VO	 WINAPI AjcBarSetProp_RngL(HWND hwnd, double n);

//----- 高位レンジ値 		(RngH) -----------------------------------------------------------------------------//
AJCEXPORT double WINAPI AjcBarGetProp_RngH(HWND hwnd);
AJCEXPORT VO	 WINAPI AjcBarSetProp_RngH(HWND hwnd, double n);

//----- ベース値 			(Base) -----------------------------------------------------------------------------//
AJCEXPORT double WINAPI AjcBarGetProp_Base(HWND hwnd);
AJCEXPORT VO	 WINAPI AjcBarSetProp_Base(HWND hwnd, double n);

//----- バッファ容量		(MaxBuf) ---------------------------------------------------------------------------//
AJCEXPORT UI	 WINAPI AjcBarGetProp_MaxBuf(HWND hwnd);
AJCEXPORT VO	 WINAPI AjcBarSetProp_MaxBuf(HWND hwnd, UI n);

//----- 最大データ項目数	(MaxItem) --------------------------------------------------------------------------//
AJCEXPORT UI	 WINAPI AjcBarGetProp_MaxItem(HWND hwnd);
AJCEXPORT VO	 WINAPI AjcBarSetProp_MaxItem(HWND hwnd, UI n);

//----- スケール値表示息の幅(ScaleWidth) -----------------------------------------------------------------------//
AJCEXPORT UI	 WINAPI AjcBarGetProp_ScaleWidth(HWND hwnd);
AJCEXPORT VO	 WINAPI AjcBarSetProp_ScaleWidth(HWND hwnd, UI n);

//----- 棒の幅				(BarWidth) -------------------------------------------------------------------------//
AJCEXPORT UI	 WINAPI AjcBarGetProp_BarWidth(HWND hwnd);
AJCEXPORT VO	 WINAPI AjcBarSetProp_BarWidth(HWND hwnd, UI n);

//----- 棒タイトルの行幅	(MinWidth) -------------------------------------------------------------------------//
AJCEXPORT UI	 WINAPI AjcBarGetProp_MinWidth(HWND hwnd);
AJCEXPORT VO	 WINAPI AjcBarSetProp_MinWidth(HWND hwnd, UI n);

//----- 棒タイトルの行数	(BarTtlLines) ----------------------------------------------------------------------//
AJCEXPORT UI	 WINAPI AjcBarGetProp_BarTtlLines(HWND hwnd);
AJCEXPORT VO	 WINAPI AjcBarSetProp_BarTtlLines(HWND hwnd, UI n);

//----- 表示色				(rgb[]) ----------------------------------------------------------------------------//
AJCEXPORT UI	 WINAPI AjcBarGetProp_rgb(HWND hwnd, UI ix);
AJCEXPORT VO	 WINAPI AjcBarSetProp_rgb(HWND hwnd, UI ix, UI n);

//----- 文字の幅 -----------------------------------------------------------------------------------------------//
AJCEXPORT UI WINAPI AjcBarGetProp_CharWidth(HWND hwnd);

//----- 文字の高さ ---------------------------------------------------------------------------------------------//
AJCEXPORT UI WINAPI AjcBarGetProp_CharHeight(HWND hwnd);

//----- ウインドサイズ -----------------------------------------------------------------------------------------//
AJCEXPORT VO WINAPI AjcBarSetProp_WndSize(HWND hwnd, UI width, UI height);

//----- ファイル，フォルダ ドロップの許可／禁止 ----------------------------------------------------------------//
AJCEXPORT VO	WINAPI AjcBarSetProp_AcceptFiles(HWND hwnd, BOOL fEnable);
AJCEXPORT BOOL	WINAPI AjcBarGetProp_AcceptFiles(HWND hwnd);

//----- データ投与 ---------------------------------------------------------------------------------------------//
AJCEXPORT VO WINAPI	AjcBarPutData1	(HWND hwnd, C_WCP pBarTtl, double dat0);
AJCEXPORT VO WINAPI	AjcBarPutData2	(HWND hwnd, C_WCP pBarTtl, double dat0, double dat1);
AJCEXPORT VO WINAPI	AjcBarPutData3	(HWND hwnd, C_WCP pBarTtl, double dat0, double dat1, double dat2);
AJCEXPORT VO WINAPI	AjcBarPutData4	(HWND hwnd, C_WCP pBarTtl, double dat0, double dat1, double dat2, double dat3);
AJCEXPORT VO WINAPI	AjcBarPutData5	(HWND hwnd, C_WCP pBarTtl, double dat0, double dat1, double dat2, double dat3, double dat4);
AJCEXPORT VO WINAPI	AjcBarPutData6	(HWND hwnd, C_WCP pBarTtl, double dat0, double dat1, double dat2, double dat3, double dat4, double dat5);
AJCEXPORT VO WINAPI	AjcBarPutData7	(HWND hwnd, C_WCP pBarTtl, double dat0, double dat1, double dat2, double dat3, double dat4, double dat5, double dat6);
AJCEXPORT VO WINAPI	AjcBarPutData8	(HWND hwnd, C_WCP pBarTtl, double dat0, double dat1, double dat2, double dat3, double dat4, double dat5, double dat6, double dat7);

//----- チップテキスト設定／取得 -------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcBarSetTipTextForMSIL(HWND hwnd, C_WCP pTxt);
AJCEXPORT	UI		WINAPI	AjcBarGetTipTextForMSIL(HWND hwnd, WCP pBuf, UI lBuf);

AJCEXPORT	BOOL	WINAPI	AjcBarSetChkBoxTipTextForMSIL(HWND hwnd, UI n, C_WCP pTxt);
AJCEXPORT	UI		WINAPI	AjcBarGetChkBoxTipTextForMSIL(HWND hwnd, UI n, WCP pBuf, UI lBuf);

/****************************************************************************************************************/
#endif
