﻿#ifndef	AJCCTRLLISTBOX_H_
#define	AJCCTRLLISTBOX_H_
/****************************************************************************************************************/
//--------------------------------------------------------------------------------------------------------------//
//	ＵＮＩＣＯＤＥ／ＡＳＣＩＩ																					//
//--------------------------------------------------------------------------------------------------------------//
#ifdef	UNICODE
	#define	AjcLbxGetAllItems		AjcLbxGetAllItemsW
	#define	AjcLbxGetSelectedItems	AjcLbxGetSelectedItemsW
	#define	AjcLbxLoadPermInfo		AjcLbxLoadPermInfoW
	#define	AjcLbxSavePermInfoEx	AjcLbxSavePermInfoExW
	#define	AjcLbxSetPermAtt		AjcLbxSetPermAttW
	#define	AjcLbxLoadItems			AjcLbxLoadItemsW
	#define	AjcLbxSaveItems			AjcLbxSaveItemsW
	#define	AjcLbxSetTipText 		AjcLbxSetTipTextW
	#define	AjcLbxGetTipText 		AjcLbxGetTipTextW
	#define	AjcLbxAddString			AjcLbxAddStringW
	#define	AjcLbxInsertString		AjcLbxInsertStringW
	#define	AjcLbxSetList			AjcLbxSetListW
	#define	AjcLbxFindString		AjcLbxFindStringW
	#define	AjcLbxGetText			AjcLbxGetTextW
	#define	AjcLbxGetTextLen		AjcLbxGetTextLenW
	#define	AjcLbxSelectString		AjcLbxSelectStringW
	#define	AjcLbxSetBasePath		AjcLbxSetBasePathW
	#define	AjcLbxSetFileFilter		AjcLbxSetFileFilterW
	#define	AjcLbxGetDroppedFile	AjcLbxGetDroppedFileW
	#define	AjcLbxGetDroppedDir		AjcLbxGetDroppedDirW
	#define	AjcLbxGetDroppedDirEx	AjcLbxGetDroppedDirExW
	#define	AjcLbxGetRemovedItem	AjcLbxGetRemovedItemW
#else
	#define	AjcLbxGetAllItems		AjcLbxGetAllItemsA
	#define	AjcLbxGetSelectedItems	AjcLbxGetSelectedItemsA
	#define	AjcLbxLoadPermInfo		AjcLbxLoadPermInfoA
	#define	AjcLbxSavePermInfoEx	AjcLbxSavePermInfoExA
	#define	AjcLbxSetPermAtt		AjcLbxSetPermAttA
	#define	AjcLbxLoadItems			AjcLbxLoadItemsA
	#define	AjcLbxSaveItems			AjcLbxSaveItemsA
	#define	AjcLbxSetTipText 		AjcLbxSetTipTextA
	#define	AjcLbxGetTipText 		AjcLbxGetTipTextA
	#define	AjcLbxAddString			AjcLbxAddStringA
	#define	AjcLbxInsertString		AjcLbxInsertStringA
	#define	AjcLbxSetList			AjcLbxSetListA
	#define	AjcLbxFindString		AjcLbxFindStringA
	#define	AjcLbxGetText			AjcLbxGetTextA
	#define	AjcLbxGetTextLen		AjcLbxGetTextLenA
	#define	AjcLbxSelectString		AjcLbxSelectStringA
	#define	AjcLbxSetBasePath		AjcLbxSetBasePathA
	#define	AjcLbxSetFileFilter		AjcLbxSetFileFilterA
	#define	AjcLbxGetDroppedFile	AjcLbxGetDroppedFileA
	#define	AjcLbxGetDroppedDir		AjcLbxGetDroppedDirA
	#define	AjcLbxGetDroppedDirEx	AjcLbxGetDroppedDirExA
	#define	AjcLbxGetRemovedItem	AjcLbxGetRemovedItemA
#endif

//--------------------------------------------------------------------------------------------------------------//
//	項目の最大文字列長（文字列終端を含む長さ）																	//
//--------------------------------------------------------------------------------------------------------------//
#define		AJCLBX_MAXSTL		1024

//--------------------------------------------------------------------------------------------------------------//
//	コントロールのスタイル																						//
//--------------------------------------------------------------------------------------------------------------//
#define	AJCLBXS_RIGHT			0x8000				//	Bit15: 右詰め表示（ウインド生成時のみ有効）
//								0x4000				//	－
#define	AJCLBXS_TRIM			0x2000				//	Bit13: 項目の前後の空白を除去する
#define	AJCLBXS_FILE			0x1000				//	Bit12: リスト項目としてファイル／フォルダを扱う場合に指定します。
													//			・相対パスと絶対パスの変換を有効化（ベースパス設定時のみ）
													//			・AJCLBXS_DIRPATH/AJCLBXS_FILEPATHを有効化

#define	AJCLBXS_DIRTAIL			0x0800				//	Bit11: ディレクトリ名の末尾に「\」を付加する
#define	AJCLBXS_ADDITEMINDROP	0x0400				//	Bit10: ファイル／ディレクトリドロップでリストボックス項目を追加
#define	AJCLBXS_ACCEPTDIRS		0x0200				//	Bit9 : ディレクトリのドラッグ＆ドロップを可能にする
#define	AJCLBXS_ACCEPTFILES		0x0100				//	Bit8 : ファイルのドラッグ＆ドロップを可能にする
#define	AJCLBXS_ACCEPTALL		(AJCLBXS_ACCEPTDIRS | AJCLBXS_ACCEPTFILES)

//								0x0080				//	－
//								0x0040				//	－

#define	AJCLBXS_DIRPATH			0x0020				//	Bit5 : 項目の追加／編集時にディレクトリパスを選択可能とする（AJCLBXS_FILE有効時）
#define	AJCLBXS_FILEPATH		0x0010				//	Bit4 : 項目の追加／編集時にファイルパスを選択可能とする    （AJCLBXS_FILE有効時）
#define	AJCLBXS_PATHALL			(AJCLBXS_DIRPATH | AJCLBXS_FILEPATH)

#define	AJCLBXS_SORT_EXACT		0x0008				//	Bit3  : COMP_EXACT & SORT 指定時、厳密な昇順ソートする
#define	AJCLBXS_COMP_EXACT		0x0004				//	Bit2  : 英字の大小を区別して比較する
#define	AJCLBXS_SINGLE			0x0002				//	Bit1  : 単一選択モード　　　　　　（ウインド生成時のみ有効）
#define	AJCLBXS_SORT			0x0001				//	Bit0  : アイテム追加時にソートする（ウインド生成時のみ有効）

#define	AJCLBXS_STD_FILE		(AJCLBXS_FILE | 				  AJCLBXS_ADDITEMINDROP | AJCLBXS_ACCEPTFILES | AJCLBXS_FILEPATH)
#define	AJCLBXS_STD_DIR			(AJCLBXS_FILE | AJCLBXS_DIRTAIL | AJCLBXS_ADDITEMINDROP | AJCLBXS_ACCEPTDIRS  | AJCLBXS_DIRPATH )
#define	AJCLBXS_STD_FILEDIR		(AJCLBXS_FILE | AJCLBXS_DIRTAIL | AJCLBXS_ADDITEMINDROP | AJCLBXS_ACCEPTALL   | AJCLBXS_PATHALL )
#define	AJCLBXS_STD_TEXT		(AJCLBXS_COMP_EXACT)

#define	AJCLBXS_STD_FILE_S		(AJCLBXS_STD_FILE	 | AJCLBXS_SORT)
#define	AJCLBXS_STD_DIR_S		(AJCLBXS_STD_DIR	 | AJCLBXS_SORT)
#define	AJCLBXS_STD_FILEDIR_S	(AJCLBXS_STD_FILEDIR | AJCLBXS_SORT)
#define	AJCLBXS_STD_TEXT_S		(AJCLBXS_SORT_EXACT | AJCLBXS_COMP_EXACT | AJCLBXS_SORT)

//--------------------------------------------------------------------------------------------------------------//
//	ポップアップメニューのマスク																				//
//--------------------------------------------------------------------------------------------------------------//
#define	AJCLBXMM_EDTITEM		0x00000001		//	項目編集
#define	AJCLBXMM_ADDITEM		0x00000002		//	項目追加
#define	AJCLBXMM_SELALL			0x00000004		//	全て選択
#define	AJCLBXMM_DESELALL		0x00000008		//	選択解除
#define	AJCLBXMM_DELETE			0x00000010		//	選択項目削除
#define	AJCLBXMM_CLEAR			0x00000020		//	リセット
#define	AJCLBXMM_COPYALL		0x00000040		//	全てコピー
#define	AJCLBXMM_COPYSEL		0x00000080		//	選択項目コピー
#define	AJCLBXMM_PASTE			0x00000100		//	貼り付け
#define	AJCLBXMM_ADDFILES		0x00000200		//	ファイル追加
#define	AJCLBXMM_TO_RELATIVE	0x00000400		//	相対パスに変更
#define	AJCLBXMM_TO_ABSOLUTE	0x00000800		//	絶対パスに変更

#define	AJCLBXMM_ALL			0x00000FFF		//	全項目

//--------------------------------------------------------------------------------------------------------------//
//	コントロールの通知メッセージ																				//
//--------------------------------------------------------------------------------------------------------------//
#define	AJCLBXN_DBLCLK			LBN_DBLCLK			//	ダブルクリック通知
#define	AJCLBXN_ERRSPACE		LBN_ERRSPACE		//	メモリ不足通知
#define	AJCLBXN_KILLFOCUS		LBN_KILLFOCUS		//	フォーカス喪失通知
#define	AJCLBXN_SELCANCEL		LBN_SELCANCEL		//	選択キャンセル通知
#define	AJCLBXN_SELCHANGE		LBN_SELCHANGE		//	選択変更通知
#define	AJCLBXN_SETFOCUS		LBN_SETFOCUS		//	フォーカス取得通知
#define	AJCLBXN_RCLICK			(WM_APP + 90)		//	右クリック通知
#define	AJCLBXN_REMOVED			(WM_APP + 91)		//	削除通知
#define	AJCLBXN_DROPDIR			(WM_APP + 92)		//	ディレクトリドロップ通知
#define	AJCLBXN_DROPFILE		(WM_APP + 93)		//	ファイルドロップ通知
#define	AJCLBXN_LISTSTYLE		(WM_APP + 94)		//	リストボックスのスタイル問い合わせ

#define	AJCLBXN_DIRDROPPED		AJCLBXN_DROPDIR		//	ディレクトリドロップ通知（旧バージョンとの互換性維持）
#define	AJCLBXN_FILEDROPPED		AJCLBXN_DROPFILE	//	ファイルドロップ通知	（旧バージョンとの互換性維持）

//--------------------------------------------------------------------------------------------------------------//
//	右クリック通知情報																							//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	int			x;									//	カーソルｘ座標
	int			y;									//	カーソルｙ座標
	BOOL		fShift;								//	SHIFTキー押下フラグ
	BOOL		fCtrl;								//	CTRL キー押下フラグ
} AJCLBXRCLK, *PAJCLBXRCLK;
typedef const AJCLBXRCLK *PCAJCLBXRCLK;

//--------------------------------------------------------------------------------------------------------------//
//	項目データ																									//
//--------------------------------------------------------------------------------------------------------------//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
typedef struct {
	BCP		pStr;
	UX		data;
} AJCLBXITEMA, *PAJCLBXITEMA;
typedef const AJCLBXITEMA *PCAJCLBXITEMA;
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
typedef struct {
	WCP		pStr;
	UX		data;
} AJCLBXITEMW, *PAJCLBXITEMW;
typedef const AJCLBXITEMW *PCAJCLBXITEMW;
//----- ＵＮＩＣＯＤＥ／ＡＳＣＩＩ------------------------------------------------------------------------------//
#ifdef	UNICODE
	#define		AJCLBXITEM		AJCLBXITEMW
	#define		PAJCLBXITEM		PAJCLBXITEMW
	#define		PCAJCLBXITEM	PCAJCLBXITEMW
#else
	#define		AJCLBXITEM		AJCLBXITEMA
	#define		PAJCLBXITEM		PAJCLBXITEMA
	#define		PCAJCLBXITEM	PCAJCLBXITEMA
#endif

//--------------------------------------------------------------------------------------------------------------//
//	リストボックス設定スタイル																					//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	UI		sty;		//	スタイル
	UI		exs;		//	拡張スタイル
} AJCLBXLSTSTY, *PAJCLBXLSTSTY;
typedef const AJCLBXLSTSTY *PCAJCLBXLSTSTY;

//--------------------------------------------------------------------------------------------------------------//
//	プロトタイプ																								//
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT PAJCLBXITEMA	WINAPI	AjcLbxGetAllItemsA	(HWND hwnd, UIP pCount);
AJCEXPORT PAJCLBXITEMW	WINAPI	AjcLbxGetAllItemsW	(HWND hwnd, UIP pCount);

AJCEXPORT VO			WINAPI	AjcLbxRelAllItems	(VOP pAllItemBuf);

AJCEXPORT PAJCLBXITEMA	WINAPI	AjcLbxGetSelectedItemsA	(HWND hwnd, UIP pCount);
AJCEXPORT PAJCLBXITEMW	WINAPI	AjcLbxGetSelectedItemsW	(HWND hwnd, UIP pCount);

AJCEXPORT VO			WINAPI	AjcLbxRelSelectedItems	(VOP pSelectedItemBuf);

AJCEXPORT BOOL			WINAPI	AjcLbxLoadPermInfoA (HWND hwnd, C_BCP pProfileSect, C_BCP pKeyPrefix);
AJCEXPORT BOOL			WINAPI	AjcLbxLoadPermInfoW (HWND hwnd, C_WCP pProfileSect, C_WCP pKeyPrefix);

AJCEXPORT BOOL			WINAPI	AjcLbxSavePermInfo	(HWND hwnd);

AJCEXPORT BOOL			WINAPI	AjcLbxSavePermInfoExA(HWND hwnd, C_BCP pProfileSect, C_BCP pKeyPrefix);
AJCEXPORT BOOL			WINAPI	AjcLbxSavePermInfoExW(HWND hwnd, C_WCP pProfileSect, C_WCP pKeyPrefix);

AJCEXPORT BOOL			WINAPI	AjcLbxSetPermAttA  (HWND hwnd, C_BCP pProfileSect, C_BCP pKeyPrefix);
AJCEXPORT BOOL			WINAPI	AjcLbxSetPermAttW  (HWND hwnd, C_WCP pProfileSect, C_WCP pKeyPrefix);

AJCEXPORT BOOL			WINAPI	AjcLbxLoadItemsA	(HWND hwnd, C_BCP pProfileSect, C_BCP pKeyPrefix);
AJCEXPORT BOOL			WINAPI	AjcLbxLoadItemsW	(HWND hwnd, C_WCP pProfileSect, C_WCP pKeyPrefix);

AJCEXPORT BOOL			WINAPI	AjcLbxSaveItemsA	(HWND hwnd, C_BCP pProfileSect, C_BCP pKeyPrefix);
AJCEXPORT BOOL			WINAPI	AjcLbxSaveItemsW	(HWND hwnd, C_WCP pProfileSect, C_WCP pKeyPrefix);


AJCEXPORT BOOL			WINAPI	AjcLbxSetTipTextA (HWND hwnd, C_BCP pTxt);
AJCEXPORT BOOL			WINAPI	AjcLbxSetTipTextW (HWND hwnd, C_WCP pTxt);

AJCEXPORT BOOL			WINAPI	AjcLbxGetTipTextA (HWND hwnd, BCP pBuf, UI lBuf);
AJCEXPORT BOOL			WINAPI	AjcLbxGetTipTextW (HWND hwnd, WCP pBuf, UI lBuf);

AJCEXPORT BOOL			WINAPI	AjcLbxSetTipShowAlways(HWND hwnd, BOOL fShowAlways);
AJCEXPORT BOOL			WINAPI	AjcLbxGetTipShowAlways(HWND hwnd);

AJCEXPORT int	 WINAPI	AjcLbxAddStringA		(HWND hwnd, C_BCP pStr);
AJCEXPORT int	 WINAPI	AjcLbxAddStringW		(HWND hwnd, C_WCP pStr);

AJCEXPORT int	 WINAPI	AjcLbxInsertStringA		(HWND hwnd, UI ix, C_BCP pStr);
AJCEXPORT int	 WINAPI	AjcLbxInsertStringW		(HWND hwnd, UI ix, C_WCP pStr);

AJCEXPORT int	 WINAPI	AjcLbxSetListA			(HWND hwnd, C_BCP pList);
AJCEXPORT int	 WINAPI	AjcLbxSetListW			(HWND hwnd, C_WCP pList);

AJCEXPORT int	 WINAPI	AjcLbxDeleteString		(HWND hwnd, UI ix);

AJCEXPORT int	 WINAPI	AjcLbxFindStringA		(HWND hwnd, UI ix, C_BCP pStr);
AJCEXPORT int	 WINAPI	AjcLbxFindStringW		(HWND hwnd, UI ix, C_WCP pStr);

AJCEXPORT int	 WINAPI	AjcLbxGetCount			(HWND hwnd);

AJCEXPORT int	 WINAPI	AjcLbxGetCurSel			(HWND hwnd);
AJCEXPORT BOOL	 WINAPI	AjcLbxGetSel			(HWND hwnd, UI ix);
AJCEXPORT int	 WINAPI	AjcLbxGetSelCount		(HWND hwnd);

AJCEXPORT BOOL	 WINAPI	AjcLbxGetTextA			(HWND hwnd, UI ix, BCP pBuf, UI lBuf);
AJCEXPORT BOOL	 WINAPI	AjcLbxGetTextW			(HWND hwnd, UI ix, WCP pBuf, UI lBuf);

AJCEXPORT int	 WINAPI	AjcLbxGetTextLenA		(HWND hwnd, UI ix);
AJCEXPORT int	 WINAPI	AjcLbxGetTextLenW		(HWND hwnd, UI ix);

AJCEXPORT BOOL	 WINAPI	AjcLbxResetContent		(HWND hwnd);

AJCEXPORT int	 WINAPI	AjcLbxSelectStringA		(HWND hwnd, UI ix, C_BCP pStr);
AJCEXPORT int	 WINAPI	AjcLbxSelectStringW		(HWND hwnd, UI ix, C_WCP pStr);

AJCEXPORT BOOL	 WINAPI	AjcLbxSetCount			(HWND hwnd, UI count);
AJCEXPORT BOOL	 WINAPI	AjcLbxSetCurSel			(HWND hwnd, UI ix);
AJCEXPORT BOOL	 WINAPI	AjcLbxSetSel			(HWND hwnd, UI ix, BOOL fSelect);

AJCEXPORT BOOL	 WINAPI	AjcLbxSetItemData		(HWND hwnd, UI ix, UX data);
AJCEXPORT UX	 WINAPI	AjcLbxGetItemData		(HWND hwnd, UI ix);

AJCEXPORT BOOL	 WINAPI	AjcLbxSetBasePathA		(HWND hwnd, C_BCP pBasePath);
AJCEXPORT BOOL	 WINAPI	AjcLbxSetBasePathW		(HWND hwnd, C_WCP pBasePath);

AJCEXPORT BOOL	 WINAPI AjcLbxSelMenuItems(HWND hwnd, UI sel);
AJCEXPORT BOOL	 WINAPI AjcLbxExcMenuItems(HWND hwnd, UI exc);

AJCEXPORT BOOL	 WINAPI AjcLbxEnablePopupMenu	(HWND hwnd, BOOL fEnable);
AJCEXPORT BOOL	 WINAPI	AjcLbxSetNtcRClk		(HWND hwnd, BOOL fNtcRClk, UI MsgRBDown, UI MsgRBUp);

AJCEXPORT BOOL	WINAPI	AjcLbxSetFileFilterA(HWND hwnd, C_BCP pFilter, C_BCP pDefExt);
AJCEXPORT BOOL	WINAPI	AjcLbxSetFileFilterW(HWND hwnd, C_WCP pFilter, C_WCP pDefExt);

AJCEXPORT BOOL	 WINAPI AjcLbxGetDroppedFileA (HWND hwnd, BC buf[MAX_PATH]);
AJCEXPORT BOOL	 WINAPI AjcLbxGetDroppedFileW (HWND hwnd, WC buf[MAX_PATH]);

AJCEXPORT BOOL	 WINAPI AjcLbxGetDroppedDirA  (HWND hwnd, BC buf[MAX_PATH]);
AJCEXPORT BOOL	 WINAPI AjcLbxGetDroppedDirW  (HWND hwnd, WC buf[MAX_PATH]);

AJCEXPORT BOOL	 WINAPI AjcLbxGetDroppedDirExA	(HWND hwnd, BC buf[MAX_PATH], BOOL fTailIsDelimiter);
AJCEXPORT BOOL	 WINAPI AjcLbxGetDroppedDirExW	(HWND hwnd, WC buf[MAX_PATH], BOOL fTailIsDelimiter);

AJCEXPORT BOOL	 WINAPI AjcLbxGetRemovedItemA  (HWND hwnd, BCP pBuf, UI lBuf);
AJCEXPORT BOOL	 WINAPI AjcLbxGetRemovedItemW  (HWND hwnd, WCP pBuf, UI lBuf);

AJCEXPORT BOOL	 WINAPI	AjcLbxSetItemHeight(HWND hwnd, UI ix, UI height);
AJCEXPORT UI	 WINAPI	AjcLbxGetItemHeight(HWND hwnd, UI ix);

AJCEXPORT HWND	 WINAPI	AjcLbxGetLstHandle(HWND hwnd);
AJCEXPORT UI	 WINAPI	AjcLbxGetLstID(HWND hwnd);

AJCEXPORT HWND	 WINAPI	AjcLbxGetMainWindow (HWND hwnd, COLORREF *pBkGnd);

//----- 通知情報取得 -------------------------------------------------------------------------------------------//
AJCEXPORT PAJCLBXLSTSTY	WINAPI	AjcLbxGetListStyle		(HWND hwnd);
AJCEXPORT PAJCLBXRCLK	WINAPI	AjcLbxGetNtcRClk		(HWND hwnd);
AJCEXPORT UI			WINAPI	AjcLbxGetNtcDirs		(HWND hwnd);
AJCEXPORT UI			WINAPI	AjcLbxGetNtcFiles		(HWND hwnd);
AJCEXPORT UI			WINAPI	AjcLbxGetNtcRemovedItems(HWND hwnd);

/****************************************************************************************************************/
#endif
