﻿#ifndef	AJCCTRLTIMECHART_H_
#define	AJCCTRLTIMECHART_H_
/****************************************************************************************************************/
/*--------------------------------------------------------------------------------------------------------------*/
/*	ＵＮＩＣＯＤＥ／ＡＳＣＩＩ																					*/
/*--------------------------------------------------------------------------------------------------------------*/
#ifdef	UNICODE
	#define	AjcTchLoadPermInfo		AjcTchLoadPermInfoW
	#define	AjcTchLoadPermInfoEx	AjcTchLoadPermInfoExW
	#define	AjcTchSavePermInfoEx	AjcTchSavePermInfoExW
	#define	AjcTchSetPermAtt		AjcTchSetPermAttW
	#define	AjcTchSetPermAttEx		AjcTchSetPermAttExW
	#define	AjcTchLoadProp			AjcTchLoadPropW
	#define	AjcTchSaveProp			AjcTchSavePropW
	#define	AjcTchLoadPropEx		AjcTchLoadPropExW
	#define	AjcTchSavePropEx		AjcTchSavePropExW
	#define	AjcTchSetTipText		AjcTchSetTipTextW
	#define	AjcTchGetTipText		AjcTchGetTipTextW
	#define	AjcTchSetChkBoxTipText	AjcTchSetChkBoxTipTextW
	#define	AjcTchGetChkBoxTipText	AjcTchGetChkBoxTipTextW
	#define	AjcTchGetDroppedFile	AjcTchGetDroppedFileW
	#define	AjcTchGetDroppedDir		AjcTchGetDroppedDirW
	#define	AjcTchGetDroppedDirEx	AjcTchGetDroppedDirExW
	#define	AjcTchSetTitleText		AjcTchSetTitleTextW
	#define	AjcTchTextOut			AjcTchTextOutW
	#define	AjcTchPrintF			AjcTchPrintFW
	#define	AjcTchGetText			AjcTchGetTextW
#else
	#define	AjcTchLoadPermInfo		AjcTchLoadPermInfoA
	#define	AjcTchLoadPermInfoEx	AjcTchLoadPermInfoExA
	#define	AjcTchSavePermInfoEx	AjcTchSavePermInfoExA
	#define	AjcTchSetPermAtt		AjcTchSetPermAttA
	#define	AjcTchSetPermAttEx		AjcTchSetPermAttExA
	#define	AjcTchLoadProp			AjcTchLoadPropA
	#define	AjcTchSaveProp			AjcTchSavePropA
	#define	AjcTchLoadPropEx		AjcTchLoadPropExA
	#define	AjcTchSavePropEx		AjcTchSavePropExA
	#define	AjcTchSetTipText		AjcTchSetTipTextA
	#define	AjcTchGetTipText		AjcTchGetTipTextA
	#define	AjcTchSetChkBoxTipText	AjcTchSetChkBoxTipTextA
	#define	AjcTchGetChkBoxTipText	AjcTchGetChkBoxTipTextA
	#define	AjcTchGetDroppedFile	AjcTchGetDroppedFileA
	#define	AjcTchGetDroppedDir		AjcTchGetDroppedDirA
	#define	AjcTchGetDroppedDirEx	AjcTchGetDroppedDirExA
	#define	AjcTchSetTitleText		AjcTchSetTitleTextA
	#define	AjcTchTextOut			AjcTchTextOutA
	#define	AjcTchPrintF			AjcTchPrintFA
	#define	AjcTchGetText			AjcTchGetTextA
#endif
//--------------------------------------------------------------------------------------------------------------//
//	コントロールのスタイル																						//
//--------------------------------------------------------------------------------------------------------------//
#define	AJCTCS_NOBORDER		0x0080			//	Bit7   : 外枠非表示
#define	AJCTCS_NOSCALELINE	0x0040			//	Bit6   : スケール・ライン非表示
#define	AJCTCS_NOSCALEVALUE	0x0020			//	Bit5   : スケール値非表示
#define	AJCTCS_NOFILTER		0x0010			//	Bit4   : フィルタ非表示
#define	AJCTCS_NOSCROLLBAR	0x0008			//	Bit3   : スクロールバー非表示

//--------------------------------------------------------------------------------------------------------------//
//	波形補間表示種別																							//
//--------------------------------------------------------------------------------------------------------------//
typedef enum {
	AJCTCIPK_WND	 = 0	,				//	表示データ
	AJCTCIPK_ALL			,				//	全データ
	AJCTCIPK_NEW			,				//	最新データ
} AJCTCIPKND;

#define	AJCTCIS_IPKND(X)	(((AJCTCIPKND)(X)) == AJCTCIPK_WND || ((AJCTCIPKND)(X)) == AJCTCIPK_ALL || ((AJCTCIPKND)(X)) == AJCTCIPK_NEW)

//--------------------------------------------------------------------------------------------------------------//
//	波形補間幅																									//
//--------------------------------------------------------------------------------------------------------------//
#define	AJCTCMIN_IPWID		2			//	最小補間幅
#define	AJCTCMAX_IPWID		100			//	最大補間幅

//--------------------------------------------------------------------------------------------------------------//
//	波形補間表示情報																							//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	AJCTCIPKND	IpKnd;					//	波形補間表示種別
	UI			IpNum;					//	最新データ表示時の最大データ数
	UI			IpWidth;				//	補間表示幅（波形の引き伸ばし倍率）
} AJCTCIPINFO, *PAJCTCIPINFO;
typedef const AJCTCIPINFO *PCAJCTCIPINFO;

//--------------------------------------------------------------------------------------------------------------//
//	コントロールのプロパティ																					//
//--------------------------------------------------------------------------------------------------------------//
#define	AJCTC_MAXBUF	100000
#define	AJCTC_MAXITEM	8

typedef struct {
	double		ofs;					//	オフセット（実際のデータ値に加える値）
	COLORREF	rgb;					//	表示色
} AJCTCITEM, *PAJCTCITEM;

typedef struct {
	double		RngL, RngH;				//	グラフ上下の座標値
	UI			TmScale;				//	タイムスケール表示幅（スケール縦線の幅，０は縦線非表示）
	UI			MaxBuf;					//	最大データ数
	UI			MaxItem;				//	最大アイテム数
	UI			AveNum;					//	平均化個数
	AJCTCITEM	Item[AJCTC_MAXITEM];	//	アイテム・プロパティ
} AJCTCPROP, *PAJCTCPROP;
typedef const AJCTCPROP *PCAJCTCPROP;

//--------------------------------------------------------------------------------------------------------------//
//	レンジ通知情報																								//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	double	RngL;		//	グラフレンジ低位値
	double	RngH;		//	グラフレンジ高位値
} AJCTC_NTC_RANGE, *PAJCTC_NTC_RANGE;
typedef const AJCTC_NTC_RANGE *PCAJCTC_NTC_RANGE;

//--------------------------------------------------------------------------------------------------------------//
//	右クリック通知情報																							//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	int			x;									//	カーソルｘ座標
	int			y;									//	カーソルｙ座標
	BOOL		fShift;								//	SHIFTキー押下フラグ
	BOOL		fCtrl;								//	CTRL キー押下フラグ
} AJCTCRCLK, *PAJCTCRCLK;
typedef const AJCTCRCLK *PCAJCTCRCLK;

//--------------------------------------------------------------------------------------------------------------//
//	時間計測ゲージ情報																							//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	BOOL		fGauEnable;							//	ゲージ許可フラグ
	UI			GauBarL;							//	ゲージ低位置
	UI			GauBarH;							//	ゲージ高位置
	BOOL		fGauUseMes;							//	単位時間＝計測値を示すフラグ
	UI			GauSetUTime;						//	単位時間（設定値）[us]
} AJCTCGAUINFO, *PAJCTCGAUINFO;
typedef const AJCTCGAUINFO *PCAJCTCGAUINFO;

//--------------------------------------------------------------------------------------------------------------//
//	横線属性																									//
//--------------------------------------------------------------------------------------------------------------//
#define	AJCTCH_SOLID		PS_SOLID			/*	実線							*/
#define	AJCTCH_DASH			PS_DASH				/*	点線（長）			-------		*/
#define	AJCTCH_DOT			PS_DOT				/*	点線（短）			.......		*/
#define	AJCTCH_DASHDOT		PS_DASHDOT			/*	１点鎖線			_._._._		*/
#define	AJCTCH_DASHDOTDOT	PS_DASHDOTDOT		/*	２点鎖線			_.._.._		*/
#define	AJCTCH_NULL			PS_NULL				/*	空線							*/
#define	AJCTCH_INSIDEFRAME	PS_INSIDEFRAME		/*	インサイドフレーム				*/

//--------------------------------------------------------------------------------------------------------------//
//	永続化項目																									//
//--------------------------------------------------------------------------------------------------------------//
#define	AJCTCH_PERM_FILTER		0x0001	//	フィルタ選択状態
#define	AJCTCH_PERM_RANGE		0x0002	//	レンジ
#define	AJCTCH_PERM_OTHER		0x0080	//	その他

#define	AJCTCH_PERM_ALL			0x00FF	//	上記全て

#define	AJCTCH_PERM_BYLOAD		0x8000	//	ロード時に指定された値を仮定（セーブ時のみ）

//--------------------------------------------------------------------------------------------------------------//
//	コントロールのメッセージ																					//
//--------------------------------------------------------------------------------------------------------------//
//----- 通知メッセージ -----------------------------------------------------------------------------------------//
#define	AJCTCN_RANGE				(WM_APP + 20)	//	グラフレンジ通知		－					PAJCTC_NTC_RANGE
#define	AJCTCN_SCRPOS				(WM_APP + 21)	//	スクロール位置通知		－					クスロール位置
#define	AJCTCN_CLEAR				(WM_APP + 22)	//	データクリアー通知		－					－
#define	AJCTCN_DBLCLK				(WM_APP + 23)	//	ダブルクリック通知		－					－
#define	AJCTCN_DROPFILE				(WM_APP + 24)	//	ファイルドロップ通知	－					ファイル数
#define	AJCTCN_DROPDIR				(WM_APP + 25)	//	フォルダドロップ通知	－					ディレクトリ数
#define	AJCTCN_RCLICK				(WM_APP + 26)	//	右クリック通知			－					PAJCTCRCLK

//----- 内部使用メッセージ -------------------------------------------------------------------------------------//
#define	AJCTCM_NEEDNTC_RANGE		(WM_APP + 90)	//	レンジ通知要

//--------------------------------------------------------------------------------------------------------------//
//	プロトタイプ																								//
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcTchStop			(HWND hwnd);
AJCEXPORT	BOOL		WINAPI	AjcTchStart			(HWND hwnd);
AJCEXPORT	BOOL		WINAPI	AjcTchPurge			(HWND hwnd);
AJCEXPORT	BOOL		WINAPI	AjcTchPutRealData	(HWND hwnd, double dat[]);
AJCEXPORT	BOOL		WINAPI	AjcTchPutIntData	(HWND hwnd, int    dat[]);

AJCEXPORT	BOOL		WINAPI	AjcTchShowBorder	(HWND hwnd, BOOL fShow, COLORREF rgb);
AJCEXPORT	BOOL		WINAPI	AjcTchShowFilter	(HWND hwnd, BOOL fShow);
AJCEXPORT	BOOL		WINAPI	AjcTchShowScale 	(HWND hwnd, BOOL fLine, BOOL fValue);

AJCEXPORT	BOOL		WINAPI	AjcTchGetProp		(HWND hwnd, PAJCTCPROP	pBuf);
AJCEXPORT	BOOL		WINAPI	AjcTchSetProp		(HWND hwnd, PCAJCTCPROP pProp);

AJCEXPORT	BOOL		WINAPI	AjcTchGetRealRange	(HWND hwnd, double *low, double *high);
AJCEXPORT	BOOL		WINAPI	AjcTchSetRealRange	(HWND hwnd, double	low, double  high);
AJCEXPORT	BOOL		WINAPI	AjcTchGetIntRange	(HWND hwnd, int    *low, int	*high);
AJCEXPORT	BOOL		WINAPI	AjcTchSetIntRange	(HWND hwnd, int 	low, int	 high);
AJCEXPORT	BOOL		WINAPI	AjcTchAdjustRange	(HWND hwnd);
AJCEXPORT	BOOL		WINAPI	AjcTchSetBufSize	(HWND hwnd, int n);
AJCEXPORT	BOOL		WINAPI	AjcTchSetItemNumber (HWND hwnd, int n);
AJCEXPORT	BOOL		WINAPI	AjcTchSetAveNumber	(HWND hwnd, int n);
AJCEXPORT	BOOL		WINAPI	AjcTchSetTimeScale	(HWND hwnd, int n);

AJCEXPORT	HBITMAP		WINAPI	AjcTchGetBitmap 	(HWND hwnd);

AJCEXPORT	BOOL		WINAPI	AjcTchLoadPermInfoA		(HWND hwnd, C_BCP pProfileSect, C_BCP pKeyPrefix);
AJCEXPORT	BOOL		WINAPI	AjcTchLoadPermInfoW		(HWND hwnd, C_WCP pProfileSect, C_WCP pKeyPrefix);

AJCEXPORT	BOOL		WINAPI	AjcTchLoadPermInfoExA	(HWND hwnd, C_BCP pProfileSect, C_BCP pKeyPrefix, UI PermItem);
AJCEXPORT	BOOL		WINAPI	AjcTchLoadPermInfoExW	(HWND hwnd, C_WCP pProfileSect, C_WCP pKeyPrefix, UI PermItem);

AJCEXPORT	BOOL		WINAPI	AjcTchSavePermInfo		(HWND hwnd);

AJCEXPORT	BOOL		WINAPI	AjcTchSavePermInfoExA	(HWND hwnd, C_BCP pProfileSect, C_BCP pKeyPrefix, UI PermItem);
AJCEXPORT	BOOL		WINAPI	AjcTchSavePermInfoExW	(HWND hwnd, C_WCP pProfileSect, C_WCP pKeyPrefix, UI PermItem);

AJCEXPORT	BOOL		WINAPI	AjcTchSetPermAttA	(HWND hwnd, C_BCP pProfileSect, C_BCP pKeyPrefix);
AJCEXPORT	BOOL		WINAPI	AjcTchSetPermAttW	(HWND hwnd, C_WCP pProfileSect, C_WCP pKeyPrefix);

AJCEXPORT	BOOL		WINAPI	AjcTchSetPermAttExA	(HWND hwnd, C_BCP pProfileSect, C_BCP pKeyPrefix, UI PermItem);
AJCEXPORT	BOOL		WINAPI	AjcTchSetPermAttExW	(HWND hwnd, C_WCP pProfileSect, C_WCP pKeyPrefix, UI PermItem);

AJCEXPORT	BOOL		WINAPI	AjcTchLoadPropA 	(HWND hwnd, C_BCP pProfileSect, PCAJCTCPROP pDefProp);
AJCEXPORT	BOOL		WINAPI	AjcTchLoadPropW 	(HWND hwnd, C_WCP pProfileSect, PCAJCTCPROP pDefProp);

AJCEXPORT	BOOL		WINAPI	AjcTchSavePropA 	(HWND hwnd, C_BCP pProfileSect);
AJCEXPORT	BOOL		WINAPI	AjcTchSavePropW 	(HWND hwnd, C_WCP pProfileSect);

AJCEXPORT	BOOL		WINAPI	AjcTchLoadPropExA	(HWND hwnd, C_BCP pProfileSect, PCAJCTCPROP pDefProp);
AJCEXPORT	BOOL		WINAPI	AjcTchLoadPropExW	(HWND hwnd, C_WCP pProfileSect, PCAJCTCPROP pDefProp);

AJCEXPORT	BOOL		WINAPI	AjcTchSavePropExA	(HWND hwnd, C_BCP pProfileSect);
AJCEXPORT	BOOL		WINAPI	AjcTchSavePropExW	(HWND hwnd, C_WCP pProfileSect);

AJCEXPORT	BOOL		WINAPI	AjcTchEnablePopupMenu(HWND hwnd, BOOL fEnable);
AJCEXPORT	BOOL		WINAPI	AjcTchSetNtcRClk	 (HWND hwnd, BOOL fNtcRClk, UI MsgRBDown, UI MsgRBUp);

AJCEXPORT	BOOL		WINAPI	AjcTchSetTipTextA	(HWND hwnd, C_BCP pTxt);
AJCEXPORT	BOOL		WINAPI	AjcTchSetTipTextW	(HWND hwnd, C_WCP pTxt);

AJCEXPORT	BOOL		WINAPI	AjcTchGetTipTextA	(HWND hwnd, BCP pBuf, UI lBuf);
AJCEXPORT	BOOL		WINAPI	AjcTchGetTipTextW	(HWND hwnd, WCP pBuf, UI lBuf);

AJCEXPORT	BOOL		WINAPI	AjcTchSetTipShowAlways(HWND hwnd, BOOL fShowAlways);
AJCEXPORT	BOOL		WINAPI	AjcTchGetTipShowAlways(HWND hwnd);

AJCEXPORT	BOOL		WINAPI	AjcTchSetChkBoxTipShowAlways(HWND hwnd, UI n, BOOL fShowAlways);
AJCEXPORT	BOOL		WINAPI	AjcTchGetChkBoxTipShowAlways(HWND hwnd, UI n);

AJCEXPORT	BOOL		WINAPI	AjcTchSetTipShowAlwaysAll(HWND hwnd, BOOL fShowAlways);

AJCEXPORT	BOOL		WINAPI	AjcTchSetChkBoxTipTextA(HWND hwnd, UI n, C_BCP pTxt);
AJCEXPORT	BOOL		WINAPI	AjcTchSetChkBoxTipTextW(HWND hwnd, UI n, C_WCP pTxt);

AJCEXPORT	BOOL		WINAPI	AjcTchGetChkBoxTipTextA(HWND hwnd, UI n, BCP pBuf, UI lBuf);
AJCEXPORT	BOOL		WINAPI	AjcTchGetChkBoxTipTextW(HWND hwnd, UI n, WCP pBuf, UI lBuf);

AJCEXPORT	BOOL		WINAPI	AjcTchSetMaxLineDist(HWND hwnd, double MaxLineDist);
AJCEXPORT	double		WINAPI	AjcTchGetMaxLineDist(HWND hwnd);

AJCEXPORT	int			WINAPI	AjcTchGetScrollPos	(HWND hwnd);
AJCEXPORT	BOOL		WINAPI	AjcTchSetScrollPos	(HWND hwnd, int pos);

AJCEXPORT	BOOL		WINAPI	AjcTchSetFilter 	(HWND hwnd, UI n, BOOL state);
AJCEXPORT	BOOL		WINAPI	AjcTchGetFilter 	(HWND hwnd, UI n);

AJCEXPORT	BOOL		WINAPI	AjcTchSetHLineAtt (HWND hwnd, UI id, COLORREF color, int width, int style);
AJCEXPORT	BOOL		WINAPI	AjcTchSetHLinePos (HWND hwnd, UI id, double pos);
AJCEXPORT	BOOL		WINAPI	AjcTchEnableHLine (HWND hwnd, UI id, BOOL fEnable);

AJCEXPORT	BOOL		WINAPI	AjcTchSetVLine	 (HWND hwnd, COLORREF color, int width, int style);
AJCEXPORT	BOOL		WINAPI	AjcTchEnableVLine(HWND hwnd, BOOL fEnable);

AJCEXPORT	BOOL		WINAPI	AjcTchSetPoint	 (HWND hwnd, int r);
AJCEXPORT	BOOL		WINAPI	AjcTchEnablePoint(HWND hwnd, BOOL fEnable);

AJCEXPORT	BOOL		WINAPI	AjcTchGetDroppedFileA (HWND hwnd, BC buf[MAX_PATH]);
AJCEXPORT	BOOL		WINAPI	AjcTchGetDroppedFileW (HWND hwnd, WC buf[MAX_PATH]);

AJCEXPORT	BOOL		WINAPI	AjcTchGetDroppedDirA  (HWND hwnd, BC buf[MAX_PATH]);
AJCEXPORT	BOOL		WINAPI	AjcTchGetDroppedDirW  (HWND hwnd, WC buf[MAX_PATH]);

AJCEXPORT	BOOL		WINAPI AjcTchGetDroppedDirExA (HWND hwnd, BC buf[MAX_PATH], BOOL fTailIsDelimiter);
AJCEXPORT	BOOL		WINAPI AjcTchGetDroppedDirExW (HWND hwnd, WC buf[MAX_PATH], BOOL fTailIsDelimiter);

AJCEXPORT	BOOL		WINAPI AjcTchSetTitleTextA(HWND hwnd, C_BCP pTitleText, COLORREF TextColor, COLORREF BackColor, HFONT hFont);
AJCEXPORT	BOOL		WINAPI AjcTchSetTitleTextW(HWND hwnd, C_WCP pTitleText, COLORREF TextColor, COLORREF BackColor, HFONT hFont);

AJCEXPORT	BOOL		WINAPI AjcTchSetIpInfo(HWND hwnd, PCAJCTCIPINFO pInfo);
AJCEXPORT	BOOL		WINAPI AjcTchGetIpInfo(HWND hwnd, PAJCTCIPINFO	pBuf );

AJCEXPORT	BOOL		WINAPI AjcTchPause(HWND hwnd, BOOL fPause);

AJCEXPORT	BOOL		WINAPI AjcTchEnableMesDraw(HWND hwnd, BOOL fEnable);

AJCEXPORT	BOOL		WINAPI AjcTchMesPeriShow   (HWND hwnd, BOOL fShow);
AJCEXPORT	BOOL		WINAPI AjcTchMesPeriReset  (HWND hwnd);
AJCEXPORT	UI			WINAPI AjcTchMesPeriGet    (HWND hwnd);

AJCEXPORT	BOOL		WINAPI AjcTchGetGauInfo(HWND hwnd, PAJCTCGAUINFO pBuf);


AJCEXPORT	HFONT		WINAPI	AjcTchSetTextFont	(HWND hwnd, HFONT hFont);

AJCEXPORT	UI			WINAPI	AjcTchTextOutA		(HWND hwnd, int x, int y, C_BCP pTxt);
AJCEXPORT	UI			WINAPI	AjcTchTextOutW		(HWND hwnd, int x, int y, C_WCP pTxt);

AJCEXPORT	UI			WINAPI	AjcTchPrintFA		(HWND hwnd, int x, int y, C_BCP pFmt, ...);
AJCEXPORT	UI			WINAPI	AjcTchPrintFW		(HWND hwnd, int x, int y, C_WCP pFmt, ...);

AJCEXPORT	UI			WINAPI	AjcTchGetTextA		(HWND hwnd, UI key, BCP pBuf, UI lBuf);
AJCEXPORT	UI			WINAPI	AjcTchGetTextW		(HWND hwnd, UI key, WCP pBuf, UI lBuf);

AJCEXPORT	BOOL		WINAPI	AjcTchClearText		(HWND hwnd, UI key);
AJCEXPORT	BOOL		WINAPI	AjcTchClearAllText	(HWND hwnd);

AJCEXPORT	BOOL		WINAPI	AjcTchClear			(HWND hwnd);

AJCEXPORT	HWND		WINAPI	AjcTchGetMainWindow	(HWND hwnd, COLORREF *pBkGnd);

//----- 通知情報取得 -------------------------------------------------------------------------------------------//
AJCEXPORT	PAJCTCRCLK			WINAPI AjcTchGetNtcRClk		(HWND hwnd);
AJCEXPORT	UI					WINAPI AjcTchGetNtcDirs		(HWND hwnd);
AJCEXPORT	UI					WINAPI AjcTchGetNtcFiles	(HWND hwnd);
AJCEXPORT	PAJCTC_NTC_RANGE	WINAPI AjcTchGetNtcRng		(HWND hwnd);
AJCEXPORT	UI					WINAPI AjcTchGetNtcScrPos	(HWND hwnd);


//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	ＭＳＩＬ用ウインド生成																						//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
AJCEXPORT HWND WINAPI AjcTchCreateForMSIL(HWND hOwner, BOOL fShowScrollBar, VO (CALLBACK *cbRengeChanged)(double low, double high),
																			VO (CALLBACK *cbNtcScrollPos)(UI pos ),
																			VO (CALLBACK *cbFileDrop	)(UI n	 ),
																			VO (CALLBACK *cbDirDrop 	)(UI n	 ),
																			VO (CALLBACK *cbRClick)(int x, int y, BOOL shift, BOOL ctrl));
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	ＭＳＩＬ用スタイルの設定／取得関数																			//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//----- コントロールの外枠・非表示／表示	(AJCTCS_NOBORDER) --------------------------------------------------//
AJCEXPORT BOOL WINAPI AjcTchGetSty_NOBORDER    (HWND hwnd		 );
AJCEXPORT VO   WINAPI AjcTchSetSty_NOBORDER    (HWND hwnd, BOOL f);

//----- スケールライン非表示／表示			(AJCTCS_NOSCALELINE) -----------------------------------------------//
AJCEXPORT BOOL WINAPI AjcTchGetSty_NOSCALELINE (HWND hwnd		 );
AJCEXPORT VO   WINAPI AjcTchSetSty_NOSCALELINE (HWND hwnd, BOOL f);

//----- スケール値・非表示／表示			(AJCTCS_NOSCALELINE) -----------------------------------------------//
AJCEXPORT BOOL WINAPI AjcTchGetSty_NOSCALEVALUE(HWND hwnd		 );
AJCEXPORT VO   WINAPI AjcTchSetSty_NOSCALEVALUE(HWND hwnd, BOOL f);

//----- フィルタ非表示／表示				(AJCTCS_NOFILTER) --------------------------------------------------//
AJCEXPORT BOOL WINAPI AjcTchGetSty_NOFILTER    (HWND hwnd		 );
AJCEXPORT VO   WINAPI AjcTchSetSty_NOFILTER    (HWND hwnd, BOOL f);

//----- スクロールバー非表示／表示			(AJCTCS_NOSCROLLBAR) -----------------------------------------------//
AJCEXPORT BOOL WINAPI AjcTchGetSty_NOSCROLLBAR (HWND hwnd		 );
AJCEXPORT VO   WINAPI AjcTchSetSty_NOSCROLLBAR (HWND hwnd, BOOL f);

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	ＭＳＩＬ用プロパティの設定／取得関数																		//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//----- 低位レンジ値 		(RngL) -----------------------------------------------------------------------------//
AJCEXPORT double WINAPI AjcTchGetProp_RngL(HWND hwnd);
AJCEXPORT VO	 WINAPI AjcTchSetProp_RngL(HWND hwnd, double n);

//----- 高位レンジ値 		(RngH) -----------------------------------------------------------------------------//
AJCEXPORT double WINAPI AjcTchGetProp_RngH(HWND hwnd);
AJCEXPORT VO	 WINAPI AjcTchSetProp_RngH(HWND hwnd, double n);

//----- 横軸のメモリ表示幅	(TmScale) --------------------------------------------------------------------------//
AJCEXPORT UI	 WINAPI AjcTchGetProp_TmScale(HWND hwnd);
AJCEXPORT VO	 WINAPI AjcTchSetProp_TmScale(HWND hwnd, UI n);

//----- バッファ容量		(MaxBuf) ---------------------------------------------------------------------------//
AJCEXPORT UI	 WINAPI AjcTchGetProp_MaxBuf(HWND hwnd);
AJCEXPORT VO	 WINAPI AjcTchSetProp_MaxBuf(HWND hwnd, UI n);

//----- 最大データ項目数	(MaxItem) --------------------------------------------------------------------------//
AJCEXPORT UI	 WINAPI AjcTchGetProp_MaxItem(HWND hwnd);
AJCEXPORT VO	 WINAPI AjcTchSetProp_MaxItem(HWND hwnd, UI n);

//----- 平均化個数			(AveNum) ---------------------------------------------------------------------------//
AJCEXPORT UI	 WINAPI AjcTchGetProp_AveNum(HWND hwnd);
AJCEXPORT VO	 WINAPI AjcTchSetProp_AveNum(HWND hwnd, UI n);

//----- オフセット			(Item[ix].ofs) ---------------------------------------------------------------------//
AJCEXPORT double WINAPI AjcTchGetProp_ofs(HWND hwnd, UI ix);
AJCEXPORT VO	 WINAPI AjcTchSetProp_ofs(HWND hwnd, UI ix, double n);

//----- 表示色				(Item[ix].rgb) ---------------------------------------------------------------------//
AJCEXPORT UI	 WINAPI AjcTchGetProp_rgb(HWND hwnd, UI ix);
AJCEXPORT VO	 WINAPI AjcTchSetProp_rgb(HWND hwnd, UI ix, UI n);

//----- 波形補間表示種別 ---------------------------------------------------------------------------------------//
AJCEXPORT UI	 WINAPI AjcTchGetProp_IpKnd(HWND hwnd);
AJCEXPORT VO	 WINAPI AjcTchSetProp_IpKnd(HWND hwnd, UI n);

//----- 最新データ補間表示時の最大データ数 ---------------------------------------------------------------------//
AJCEXPORT UI	 WINAPI AjcTchGetProp_IpNum(HWND hwnd);
AJCEXPORT VO	 WINAPI AjcTchSetProp_IpNum(HWND hwnd, UI n);

//----- 補間表示幅（波形の引き伸ばし倍率） ---------------------------------------------------------------------//
AJCEXPORT UI	 WINAPI AjcTchGetProp_IpWidth(HWND hwnd);
AJCEXPORT VO	 WINAPI AjcTchSetProp_IpWidth(HWND hwnd, UI n);

//----- ウインドサイズ -----------------------------------------------------------------------------------------//
AJCEXPORT VO WINAPI AjcTchSetProp_WndSize(HWND hwnd, UI width, UI height);

//----- ファイル，フォルダ ドロップの許可／禁止 ----------------------------------------------------------------//
AJCEXPORT VO	WINAPI AjcTchSetProp_AcceptFiles(HWND hwnd, BOOL fEnable);
AJCEXPORT BOOL	WINAPI AjcTchGetProp_AcceptFiles(HWND hwnd);

//----- チップテキスト設定／取得 -------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcTchSetTipTextForMSIL(HWND hwnd, C_WCP pTxt);
AJCEXPORT	UI		WINAPI	AjcTchGetTipTextForMSIL(HWND hwnd, WCP pBuf, UI lBuf);

//----- チェックボックスのチップテキスト設定／取得 -------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcTchSetChkBoxTipTextForMSIL(HWND hwnd, UI n, C_WCP pTxt);
AJCEXPORT	UI		WINAPI	AjcTchGetChkBoxTipTextForMSIL(HWND hwnd, UI n, WCP pBuf, UI lBuf);

//----- データ投与 ---------------------------------------------------------------------------------------------//
AJCEXPORT VO WINAPI	AjcTchPutData1	(HWND hwnd, double dat0);
AJCEXPORT VO WINAPI	AjcTchPutData2	(HWND hwnd, double dat0, double dat1);
AJCEXPORT VO WINAPI	AjcTchPutData3	(HWND hwnd, double dat0, double dat1, double dat2);
AJCEXPORT VO WINAPI	AjcTchPutData4	(HWND hwnd, double dat0, double dat1, double dat2, double dat3);
AJCEXPORT VO WINAPI	AjcTchPutData5	(HWND hwnd, double dat0, double dat1, double dat2, double dat3, double dat4);
AJCEXPORT VO WINAPI	AjcTchPutData6	(HWND hwnd, double dat0, double dat1, double dat2, double dat3, double dat4, double dat5);
AJCEXPORT VO WINAPI	AjcTchPutData7	(HWND hwnd, double dat0, double dat1, double dat2, double dat3, double dat4, double dat5, double dat6);
AJCEXPORT VO WINAPI	AjcTchPutData8	(HWND hwnd, double dat0, double dat1, double dat2, double dat3, double dat4, double dat5, double dat6, double dat7);


/****************************************************************************************************************/
#endif
