﻿#ifndef	AJCFONTDLG_H_
#define	AJCFONTDLG_H_
/****************************************************************************************************************/
/*--------------------------------------------------------------------------------------------------------------*/
/*	ＵＮＩＣＯＤＥ／ＡＳＣＩＩ																					*/
/*--------------------------------------------------------------------------------------------------------------*/
#ifdef	UNICODE
	#define	AjcCfSetPreviewText				AjcCfSetPreviewTextW
	#define	AjcCfFindFont					AjcCfFindFontW
	#define	AjcCfFindFontEx					AjcCfFindFontExW
	#define	AjcCfEnumFonts					AjcCfEnumFontsW
	#define	AjcCfEnumFontsEx				AjcCfEnumFontsExW
	#define	AjcCfInitFontInfo				AjcCfInitFontInfoW
	#define	AjcCfInitPermInfo				AjcCfInitPermInfoW
	#define	AjcCfInfoToText					AjcCfInfoToTextW
	#define	AjcCfTextToInfo					AjcCfTextToInfoW
	#define	AjcCfMergeToInfo				AjcCfMergeToInfoW
	#define	AjcCfFontDlg					AjcCfFontDlgW

	#define	AJCCFFONTINFO					AJCCFFONTINFOW
	#define	PAJCCFFONTINFO					PAJCCFFONTINFOW
	#define	PCAJCCFFONTINFO					PCAJCCFFONTINFOW

	#define	AJCCFPERMINFO					AJCCFPERMINFOW
	#define	PAJCCFPERMINFO					PAJCCFPERMINFOW
	#define	PCAJCCFPERMINFO					PCAJCCFPERMINFOW
#else
	#define	AjcCfSetPreviewText				AjcCfSetPreviewTextA
	#define	AjcCfFindFont					AjcCfFindFontA
	#define	AjcCfFindFontEx					AjcCfFindFontExA
	#define	AjcCfEnumFonts					AjcCfEnumFontsA
	#define	AjcCfEnumFontsEx				AjcCfEnumFontsExA
	#define	AjcCfInitFontInfo				AjcCfInitFontInfoA
	#define	AjcCfInitPermInfo				AjcCfInitPermInfoA
	#define	AjcCfInfoToText					AjcCfInfoToTextA
	#define	AjcCfTextToInfo					AjcCfTextToInfoA
	#define	AjcCfMergeToInfo				AjcCfMergeToInfoA
	#define	AjcCfFontDlg					AjcCfFontDlgA

	#define	AJCCFFONTINFO					AJCCFFONTINFOA
	#define	PAJCCFFONTINFO					PAJCCFFONTINFOA
	#define	PCAJCCFFONTINFO					PCAJCCFFONTINFOA

	#define	AJCCFPERMINFO					AJCCFPERMINFOA
	#define	PAJCCFPERMINFO					PAJCCFPERMINFOA
	#define	PCAJCCFPERMINFO					PCAJCCFPERMINFOA
#endif
//--------------------------------------------------------------------------------------------------------------//
//	フォント選択ダイアログ 永続情報																				//
//--------------------------------------------------------------------------------------------------------------//
typedef union {
	struct {UB PitchAndFamily, CharSet;} s;
	UI									 v;
} AJCCFATT, *PAJCCFATT;
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
#define		AJCCFPERMID			0x298FC2B3		//	永続化情報ＩＤ
#define		AJCCFMAX_TEXT		256				//	永続化情報・文字列長の最大値
//----- 固定ヘッダ部 -------------------------------------------------------------------------------------------//
typedef struct {
	UI			id;							//	情報が有効であることを示すＩＤ(=AJCCFPERMID)
	BOOL		fPixel;						//	高さ＝ピクセル選択
	BOOL		fItalic;					//	斜字 チェック
	BOOL		fBold;						//	太字 チェック
	BOOL		fFixed;						//	固定ピッチ チェック
	UI			Pixels;						//	高さのピクセル数
	UI			Points;						//	高さのポイント数
	UI			LSpace;						//	行間スペース
	AJCCFATT	FixAttr;					//	最後に選択された固定ピッチフォントの属性（CharSet, PitchAndFamily)
	AJCCFATT	AnyAttr;					//	最後に選択された任意ピッチフォントの属性（CharSet, PitchAndFamily)
} AJCCFPERMHD, *PAJCCFPERMHD;
//----- バイト文字 ---------------------------------------------------------------------------------------------//
typedef struct {
	AJCCFPERMHD	hd;							//	固定部
	BC			FixFace[LF_FACESIZE];		//	最後に選択された固定ピッチフォントのフォント名
	BC			AnyFace[LF_FACESIZE];		//	最後に選択された任意ピッチフォントのフォント名
} AJCCFPERMINFOA, *PAJCCFPERMINFOA;
typedef const AJCCFPERMINFOA *PCAJCCFPERMINFOA;
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
typedef struct {
	AJCCFPERMHD	hd;							//	固定部
	WC			FixFace[LF_FACESIZE];		//	最後に選択された固定ピッチフォントのフォント名
	WC			AnyFace[LF_FACESIZE];		//	最後に選択された任意ピッチフォントのフォント名
} AJCCFPERMINFOW, *PAJCCFPERMINFOW;
typedef const AJCCFPERMINFOW *PCAJCCFPERMINFOW;
//--------------------------------------------------------------------------------------------------------------//
//	フォント情報																								//
//--------------------------------------------------------------------------------------------------------------//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
typedef struct {
	LOGFONTA	lf;				//	フォント情報
	UI			lsp;			//	行間スペース
} AJCCFFONTINFOA, *PAJCCFFONTINFOA;
typedef const AJCCFFONTINFOA *PCAJCCFFONTINFOA;

//----- ワイド文字 ---------------------------------------------------------------------------------------------//
typedef struct {
	LOGFONTW	lf;				//	フォント情報
	UI			lsp;			//	行間スペース
} AJCCFFONTINFOW, *PAJCCFFONTINFOW;
typedef const AJCCFFONTINFOW *PCAJCCFFONTINFOW;

//----- ダイアログ形式フラグ -----------------------------------------------------------------------------------//
#define		AJCCFF_FIXEDONLY	0x8000		//	初期値で「固定ピッチのみ」を選択
#define		AJCCFF_INCVERT		0x4000		//	縦書きフォントを含める

#define		AJCCFF_NOBOLD		0x0800		//	「太字」設定を禁止
#define		AJCCFF_NOITALIC		0x0400		//	「斜字」設定を禁止
#define		AJCCFF_NOFIXED		0x0200		//	「固定ピッチのみ」設定を禁止
#define		AJCCFF_NOLSPACE		0x0100		//	「行間スペース」を設定禁止

#define		AJCCFF_HIDEBOLD		0x0080		//	「太字」非表示
#define		AJCCFF_HIDEITALIC	0x0040		//	「斜字」非表示
#define		AJCCFF_HIDEFIXED	0x0020		//	「固定ピッチのみ」非表示
#define		AJCCFF_HIDELSPACE	0x0010		//	「行間スペース」非表示

//----- フォント属性情報 ---------------------------------------------------------------------------------------//
//	フォント属性フラグ(flag)
#define		AJCFIF_ORG		0x10		//	オリジナルフォント
#define		AJCFIF_ENG		0x08		//	英語名フォント
#define		AJCFIF_SUB		0x04		//	サブファミリ

//	フォント属性情報
typedef struct _AJCFIFNODE {
	UB		flag;						//	フラグ（AJCFIF_XXX）
	UB		PitchAndFamily;				//	ピッチ＆ファミリ
	UB		CharSet;					//	キャラクタセット
	UB		filler;						//	-
	C_WCP	pOrgName;					//	英字名→オリジナル名へのポインタ
} AJCFIFNODE, *PAJCFIFNODE;
typedef const AJCFIFNODE *PCAJCFIFNODE;


/*--------------------------------------------------------------------------------------------------------------*/
/*	プロトタイプ																								*/
/*--------------------------------------------------------------------------------------------------------------*/
AJCEXPORT HAJCAVS	WINAPI	AjcCfCreateAllFontInfo(VO);
AJCEXPORT VO		WINAPI	AjcCfReleaseAllFontInfo(VO);

AJCEXPORT int		WINAPI	AjcCfPointsToPixels(int points);
AJCEXPORT int		WINAPI	AjcCfPixelsToPoints(int pixels);


AJCEXPORT BOOL	WINAPI	AjcCfSetPreviewTextA(C_BCP pText);
AJCEXPORT BOOL	WINAPI	AjcCfSetPreviewTextW(C_WCP pText);

AJCEXPORT UI	WINAPI	AjcCfEnumFontsA(UX cbp, BOOL (CALLBACK *cbNtcFont)(C_BCP pFaceName, UB PitchAndFamily, UB CharSet, UX cbp));
AJCEXPORT UI	WINAPI	AjcCfEnumFontsW(UX cbp, BOOL (CALLBACK *cbNtcFont)(C_WCP pFaceName, UB PitchAndFamily, UB CharSet, UX cbp));

AJCEXPORT UI	WINAPI	AjcCfEnumFontsExA(UX cbp, BOOL (CALLBACK *cbNtcFontA)(C_BCP pFontName, PCAJCFIFNODE pNode, UX cbp));
AJCEXPORT UI	WINAPI	AjcCfEnumFontsExW(UX cbp, BOOL (CALLBACK *cbNtcFontW)(C_WCP pFontName, PCAJCFIFNODE pNode, UX cbp));

AJCEXPORT BOOL	WINAPI	AjcCfFindFontA(C_BCP pFaceName, PAJCCFATT pBuf);
AJCEXPORT BOOL	WINAPI	AjcCfFindFontW(C_WCP pFaceName, PAJCCFATT pBuf);

AJCEXPORT PCAJCFIFNODE	WINAPI	AjcCfFindFontExA(C_BCP pFontName);
AJCEXPORT PCAJCFIFNODE	WINAPI	AjcCfFindFontExW(C_WCP pFontName);

AJCEXPORT BOOL	WINAPI	AjcCfInitFontInfoA(C_BCP pFace, PAJCCFFONTINFOA pFont);
AJCEXPORT BOOL	WINAPI	AjcCfInitFontInfoW(C_WCP pFace, PAJCCFFONTINFOW pFont);

AJCEXPORT BOOL	WINAPI	AjcCfInitPermInfoA(C_BCP pFixFace, C_BCP pAnyFace, PAJCCFPERMINFOA pPerm);
AJCEXPORT BOOL	WINAPI	AjcCfInitPermInfoW(C_WCP pFixFace, C_WCP pAnyFace, PAJCCFPERMINFOW pPerm);

AJCEXPORT UI	WINAPI	AjcCfInfoToTextA(PCAJCCFPERMINFOA pPerm, BC pBuf[AJCCFMAX_TEXT]);
AJCEXPORT UI	WINAPI	AjcCfInfoToTextW(PCAJCCFPERMINFOW pPerm, WC pBuf[AJCCFMAX_TEXT]);

AJCEXPORT UI	WINAPI	AjcCfInfoToTextExA(PCAJCCFFONTINFOA pFont, PCAJCCFPERMINFOA pPerm, BC pBuf[AJCCFMAX_TEXT]);
AJCEXPORT UI	WINAPI	AjcCfInfoToTextExW(PCAJCCFFONTINFOW pFont, PCAJCCFPERMINFOW pPerm, WC pBuf[AJCCFMAX_TEXT]);

AJCEXPORT BOOL	WINAPI	AjcCfTextToInfoA(C_BCP pTxt, PAJCCFPERMINFOA pPerm);
AJCEXPORT BOOL	WINAPI	AjcCfTextToInfoW(C_WCP pTxt, PAJCCFPERMINFOW pPerm);

AJCEXPORT BOOL	WINAPI	AjcCfTextToInfoExA(C_BCP pTxt, PAJCCFFONTINFOA pFont, PAJCCFPERMINFOA pPerm);
AJCEXPORT BOOL	WINAPI	AjcCfTextToInfoExW(C_WCP pTxt, PAJCCFFONTINFOW pFont, PAJCCFPERMINFOW pPerm);

AJCEXPORT BOOL	WINAPI	AjcCfMergeToInfoA(PCAJCCFFONTINFOA pFont, PAJCCFPERMINFOA pPerm);
AJCEXPORT BOOL	WINAPI	AjcCfMergeToInfoW(PCAJCCFFONTINFOW pFont, PAJCCFPERMINFOW pPerm);

AJCEXPORT BOOL	WINAPI	AjcCfFontDlgA(HWND hOwner, UI opt, PAJCCFFONTINFOA pFont, PAJCCFPERMINFOA pPerm, 
							UX cbp, VO (CALLBACK *cbInit)(HWND hDlg, UX cbp), BOOL (CALLBACK *cbApply)(HFONT hFont, UI lsp, UX cbp));
AJCEXPORT BOOL	WINAPI	AjcCfFontDlgW(HWND hOwner, UI opt, PAJCCFFONTINFOW pFont, PAJCCFPERMINFOW pPerm, 
							UX cbp, VO (CALLBACK *cbInit)(HWND hDlg, UX cbp), BOOL (CALLBACK *cbApply)(HFONT hFont, UI lsp, UX cbp));

/****************************************************************************************************************/
#endif
