﻿#ifndef	AJCHEXDATA_H_
#define	AJCHEXDATA_H_
/****************************************************************************************************************/
//--------------------------------------------------------------------------------------------------------------//
//	エラーコード																								//
//--------------------------------------------------------------------------------------------------------------//
#define		AJCIHERR_OK			0		//	ＯＫ
#define		AJCIHERR_DIGIT		1		//	不正文字
#define		AJCIHERR_NOMARK		2		//	先頭が 'S' / ':'でない
#define		AJCIHERR_SUM		3		//	サムチェックエラー
#define		AJCIHERR_TYPE		4		//	不正レコードタイプ
#define		AJCIHERR_NOEND		5		//	ＥＮＤレコードなし
#define		AJCIHERR_FOPEN		6		//	ファイルオープン失敗

//--------------------------------------------------------------------------------------------------------------//
//	ＵＮＩＣＯＤＥ／ＡＳＣＩＩ																					//
//--------------------------------------------------------------------------------------------------------------//
#ifdef	UNICODE
	#define		AjcLoadHexData			AjcLoadHexDataW
	#define		AjcIHexToBin			AjcIHexToBinW
	#define		AjcSMotToBin			AjcSMotToBinW
#else
	#define		AjcLoadHexData			AjcLoadHexDataA
	#define		AjcIHexToBin			AjcIHexToBinA
	#define		AjcSMotToBin			AjcSMotToBinA
#endif

//--------------------------------------------------------------------------------------------------------------//
//	プロトタイプ																								//
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT	UI	WINAPI	AjcLoadHexDataA(UBP pBuf, UL nBuf, UL ofs, ULP pSrtAdr,
															UX cbp, BOOL (CALLBACK *cbGetRec)(UX cbp, BCP pRec, UI nRec));
AJCEXPORT	UI	WINAPI	AjcLoadHexFileA(C_BCP pFile, UBP pBuf, UL nBuf, UL ofs, ULP pSrtAdr);
AJCEXPORT	UI	WINAPI	AjcIHexToBinA(C_BCP pRec, UBP pBuf, UI nBuf, UBP pTyp, ULP pAdr, UIP pLen);
AJCEXPORT	UI	WINAPI	AjcSMotToBinA(C_BCP pRec, UBP pBuf, UI nBuf, UBP pTyp, ULP pAdr, UIP pLen);

AJCEXPORT	UI	WINAPI	AjcLoadHexDataW(UBP pBuf, UL nBuf, UL ofs, ULP pSrtAdr,
															UX cbp, BOOL (CALLBACK *cbGetRec)(UX cbp, WCP pRec, UI nRec));
AJCEXPORT	UI	WINAPI	AjcLoadHexFileW(C_WCP pFile, UBP pBuf, UL nBuf, UL ofs, ULP pSrtAdr);
AJCEXPORT	UI	WINAPI	AjcIHexToBinW(C_WCP pRec, UBP pBuf, UI nBuf, UBP pTyp, ULP pAdr, UIP pLen);
AJCEXPORT	UI	WINAPI	AjcSMotToBinW(C_WCP pRec, UBP pBuf, UI nBuf, UBP pTyp, ULP pAdr, UIP pLen);

/****************************************************************************************************************/
#endif
