﻿#ifndef	AJCIMGFUNC_H_
#define	AJCIMGFUNC_H_
/****************************************************************************************************************/
/*--------------------------------------------------------------------------------------------------------------*/
/*	イメージ情報インスタンス																					*/
/*--------------------------------------------------------------------------------------------------------------*/
typedef struct {
	BOOL		fValid;					//	有効フラグ（イメージ読み出し済フラグ）
	VOP			hFactory;				//	IShellImageDataFactory	インタフェース
	VOP			hImg;					//	IShellImageData			インタフェース
	HBITMAP		hBmp;					//	ビットマップ・ハンドル（ＤＩＢセクション）
	int			width;					//	イメージの横サイズ
	int			height;					//	イメージの縦サイズ
} AJC_IMGINFO, *PAJC_IMGINFO;
typedef const AJC_IMGINFO *PCAJC_IMGINFO;

/*--------------------------------------------------------------------------------------------------------------*/
/*	ＵＮＩＣＯＤＥ／ＡＳＣＩＩ																					*/
/*--------------------------------------------------------------------------------------------------------------*/
#ifdef	UNICODE
	#define	AjcImgFuncRead		AjcImgFuncReadW
#else
	#define	AjcImgFuncRead		AjcImgFuncReadA
#endif

/*--------------------------------------------------------------------------------------------------------------*/
/*	プロトタイプ																								*/
/*--------------------------------------------------------------------------------------------------------------*/
AJCEXPORT	BOOL	WINAPI	AjcImgFuncReadA	 (PAJC_IMGINFO pImgInfo, C_BCP pFilePath);
AJCEXPORT	BOOL	WINAPI	AjcImgFuncReadW	 (PAJC_IMGINFO pImgInfo, C_WCP pFilePath);
AJCEXPORT	BOOL	WINAPI	AjcImgFuncDraw	 (PAJC_IMGINFO pImgInfo, LPRECT pSrc, HDC hdc, LPRECT pDst);
AJCEXPORT	BOOL	WINAPI	AjcImgFuncRelease(PAJC_IMGINFO pImgInfo);

/****************************************************************************************************************/
#endif
