﻿#ifndef	AJCMSGMAP_H_
#define	AJCMSGMAP_H_
/****************************************************************************************************************/
/*--------------------------------------------------------------------------------------------------------------*/
/*	ＵＮＩＣＯＤＥ／ＡＳＣＩＩ																					*/
/*--------------------------------------------------------------------------------------------------------------*/
#ifdef	UNICODE
	#define		AjcMmpInitTbl		AjcMmpInitTblW
	#define		AJC_WNDMAP_DEF		AJC_WNDMAP_DEFW
	#define		AJC_DLGMAP_DEF		AJC_DLGMAP_DEFW
#else
	#define		AjcMmpInitTbl		AjcMmpInitTblA
	#define		AJC_WNDMAP_DEF		AJC_WNDMAP_DEFA
	#define		AJC_DLGMAP_DEF		AJC_DLGMAP_DEFA
#endif
//--------------------------------------------------------------------------------------------------------------//
//	マクロ																										//
//--------------------------------------------------------------------------------------------------------------//
#define	AJCMSGTYPE_END	0
#define	AJCMSGTYPE_MSG	1
#define	AJCMSGTYPE_CMD	2
#define	AJCMSGTYPE_NTC	3

//--------------------------------------------------------------------------------------------------------------//
//	メッセージマップ テーブル																					//
//--------------------------------------------------------------------------------------------------------------//
//----- 共通処理用 ---------------------------------------------------------------------------------------------//
typedef struct _AJCMSGTBL {
	UI		MsgType;													//	メッセージタイプ（AJCMSGTYPE_XXX）
	UI		msg;														//	ウインドメッセージ
	int		cmd;														//	コマンド（コントロールＩＤ）
	LRESULT	(*func)(HWND hwnd, UI msg, WPARAM wParam, LPARAM lParam);	//	アクション関数
	C_VOP	pRwm;														//	アプリ名（RegisterWindowMessage()用）
	struct _AJCMSGTBL *pNxt;											//	次のエントリポインタ
} AJCMSGTBL, *PAJCMSGTBL;
//----- バイト文字定義用 ---------------------------------------------------------------------------------------//
typedef struct _AJCMSGTBLA {
	UI		MsgType;													//	メッセージタイプ（AJCMSGTYPE_XXX）
	UI		msg;														//	ウインドメッセージ
	int		cmd;														//	コマンド（コントロールＩＤ）
	LRESULT	(*func)(HWND hwnd, UI msg, WPARAM wParam, LPARAM lParam);	//	アクション関数
	C_BCP	pRwm;														//	アプリ名（RegisterWindowMessage()用）
	struct _AJCMSGTBLA *pNxt;											//	次のエントリポインタ
} AJCMSGTBLA, *PAJCMSGTBLA;
//----- ワイド文字定義用 ---------------------------------------------------------------------------------------//
typedef struct _AJCMSGTBLW {
	UI		MsgType;													//	メッセージタイプ（AJCMSGTYPE_XXX）
	UI		msg;														//	ウインドメッセージ
	int		cmd;														//	コマンド（コントロールＩＤ）
	LRESULT	(*func)(HWND hwnd, UI msg, WPARAM wParam, LPARAM lParam);	//	アクション関数
	C_WCP	pRwm;														//	アプリ名（RegisterWindowMessage()用）
	struct _AJCMSGTBLW *pNxt;											//	次のエントリポインタ
} AJCMSGTBLW, *PAJCMSGTBLW;

//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	PAJCMSGTBL	pMsg;
	PAJCMSGTBL	pCmd;
	PAJCMSGTBL	pNtc;
	PAJCMSGTBL	pWmCmd;
	PAJCMSGTBL	pWmNtc;
} AJCMSGCHAINPTR, *PAJCMSGCHAINPTR;
//--------------------------------------------------------------------------------------------------------------//
#define	AJC_WNDPROC_NAME(NAME)	((WNDPROC)AjcWnd##NAME##Proc)
#define	AJC_DLGPROC_NAME(NAME)	((DLGPROC)AjcDlg##NAME##Proc)

#define	AJC_WNDPROC_DEF(NAME)	static	LRESULT CALLBACK AjcWnd##NAME##Proc(HWND hwnd, UI msg, WPARAM wParam, LPARAM lParam)

#define	AJC_DLGPROC_DEF(NAME)	static	LRESULT CALLBACK AjcDlg##NAME##Proc(HWND hDlg, UI msg, WPARAM wParam, LPARAM lParam)

//--------------------------------------------------------------------------------------------------------------//
//	サブクラス化情報																							//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	C_BCP		pName;		//	プロシージャの名前（AJC_WNDMAP_DEF(name)で指定した名称）
	WNDPROC		wpNew;		//	サブクラス化した新ウインドプロシージャ
	WNDPROC		wpOld;		//	サブクラス化前の元ウインドプロシージャ
	WNDPROC		wpRet;		//	実際に実行される元ウインドプロシージャ
} AJCSBCINFO, *PAJCSBCINFO;
typedef const AJCSBCINFO *PCAJCSBCINFO;


//----------------------------------------------------------------------------------------------------------------------------------//
//	AJC_WNDMAP_DEF（ウインドメッセージマップ定義開始）																				//
//----------------------------------------------------------------------------------------------------------------------------------//
//----- バイト文字 -----------------------------------------------------------------------------------------------------------------//
#define	AJC_WNDMAP_DEFA(NAME) 																										\
extern	AJCMSGTBLA		AjcWndMsgTbl_##NAME[];										/*	メッセージテーブル						*/	\
static	BOOL			AjcWndMsgFirst_##NAME  = TRUE;								/*	初回フラグ								*/	\
static	AJCMSGCHAINPTR	AjcWndMsgChain_##NAME  = {NULL, NULL, NULL, NULL, NULL};	/*	各メッセージチェインテーブル先頭ポインタ*/	\
AJC_WNDPROC_DEF(NAME) {																/*	ウインドプロシージャ・エントリポイント	*/	\
	LRESULT rc;																		/*	ウインドプロシージャの戻り値			*/	\
	if (AjcWndMsgFirst_##NAME) {													/*	初回？									*/	\
		AjcWndMsgFirst_##NAME = FALSE;												/*		初回フラグ解除						*/	\
		AjcMmpInitTblA((PAJCMSGTBL)AjcWndMsgTbl_##NAME, &AjcWndMsgChain_##NAME);	/*			メッセージテーブル初期化		*/	\
	}																				/*			・								*/	\
	rc = AjcMmpWndMsgHandle(&AjcWndMsgChain_##NAME, hwnd, msg, wParam, lParam,		/*			メッセージハンドラ実行			*/	\
											 AJC_WNDPROC_NAME(NAME), #NAME);		/*			・								*/	\
	if		(msg == WM_CREATE ) AjcDgcSubclassEx(hwnd, RGB(255,255,255));			/*			ＷＮＤカラー設定				*/	\
	else if (msg == WM_DESTROY) AjcMmpDelSubclass(hwnd, #NAME);						/*			サブクラス情報削除				*/	\
	return rc;																		/*			戻る							*/	\
}																					/*											*/	\
static	AJCMSGTBLA	AjcWndMsgTbl_##NAME[] = {										/*			メッセージテーブル開始			*/
//----- ワイド文字 -----------------------------------------------------------------------------------------------------------------//
#define	AJC_WNDMAP_DEFW(NAME) 																										\
extern	AJCMSGTBLW		AjcWndMsgTbl_##NAME[];										/*	メッセージテーブル						*/	\
static	BOOL			AjcWndMsgFirst_##NAME  = TRUE;								/*	初回フラグ								*/	\
static	AJCMSGCHAINPTR	AjcWndMsgChain_##NAME  = {NULL, NULL, NULL, NULL, NULL};	/*	各メッセージチェインテーブル先頭ポインタ*/	\
AJC_WNDPROC_DEF(NAME) {																/*	ウインドプロシージャ・エントリポイント	*/	\
	LRESULT rc;																		/*	ウインドプロシージャの戻り値			*/	\
	if (AjcWndMsgFirst_##NAME) {													/*	初回？									*/	\
		AjcWndMsgFirst_##NAME = FALSE;												/*		初回フラグ解除						*/	\
		AjcMmpInitTblW((PAJCMSGTBL)AjcWndMsgTbl_##NAME, &AjcWndMsgChain_##NAME);	/*			メッセージテーブル初期化		*/	\
	}																				/*			・								*/	\
	rc = AjcMmpWndMsgHandle(&AjcWndMsgChain_##NAME, hwnd, msg, wParam, lParam,		/*			メッセージハンドラ実行			*/	\
											 AJC_WNDPROC_NAME(NAME), #NAME);		/*			・								*/	\
	if		(msg == WM_CREATE ) AjcDgcSubclassEx(hwnd, RGB(255,255,255));			/*			ＷＮＤカラー設定				*/	\
	else if (msg == WM_DESTROY) AjcMmpDelSubclass(hwnd, #NAME);						/*			サブクラス情報削除				*/	\
	return rc;																		/*			戻る							*/	\
}																					/*											*/	\
static	AJCMSGTBLW	AjcWndMsgTbl_##NAME[] = {										/*			メッセージテーブル開始			*/
//----------------------------------------------------------------------------------------------------------------------------------//
//	AJC_DLGMAP_DEF（ダイアログメッセージマップ定義開始）																			//
//----------------------------------------------------------------------------------------------------------------------------------//
//----- バイト文字 -----------------------------------------------------------------------------------------------------------------//
#define	AJC_DLGMAP_DEFA(NAME) 																										\
extern	AJCMSGTBLA		AjcDlgMsgTbl_##NAME[];										/*	メッセージテーブル						*/	\
static	BOOL			AjcDlgMsgFirst_##NAME  = TRUE;								/*	初回フラグ								*/	\
static	AJCMSGCHAINPTR	AjcDlgMsgChain_##NAME  = {NULL, NULL, NULL, NULL, NULL};	/*	各メッセージチェインテーブル先頭ポインタ*/	\
AJC_DLGPROC_DEF(NAME) {																/*	ウインドプロシージャ・エントリポイント	*/	\
	LRESULT rc;																		/*	ウインドプロシージャの戻り値			*/	\
	if (AjcDlgMsgFirst_##NAME) {													/*	初回？									*/	\
		AjcDlgMsgFirst_##NAME = FALSE;												/*		初回フラグ解除						*/	\
		AjcMmpInitTblA((PAJCMSGTBL)AjcDlgMsgTbl_##NAME, &AjcDlgMsgChain_##NAME);	/*			メッセージテーブル初期化		*/	\
	}																				/*			・								*/	\
	rc = AjcMmpDlgMsgHandle(&AjcDlgMsgChain_##NAME, hDlg, msg, wParam, lParam);		/*			メッセージハンドラ実行			*/	\
	if		(msg == WM_INITDIALOG) AjcDgcSubclassEx(hDlg, RGB(255,255,255));		/*			ＷＮＤカラー設定				*/	\
	return rc;																		/*			戻る							*/	\
}																					/*											*/	\
static	AJCMSGTBLA	AjcDlgMsgTbl_##NAME[] = {										/*			メッセージテーブル開始			*/
//----- ワイド文字 -----------------------------------------------------------------------------------------------------------------//
#define	AJC_DLGMAP_DEFW(NAME) 																										\
extern	AJCMSGTBLW		AjcDlgMsgTbl_##NAME[];										/*	メッセージテーブル						*/	\
static	BOOL			AjcDlgMsgFirst_##NAME  = TRUE;								/*	初回フラグ								*/	\
static	AJCMSGCHAINPTR	AjcDlgMsgChain_##NAME  = {NULL, NULL, NULL, NULL, NULL};	/*	各メッセージチェインテーブル先頭ポインタ*/	\
AJC_DLGPROC_DEF(NAME) {																/*	ウインドプロシージャ・エントリポイント	*/	\
	LRESULT rc;																		/*	ウインドプロシージャの戻り値			*/	\
	if (AjcDlgMsgFirst_##NAME) {													/*	初回？									*/	\
		AjcDlgMsgFirst_##NAME = FALSE;												/*		初回フラグ解除						*/	\
		AjcMmpInitTblW((PAJCMSGTBL)AjcDlgMsgTbl_##NAME, &AjcDlgMsgChain_##NAME);	/*			メッセージテーブル初期化		*/	\
	}																				/*			・								*/	\
	rc = AjcMmpDlgMsgHandle(&AjcDlgMsgChain_##NAME, hDlg, msg, wParam, lParam);		/*			メッセージハンドラ実行			*/	\
	if		(msg == WM_INITDIALOG) AjcDgcSubclassEx(hDlg, RGB(255,255,255));		/*			ＷＮＤカラー設定				*/	\
	return rc;																		/*			戻る							*/	\
}																					/*											*/	\
static	AJCMSGTBLW	AjcDlgMsgTbl_##NAME[] = {										/*			メッセージテーブル開始			*/
//--------------------------------------------------------------------------------------------------------------//
//											 MsgType		 msg		 cmd  func					pRwm  pNxt
#define		AJC_WNDMAP_MSG(NAME, MSG)		{AJCMSGTYPE_MSG, MSG	   , 0	, AjcWnd##NAME##_##MSG, NULL, NULL},
#define		AJC_WNDMAP_RWM(NAME, MSG, APP)	{AJCMSGTYPE_MSG, 0		   , 0	, AjcWnd##NAME##_##MSG, APP , NULL},
#define		AJC_WNDMAP_CMD(NAME, CMD)		{AJCMSGTYPE_CMD, WM_COMMAND, CMD, AjcWnd##NAME##_##CMD, NULL, NULL},
#define		AJC_WNDMAP_NTC(NAME, CMD)		{AJCMSGTYPE_NTC, WM_NOTIFY , CMD, AjcWnd##NAME##_##CMD, NULL, NULL},

#define		AJC_DLGMAP_MSG(NAME, MSG)		{AJCMSGTYPE_MSG, MSG	   , 0	, AjcDlg##NAME##_##MSG, NULL, NULL},
#define		AJC_DLGMAP_RWM(NAME, MSG, APP)	{AJCMSGTYPE_MSG, 0		   , 0	, AjcDlg##NAME##_##MSG, APP , NULL},
#define		AJC_DLGMAP_CMD(NAME, CMD)		{AJCMSGTYPE_CMD, WM_COMMAND, CMD, AjcDlg##NAME##_##CMD, NULL, NULL},
#define		AJC_DLGMAP_NTC(NAME, CMD)		{AJCMSGTYPE_NTC, WM_NOTIFY , CMD, AjcDlg##NAME##_##CMD, NULL, NULL},

#define		AJCM_CTLCOLOR_ANY_STR			TEXT("_AJCM_CTLCOLOR_ANY_")
#define		AJC_WNDMAP_DGC(NAME, MSG)		AJC_WNDMAP_RWM(NAME, MSG, AJCM_CTLCOLOR_ANY_STR)
#define		AJC_DLGMAP_DGC(NAME, MSG)		AJC_DLGMAP_RWM(NAME, MSG, AJCM_CTLCOLOR_ANY_STR)

#define		AJCM_CTLCOLOR_BTN_STR			TEXT("_AJCM_CTLCOLOR_BTN_")
#define		AJC_WNDMAP_DGB(NAME, MSG)		AJC_WNDMAP_RWM(NAME, MSG, AJCM_CTLCOLOR_BTN_STR)
#define		AJC_DLGMAP_DGB(NAME, MSG)		AJC_DLGMAP_RWM(NAME, MSG, AJCM_CTLCOLOR_BTN_STR)

#define		AJCM_CTLCOLOR_LSI_STR			TEXT("_AJCM_CTLCOLOR_LSI_")
#define		AJC_WNDMAP_CLI(NAME, MSG)		AJC_WNDMAP_RWM(NAME, MSG, AJCM_CTLCOLOR_LSI_STR)
#define		AJC_DLGMAP_CLI(NAME, MSG)		AJC_DLGMAP_RWM(NAME, MSG, AJCM_CTLCOLOR_LSI_STR)

#define		AJCM_CTLDRAW_LSI_STR			TEXT("_AJCM_CTLDRAW_LSI_")
#define		AJC_WNDMAP_DLI(NAME, MSG)		AJC_WNDMAP_RWM(NAME, MSG, AJCM_CTLDRAW_LSI_STR)
#define		AJC_DLGMAP_DLI(NAME, MSG)		AJC_DLGMAP_RWM(NAME, MSG, AJCM_CTLDRAW_LSI_STR)

//--------------------------------------------------------------------------------------------------------------//
#define		AJC_WNDMAP_END	{AJCMSGTYPE_END}};
#define		AJC_DLGMAP_END	{AJCMSGTYPE_END}};
//--------------------------------------------------------------------------------------------------------------//
#define		AJC_WNDPROC(NAME, MSG)	static	LRESULT AjcWnd##NAME##_##MSG(HWND hwnd, UI msg, WPARAM wParam, LPARAM lParam)
#define		AJC_DLGPROC(NAME, MSG)	static	LRESULT AjcDlg##NAME##_##MSG(HWND hDlg, UI msg, WPARAM wParam, LPARAM lParam)

//----- サブクラス設定マクロ -----------------------------------------------------------------------------------//
#define		MAjcMmpSetSubclass(NAME, _HWND_)	AjcMmpSetSubclass(_HWND_, #NAME, AJC_WNDPROC_NAME(NAME))

//----- サブクラス解除マクロ -----------------------------------------------------------------------------------//
#define		MAjcMmpClrSubclass(NAME, _HWND_)	AjcMmpClrSubclass(_HWND_, #NAME)

//----- デフォルトウインドプロシージャを「DefWindowProc()」に変更 ----------------------------------------------//
#define		MAjcMmpSetDefWndProc(NAME, _HWND_)	AjcMmpSetDefWndProcEx(_HWND_, #NAME, DefWindowProc)

//----- オリジナルウインドプロシージャ呼び出しマクロ -----------------------------------------------------------//
#define		MAjcMmpCallOrgWndProc(NAME)					AjcMmpCallOrgWndProc(hwnd, #NAME, msg, wParam, lParam)
#define		MAjcMmpCallOrgWndProcEx(NAME, H, M, W, L)	AjcMmpCallOrgWndProc(H	 , #NAME, M  , W	 , L	 )

//--------------------------------------------------------------------------------------------------------------//
//	プロトタイプ																								//
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT	VO		CALLBACK AjcMmpInitTbl	(PAJCMSGTBL pMsgTbl, PAJCMSGCHAINPTR pChain);
AJCEXPORT	LRESULT	CALLBACK AjcMmpWndMsgHandle(PAJCMSGCHAINPTR pChain, HWND hwnd, UI msg, WPARAM wParam, LPARAM lParam, WNDPROC MyProc, C_BCP pName);
AJCEXPORT	LRESULT	CALLBACK AjcMmpDlgMsgHandle(PAJCMSGCHAINPTR pChain, HWND hDlg, UI msg, WPARAM wParam, LPARAM lParam);

#ifdef AJCOLDSUBCLASS
AJCEXPORT	BOOL	CALLBACK AjcMmpSetDefWndProc (HWND hwnd, WNDPROC DefWndProc);
AJCEXPORT	WNDPROC	CALLBACK AjcMmpGetDefWndProc (HWND hwnd);
AJCEXPORT	LRESULT	CALLBACK AjcMmpCallDefWndProc(HWND hwnd, UI msg, WPARAM wParam, LPARAM lParam);
#endif

AJCEXPORT	WNDPROC	CALLBACK AjcMmpSetSubclass	  (HWND hwnd, C_BCP pName, WNDPROC NewProc);
AJCEXPORT	BOOL	CALLBACK AjcMmpClrSubclass	  (HWND hwnd, C_BCP pName);
AJCEXPORT	BOOL 	CALLBACK AjcMmpDelSubclass	  (HWND hwnd, C_BCP pName);
AJCEXPORT	UI		CALLBACK AjcMmpGetSubclassInfo(HWND hwnd, AJCSBCINFO buf[], UI nBuf);
AJCEXPORT	BOOL	CALLBACK AjcMmpSetDefWndProcEx(HWND hwnd, C_BCP pName, WNDPROC DefWndProc);
AJCEXPORT	WNDPROC	CALLBACK AjcMmpGetDefWndProcEx(HWND hwnd, C_BCP pName);
AJCEXPORT	LRESULT	CALLBACK AjcMmpCallOrgWndProc (HWND hwnd, C_BCP pName, UI msg, WPARAM wParam, LPARAM lParam);

/****************************************************************************************************************/
#endif
